/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.concurrency.AsyncFuture;
import com.intellij.concurrency.AsyncFutureFactory;
import com.intellij.concurrency.AsyncFutureResult;
import com.intellij.concurrency.DefaultResultConsumer;
import com.intellij.concurrency.ResultConsumer;
import com.intellij.concurrency.SameThreadExecutor;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class MergeQuery<T>
implements Query<T> {
    private final Query<? extends T> myQuery1;
    private final Query<? extends T> myQuery2;

    public MergeQuery(@NotNull Query<? extends T> query1, @NotNull Query<? extends T> query2) {
        if (query1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "query1", "com/intellij/util/MergeQuery", "<init>"));
        }
        if (query2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "query2", "com/intellij/util/MergeQuery", "<init>"));
        }
        this.myQuery1 = query1;
        this.myQuery2 = query2;
    }

    @Override
    @NotNull
    public Collection<T> findAll() {
        ArrayList results = new ArrayList();
        Processor processor = Processors.cancelableCollectProcessor(results);
        this.forEach((Processor<T>)processor);
        ArrayList arrayList = results;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/MergeQuery", "findAll"));
        }
        return arrayList;
    }

    @Override
    public T findFirst() {
        CommonProcessors.FindFirstProcessor processor = new CommonProcessors.FindFirstProcessor();
        this.forEach((Processor<T>)processor);
        return processor.getFoundValue();
    }

    @Override
    public boolean forEach(@NotNull Processor<T> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/util/MergeQuery", "forEach"));
        }
        return this.processSubQuery(this.myQuery1, consumer) && this.processSubQuery(this.myQuery2, consumer);
    }

    @Override
    @NotNull
    public AsyncFuture<Boolean> forEachAsync(final @NotNull Processor<T> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/util/MergeQuery", "forEachAsync"));
        }
        final AsyncFutureResult<Boolean> result = AsyncFutureFactory.getInstance().createAsyncFutureResult();
        AsyncFuture<Boolean> fq = this.processSubQueryAsync(this.myQuery1, consumer);
        fq.addConsumer(SameThreadExecutor.INSTANCE, (ResultConsumer<Boolean>)new DefaultResultConsumer<Boolean>(result){

            @Override
            public void onSuccess(Boolean value2) {
                if (value2.booleanValue()) {
                    AsyncFuture fq2 = MergeQuery.this.processSubQueryAsync(MergeQuery.this.myQuery2, consumer);
                    fq2.addConsumer(SameThreadExecutor.INSTANCE, new DefaultResultConsumer(result));
                } else {
                    result.set(false);
                }
            }
        });
        AsyncFutureResult<Boolean> asyncFutureResult = result;
        if (asyncFutureResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/MergeQuery", "forEachAsync"));
        }
        return asyncFutureResult;
    }

    private <V extends T> boolean processSubQuery(@NotNull Query<V> subQuery, @NotNull Processor<T> consumer) {
        if (subQuery == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subQuery", "com/intellij/util/MergeQuery", "processSubQuery"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/util/MergeQuery", "processSubQuery"));
        }
        return subQuery.forEach(consumer);
    }

    private <V extends T> AsyncFuture<Boolean> processSubQueryAsync(@NotNull Query<V> query1, @NotNull Processor<T> consumer) {
        if (query1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "query1", "com/intellij/util/MergeQuery", "processSubQueryAsync"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/util/MergeQuery", "processSubQueryAsync"));
        }
        return query1.forEachAsync(consumer);
    }

    @Override
    @NotNull
    public T[] toArray(@NotNull T[] a) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "com/intellij/util/MergeQuery", "toArray"));
        }
        Collection<T> results = this.findAll();
        T[] TArray = results.toArray(a);
        if (TArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/MergeQuery", "toArray"));
        }
        return TArray;
    }

    @Override
    public Iterator<T> iterator() {
        return this.findAll().iterator();
    }
}

