/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.text.StringUtil;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.util.XMLResourceDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;

public class SVGLoader {
    private TranscoderInput input;
    private BufferedImage img;
    private float width;
    private float height;

    public static Image load(@NotNull URL url, float scale) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/SVGLoader", "load"));
        }
        return SVGLoader.load(url, url.openStream(), scale);
    }

    public static Image load(@NotNull InputStream stream, float scale) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/util/SVGLoader", "load"));
        }
        return SVGLoader.load(null, stream, scale);
    }

    public static Image load(@Nullable URL url, @NotNull InputStream stream, float scale) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/util/SVGLoader", "load"));
        }
        try {
            return new SVGLoader(url, stream, scale).createImage();
        }
        catch (TranscoderException ex) {
            throw new IOException(ex);
        }
    }

    private SVGLoader(@Nullable URL url, InputStream stream, float scale) throws IOException {
        Document document = null;
        String uri = null;
        try {
            uri = url != null ? url.toURI().toString() : null;
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        document = new SAXSVGDocumentFactory(XMLResourceDescriptor.getXMLParserClassName()).createDocument(uri, stream);
        if (document == null) {
            throw new IOException("document not created");
        }
        this.input = new TranscoderInput(document);
        this.width = (float)SizeAttr.width.value(document) * scale;
        this.height = (float)SizeAttr.height.value(document) * scale;
    }

    private BufferedImage createImage() throws TranscoderException {
        MyTranscoder r = new MyTranscoder();
        r.addTranscodingHint(ImageTranscoder.KEY_WIDTH, new Float(this.width));
        r.addTranscodingHint(ImageTranscoder.KEY_HEIGHT, new Float(this.height));
        r.transcode(this.input, null);
        return this.img;
    }

    private class MyTranscoder
    extends ImageTranscoder {
        private MyTranscoder() {
        }

        public BufferedImage createImage(int w, int h) {
            return new BufferedImage(w, h, 2);
        }

        public void writeImage(BufferedImage img, TranscoderOutput output) throws TranscoderException {
            SVGLoader.this.img = img;
        }
    }

    private static class ViewBox {
        private final int x;
        private final int y;
        private final int width;
        private final int height;

        public ViewBox(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public static ViewBox fromString(String s) {
            List<String> values = StringUtil.split(s, " ");
            if (values.size() == 4) {
                return new ViewBox(Integer.parseInt(values.get(0)), Integer.parseInt(values.get(1)), Integer.parseInt(values.get(2)), Integer.parseInt(values.get(3)));
            }
            throw new IllegalArgumentException("String should be formatted like 'x y width height'");
        }
    }

    private static enum SizeAttr {
        width,
        height;

        static final int FALLBACK_VALUE = 16;

        public int value(@NotNull Document document) {
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/util/SVGLoader$SizeAttr", "value"));
            }
            String value2 = document.getDocumentElement().getAttribute(this.name());
            if (value2.endsWith("px")) {
                try {
                    return Integer.parseInt(value2.substring(0, value2.length() - 2));
                }
                catch (NumberFormatException ex) {
                    ex.printStackTrace();
                }
            }
            try {
                ViewBox viewBox = ViewBox.fromString(document.getDocumentElement().getAttribute("viewBox"));
                return this == width ? viewBox.width : viewBox.height;
            }
            catch (Exception e) {
                e.printStackTrace();
                return 16;
            }
        }
    }
}

