/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class BidirectionalMultiMap<K, V> {
    private final Map<K, Set<V>> myKey2Values;
    private final Map<V, Set<K>> myValue2Keys;

    public BidirectionalMultiMap() {
        this(new HashMap(), new HashMap());
    }

    public BidirectionalMultiMap(Map<K, Set<V>> key2Values, Map<V, Set<K>> value2Keys) {
        this.myKey2Values = key2Values;
        this.myValue2Keys = value2Keys;
    }

    @NotNull
    public Set<V> getValues(K key) {
        Set<V> set = this.myKey2Values.get(key);
        Set<Object> set2 = set != null ? set : Collections.emptySet();
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/BidirectionalMultiMap", "getValues"));
        }
        return set2;
    }

    @NotNull
    public Set<K> getKeys(V value2) {
        Set<K> set = this.myValue2Keys.get(value2);
        Set<Object> set2 = set != null ? set : Collections.emptySet();
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/BidirectionalMultiMap", "getKeys"));
        }
        return set2;
    }

    public boolean containsKey(K key) {
        return this.myKey2Values.containsKey(key);
    }

    public boolean containsValue(V value2) {
        return this.myValue2Keys.containsKey(value2);
    }

    public boolean put(K key, V value2) {
        Set<K> ks = this.myValue2Keys.get(value2);
        if (ks == null) {
            ks = this.createKeysSet();
            this.myValue2Keys.put((Set<K>)value2, (Set<V>)ks);
        }
        ks.add(key);
        Set<V> vs = this.myKey2Values.get(key);
        if (vs == null) {
            vs = this.createValuesSet();
            this.myKey2Values.put(key, vs);
        }
        return vs.add(value2);
    }

    @NotNull
    protected Set<V> createValuesSet() {
        HashSet hashSet = new HashSet();
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/BidirectionalMultiMap", "createValuesSet"));
        }
        return hashSet;
    }

    @NotNull
    protected Set<K> createKeysSet() {
        HashSet hashSet = new HashSet();
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/BidirectionalMultiMap", "createKeysSet"));
        }
        return hashSet;
    }

    public boolean removeKey(K key) {
        Set<V> vs = this.myKey2Values.get(key);
        if (vs == null) {
            return false;
        }
        for (V v : vs) {
            Set<K> ks = this.myValue2Keys.get(v);
            ks.remove(key);
            if (!ks.isEmpty()) continue;
            this.myValue2Keys.remove(v);
        }
        this.myKey2Values.remove(key);
        return true;
    }

    public void remove(K key, V value2) {
        Set<V> vs = this.myKey2Values.get(key);
        Set<K> ks = this.myValue2Keys.get(value2);
        if (ks != null && vs != null) {
            ks.remove(key);
            vs.remove(value2);
            if (ks.isEmpty()) {
                this.myValue2Keys.remove(value2);
            }
            if (vs.isEmpty()) {
                this.myKey2Values.remove(key);
            }
        }
    }

    public boolean isEmpty() {
        return this.myKey2Values.isEmpty() && this.myValue2Keys.isEmpty();
    }

    public boolean removeValue(V value2) {
        Set<K> ks = this.myValue2Keys.get(value2);
        if (ks == null) {
            return false;
        }
        for (K k : ks) {
            Set<V> vs = this.myKey2Values.get(k);
            vs.remove(value2);
            if (!vs.isEmpty()) continue;
            this.myKey2Values.remove(k);
        }
        this.myValue2Keys.remove(value2);
        return true;
    }

    public void clear() {
        this.myKey2Values.clear();
        this.myValue2Keys.clear();
    }

    public Set<K> getKeys() {
        return this.myKey2Values.keySet();
    }

    public Set<V> getValues() {
        return this.myValue2Keys.keySet();
    }
}

