/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

public class SequenceIterator<T>
implements Iterator<T> {
    private final Iterator<T>[] myIterators;
    private int myCurrentIndex;

    public SequenceIterator(Iterator<T> ... iterators) {
        if (iterators == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterators", "com/intellij/util/containers/SequenceIterator", "<init>"));
        }
        this.myIterators = new Iterator[iterators.length];
        System.arraycopy(iterators, 0, this.myIterators, 0, iterators.length);
    }

    public SequenceIterator(@NotNull Collection<Iterator<T>> iterators) {
        if (iterators == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterators", "com/intellij/util/containers/SequenceIterator", "<init>"));
        }
        this(iterators.toArray(new Iterator[iterators.size()]));
    }

    @Override
    public boolean hasNext() {
        for (int index = this.myCurrentIndex; index < this.myIterators.length; ++index) {
            Iterator<T> iterator = this.myIterators[index];
            if (iterator == null || !iterator.hasNext()) continue;
            this.myCurrentIndex = index;
            return true;
        }
        return false;
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            return this.myIterators[this.myCurrentIndex].next();
        }
        throw new NoSuchElementException("Iterator has no more elements");
    }

    @Override
    public void remove() {
        if (this.myCurrentIndex >= this.myIterators.length) {
            throw new IllegalStateException();
        }
        this.myIterators[this.myCurrentIndex].remove();
    }

    @NotNull
    public static <T> SequenceIterator<T> create(@NotNull Iterator<T> first, @NotNull Iterator<T> second) {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/intellij/util/containers/SequenceIterator", "create"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "com/intellij/util/containers/SequenceIterator", "create"));
        }
        SequenceIterator<T> sequenceIterator = new SequenceIterator<T>(first, second);
        if (sequenceIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/SequenceIterator", "create"));
        }
        return sequenceIterator;
    }

    @NotNull
    public static <T> SequenceIterator<T> create(@NotNull Iterator<T> first, @NotNull Iterator<T> second, @NotNull Iterator<T> third) {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/intellij/util/containers/SequenceIterator", "create"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "com/intellij/util/containers/SequenceIterator", "create"));
        }
        if (third == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "third", "com/intellij/util/containers/SequenceIterator", "create"));
        }
        SequenceIterator<T> sequenceIterator = new SequenceIterator<T>(first, second, third);
        if (sequenceIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/SequenceIterator", "create"));
        }
        return sequenceIterator;
    }
}

