/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.concurrent.ConcurrentMap;

public abstract class SoftFactoryMap<T, V> {
    private final ConcurrentMap<T, V> myMap = ContainerUtil.createConcurrentWeakKeySoftValueMap();

    protected abstract V create(T var1);

    public final V get(T key) {
        Object v = this.myMap.get(key);
        if (v != null) {
            return v == ObjectUtils.NULL ? null : (V)v;
        }
        V value2 = this.create(key);
        Object toPut = value2 == null ? ObjectUtils.NULL : value2;
        Object prev = this.myMap.putIfAbsent(key, toPut);
        return (V)(prev == null || prev == ObjectUtils.NULL ? value2 : prev);
    }

    public final boolean containsKey(T key) {
        return this.myMap.containsKey(key);
    }

    public void clear() {
        this.myMap.clear();
    }
}

