/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.AbstractList;
import java.util.Comparator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public class SortedList<T>
extends AbstractList<T> {
    private final SortedMap<T, List<T>> myMap;
    private final Comparator<T> myComparator;
    private List<T> myDelegate;

    public SortedList(@NotNull Comparator<T> comparator) {
        if (comparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparator", "com/intellij/util/containers/SortedList", "<init>"));
        }
        this.myComparator = comparator;
        this.myMap = new TreeMap<T, List<T>>(comparator);
    }

    @NotNull
    public Comparator<T> getComparator() {
        Comparator<T> comparator = this.myComparator;
        if (comparator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/SortedList", "getComparator"));
        }
        return comparator;
    }

    @Override
    public void add(int index, T element) {
        this.addToMap(element);
    }

    private void addToMap(T element) {
        SmartList<T> group = (SmartList<T>)this.myMap.get(element);
        if (group == null) {
            group = new SmartList<T>();
            this.myMap.put(element, group);
        }
        group.add(element);
        this.myDelegate = null;
    }

    @Override
    public boolean add(T t) {
        this.addToMap(t);
        return true;
    }

    @Override
    public T remove(int index) {
        T value2 = this.get(index);
        this.remove(value2);
        return value2;
    }

    @Override
    public boolean remove(Object value2) {
        List group = (List)this.myMap.remove(value2);
        if (group == null) {
            return false;
        }
        group.remove(value2);
        if (!group.isEmpty()) {
            this.myMap.put(group.get(0), group);
        }
        this.myDelegate = null;
        return true;
    }

    @Override
    public T get(int index) {
        return this.ensureLinearized().get(index);
    }

    @NotNull
    private List<T> ensureLinearized() {
        List<T> delegate = this.myDelegate;
        if (delegate == null) {
            this.myDelegate = delegate = ContainerUtil.concat(this.myMap.values());
        }
        List<T> list = delegate;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/SortedList", "ensureLinearized"));
        }
        return list;
    }

    @Override
    public void clear() {
        this.myMap.clear();
        this.myDelegate = null;
    }

    @Override
    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    @Override
    public int size() {
        return this.ensureLinearized().size();
    }
}

