/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.StringInterner;
import com.intellij.util.containers.WeakInterner;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class WeakStringInterner
extends StringInterner {
    private final WeakInterner<String> myDelegate = new WeakInterner();

    @Override
    @NotNull
    public String intern(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/containers/WeakStringInterner", "intern"));
        }
        String string = this.myDelegate.intern(name);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/WeakStringInterner", "intern"));
        }
        return string;
    }

    @Override
    public void clear() {
        this.myDelegate.clear();
    }

    @Override
    @NotNull
    public Set<String> getValues() {
        Set<String> set = this.myDelegate.getValues();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/WeakStringInterner", "getValues"));
        }
        return set;
    }
}

