/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.impl.CollectionInputDataDiffBuilder;
import com.intellij.util.indexing.impl.DebugAssertions;
import com.intellij.util.indexing.impl.EmptyInputDataDiffBuilder;
import com.intellij.util.indexing.impl.InputDataDiffBuilder;
import com.intellij.util.indexing.impl.KeyValueUpdateProcessor;
import com.intellij.util.indexing.impl.RemovedKeyProcessor;
import gnu.trove.THashMap;
import gnu.trove.TObjectObjectProcedure;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class MapInputDataDiffBuilder<Key, Value>
extends InputDataDiffBuilder<Key, Value> {
    private static final boolean ourDiffUpdateEnabled = SystemProperties.getBooleanProperty("idea.disable.diff.index.update", true);
    private final Map<Key, Value> myMap;
    private static final AtomicInteger requests = new AtomicInteger();
    private static final AtomicInteger totalRemovals = new AtomicInteger();
    private static final AtomicInteger totalAdditions = new AtomicInteger();
    private static final AtomicInteger incrementalRemovals = new AtomicInteger();
    private static final AtomicInteger incrementalAdditions = new AtomicInteger();

    public MapInputDataDiffBuilder(int inputId, @Nullable Map<Key, Value> map2) {
        super(inputId);
        this.myMap = map2 == null ? Collections.emptyMap() : map2;
    }

    @Override
    public void differentiate(@NotNull Map<Key, Value> newData, @NotNull KeyValueUpdateProcessor<Key, Value> addProcessor, @NotNull KeyValueUpdateProcessor<Key, Value> updateProcessor, @NotNull RemovedKeyProcessor<Key> removeProcessor) throws StorageException {
        if (newData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newData", "com/intellij/util/indexing/impl/MapInputDataDiffBuilder", "differentiate"));
        }
        if (addProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "addProcessor", "com/intellij/util/indexing/impl/MapInputDataDiffBuilder", "differentiate"));
        }
        if (updateProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updateProcessor", "com/intellij/util/indexing/impl/MapInputDataDiffBuilder", "differentiate"));
        }
        if (removeProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "removeProcessor", "com/intellij/util/indexing/impl/MapInputDataDiffBuilder", "differentiate"));
        }
        if (ourDiffUpdateEnabled) {
            if (this.myMap.isEmpty()) {
                EmptyInputDataDiffBuilder.processKeys(newData, addProcessor, this.myInputId);
            } else if (newData.isEmpty()) {
                this.processAllKeysAsDeleted(removeProcessor);
            } else {
                Key key;
                int added = 0;
                int removed = 0;
                for (Map.Entry<Key, Value> e : this.myMap.entrySet()) {
                    key = e.getKey();
                    Value newValue = newData.get(key);
                    if (Comparing.equal(e.getValue(), newValue) && (newValue != null || newData.containsKey(key))) continue;
                    if (!newData.containsKey(key)) {
                        removeProcessor.process(key, this.myInputId);
                        ++removed;
                        continue;
                    }
                    updateProcessor.process(key, newValue, this.myInputId);
                    ++added;
                    ++removed;
                }
                for (Map.Entry<Key, Value> e : newData.entrySet()) {
                    key = e.getKey();
                    if (this.myMap.containsKey(key)) continue;
                    addProcessor.process(key, e.getValue(), this.myInputId);
                    ++added;
                }
                incrementalAdditions.addAndGet(added);
                incrementalRemovals.addAndGet(removed);
                int totalRequests = requests.incrementAndGet();
                totalRemovals.addAndGet(this.myMap.size());
                totalAdditions.addAndGet(newData.size());
                if ((totalRequests & 0xFFF) == 0 && DebugAssertions.DEBUG) {
                    Logger.getInstance(this.getClass()).info("Incremental index diff update:" + requests + ", removals:" + totalRemovals + "->" + incrementalRemovals + ", additions:" + totalAdditions + "->" + incrementalAdditions);
                }
            }
        } else {
            CollectionInputDataDiffBuilder.differentiateWithKeySeq(this.myMap.keySet(), newData, this.myInputId, addProcessor, removeProcessor);
        }
    }

    private void processAllKeysAsDeleted(final RemovedKeyProcessor<Key> removeProcessor) throws StorageException {
        if (this.myMap instanceof THashMap) {
            final StorageException[] exception = new StorageException[]{null};
            ((THashMap)this.myMap).forEachEntry(new TObjectObjectProcedure<Key, Value>(){

                public boolean execute(Key k, Value v) {
                    try {
                        removeProcessor.process(k, MapInputDataDiffBuilder.this.myInputId);
                    }
                    catch (StorageException e) {
                        exception[0] = e;
                        return false;
                    }
                    return true;
                }
            });
            if (exception[0] != null) {
                throw exception[0];
            }
        } else {
            for (Key key : this.myMap.keySet()) {
                removeProcessor.process(key, this.myInputId);
            }
        }
    }
}

