/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.containers.SLRUMap;
import com.intellij.util.containers.hash.EqualityPolicy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public abstract class FileAccessorCache<K, T>
implements EqualityPolicy<K> {
    private final SLRUMap<K, Handle<T>> myCache;
    private final List<T> myElementsToBeDisposed = new ArrayList<T>();
    private final Object myCacheLock = new Object();
    private final Object myUpdateLock = new Object();

    public FileAccessorCache(int protectedQueueSize, int probationalQueueSize) {
        this.myCache = new SLRUMap<K, Handle<T>>(protectedQueueSize, probationalQueueSize, this){

            @Override
            protected final void onDropFromCache(K key, Handle<T> value2) {
                value2.release();
            }
        };
    }

    protected abstract T createAccessor(K var1) throws IOException;

    protected abstract void disposeAccessor(T var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public final Handle<T> get(K key) {
        Handle<T> cached = this.getIfCached(key);
        if (cached != null) {
            Handle<T> handle = cached;
            if (handle != null) return handle;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/FileAccessorCache", "get"));
        }
        Object object = this.myUpdateLock;
        // MONITORENTER : object
        cached = this.getIfCached(key);
        if (cached != null) {
            Handle<T> handle = cached;
            // MONITOREXIT : object
            if (handle != null) return handle;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/FileAccessorCache", "get"));
        }
        Handle<T> handle = this.createHandle(key);
        // MONITOREXIT : object
        if (handle != null) return handle;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/FileAccessorCache", "get"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Handle<T> createHandle(K key) {
        Handle<T> handle;
        try {
            Handle<T> cached = new Handle<T>(this.createAccessor(key), this);
            ((Handle)cached).allocate();
            Object object = this.myCacheLock;
            synchronized (object) {
                this.myCache.put(key, cached);
            }
            this.disposeInvalidAccessors();
            handle = cached;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        if (handle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/FileAccessorCache", "createHandle"));
        }
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeInvalidAccessors() {
        ArrayList<T> fileAccessorsToBeDisposed;
        Iterator iterator = this.myCacheLock;
        synchronized (iterator) {
            if (this.myElementsToBeDisposed.isEmpty()) {
                return;
            }
            fileAccessorsToBeDisposed = new ArrayList<T>(this.myElementsToBeDisposed);
            this.myElementsToBeDisposed.clear();
        }
        for (Object t : fileAccessorsToBeDisposed) {
            try {
                this.disposeAccessor(t);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Handle<T> getIfCached(K key) {
        Object object = this.myCacheLock;
        synchronized (object) {
            Handle<T> value2 = this.myCache.get(key);
            if (value2 != null) {
                ((Handle)value2).allocate();
            }
            return value2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(K key) {
        try {
            Object object = this.myCacheLock;
            synchronized (object) {
                boolean bl = this.myCache.remove(key);
                return bl;
            }
        }
        finally {
            Object object = this.myUpdateLock;
            synchronized (object) {
                this.disposeInvalidAccessors();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object;
        try {
            object = this.myCacheLock;
            synchronized (object) {
                this.myCache.clear();
            }
        }
        finally {
            object = this.myUpdateLock;
            synchronized (object) {
                this.disposeInvalidAccessors();
            }
        }
    }

    @Override
    public int getHashCode(K value2) {
        return value2.hashCode();
    }

    @Override
    public boolean isEqual(K val1, K val2) {
        return val1.equals(val2);
    }

    public static final class Handle<T> {
        private final FileAccessorCache<?, T> myOwner;
        private final T myFileAccessor;
        private final AtomicInteger myRefCount = new AtomicInteger(1);

        public Handle(T fileAccessor, FileAccessorCache<?, T> owner) {
            this.myFileAccessor = fileAccessor;
            this.myOwner = owner;
        }

        private void allocate() {
            this.myRefCount.incrementAndGet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void release() {
            if (this.myRefCount.decrementAndGet() == 0) {
                Object object = ((FileAccessorCache)this.myOwner).myCacheLock;
                synchronized (object) {
                    ((FileAccessorCache)this.myOwner).myElementsToBeDisposed.add(this.myFileAccessor);
                }
            }
        }

        public T get() {
            return this.myFileAccessor;
        }
    }
}

