/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public abstract class InlineKeyDescriptor<T>
implements KeyDescriptor<T> {
    private final boolean myCompactFormat = this.isCompactFormat();

    protected boolean isCompactFormat() {
        return false;
    }

    @Override
    public final int getHashCode(T value2) {
        return this.toInt(value2);
    }

    @Override
    public final boolean isEqual(T val1, T val2) {
        return this.toInt(val1) == this.toInt(val2);
    }

    @Override
    public final void save(@NotNull DataOutput out, T value2) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/util/io/InlineKeyDescriptor", "save"));
        }
        int v = this.toInt(value2);
        if (this.myCompactFormat) {
            DataInputOutputUtil.writeINT(out, v);
        } else {
            out.writeInt(v);
        }
    }

    @Override
    public final T read(@NotNull DataInput in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/util/io/InlineKeyDescriptor", "read"));
        }
        int n = this.myCompactFormat ? DataInputOutputUtil.readINT(in) : in.readInt();
        return this.fromInt(n);
    }

    public abstract T fromInt(int var1);

    public abstract int toInt(T var1);
}

