/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.DataExternalizer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NullableDataExternalizer<T>
implements DataExternalizer<T> {
    private final DataExternalizer<T> myNotNullExternalizer;

    public NullableDataExternalizer(DataExternalizer<T> externalizer) {
        this.myNotNullExternalizer = externalizer;
    }

    @Override
    public void save(@NotNull DataOutput out, T value2) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/util/io/NullableDataExternalizer", "save"));
        }
        if (value2 == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.myNotNullExternalizer.save(out, value2);
        }
    }

    @Override
    @Nullable
    public T read(@NotNull DataInput in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/util/io/NullableDataExternalizer", "read"));
        }
        boolean isDefined = in.readBoolean();
        if (isDefined) {
            return this.myNotNullExternalizer.read(in);
        }
        return null;
    }
}

