/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.Base64;
import com.intellij.util.ThreeState;
import gnu.trove.TIntArrayList;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class URLUtil {
    public static final String SCHEME_SEPARATOR = "://";
    public static final String FILE_PROTOCOL = "file";
    public static final String HTTP_PROTOCOL = "http";
    public static final String JAR_PROTOCOL = "jar";
    public static final String JAR_SEPARATOR = "!/";
    public static final Pattern DATA_URI_PATTERN = Pattern.compile("data:([^,;]+/[^,;]+)(;charset(?:=|:)[^,;]+)?(;base64)?,(.+)");
    public static final Pattern URL_PATTERN = Pattern.compile("\\b(mailto:|(news|(ht|f)tp(s?))://|((?<![\\p{L}0-9_.])(www\\.)))[-A-Za-z0-9+$&@#/%?=~_|!:,.;]*[-A-Za-z0-9+$&@#/%=~_|]");

    private URLUtil() {
    }

    public static boolean canContainUrl(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/util/io/URLUtil", "canContainUrl"));
        }
        return line.contains("mailto:") || line.contains(SCHEME_SEPARATOR) || line.contains("www.");
    }

    @NotNull
    public static InputStream openStream(@NotNull URL url) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/io/URLUtil", "openStream"));
        }
        String protocol = url.getProtocol();
        InputStream inputStream = protocol.equals(JAR_PROTOCOL) ? URLUtil.openJarStream(url) : url.openStream();
        if (inputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/URLUtil", "openStream"));
        }
        return inputStream;
    }

    @NotNull
    public static InputStream openResourceStream(@NotNull URL url) throws IOException {
        InputStream inputStream;
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/io/URLUtil", "openResourceStream"));
        }
        try {
            inputStream = URLUtil.openStream(url);
        }
        catch (FileNotFoundException ex) {
            InputStream resourceStream;
            int pos;
            String protocol = url.getProtocol();
            String file = null;
            if (protocol.equals(FILE_PROTOCOL)) {
                file = url.getFile();
            } else if (protocol.equals(JAR_PROTOCOL) && (pos = url.getFile().indexOf("!")) >= 0) {
                file = url.getFile().substring(pos + 1);
            }
            if (file != null && file.startsWith("/") && (resourceStream = URLUtil.class.getResourceAsStream(file)) != null) {
                InputStream inputStream2 = resourceStream;
                if (inputStream2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/URLUtil", "openResourceStream"));
                }
                return inputStream2;
            }
            throw ex;
        }
        if (inputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/URLUtil", "openResourceStream"));
        }
        return inputStream;
    }

    @NotNull
    private static InputStream openJarStream(@NotNull URL url) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/io/URLUtil", "openJarStream"));
        }
        Pair<String, String> paths = URLUtil.splitJarUrl(url.getFile());
        if (paths == null) {
            throw new MalformedURLException(url.getFile());
        }
        final ZipFile zipFile = new ZipFile((String)paths.first);
        ZipEntry zipEntry = zipFile.getEntry((String)paths.second);
        if (zipEntry == null) {
            zipFile.close();
            throw new FileNotFoundException("Entry " + (String)paths.second + " not found in " + (String)paths.first);
        }
        FilterInputStream filterInputStream = new FilterInputStream(zipFile.getInputStream(zipEntry)){

            @Override
            public void close() throws IOException {
                super.close();
                zipFile.close();
            }
        };
        if (filterInputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/URLUtil", "openJarStream"));
        }
        return filterInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    public static ThreeState resourceExists(@NotNull URL url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/io/URLUtil", "resourceExists"));
        }
        if (url.getProtocol().equals(FILE_PROTOCOL)) {
            ThreeState threeState = ThreeState.fromBoolean(URLUtil.urlToFile(url).exists());
            if (threeState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/URLUtil", "resourceExists"));
            }
            return threeState;
        }
        if (url.getProtocol().equals(JAR_PROTOCOL)) {
            Pair<String, String> paths = URLUtil.splitJarUrl(url.getFile());
            if (paths == null) {
                ThreeState threeState = ThreeState.NO;
                if (threeState == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/URLUtil", "resourceExists"));
                }
                return threeState;
            }
            if (!new File((String)paths.first).isFile()) {
                ThreeState threeState = ThreeState.NO;
                if (threeState == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/URLUtil", "resourceExists"));
                }
                return threeState;
            }
            ZipFile file = new ZipFile((String)paths.first);
            ThreeState threeState = ThreeState.fromBoolean(file.getEntry((String)paths.second) != null);
            file.close();
            ThreeState threeState2 = threeState;
            if (threeState2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/URLUtil", "resourceExists"));
            }
            return threeState2;
            {
                catch (Throwable throwable) {
                    try {
                        file.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        ThreeState threeState3 = ThreeState.NO;
                        if (threeState3 == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/URLUtil", "resourceExists"));
                        }
                        return threeState3;
                    }
                }
            }
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/URLUtil", "resourceExists"));
        }
        return threeState;
    }

    @Nullable
    public static Pair<String, String> splitJarUrl(@NotNull String url) {
        String jarPath;
        String resourcePath;
        block7: {
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/io/URLUtil", "splitJarUrl"));
            }
            int pivot = url.indexOf(JAR_SEPARATOR);
            if (pivot < 0) {
                return null;
            }
            resourcePath = url.substring(pivot + 2);
            jarPath = url.substring(0, pivot);
            if (StringUtil.startsWithConcatenation(jarPath, JAR_PROTOCOL, ":")) {
                jarPath = jarPath.substring(JAR_PROTOCOL.length() + 1);
            }
            if (jarPath.startsWith(FILE_PROTOCOL)) {
                try {
                    jarPath = URLUtil.urlToFile(new URL(jarPath)).getPath().replace('\\', '/');
                }
                catch (Exception e) {
                    jarPath = jarPath.substring(FILE_PROTOCOL.length());
                    if (jarPath.startsWith(SCHEME_SEPARATOR)) {
                        jarPath = jarPath.substring(SCHEME_SEPARATOR.length());
                    }
                    if (!StringUtil.startsWithChar(jarPath, ':')) break block7;
                    jarPath = jarPath.substring(1);
                }
            }
        }
        return Pair.create(jarPath, resourcePath);
    }

    @NotNull
    public static File urlToFile(@NotNull URL url) {
        File file;
        block3: {
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/io/URLUtil", "urlToFile"));
            }
            try {
                file = new File(url.toURI().getSchemeSpecificPart());
                if (file != null) break block3;
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("URL='" + url.toString() + "'", e);
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/URLUtil", "urlToFile"));
        }
        return file;
    }

    @NotNull
    public static String unescapePercentSequences(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/util/io/URLUtil", "unescapePercentSequences"));
        }
        if (s.indexOf(37) == -1) {
            String string = s;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/URLUtil", "unescapePercentSequences"));
            }
            return string;
        }
        StringBuilder decoded = new StringBuilder();
        int len = s.length();
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (c == '%') {
                TIntArrayList bytes = new TIntArrayList();
                while (i + 2 < len && s.charAt(i) == '%') {
                    int d1 = URLUtil.decode(s.charAt(i + 1));
                    int d2 = URLUtil.decode(s.charAt(i + 2));
                    if (d1 == -1 || d2 == -1) break;
                    bytes.add((d1 & 0xF) << 4 | d2 & 0xF);
                    i += 3;
                }
                if (!bytes.isEmpty()) {
                    byte[] bytesArray = new byte[bytes.size()];
                    for (int j = 0; j < bytes.size(); ++j) {
                        bytesArray[j] = (byte)bytes.getQuick(j);
                    }
                    decoded.append(new String(bytesArray, CharsetToolkit.UTF8_CHARSET));
                    continue;
                }
            }
            decoded.append(c);
            ++i;
        }
        String string = decoded.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/URLUtil", "unescapePercentSequences"));
        }
        return string;
    }

    private static int decode(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return -1;
    }

    public static boolean containsScheme(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/io/URLUtil", "containsScheme"));
        }
        return url.contains(SCHEME_SEPARATOR);
    }

    public static boolean isDataUri(@NotNull String value2) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/io/URLUtil", "isDataUri"));
        }
        return !value2.isEmpty() && value2.startsWith("data:", value2.charAt(0) == '\"' || value2.charAt(0) == '\'' ? 1 : 0);
    }

    @Nullable
    public static byte[] getBytesFromDataUri(@NotNull String dataUrl) {
        if (dataUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataUrl", "com/intellij/util/io/URLUtil", "getBytesFromDataUri"));
        }
        Matcher matcher = DATA_URI_PATTERN.matcher(StringUtil.unquoteString(dataUrl));
        if (matcher.matches()) {
            try {
                String content = matcher.group(4);
                return ";base64".equalsIgnoreCase(matcher.group(3)) ? Base64.decode(content) : content.getBytes(CharsetToolkit.UTF8_CHARSET);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return null;
    }

    @NotNull
    public static String parseHostFromSshUrl(@NotNull String sshUrl) {
        if (sshUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sshUrl", "com/intellij/util/io/URLUtil", "parseHostFromSshUrl"));
        }
        String host = sshUrl;
        int at = host.lastIndexOf(64);
        if (at > 0) {
            host = host.substring(at + 1);
        } else {
            int firstColon = host.indexOf(58);
            if (firstColon > 0) {
                host = host.substring(firstColon + 3);
            }
        }
        int colon = host.indexOf(58);
        if (colon > 0) {
            host = host.substring(0, colon);
        } else {
            int slash = host.indexOf(47);
            if (slash > 0) {
                host = host.substring(0, slash);
            }
        }
        String string = host;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/URLUtil", "parseHostFromSshUrl"));
        }
        return string;
    }

    @NotNull
    public static URL getJarEntryURL(@NotNull File file, @NotNull String pathInJar) throws MalformedURLException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", FILE_PROTOCOL, "com/intellij/util/io/URLUtil", "getJarEntryURL"));
        }
        if (pathInJar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathInJar", "com/intellij/util/io/URLUtil", "getJarEntryURL"));
        }
        String fileURL = StringUtil.replace(file.toURI().toASCIIString(), "!", "%21");
        URL uRL = new URL("jar:" + fileURL + JAR_SEPARATOR + StringUtil.trimLeading(pathInJar, '/'));
        if (uRL == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/URLUtil", "getJarEntryURL"));
        }
        return uRL;
    }

    @NotNull
    public static String encodeURIComponent(@NotNull String s) {
        String string;
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/util/io/URLUtil", "encodeURIComponent"));
        }
        try {
            string = URLEncoder.encode(s, "UTF-8").replaceAll("\\+", "%20").replaceAll("%21", "!").replaceAll("%27", "'").replaceAll("%28", "(").replaceAll("%29", ")").replaceAll("%7E", "~");
        }
        catch (UnsupportedEncodingException e) {
            String string2 = s;
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/URLUtil", "encodeURIComponent"));
            }
            return string2;
        }
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/URLUtil", "encodeURIComponent"));
        }
        return string;
    }
}

