/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MouseInputListener;
import org.jetbrains.annotations.NotNull;

public class MouseEventAdapter<T>
extends MouseAdapter
implements MouseInputListener {
    private final T myAdapter;

    public MouseEventAdapter(T adapter) {
        this.myAdapter = adapter;
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        MouseListener listener = this.getMouseListener(this.myAdapter);
        if (listener != null) {
            listener.mouseEntered(this.convert(event));
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        MouseListener listener = this.getMouseListener(this.myAdapter);
        if (listener != null) {
            listener.mousePressed(this.convert(event));
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        MouseListener listener = this.getMouseListener(this.myAdapter);
        if (listener != null) {
            listener.mouseClicked(this.convert(event));
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        MouseListener listener = this.getMouseListener(this.myAdapter);
        if (listener != null) {
            listener.mouseReleased(this.convert(event));
        }
    }

    @Override
    public void mouseExited(MouseEvent event) {
        MouseListener listener = this.getMouseListener(this.myAdapter);
        if (listener != null) {
            listener.mouseExited(this.convert(event));
        }
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        MouseMotionListener listener = this.getMouseMotionListener(this.myAdapter);
        if (listener != null) {
            listener.mouseMoved(this.convert(event));
        }
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        MouseMotionListener listener = this.getMouseMotionListener(this.myAdapter);
        if (listener != null) {
            listener.mouseDragged(this.convert(event));
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent event) {
        MouseWheelListener listener = this.getMouseWheelListener(this.myAdapter);
        if (listener != null) {
            listener.mouseWheelMoved(this.convert(event));
        }
    }

    protected MouseListener getMouseListener(T adapter) {
        return adapter instanceof MouseListener ? (MouseListener)adapter : null;
    }

    protected MouseMotionListener getMouseMotionListener(T adapter) {
        return adapter instanceof MouseMotionListener ? (MouseMotionListener)adapter : null;
    }

    protected MouseWheelListener getMouseWheelListener(T adapter) {
        return adapter instanceof MouseWheelListener ? (MouseWheelListener)adapter : null;
    }

    @NotNull
    protected MouseEvent convert(@NotNull MouseEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/util/ui/MouseEventAdapter", "convert"));
        }
        MouseEvent mouseEvent = event;
        if (mouseEvent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/MouseEventAdapter", "convert"));
        }
        return mouseEvent;
    }

    @NotNull
    protected MouseWheelEvent convert(@NotNull MouseWheelEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/util/ui/MouseEventAdapter", "convert"));
        }
        MouseWheelEvent mouseWheelEvent = event;
        if (mouseWheelEvent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/MouseEventAdapter", "convert"));
        }
        return mouseWheelEvent;
    }

    @NotNull
    public static MouseEvent convert(@NotNull MouseEvent event, Component source) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/util/ui/MouseEventAdapter", "convert"));
        }
        Point point = event.getLocationOnScreen();
        SwingUtilities.convertPointFromScreen(point, source);
        MouseEvent mouseEvent = MouseEventAdapter.convert(event, source, point.x, point.y);
        if (mouseEvent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/MouseEventAdapter", "convert"));
        }
        return mouseEvent;
    }

    @NotNull
    public static MouseEvent convert(@NotNull MouseEvent event, Component source, int x, int y) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/util/ui/MouseEventAdapter", "convert"));
        }
        MouseEvent mouseEvent = MouseEventAdapter.convert(event, source, event.getID(), event.getWhen(), event.getModifiers() | event.getModifiersEx(), x, y);
        if (mouseEvent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/MouseEventAdapter", "convert"));
        }
        return mouseEvent;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static MouseEvent convert(@NotNull MouseEvent event, Component source, int id, long when, int modifiers, int x, int n) {
        void y;
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/util/ui/MouseEventAdapter", "convert"));
        }
        if (event instanceof MouseWheelEvent) {
            MouseWheelEvent mouseWheelEvent = MouseEventAdapter.convert((MouseWheelEvent)event, source, id, when, modifiers, x, (int)y);
            if (mouseWheelEvent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/MouseEventAdapter", "convert"));
            }
            return mouseWheelEvent;
        }
        if (event instanceof MenuDragMouseEvent) {
            MenuDragMouseEvent menuDragMouseEvent = MouseEventAdapter.convert((MenuDragMouseEvent)event, source, id, when, modifiers, x, (int)y);
            if (menuDragMouseEvent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/MouseEventAdapter", "convert"));
            }
            return menuDragMouseEvent;
        }
        MouseEvent mouseEvent = new MouseEvent(source, id, when, modifiers, x, (int)y, event.getClickCount(), event.isPopupTrigger(), event.getButton());
        if (mouseEvent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/MouseEventAdapter", "convert"));
        }
        return mouseEvent;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static MouseWheelEvent convert(@NotNull MouseWheelEvent event, Component source, int id, long when, int modifiers, int x, int n) {
        void y;
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/util/ui/MouseEventAdapter", "convert"));
        }
        MouseWheelEvent mouseWheelEvent = new MouseWheelEvent(source, id, when, modifiers, x, (int)y, event.getXOnScreen(), event.getYOnScreen(), event.getClickCount(), event.isPopupTrigger(), event.getScrollType(), event.getScrollAmount(), event.getWheelRotation());
        if (mouseWheelEvent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/MouseEventAdapter", "convert"));
        }
        return mouseWheelEvent;
    }

    @NotNull
    public static MenuDragMouseEvent convert(MenuDragMouseEvent event, Component source, int id, long when, int modifiers, int x, int y) {
        MenuDragMouseEvent menuDragMouseEvent = new MenuDragMouseEvent(source, id, when, modifiers, x, y, event.getClickCount(), event.isPopupTrigger(), event.getPath(), event.getMenuSelectionManager());
        if (menuDragMouseEvent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/MouseEventAdapter", "convert"));
        }
        return menuDragMouseEvent;
    }
}

