/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.alternatives;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoException;
import org.picocontainer.PicoVerificationException;
import org.picocontainer.PicoVisitor;
import org.picocontainer.defaults.VerifyingVisitor;

public class ImmutablePicoContainer
implements PicoContainer,
Serializable {
    private PicoContainer delegate;

    public ImmutablePicoContainer(PicoContainer delegate) {
        if (delegate == null) {
            throw new NullPointerException("You must pass in a picoContainer instance");
        }
        this.delegate = delegate;
    }

    public Object getComponentInstance(Object componentKey) {
        return this.delegate.getComponentInstance(componentKey);
    }

    public Object getComponentInstanceOfType(Class componentType) {
        return this.delegate.getComponentInstanceOfType(componentType);
    }

    public List getComponentInstances() {
        return this.delegate.getComponentInstances();
    }

    public synchronized PicoContainer getParent() {
        return this.delegate.getParent();
    }

    public ComponentAdapter getComponentAdapter(Object componentKey) {
        return this.delegate.getComponentAdapter(componentKey);
    }

    public ComponentAdapter getComponentAdapterOfType(Class componentType) {
        return this.delegate.getComponentAdapterOfType(componentType);
    }

    public Collection getComponentAdapters() {
        return this.delegate.getComponentAdapters();
    }

    public List getComponentAdaptersOfType(Class componentType) {
        return this.delegate.getComponentAdaptersOfType(componentType);
    }

    public void verify() throws PicoVerificationException {
        new VerifyingVisitor().traverse(this);
    }

    public List getComponentInstancesOfType(Class type2) throws PicoException {
        return this.delegate.getComponentInstancesOfType(type2);
    }

    public void accept(PicoVisitor visitor) {
        this.delegate.accept(visitor);
    }

    public void start() {
        throw new UnsupportedOperationException("This container is immutable, start() is not allowed");
    }

    public void stop() {
        throw new UnsupportedOperationException("This container is immutable, stop() is not allowed");
    }

    public void dispose() {
        throw new UnsupportedOperationException("This container is immutable, dispose() is not allowed");
    }
}

