/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.uast.kotlin;

import com.intellij.lang.Language;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiVariable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForFacade;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastLanguagePlugin;
import org.jetbrains.uast.kotlin.KotlinAbstractUExpression;
import org.jetbrains.uast.kotlin.KotlinConverter;
import org.jetbrains.uast.kotlin.KotlinInternalUastUtilsKt;
import org.jetbrains.uast.kotlin.KotlinUFunctionCallExpression;
import org.jetbrains.uast.kotlin.KotlinUSimpleReferenceExpression;
import org.jetbrains.uast.kotlin.KotlinUastResolveProviderService;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00102\u0010\u0010\u0013\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0010\u0018\u00010\u0014H\u0016J$\u0010\u0015\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\r2\u0010\u0010\u0013\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0010\u0018\u00010\u0014H\u0016J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J$\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0011\u001a\u00020\r2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001d\u001a\u00020\u0019H\u0016J\u0010\u0010\u001e\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\u0019H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\u00020\f*\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u000e\u00a8\u0006\""}, d2={"Lorg/jetbrains/uast/kotlin/KotlinUastLanguagePlugin;", "Lorg/jetbrains/uast/UastLanguagePlugin;", "()V", "language", "Lcom/intellij/lang/Language;", "getLanguage", "()Lcom/intellij/lang/Language;", "priority", "", "getPriority", "()I", "isJvmElement", "", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)Z", "convertElement", "Lorg/jetbrains/uast/UElement;", "element", "parent", "requiredType", "Ljava/lang/Class;", "convertElementWithParent", "getConstructorCallExpression", "Lorg/jetbrains/uast/UastLanguagePlugin$ResolvedConstructor;", "fqName", "", "getMethodCallExpression", "Lorg/jetbrains/uast/UastLanguagePlugin$ResolvedMethod;", "containingClassFqName", "methodName", "isExpressionValueUsed", "Lorg/jetbrains/uast/UExpression;", "isFileSupported", "fileName", "uast-kotlin"})
public final class KotlinUastLanguagePlugin
implements UastLanguagePlugin {
    private final int priority = 10;

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    @NotNull
    public Language getLanguage() {
        KotlinLanguage kotlinLanguage = KotlinLanguage.INSTANCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinLanguage, (String)"KotlinLanguage.INSTANCE");
        return (Language)kotlinLanguage;
    }

    @Override
    public boolean isFileSupported(@NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        return StringsKt.endsWith((String)fileName, (String)".kt", (boolean)false) || StringsKt.endsWith((String)fileName, (String)".kts", (boolean)false);
    }

    private final boolean isJvmElement(@NotNull PsiElement $this$isJvmElement) {
        KotlinUastResolveProviderService resolveProvider = (KotlinUastResolveProviderService)ServiceManager.getService((Project)$this$isJvmElement.getProject(), KotlinUastResolveProviderService.class);
        return resolveProvider.isJvmElement($this$isJvmElement);
    }

    @Override
    @Nullable
    public UElement convertElement(@NotNull PsiElement element, @Nullable UElement parent, @Nullable Class<? extends UElement> requiredType) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        if (!this.isJvmElement(element)) {
            return null;
        }
        return KotlinConverter.INSTANCE.convertDeclarationOrElement(element, parent, requiredType);
    }

    @Override
    @Nullable
    public UElement convertElementWithParent(@NotNull PsiElement element, @Nullable Class<? extends UElement> requiredType) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        if (!this.isJvmElement(element)) {
            return null;
        }
        if (element instanceof PsiFile) {
            return KotlinConverter.INSTANCE.convertDeclaration$uast_kotlin(element, null, requiredType);
        }
        if (element instanceof KtLightClassForFacade) {
            return KotlinConverter.INSTANCE.convertDeclaration$uast_kotlin(element, null, requiredType);
        }
        return KotlinConverter.INSTANCE.convertDeclarationOrElement(element, null, requiredType);
    }

    @Override
    @Nullable
    public UastLanguagePlugin.ResolvedMethod getMethodCallExpression(@NotNull PsiElement element, @Nullable String containingClassFqName, @NotNull String methodName2) {
        PsiElement parent;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)methodName2, (String)"methodName");
        if (!(element instanceof KtCallExpression)) {
            return null;
        }
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)element), (BindingContext)KotlinInternalUastUtilsKt.analyze((KtElement)element));
        if (resolvedCall == null) {
            return null;
        }
        ResolvedCall resolvedCall2 = resolvedCall;
        CallableDescriptor resultingDescriptor = resolvedCall2.getResultingDescriptor();
        if (!(resultingDescriptor instanceof FunctionDescriptor) || Intrinsics.areEqual((Object)((FunctionDescriptor)resultingDescriptor).getName().asString(), (Object)methodName2) ^ true) {
            return null;
        }
        PsiElement psiElement = parent = ((KtCallExpression)element).getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"parent");
        UElement uElement = this.convertElementWithParent(psiElement, null);
        if (uElement == null) {
            return null;
        }
        UElement parentUElement = uElement;
        KotlinUFunctionCallExpression uExpression = new KotlinUFunctionCallExpression((KtCallElement)element, parentUElement, resolvedCall2);
        PsiMethod psiMethod = uExpression.resolve();
        if (psiMethod == null) {
            return null;
        }
        PsiMethod method = psiMethod;
        if (Intrinsics.areEqual((Object)method.getName(), (Object)methodName2) ^ true) {
            return null;
        }
        return new UastLanguagePlugin.ResolvedMethod(uExpression, method);
    }

    @Override
    @Nullable
    public UastLanguagePlugin.ResolvedConstructor getConstructorCallExpression(@NotNull PsiElement element, @NotNull String fqName) {
        ClassifierDescriptor classifierDescriptor;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)fqName, (String)"fqName");
        if (!(element instanceof KtCallExpression)) {
            return null;
        }
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)element), (BindingContext)KotlinInternalUastUtilsKt.analyze((KtElement)element));
        if (resolvedCall == null) {
            return null;
        }
        ResolvedCall resolvedCall2 = resolvedCall;
        CallableDescriptor resultingDescriptor = resolvedCall2.getResultingDescriptor();
        if (!(resultingDescriptor instanceof ConstructorDescriptor) || Intrinsics.areEqual((Object)((classifierDescriptor = ((ConstructorDescriptor)resultingDescriptor).getReturnType().getConstructor().getDeclarationDescriptor()) != null && (classifierDescriptor = classifierDescriptor.getName()) != null ? classifierDescriptor.asString() : null), (Object)fqName) ^ true) {
            return null;
        }
        PsiElement psiElement = KotlinConverter.INSTANCE.unwrapElements$uast_kotlin(((KtCallExpression)element).getParent());
        if (psiElement == null) {
            return null;
        }
        PsiElement parent = psiElement;
        UElement uElement = this.convertElementWithParent(parent, null);
        if (uElement == null) {
            return null;
        }
        UElement parentUElement = uElement;
        KotlinUFunctionCallExpression uExpression = new KotlinUFunctionCallExpression((KtCallElement)element, parentUElement, resolvedCall2);
        PsiMethod psiMethod = uExpression.resolve();
        if (psiMethod == null) {
            return null;
        }
        PsiMethod method = psiMethod;
        PsiClass psiClass = method.getContainingClass();
        if (psiClass == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiClass, (String)"method.containingClass ?: return null");
        PsiClass containingClass = psiClass;
        return new UastLanguagePlugin.ResolvedConstructor(uExpression, method, containingClass);
    }

    @Override
    public boolean isExpressionValueUsed(@NotNull UExpression element) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        UExpression uExpression = element;
        if (uExpression instanceof KotlinUSimpleReferenceExpression.KotlinAccessorCallExpression) {
            bl = ((KotlinUSimpleReferenceExpression.KotlinAccessorCallExpression)element).getSetterValue() != null;
        } else if (uExpression instanceof KotlinAbstractUExpression) {
            PsiElement psiElement = element.getPsi();
            if (!(psiElement instanceof KtElement)) {
                psiElement = null;
            }
            KtElement ktElement = (KtElement)psiElement;
            if (ktElement == null) {
                return false;
            }
            KtElement ktElement2 = ktElement;
            Boolean bl2 = (Boolean)KotlinInternalUastUtilsKt.analyze(ktElement2).get((ReadOnlySlice)BindingContext.USED_AS_EXPRESSION, (Object)ktElement2);
            if (bl2 == null) {
                bl2 = false;
            }
            bl = bl2;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public UExpression getInitializerBody(@NotNull PsiClassInitializer element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return UastLanguagePlugin.DefaultImpls.getInitializerBody((UastLanguagePlugin)this, element);
    }

    @Override
    @Nullable
    public UExpression getInitializerBody(@NotNull PsiVariable element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return UastLanguagePlugin.DefaultImpls.getInitializerBody((UastLanguagePlugin)this, element);
    }

    @Override
    @Nullable
    public UExpression getMethodBody(@NotNull PsiMethod element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return UastLanguagePlugin.DefaultImpls.getMethodBody(this, element);
    }
}

