/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.rendering.api;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;

public class ItemResourceValue
extends ResourceValue {
    private final boolean mIsFrameworkAttr;

    public ItemResourceValue(String attributeName, boolean isFrameworkAttr, String value, boolean isFrameworkStyle, String libraryName) {
        super(ResourceUrl.create(ResourceType.STYLE_ITEM, attributeName, isFrameworkStyle), value, libraryName);
        this.mIsFrameworkAttr = isFrameworkAttr;
    }

    public boolean isFrameworkAttr() {
        return this.mIsFrameworkAttr;
    }

    @Override
    public String toString() {
        return super.toString() + " (mIsFrameworkAttr=" + this.mIsFrameworkAttr + ")";
    }

    Attribute getAttribute() {
        return new Attribute(this.getName(), this.mIsFrameworkAttr);
    }

    static final class Attribute {
        String mName;
        boolean mIsFrameworkAttr;

        Attribute(String name, boolean isFrameworkAttr) {
            this.mName = name;
            this.mIsFrameworkAttr = isFrameworkAttr;
        }

        public int hashCode() {
            int booleanHash = this.mIsFrameworkAttr ? 1231 : 1237;
            return 31 * booleanHash + this.mName.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Attribute) {
                Attribute attr = (Attribute)obj;
                return this.mIsFrameworkAttr == attr.mIsFrameworkAttr && this.mName.equals(attr.mName);
            }
            return false;
        }

        public String toString() {
            return this.mName + " (framework:" + this.mIsFrameworkAttr + ")";
        }
    }
}

