/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.rendering.api;

import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.Objects;
import java.util.function.Function;

public class ResourceNamespace
implements Serializable {
    public static final ResourceNamespace ANDROID = new ResourceNamespace("android");
    public static final ResourceNamespace RES_AUTO = new ResAutoNamespace();
    public static final ResourceNamespace TOOLS = new ToolsNamespace();
    public static final ResourceNamespace TODO = RES_AUTO;
    public static final Function<String, String> EMPTY_NAMESPACE_CONTEXT = s -> null;
    private final String packageName;

    public static ResourceNamespace fromPackageName(String packageName) {
        assert (!Strings.isNullOrEmpty((String)packageName));
        if (packageName.equals("android")) {
            return ANDROID;
        }
        return new ResourceNamespace(packageName);
    }

    @Deprecated
    public static ResourceNamespace fromBoolean(boolean isFramework) {
        return isFramework ? ANDROID : TODO;
    }

    public static ResourceNamespace fromNamespacePrefix(String prefix, ResourceNamespace defaultNamespace, Function<String, String> namespaceLookup) {
        if (Strings.isNullOrEmpty((String)prefix)) {
            return defaultNamespace;
        }
        String uri = namespaceLookup.apply(prefix);
        if (uri != null) {
            if (uri.equals("http://schemas.android.com/apk/res-auto")) {
                return RES_AUTO;
            }
            if (uri.equals("http://schemas.android.com/tools")) {
                return TOOLS;
            }
            if (uri.startsWith("http://schemas.android.com/apk/res/")) {
                String packageName = uri.substring("http://schemas.android.com/apk/res/".length());
                if (!packageName.isEmpty()) {
                    return new ResourceNamespace(packageName);
                }
                return null;
            }
            return null;
        }
        return ResourceNamespace.fromPackageName(prefix);
    }

    private ResourceNamespace(String packageName) {
        this.packageName = packageName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getXmlNamespaceUri() {
        return "http://schemas.android.com/apk/res/" + this.packageName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceNamespace that = (ResourceNamespace)o;
        return Objects.equals(this.packageName, that.packageName);
    }

    public int hashCode() {
        return Objects.hashCode(this.packageName);
    }

    public String toString() {
        return this.packageName;
    }

    private static class ToolsNamespace
    extends ResourceNamespace {
        private ToolsNamespace() {
            super(null);
        }

        @Override
        public String getXmlNamespaceUri() {
            return "http://schemas.android.com/tools";
        }

        @Override
        public String toString() {
            return "tools";
        }

        @Override
        public int hashCode() {
            return 1;
        }
    }

    private static class ResAutoNamespace
    extends ResourceNamespace {
        private ResAutoNamespace() {
            super(null);
        }

        @Override
        public String getXmlNamespaceUri() {
            return "http://schemas.android.com/apk/res-auto";
        }

        @Override
        public String toString() {
            return "res-auto";
        }
    }
}

