/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.resources.ResourceType;
import java.io.Serializable;
import java.util.Objects;
import java.util.function.Function;

public class ResourceUrl
implements Serializable {
    public final ResourceType type;
    public final String name;
    public final String namespace;
    public final boolean framework;
    public final boolean create;
    public final boolean theme;

    private ResourceUrl(ResourceType type, String name, String namespace, boolean framework, boolean create, boolean theme) {
        this.type = type;
        this.name = name;
        this.framework = framework;
        this.namespace = namespace;
        this.create = create;
        this.theme = theme;
    }

    @Deprecated
    public static ResourceUrl create(ResourceType type, String name, boolean framework) {
        return new ResourceUrl(type, name, framework ? "android" : null, framework, false, false);
    }

    public static ResourceUrl create(String namespace, ResourceType type, String name) {
        return new ResourceUrl(type, name, namespace, "android".equals(namespace), false, false);
    }

    public static ResourceUrl parse(String url) {
        return ResourceUrl.parse(url, false);
    }

    public static ResourceUrl parse(String url, boolean forceFramework) {
        String typeName;
        ResourceType type;
        String namespace;
        boolean isTheme = false;
        if (url.startsWith("?")) {
            isTheme = true;
            String remainder = url.substring("?".length());
            if (url.startsWith("?attr/")) {
                url = "@" + url.substring("?".length());
            } else {
                int colon = url.indexOf(58);
                if (colon != -1) {
                    if (remainder.indexOf(47, colon) == -1) {
                        remainder = remainder.substring(0, colon) + "attr" + '/' + remainder.substring(colon);
                    }
                    url = "@" + remainder;
                } else {
                    int slash = url.indexOf(47);
                    if (slash == -1) {
                        url = "@attr/" + remainder;
                    }
                }
            }
        }
        if (!url.startsWith("@") || ResourceUrl.isNullOrEmpty(url)) {
            return null;
        }
        int typeEnd = url.indexOf(47, 1);
        if (typeEnd == -1) {
            return null;
        }
        int nameBegin = typeEnd + 1;
        boolean create = url.startsWith("@+");
        int typeBegin = create ? 2 : 1;
        int colon = url.lastIndexOf(58, typeEnd);
        boolean framework = forceFramework;
        String string = namespace = forceFramework ? "android" : null;
        if (colon != -1) {
            if (url.startsWith("android", typeBegin)) {
                framework = true;
                namespace = "android";
            } else {
                namespace = url.substring(typeBegin, colon);
            }
            typeBegin = colon + 1;
        }
        if ((type = ResourceType.getEnum(typeName = url.substring(typeBegin, typeEnd))) == null) {
            return null;
        }
        String name = url.substring(nameBegin);
        if (name.isEmpty()) {
            return null;
        }
        return new ResourceUrl(type, name, namespace, framework, create, isTheme);
    }

    public static boolean isNullOrEmpty(String url) {
        return url.equals("@null") || url.equals("@empty") || url.equals("@undefined");
    }

    public boolean hasValidName() {
        return ResourceUrl.isValidName(this.name, this.type);
    }

    public static boolean isValidName(String input, ResourceType type) {
        if (input.isEmpty()) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(input.charAt(0))) {
            return false;
        }
        int n = input.length();
        for (int i = 1; i < n; ++i) {
            char c = input.charAt(i);
            if (Character.isJavaIdentifierPart(c) || c == '.' || type == ResourceType.SAMPLE_DATA && (c == '/' || c == '[' || c == ']' || c == ':')) continue;
            return false;
        }
        return true;
    }

    public ResourceUrl asThemeUrl() {
        return new ResourceUrl(this.type, this.name, this.namespace, this.framework, this.create, true);
    }

    public ResourceReference resolve(ResourceNamespace contextNamespace, Function<String, String> namespaceLookup) {
        ResourceNamespace resolvedNamespace = ResourceNamespace.fromNamespacePrefix(this.namespace, contextNamespace, namespaceLookup);
        if (resolvedNamespace == null) {
            return null;
        }
        return new ResourceReference(resolvedNamespace, this.type, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.theme ? "?" : "@");
        if (this.create) {
            sb.append('+');
        }
        if (this.framework) {
            sb.append("android");
            sb.append(':');
        }
        sb.append(this.type.getName());
        sb.append('/');
        sb.append(this.name);
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceUrl that = (ResourceUrl)o;
        return this.framework == that.framework && this.create == that.create && this.theme == that.theme && this.type == that.type && Objects.equals(this.name, that.name) && Objects.equals(this.namespace, that.namespace);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.name, this.namespace, this.framework, this.create, this.theme});
    }
}

