/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.rendering.api;

import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.resources.ResourceType;
import java.util.ArrayList;
import java.util.List;

public class PluralsResourceValue
extends ResourceValue {
    private final List<String> mQuantities = new ArrayList<String>();
    private final List<String> mValues = new ArrayList<String>();

    public PluralsResourceValue(ResourceReference reference, String value, String libraryName) {
        super(reference, value, libraryName);
        assert (reference.getResourceType() == ResourceType.PLURALS);
    }

    public void addPlural(String quantity, String value) {
        this.mQuantities.add(quantity);
        this.mValues.add(value);
    }

    public int getPluralsCount() {
        return this.mQuantities.size();
    }

    public String getQuantity(int index) {
        return this.mQuantities.get(index);
    }

    public String getValue(int index) {
        return this.mValues.get(index);
    }

    public String getValue(String quantity) {
        assert (this.mQuantities.size() == this.mValues.size());
        int n = this.mQuantities.size();
        for (int i = 0; i < n; ++i) {
            if (!quantity.equals(this.mQuantities.get(i))) continue;
            return this.mValues.get(i);
        }
        return null;
    }

    @Override
    public String getValue() {
        if (super.getValue() == null && !this.mValues.isEmpty()) {
            return this.getValue(0);
        }
        return super.getValue();
    }
}

