/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.rendering.api;

import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.regex.Pattern;

public class SampleDataResourceValue
extends ResourceValue {
    private static final Splitter NEW_LINE_SPLITTER = Splitter.on((Pattern)Pattern.compile("\r?\n")).omitEmptyStrings();
    private final ImmutableList<String> myLines;
    private final ResourceReference myReference;

    public SampleDataResourceValue(ResourceReference reference, byte[] content) {
        super(reference, null);
        this.myReference = reference;
        this.myLines = content != null ? ImmutableList.copyOf((Collection)NEW_LINE_SPLITTER.splitToList((CharSequence)new String(content, Charsets.UTF_8))) : ImmutableList.of();
    }

    @Override
    public String getValue() {
        return this.myReference.getResourceUrl().toString();
    }

    public ImmutableList<String> getValueAsLines() {
        return this.myLines;
    }

    @Override
    public ResourceReference getReference() {
        return this.myReference;
    }
}

