/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.rendering.api;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.utils.HashCodes;
import com.google.common.base.MoreObjects;
import java.io.Serializable;

public final class ResourceReference
implements Serializable {
    private final ResourceType resourceType;
    private final ResourceNamespace namespace;
    private final String name;

    public ResourceReference(ResourceNamespace namespace, ResourceType resourceType, String name) {
        this.namespace = namespace;
        this.resourceType = resourceType;
        this.name = name;
    }

    @Deprecated
    public ResourceReference(String name, boolean isFramework) {
        this(ResourceNamespace.fromBoolean(isFramework), ResourceType.LAYOUT, name);
    }

    @Deprecated
    public ResourceReference(ResourceType type, String name, boolean isFramework) {
        this(ResourceNamespace.fromBoolean(isFramework), type, name);
    }

    public static ResourceReference style(ResourceNamespace namespace, String name) {
        return new ResourceReference(namespace, ResourceType.STYLE, name);
    }

    public String getName() {
        return this.name;
    }

    public String getQualifiedName() {
        String packageName = this.namespace.getPackageName();
        return packageName == null ? this.name : packageName + ':' + this.name;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public ResourceNamespace getNamespace() {
        return this.namespace;
    }

    @Deprecated
    public final boolean isFramework() {
        return ResourceNamespace.ANDROID.equals(this.namespace);
    }

    public ResourceUrl getResourceUrl() {
        return ResourceUrl.create(this.namespace.getPackageName(), this.resourceType, this.name);
    }

    public ResourceUrl getRelativeResourceUrl(ResourceNamespace context) {
        return this.getRelativeResourceUrl(context, ResourceNamespace.Resolver.EMPTY_RESOLVER);
    }

    public ResourceUrl getRelativeResourceUrl(ResourceNamespace context, ResourceNamespace.Resolver resolver) {
        String prefix;
        String namespaceString = this.namespace.equals(context) ? null : ((prefix = resolver.uriToPrefix(this.namespace.getXmlNamespaceUri())) != null ? prefix : this.namespace.getPackageName());
        return ResourceUrl.create(namespaceString, this.resourceType, this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceReference reference = (ResourceReference)o;
        if (this.resourceType != reference.resourceType) {
            return false;
        }
        if (!this.namespace.equals(reference.namespace)) {
            return false;
        }
        return this.name.equals(reference.name);
    }

    public int hashCode() {
        return HashCodes.mix((int)this.resourceType.hashCode(), (int)this.namespace.hashCode(), (int)this.name.hashCode());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("namespace", (Object)this.namespace).add("type", (Object)this.resourceType).add("name", (Object)this.name).toString();
    }
}

