/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.resources.ResourceType;
import com.android.utils.HashCodes;
import java.io.Serializable;
import java.util.Objects;

public class ResourceUrl
implements Serializable {
    public final ResourceType type;
    public final String name;
    public final String namespace;
    public final UrlType urlType;
    public final boolean privateAccessOverride;

    public boolean isFramework() {
        return "android".equals(this.namespace);
    }

    public boolean isCreate() {
        return this.urlType == UrlType.CREATE;
    }

    public boolean isTheme() {
        return this.urlType == UrlType.THEME;
    }

    public boolean isPrivateAccessOverride() {
        return this.privateAccessOverride;
    }

    private ResourceUrl(ResourceType type, String name, String namespace, UrlType urlType, boolean privateAccessOverride) {
        this.type = type;
        this.name = name;
        this.namespace = namespace;
        this.urlType = urlType;
        this.privateAccessOverride = privateAccessOverride;
    }

    @Deprecated
    public static ResourceUrl create(ResourceType type, String name, boolean framework) {
        return new ResourceUrl(type, name, framework ? "android" : null, UrlType.NORMAL, false);
    }

    public static ResourceUrl create(String namespace, ResourceType type, String name) {
        return new ResourceUrl(type, name, namespace, UrlType.NORMAL, false);
    }

    public static ResourceUrl createThemeReference(String namespace, ResourceType type, String name) {
        return new ResourceUrl(type, name, namespace, UrlType.THEME, false);
    }

    public static ResourceUrl createAttrReference(String namespace, String name) {
        return new ResourceUrl(ResourceType.ATTR, name, namespace, UrlType.ATTR, false);
    }

    public static ResourceUrl parse(String url) {
        return ResourceUrl.parse(url, false);
    }

    public static ResourceUrl parse(String url, boolean forceFramework) {
        String typeName;
        ResourceType type;
        String namespace;
        int typeBegin;
        UrlType urlType = UrlType.NORMAL;
        boolean privateAccessOverride = false;
        if (url.startsWith("?")) {
            urlType = UrlType.THEME;
            String remainder = url.substring("?".length());
            if (url.startsWith("?attr/")) {
                url = "@" + url.substring("?".length());
            } else {
                int colon = url.indexOf(58);
                if (colon >= 0) {
                    if (remainder.indexOf(47, colon) < 0) {
                        remainder = remainder.substring(0, colon) + "attr" + '/' + remainder.substring(colon);
                    }
                    url = "@" + remainder;
                } else {
                    int slash = url.indexOf(47);
                    if (slash < 0) {
                        url = "@attr/" + remainder;
                    }
                }
            }
        }
        if (!url.startsWith("@") || ResourceUrl.isNullOrEmpty(url)) {
            return null;
        }
        int typeEnd = url.indexOf(47, 1);
        if (typeEnd < 0) {
            return null;
        }
        int nameBegin = typeEnd + 1;
        if (url.startsWith("@+")) {
            urlType = UrlType.CREATE;
            typeBegin = 2;
        } else {
            typeBegin = 1;
        }
        if (url.startsWith("*", typeBegin)) {
            ++typeBegin;
            privateAccessOverride = true;
        }
        int colon = url.lastIndexOf(58, typeEnd);
        String string = namespace = forceFramework ? "android" : null;
        if (colon >= 0) {
            if (colon - typeBegin == "android".length() && url.startsWith("android", typeBegin)) {
                namespace = "android";
            } else {
                namespace = url.substring(typeBegin, colon);
                if (namespace.isEmpty()) {
                    return null;
                }
            }
            typeBegin = colon + 1;
        }
        if ((type = ResourceType.fromXmlValue(typeName = url.substring(typeBegin, typeEnd))) == null) {
            return null;
        }
        String name = url.substring(nameBegin);
        if (name.isEmpty()) {
            return null;
        }
        return new ResourceUrl(type, name, namespace, urlType, privateAccessOverride);
    }

    public static ResourceUrl parseAttrReference(String input) {
        String name;
        if (input.isEmpty()) {
            return null;
        }
        if (input.charAt(0) == '@' || input.charAt(0) == '?') {
            return null;
        }
        boolean privateAccessOverride = false;
        int prefixEnd = 0;
        if (input.charAt(0) == '*') {
            prefixEnd = 1;
            privateAccessOverride = true;
        }
        if (input.indexOf(47, prefixEnd) >= 0) {
            return null;
        }
        String namespace = null;
        int colon = input.indexOf(58, prefixEnd);
        if (colon < 0) {
            name = input.substring(prefixEnd);
        } else {
            namespace = input.substring(prefixEnd, colon);
            if (namespace.isEmpty()) {
                return null;
            }
            name = input.substring(colon + 1);
        }
        if (name.isEmpty()) {
            return null;
        }
        return new ResourceUrl(ResourceType.ATTR, name, namespace, UrlType.ATTR, privateAccessOverride);
    }

    public static ResourceUrl parseStyleParentReference(String input) {
        String name;
        int slash;
        if (input.isEmpty()) {
            return null;
        }
        boolean privateAccessOverride = false;
        int pos = 0;
        if (input.charAt(pos) == '@' || input.charAt(pos) == '?') {
            ++pos;
        }
        if (input.startsWith("*", pos)) {
            ++pos;
            privateAccessOverride = true;
        }
        String namespace = null;
        int colon = input.indexOf(58, pos);
        if (colon != -1) {
            namespace = input.substring(pos, colon);
            if (namespace.isEmpty()) {
                return null;
            }
            pos = colon + 1;
        }
        if ((slash = input.indexOf(47, pos)) != -1) {
            if (!input.startsWith("style/", pos)) {
                return null;
            }
            pos = slash + 1;
        }
        if ((name = input.substring(pos)).isEmpty()) {
            return null;
        }
        return new ResourceUrl(ResourceType.STYLE, name, namespace, UrlType.NORMAL, privateAccessOverride);
    }

    public static boolean isNullOrEmpty(String url) {
        return url.equals("@null") || url.equals("@empty") || url.equals("@undefined");
    }

    public boolean hasValidName() {
        return ResourceUrl.isValidName(this.name, this.type);
    }

    public static boolean isValidName(String input, ResourceType type) {
        if (input.isEmpty()) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(input.charAt(0))) {
            return false;
        }
        int n = input.length();
        for (int i = 1; i < n; ++i) {
            char c = input.charAt(i);
            if (Character.isJavaIdentifierPart(c) || c == '.' || type == ResourceType.SAMPLE_DATA && (c == '/' || c == '[' || c == ']' || c == ':')) continue;
            return false;
        }
        return true;
    }

    public ResourceReference resolve(ResourceNamespace contextNamespace, ResourceNamespace.Resolver resolver) {
        ResourceNamespace resolvedNamespace = ResourceNamespace.fromNamespacePrefix(this.namespace, contextNamespace, resolver);
        if (resolvedNamespace == null) {
            return null;
        }
        return new ResourceReference(resolvedNamespace, this.type, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        switch (this.urlType) {
            case NORMAL: {
                sb.append("@");
                break;
            }
            case CREATE: {
                sb.append("@+");
                break;
            }
            case THEME: {
                sb.append("?");
                break;
            }
        }
        if (this.privateAccessOverride) {
            sb.append('*');
        }
        if (this.namespace != null) {
            sb.append(this.namespace);
            sb.append(':');
        }
        if (this.urlType != UrlType.ATTR) {
            sb.append(this.type.getName());
            sb.append('/');
        }
        sb.append(this.name);
        return sb.toString();
    }

    public String getQualifiedName() {
        if (this.namespace == null) {
            return this.name;
        }
        return this.namespace + ':' + this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceUrl that = (ResourceUrl)o;
        return this.urlType == that.urlType && this.type == that.type && Objects.equals(this.name, that.name) && Objects.equals(this.namespace, that.namespace);
    }

    public int hashCode() {
        return HashCodes.mix((int)this.urlType.hashCode(), (int)this.type.hashCode(), (int)Objects.hashCode(this.name), (int)Objects.hashCode(this.namespace));
    }

    public static enum UrlType {
        NORMAL,
        CREATE,
        THEME,
        ATTR;

    }
}

