/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.rendering.api;

import com.android.ide.common.rendering.api.AdapterBinding;
import com.android.ide.common.rendering.api.HardwareConfig;
import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.LayoutLog;
import com.android.ide.common.rendering.api.LayoutlibCallback;
import com.android.ide.common.rendering.api.RenderParams;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SessionParams
extends RenderParams {
    private final ILayoutPullParser mLayoutDescription;
    private final RenderingMode mRenderingMode;
    private boolean mLayoutOnly = false;
    private Map<ResourceReference, AdapterBinding> mAdapterBindingMap;
    private boolean mExtendedViewInfoMode = false;
    private final int mSimulatedPlatformVersion;

    public SessionParams(ILayoutPullParser layoutDescription, RenderingMode renderingMode, Object projectKey, HardwareConfig hardwareConfig, RenderResources renderResources, LayoutlibCallback layoutlibCallback, int minSdkVersion, int targetSdkVersion, LayoutLog log) {
        this(layoutDescription, renderingMode, projectKey, hardwareConfig, renderResources, layoutlibCallback, minSdkVersion, targetSdkVersion, log, 0);
    }

    public SessionParams(ILayoutPullParser layoutDescription, RenderingMode renderingMode, Object projectKey, HardwareConfig hardwareConfig, RenderResources renderResources, LayoutlibCallback projectCallback, int minSdkVersion, int targetSdkVersion, LayoutLog log, int simulatedPlatformVersion) {
        super(projectKey, hardwareConfig, renderResources, projectCallback, minSdkVersion, targetSdkVersion, log);
        this.mLayoutDescription = layoutDescription;
        this.mRenderingMode = renderingMode;
        this.mSimulatedPlatformVersion = simulatedPlatformVersion;
    }

    public SessionParams(SessionParams params) {
        super(params);
        this.mLayoutDescription = params.mLayoutDescription;
        this.mRenderingMode = params.mRenderingMode;
        this.mSimulatedPlatformVersion = params.mSimulatedPlatformVersion;
        if (params.mAdapterBindingMap != null) {
            this.mAdapterBindingMap = new HashMap<ResourceReference, AdapterBinding>(params.mAdapterBindingMap);
        }
        this.mExtendedViewInfoMode = params.mExtendedViewInfoMode;
    }

    public ILayoutPullParser getLayoutDescription() {
        return this.mLayoutDescription;
    }

    public RenderingMode getRenderingMode() {
        return this.mRenderingMode;
    }

    public void setLayoutOnly() {
        this.mLayoutOnly = true;
    }

    public boolean isLayoutOnly() {
        return this.mLayoutOnly;
    }

    public void addAdapterBinding(ResourceReference reference, AdapterBinding data) {
        if (this.mAdapterBindingMap == null) {
            this.mAdapterBindingMap = new HashMap<ResourceReference, AdapterBinding>();
        }
        this.mAdapterBindingMap.put(reference, data);
    }

    public Map<ResourceReference, AdapterBinding> getAdapterBindings() {
        if (this.mAdapterBindingMap == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.mAdapterBindingMap);
    }

    public void setExtendedViewInfoMode(boolean mode) {
        this.mExtendedViewInfoMode = mode;
    }

    public boolean getExtendedViewInfoMode() {
        return this.mExtendedViewInfoMode;
    }

    public int getSimulatedPlatformVersion() {
        return this.mSimulatedPlatformVersion;
    }

    public static class Key<T> {
        public final Class<T> mExpectedClass;
        public final String mName;

        public Key(String name, Class<T> expectedClass) {
            assert (name != null);
            assert (expectedClass != null);
            this.mExpectedClass = expectedClass;
            this.mName = name;
        }

        public int hashCode() {
            int result = this.mExpectedClass.hashCode();
            return 31 * result + this.mName.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj != null && this.getClass() == obj.getClass()) {
                Key k = (Key)obj;
                return this.mExpectedClass.equals(k.mExpectedClass) && this.mName.equals(k.mName);
            }
            return false;
        }

        public String toString() {
            return this.mName;
        }
    }

    public static enum RenderingMode {
        NORMAL(SizeAction.KEEP, SizeAction.KEEP),
        V_SCROLL(SizeAction.KEEP, SizeAction.EXPAND),
        H_SCROLL(SizeAction.EXPAND, SizeAction.KEEP),
        FULL_EXPAND(SizeAction.EXPAND, SizeAction.EXPAND),
        SHRINK(SizeAction.SHRINK, SizeAction.SHRINK);

        private final SizeAction mHorizAction;
        private final SizeAction mVertAction;

        private RenderingMode(SizeAction horizAction, SizeAction vertAction) {
            this.mHorizAction = horizAction;
            this.mVertAction = vertAction;
        }

        @Deprecated
        public boolean isHorizExpand() {
            return this.mHorizAction == SizeAction.EXPAND;
        }

        @Deprecated
        public boolean isVertExpand() {
            return this.mVertAction == SizeAction.EXPAND;
        }

        public SizeAction getHorizAction() {
            return this.mHorizAction;
        }

        public SizeAction getVertAction() {
            return this.mVertAction;
        }

        public static enum SizeAction {
            EXPAND,
            KEEP,
            SHRINK;

        }
    }
}

