/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.google.common.annotations.Beta;

@Beta
public enum Severity {
    FATAL("Fatal"),
    ERROR("Error"),
    WARNING("Warning"),
    INFORMATIONAL("Information"),
    IGNORE("Ignore");

    private final String display;

    private Severity(String display) {
        this.display = display;
    }

    public String getDescription() {
        return this.display;
    }

    public String getName() {
        return this.name();
    }

    public static Severity fromName(String name) {
        for (Severity severity : Severity.values()) {
            if (!severity.name().equalsIgnoreCase(name)) continue;
            return severity;
        }
        return null;
    }

    public static Severity fromLintOptionSeverity(int severity) {
        switch (severity) {
            case 1: {
                return FATAL;
            }
            case 2: {
                return ERROR;
            }
            case 3: {
                return WARNING;
            }
            case 4: {
                return INFORMATIONAL;
            }
        }
        return IGNORE;
    }

    public static Severity min(Severity severity1, Severity severity2) {
        return severity1.compareTo(severity2) > 0 ? severity1 : severity2;
    }

    public static Severity max(Severity severity1, Severity severity2) {
        return severity1.compareTo(severity2) < 0 ? severity1 : severity2;
    }

    public boolean isError() {
        return this == ERROR || this == FATAL;
    }
}

