/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.SdkConstants;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.Variant;
import com.android.ide.common.repository.ResourceVisibilityLookup;
import com.android.ide.common.res2.AbstractResourceRepository;
import com.android.ide.common.res2.ResourceItem;
import com.android.manifmerger.Actions;
import com.android.prefs.AndroidLocation;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressIndicatorAdapter;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.targets.AndroidTargetManager;
import com.android.tools.lint.client.api.BlameFile;
import com.android.tools.lint.client.api.CircularDependencyException;
import com.android.tools.lint.client.api.ClassEntry;
import com.android.tools.lint.client.api.CompositeIssueRegistry;
import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.DefaultConfiguration;
import com.android.tools.lint.client.api.DefaultSdkInfo;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.JarFileIssueRegistry;
import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.SdkInfo;
import com.android.tools.lint.client.api.UastParser;
import com.android.tools.lint.client.api.XmlParser;
import com.android.tools.lint.detector.api.CharSequences;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.utils.Pair;
import com.android.utils.XmlUtils;
import com.google.common.annotations.Beta;
import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Beta
public abstract class LintClient {
    private static final String PROP_BIN_DIR = "com.android.tools.lint.bindir";
    private static final int SDK_DATABASE_MIN_VERSION = 26;
    private Map<Project, ClassPathInfo> projectInfo;
    protected Map<File, Project> dirToProject;
    protected Set<File> projectDirs = Sets.newHashSet();
    protected IAndroidTarget[] targets;
    protected AndroidSdkHandler sdk;
    private static final String MERGED_MANIFEST = "lint-merged-manifest";
    private Map<Object, BlameFile> reportFileCache;
    protected IdentityHashMap<Node, Pair<File, Node>> sourceNodeCache;
    protected static final Pair<File, Node> NOT_FOUND = Pair.of(null, null);
    private ResourceVisibilityLookup.Provider resourceVisibility;
    public static final String CLIENT_STUDIO = "studio";
    public static final String CLIENT_GRADLE = "gradle";
    public static final String CLIENT_CLI = "cli";
    public static final String CLIENT_UNKNOWN = "unknown";
    private static String clientName = "unknown";

    protected LintClient(String clientName) {
        LintClient.clientName = clientName;
    }

    protected LintClient() {
        clientName = CLIENT_UNKNOWN;
    }

    public Configuration getConfiguration(Project project, LintDriver driver) {
        return DefaultConfiguration.create(this, project, null);
    }

    public abstract void report(Context var1, Issue var2, Severity var3, Location var4, String var5, TextFormat var6, LintFix var7);

    public void log(Throwable exception, String format, Object ... args) {
        this.log(Severity.WARNING, exception, format, args);
    }

    public abstract void log(Severity var1, Throwable var2, String var3, Object ... var4);

    public abstract XmlParser getXmlParser();

    public abstract JavaParser getJavaParser(Project var1);

    public abstract UastParser getUastParser(Project var1);

    public Class<? extends Detector> replaceDetector(Class<? extends Detector> detectorClass) {
        return detectorClass;
    }

    public abstract CharSequence readFile(File var1);

    public byte[] readBytes(File file) throws IOException {
        return Files.toByteArray((File)file);
    }

    public List<File> getJavaSourceFolders(Project project) {
        return this.getClassPath(project).getSourceFolders();
    }

    public List<File> getGeneratedSourceFolders(Project project) {
        return this.getClassPath(project).getGeneratedFolders();
    }

    public List<File> getJavaClassFolders(Project project) {
        return this.getClassPath(project).getClassFolders();
    }

    public List<File> getJavaLibraries(Project project, boolean includeProvided) {
        return this.getClassPath(project).getLibraries(includeProvided);
    }

    public List<File> getTestSourceFolders(Project project) {
        return this.getClassPath(project).getTestSourceFolders();
    }

    public List<File> getTestLibraries(Project project) {
        return this.getClassPath(project).getTestLibraries();
    }

    public List<File> getResourceFolders(Project project) {
        File res = new File(project.getDir(), "res");
        if (res.exists()) {
            return Collections.singletonList(res);
        }
        return Collections.emptyList();
    }

    public List<File> getAssetFolders(Project project) {
        File assets = new File(project.getDir(), "assets");
        if (assets.exists()) {
            return Collections.singletonList(assets);
        }
        return Collections.emptyList();
    }

    public SdkInfo getSdkInfo(Project project) {
        return new DefaultSdkInfo();
    }

    public File getCacheDir(boolean create) {
        String path = System.getenv("ANDROID_SDK_CACHE_DIR");
        if (path != null) {
            File dir = new File(path);
            if (create && !dir.exists() && !dir.mkdirs()) {
                return null;
            }
            return dir;
        }
        String home = System.getProperty("user.home");
        String relative = ".android" + File.separator + "cache";
        File dir = new File(home, relative);
        if (create && !dir.exists() && !dir.mkdirs()) {
            return null;
        }
        return dir;
    }

    private static File getLintBinDir() {
        File file;
        String path = System.getProperty(PROP_BIN_DIR);
        if (path == null || path.isEmpty()) {
            path = System.getenv(PROP_BIN_DIR);
        }
        if (path != null && !path.isEmpty() && (file = new File(path)).exists()) {
            return file;
        }
        return null;
    }

    public File getSdkHome() {
        String home;
        File binDir = LintClient.getLintBinDir();
        if (binDir != null) {
            assert (binDir.getName().equals("tools"));
            File root = binDir.getParentFile();
            if (root != null && root.isDirectory()) {
                return root;
            }
        }
        if ((home = System.getenv("ANDROID_HOME")) != null) {
            return new File(home);
        }
        return null;
    }

    public File findResource(String relativePath) {
        File top = this.getSdkHome();
        if (top == null) {
            throw new IllegalArgumentException("Lint must be invoked with $ANDROID_HOME set to point to the SDK, or the System property com.android.tools.lint.bindir pointing to the ANDROID_SDK tools directory");
        }
        boolean isAnnotationZip = "annotations.zip".equals(relativePath);
        boolean isApiDatabase = "api-versions.xml".equals(relativePath);
        if (isAnnotationZip || isApiDatabase) {
            String build;
            File file;
            String path;
            if (isAnnotationZip && (path = System.getenv("SDK_ANNOTATIONS")) != null && (file = new File(path)).exists()) {
                return file;
            }
            IAndroidTarget[] targets = this.getTargets();
            for (int i = targets.length - 1; i >= 0; --i) {
                File file2;
                IAndroidTarget target = targets[i];
                if (!target.isPlatform() || target.getVersion().getFeatureLevel() < 26 || !(file2 = new File(target.getFile(7), relativePath)).isFile()) continue;
                return file2;
            }
            file = new File(top, "platform-tools" + File.separator + "api" + File.separator + relativePath);
            if (file.exists()) {
                return file;
            }
            if (isApiDatabase && (build = System.getenv("ANDROID_BUILD_TOP")) != null && (file = new File(build, "development/sdk/api-versions.xml".replace('/', File.separatorChar))).exists()) {
                return file;
            }
            return null;
        }
        File file = new File(top, relativePath);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    public boolean isGradleProject(Project project) {
        File root;
        if (new File(project.getDir(), "build.gradle").exists()) {
            return true;
        }
        File parent = project.getDir().getParentFile();
        return parent != null && parent.getName().equals("src") && (root = parent.getParentFile()) != null && new File(root, "build.gradle").exists();
    }

    protected ClassPathInfo getClassPath(Project project) {
        ClassPathInfo info;
        if (this.projectInfo == null) {
            this.projectInfo = Maps.newHashMap();
            info = null;
        } else {
            info = this.projectInfo.get(project);
        }
        if (info == null) {
            File[] jars;
            File libs;
            CharSequence classpathXml;
            Document document;
            ArrayList<File> sources = new ArrayList<File>(2);
            ArrayList<File> classes = new ArrayList<File>(1);
            ArrayList<File> generated = new ArrayList<File>(1);
            ArrayList<File> libraries = new ArrayList<File>();
            List<File> tests = Collections.emptyList();
            File projectDir = project.getDir();
            File classpathFile = new File(projectDir, ".classpath");
            if (classpathFile.exists() && (document = CharSequences.parseDocumentSilently(classpathXml = this.readFile(classpathFile), false)) != null) {
                File[] tags = document.getElementsByTagName("classpathentry");
                int n = tags.getLength();
                for (int i = 0; i < n; ++i) {
                    String path;
                    File folder;
                    Element element = (Element)tags.item(i);
                    String kind = element.getAttribute("kind");
                    ArrayList<File> addTo = null;
                    if (kind.equals("src")) {
                        addTo = sources;
                    } else if (kind.equals("output")) {
                        addTo = classes;
                    } else if (kind.equals("lib")) {
                        addTo = libraries;
                    }
                    if (addTo == null || !(folder = new File(projectDir, path = element.getAttribute("path"))).exists()) continue;
                    addTo.add(folder);
                }
            }
            if ((libs = new File(project.getDir(), "libs")).isDirectory() && (jars = libs.listFiles()) != null) {
                for (File jar : jars) {
                    if (!LintUtils.endsWith(jar.getPath(), ".jar") || libraries.contains(jar)) continue;
                    libraries.add(jar);
                }
            }
            if (classes.isEmpty()) {
                File folder = new File(projectDir, SdkConstants.CLASS_FOLDER);
                if (folder.exists()) {
                    classes.add(folder);
                } else {
                    folder = new File(projectDir, "target" + File.separator + "classes");
                    if (folder.exists()) {
                        classes.add(folder);
                        if (sources.isEmpty()) {
                            File src = new File(projectDir, "src" + File.separator + "main" + File.separator + "java");
                            if (src.exists()) {
                                sources.add(src);
                            } else {
                                src = new File(projectDir, "src");
                                if (src.exists()) {
                                    sources.add(src);
                                }
                            }
                            File gen = new File(projectDir, "target" + File.separator + "generated-sources" + File.separator + "r");
                            if (gen.exists()) {
                                generated.add(gen);
                            }
                        }
                    }
                }
            }
            if (sources.isEmpty()) {
                File gen;
                File src = new File(projectDir, "src");
                if (src.exists()) {
                    sources.add(src);
                }
                if ((gen = new File(projectDir, "gen")).exists()) {
                    generated.add(gen);
                }
            }
            info = new ClassPathInfo(sources, classes, libraries, libraries, tests, Collections.emptyList(), generated);
            this.projectInfo.put(project, info);
        }
        return info;
    }

    public Project getProject(File dir, File referenceDir) {
        if (this.dirToProject == null) {
            this.dirToProject = new HashMap<File, Project>();
        }
        File canonicalDir = dir;
        try {
            canonicalDir = dir.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Project project = this.dirToProject.get(canonicalDir);
        if (project != null) {
            return project;
        }
        project = this.createProject(dir, referenceDir);
        this.dirToProject.put(canonicalDir, project);
        return project;
    }

    public Collection<Project> getKnownProjects() {
        return this.dirToProject != null ? this.dirToProject.values() : Collections.emptyList();
    }

    public void registerProject(File dir, Project project) {
        File canonicalDir = dir;
        try {
            canonicalDir = dir.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.dirToProject == null) {
            this.dirToProject = new HashMap<File, Project>();
        } else assert (!this.dirToProject.containsKey(dir)) : dir;
        this.dirToProject.put(canonicalDir, project);
    }

    protected Project createProject(File dir, File referenceDir) {
        if (this.projectDirs.contains(dir)) {
            throw new CircularDependencyException("Circular library dependencies; check your project.properties files carefully");
        }
        this.projectDirs.add(dir);
        return Project.create(this, dir, referenceDir);
    }

    protected void initializeProjects(Collection<Project> knownProjects) {
    }

    protected void disposeProjects(Collection<Project> knownProjects) {
    }

    public String getProjectName(Project project) {
        return project.getDir().getName();
    }

    public IAndroidTarget[] getTargets() {
        if (this.targets == null) {
            AndroidSdkHandler sdkHandler = this.getSdk();
            if (sdkHandler != null) {
                ProgressIndicator logger = this.getRepositoryLogger();
                Collection targets = sdkHandler.getAndroidTargetManager(logger).getTargets(logger);
                this.targets = targets.toArray(new IAndroidTarget[targets.size()]);
            } else {
                this.targets = new IAndroidTarget[0];
            }
        }
        return this.targets;
    }

    public AndroidSdkHandler getSdk() {
        File sdkHome;
        if (this.sdk == null && (sdkHome = this.getSdkHome()) != null) {
            this.sdk = AndroidSdkHandler.getInstance((File)sdkHome);
        }
        return this.sdk;
    }

    public IAndroidTarget getCompileTarget(Project project) {
        IAndroidTarget target;
        String compileSdkVersion = project.getBuildTargetHash();
        if (compileSdkVersion != null) {
            AndroidTargetManager manager;
            ProgressIndicator logger = this.getRepositoryLogger();
            AndroidSdkHandler handler = this.getSdk();
            if (handler != null && (target = (manager = handler.getAndroidTargetManager(logger)).getTargetFromHashString(compileSdkVersion, logger)) != null) {
                return target;
            }
        }
        int buildSdk = project.getBuildSdk();
        IAndroidTarget[] targets = this.getTargets();
        for (int i = targets.length - 1; i >= 0; --i) {
            target = targets[i];
            if (!target.isPlatform() || target.getVersion().getApiLevel() != buildSdk) continue;
            return target;
        }
        return null;
    }

    public int getHighestKnownApiLevel() {
        int max = 25;
        for (IAndroidTarget target : this.getTargets()) {
            int api;
            if (!target.isPlatform() || (api = target.getVersion().getApiLevel()) <= max || target.getVersion().isPreview()) continue;
            max = api;
        }
        return max;
    }

    public BuildToolInfo getBuildTools(Project project) {
        AndroidSdkHandler sdk = this.getSdk();
        if (sdk != null) {
            IAndroidTarget compileTarget = this.getCompileTarget(project);
            if (compileTarget != null) {
                return compileTarget.getBuildToolInfo();
            }
            return sdk.getLatestBuildTool(this.getRepositoryLogger(), false);
        }
        return null;
    }

    public String getSuperClass(Project project, String name) {
        assert (name.indexOf(46) == -1) : "Use VM signatures, e.g. java/lang/Integer";
        if ("java/lang/Object".equals(name)) {
            return null;
        }
        String superClass = project.getSuperClassMap().get(name);
        if (superClass != null) {
            return superClass;
        }
        for (Project library : project.getAllLibraries()) {
            superClass = library.getSuperClassMap().get(name);
            if (superClass == null) continue;
            return superClass;
        }
        return null;
    }

    public Map<String, String> createSuperClassMap(Project project) {
        List<File> libraries = project.getJavaLibraries(true);
        List<File> classFolders = project.getJavaClassFolders();
        List<ClassEntry> classEntries = ClassEntry.fromClassPath(this, classFolders, true);
        if (libraries.isEmpty()) {
            return ClassEntry.createSuperClassMap(this, classEntries);
        }
        List<ClassEntry> libraryEntries = ClassEntry.fromClassPath(this, libraries, true);
        return ClassEntry.createSuperClassMap(this, libraryEntries, classEntries);
    }

    public Boolean isSubclassOf(Project project, String name, String superClassName) {
        return null;
    }

    public List<File> findGlobalRuleJars() {
        String lintClassPath;
        File jarFile;
        List<File> files = null;
        try {
            File[] list;
            String androidHome = AndroidLocation.getFolder();
            File lint = new File(androidHome + File.separator + "lint");
            if (lint.exists() && (list = lint.listFiles()) != null) {
                File[] fileArray = list;
                int n = fileArray.length;
                for (int i = 0; i < n; ++i) {
                    jarFile = fileArray[i];
                    if (!LintUtils.endsWith(jarFile.getName(), ".jar")) continue;
                    if (files == null) {
                        files = new ArrayList<File>();
                    }
                    files.add(jarFile);
                }
            }
        }
        catch (AndroidLocation.AndroidLocationException androidHome) {
            // empty catch block
        }
        if ((lintClassPath = System.getenv("ANDROID_LINT_JARS")) != null && !lintClassPath.isEmpty()) {
            String[] paths;
            for (String path : paths = lintClassPath.split(File.pathSeparator)) {
                jarFile = new File(path);
                if (!jarFile.exists()) continue;
                if (files == null) {
                    files = new ArrayList<File>();
                } else if (files.contains(jarFile)) continue;
                files.add(jarFile);
            }
        }
        return files != null ? files : Collections.emptyList();
    }

    public List<File> findRuleJars(Project project) {
        if (project.isGradleProject()) {
            File lintJar;
            if (project.isLibrary()) {
                File lintJar2;
                AndroidLibrary model = project.getGradleLibraryModel();
                if (model != null && (lintJar2 = model.getLintJar()).exists()) {
                    return Collections.singletonList(lintJar2);
                }
            } else if (project.getSubset() != null) {
                ArrayList rules = null;
                Variant variant = project.getCurrentVariant();
                if (variant != null) {
                    Collection libraries = variant.getMainArtifact().getDependencies().getLibraries();
                    for (AndroidLibrary library : libraries) {
                        File lintJar3 = library.getLintJar();
                        if (!lintJar3.exists()) continue;
                        if (rules == null) {
                            rules = Lists.newArrayListWithExpectedSize((int)4);
                        }
                        rules.add(lintJar3);
                    }
                    if (rules != null) {
                        return rules;
                    }
                }
            } else if (project.getDir().getPath().endsWith(".aar") && (lintJar = new File(project.getDir(), "lint.jar")).exists()) {
                return Collections.singletonList(lintJar);
            }
        }
        return Collections.emptyList();
    }

    public URLConnection openConnection(URL url) throws IOException {
        return url.openConnection();
    }

    public void closeConnection(URLConnection connection) throws IOException {
        if (connection instanceof HttpURLConnection) {
            ((HttpURLConnection)connection).disconnect();
        }
    }

    public boolean isProjectDirectory(File dir) {
        return LintUtils.isManifestFolder(dir) || Project.isAospFrameworksRelatedProject(dir) || new File(dir, "build.gradle").exists();
    }

    public boolean checkForSuppressComments() {
        return true;
    }

    public IssueRegistry addCustomLintRules(IssueRegistry registry) {
        List<File> jarFiles = this.findGlobalRuleJars();
        if (!jarFiles.isEmpty()) {
            ArrayList registries = Lists.newArrayListWithExpectedSize((int)jarFiles.size());
            registries.add(registry);
            for (File jarFile : jarFiles) {
                try {
                    registries.add(JarFileIssueRegistry.get(this, jarFile));
                }
                catch (Throwable e) {
                    this.log(e, "Could not load custom rule jar file %1$s", jarFile);
                }
            }
            if (registries.size() > 1) {
                return new CompositeIssueRegistry(registries);
            }
        }
        return registry;
    }

    public ClassLoader createUrlClassLoader(URL[] urls, ClassLoader parent) {
        return new URLClassLoader(urls, parent);
    }

    public Document getMergedManifest(Project project) {
        List<File> manifestFiles = project.getManifestFiles();
        if (manifestFiles.size() == 1) {
            File primary = manifestFiles.get(0);
            try {
                String xml = Files.toString((File)primary, (Charset)Charsets.UTF_8);
                return XmlUtils.parseDocumentSilently((String)xml, (boolean)true);
            }
            catch (IOException e) {
                this.log(Severity.ERROR, e, "Could not read manifest " + primary, new Object[0]);
            }
        }
        return null;
    }

    public void resolveMergeManifestSources(Document mergedManifest, Object reportFile) {
        mergedManifest.setUserData(MERGED_MANIFEST, reportFile, null);
    }

    public boolean isMergeManifestNode(Node node) {
        Document doc = node.getOwnerDocument();
        return doc != null && doc.getUserData(MERGED_MANIFEST) != null;
    }

    public Pair<File, Node> findManifestSourceNode(Node mergedNode) {
        Pair<File, Node> cacheValue;
        Pair<File, Node> source;
        if (this.sourceNodeCache != null && (source = this.sourceNodeCache.get(mergedNode)) != null) {
            if (source == NOT_FOUND) {
                return null;
            }
            return source;
        }
        Document doc = mergedNode.getOwnerDocument();
        if (doc == null) {
            return null;
        }
        Object report = doc.getUserData(MERGED_MANIFEST);
        if (report == null) {
            return null;
        }
        BlameFile blameFile = null;
        if (this.reportFileCache != null) {
            blameFile = this.reportFileCache.get(report);
        } else {
            this.reportFileCache = Maps.newHashMap();
        }
        if (blameFile == null) {
            try {
                if (report instanceof File) {
                    File file = (File)report;
                    if (file.getPath().endsWith(".xml")) {
                        return Pair.of((Object)file, (Object)mergedNode);
                    }
                    blameFile = BlameFile.parse(file);
                } else if (report instanceof String) {
                    List lines = Splitter.on((char)'\n').splitToList((CharSequence)((String)report));
                    blameFile = BlameFile.parse(lines);
                } else if (report instanceof Actions) {
                    blameFile = BlameFile.parse((Actions)report);
                } else {
                    assert (false) : report;
                    blameFile = BlameFile.NONE;
                }
            }
            catch (IOException ignore) {
                blameFile = BlameFile.NONE;
            }
            this.reportFileCache.put(report, blameFile);
        }
        Pair<File, Node> source2 = null;
        if (blameFile != BlameFile.NONE) {
            source2 = blameFile.findSourceNode(this, mergedNode);
        }
        Pair<File, Node> pair = cacheValue = source2 != null ? source2 : NOT_FOUND;
        if (this.sourceNodeCache == null) {
            this.sourceNodeCache = Maps.newIdentityHashMap();
        }
        this.sourceNodeCache.put(mergedNode, cacheValue);
        return source2;
    }

    public Location findManifestSourceLocation(Node mergedNode) {
        Pair<File, Node> source = this.findManifestSourceNode(mergedNode);
        if (source != null) {
            return this.getXmlParser().getLocation((File)source.getFirst(), (Node)source.getSecond());
        }
        return null;
    }

    public String getDisplayPath(File file) {
        return TextFormat.TEXT.convertTo(file.getPath(), TextFormat.RAW);
    }

    public boolean supportsProjectResources() {
        return false;
    }

    @Deprecated
    public AbstractResourceRepository getProjectResources(Project project, boolean includeDependencies) {
        return this.getResourceRepository(project, includeDependencies, false);
    }

    public AbstractResourceRepository getResourceRepository(Project project, boolean includeModuleDependencies, boolean includeLibraries) {
        return null;
    }

    public Location.Handle createResourceItemHandle(ResourceItem item) {
        return new Location.ResourceItemHandle(item);
    }

    public ResourceVisibilityLookup.Provider getResourceVisibilityProvider() {
        if (this.resourceVisibility == null) {
            this.resourceVisibility = new ResourceVisibilityLookup.Provider();
        }
        return this.resourceVisibility;
    }

    public static String getClientName() {
        return clientName;
    }

    public String getClientRevision() {
        return null;
    }

    public static boolean isStudio() {
        return CLIENT_STUDIO.equals(clientName);
    }

    public static boolean isGradle() {
        return CLIENT_GRADLE.equals(clientName);
    }

    public void runReadAction(Runnable runnable) {
        runnable.run();
    }

    public ProgressIndicator getRepositoryLogger() {
        return new RepoLogger();
    }

    private static final class RepoLogger
    extends ProgressIndicatorAdapter {
        private RepoLogger() {
        }

        public void logError(String s, Throwable e) {
        }

        public void logInfo(String s) {
        }

        public void logWarning(String s, Throwable e) {
        }
    }

    protected static class ClassPathInfo {
        private final List<File> classFolders;
        private final List<File> sourceFolders;
        private final List<File> libraries;
        private final List<File> nonProvidedLibraries;
        private final List<File> testFolders;
        private final List<File> testLibraries;
        private final List<File> generatedFolders;

        public ClassPathInfo(List<File> sourceFolders, List<File> classFolders, List<File> libraries, List<File> nonProvidedLibraries, List<File> testFolders, List<File> testLibraries, List<File> generatedFolders) {
            this.sourceFolders = sourceFolders;
            this.classFolders = classFolders;
            this.libraries = libraries;
            this.nonProvidedLibraries = nonProvidedLibraries;
            this.testFolders = testFolders;
            this.testLibraries = testLibraries;
            this.generatedFolders = generatedFolders;
        }

        public List<File> getSourceFolders() {
            return this.sourceFolders;
        }

        public List<File> getClassFolders() {
            return this.classFolders;
        }

        public List<File> getLibraries(boolean includeProvided) {
            return includeProvided ? this.libraries : this.nonProvidedLibraries;
        }

        public List<File> getTestSourceFolders() {
            return this.testFolders;
        }

        public List<File> getTestLibraries() {
            return this.testLibraries;
        }

        public List<File> getGeneratedFolders() {
            return this.generatedFolders;
        }
    }
}

