/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;

public final class TextFormat
extends Enum<TextFormat> {
    public static final /* enum */ TextFormat RAW = new TextFormat();
    public static final /* enum */ TextFormat TEXT = new TextFormat();
    public static final /* enum */ TextFormat HTML = new TextFormat();
    public static final /* enum */ TextFormat HTML_WITH_UNICODE = new TextFormat();
    private static final String HTTP_PREFIX = "http://";
    private static final String HTTPS_PREFIX = "https://";
    private static final /* synthetic */ TextFormat[] $VALUES;

    public static TextFormat[] values() {
        return (TextFormat[])$VALUES.clone();
    }

    public static TextFormat valueOf(String name) {
        return Enum.valueOf(TextFormat.class, name);
    }

    public String toHtml(String text) {
        return this.convertTo(text, HTML);
    }

    public String toText(String text) {
        return this.convertTo(text, TEXT);
    }

    public String convertTo(String message, TextFormat to) {
        if (this == to) {
            return message;
        }
        switch (this) {
            case RAW: {
                switch (to) {
                    case RAW: {
                        return message;
                    }
                    case TEXT: 
                    case HTML: 
                    case HTML_WITH_UNICODE: {
                        return to.fromRaw(message);
                    }
                }
            }
            case TEXT: {
                switch (to) {
                    case RAW: {
                        return TextFormat.textToRaw(message);
                    }
                    case TEXT: {
                        return message;
                    }
                    case HTML: 
                    case HTML_WITH_UNICODE: {
                        return XmlUtils.toXmlTextValue((String)message);
                    }
                }
            }
            case HTML: {
                switch (to) {
                    case HTML: {
                        return message;
                    }
                    case HTML_WITH_UNICODE: {
                        return TextFormat.removeNumericEntities(message);
                    }
                    case RAW: 
                    case TEXT: {
                        return to.fromHtml(message);
                    }
                }
            }
            case HTML_WITH_UNICODE: {
                switch (to) {
                    case HTML: 
                    case HTML_WITH_UNICODE: {
                        return message;
                    }
                    case RAW: 
                    case TEXT: {
                        return to.fromHtml(message);
                    }
                }
            }
        }
        return message;
    }

    private static String textToRaw(String message) {
        boolean mustEscape = false;
        int n = message.length();
        for (int i = 0; i < n; ++i) {
            char c = message.charAt(i);
            if (c != '\\' && c != '*' && c != '`') continue;
            mustEscape = true;
            break;
        }
        if (!mustEscape) {
            return message;
        }
        StringBuilder sb = new StringBuilder(message.length() * 2);
        for (int i = 0; i < n; ++i) {
            char c = message.charAt(i);
            if (c == '\\' || c == '*' || c == '`') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private String fromHtml(String html) {
        assert (this == RAW || this == TEXT) : this;
        StringBuilder sb = new StringBuilder(html.length());
        boolean inPre = false;
        int n = html.length();
        for (int i = 0; i < n; ++i) {
            int end;
            char c = html.charAt(i);
            if (c == '<') {
                String tag;
                int begin;
                if (html.startsWith("<!--", i)) {
                    end = html.indexOf("-->", i);
                    if (end == -1) break;
                    i = end + 2;
                    continue;
                }
                boolean isEndTag = false;
                if (html.startsWith("</", i)) {
                    begin = i + 2;
                    isEndTag = true;
                } else {
                    begin = i + 1;
                }
                i = html.indexOf(62, i);
                if (i == -1) break;
                int end2 = i;
                if (html.charAt(i - 1) == '/') {
                    --end2;
                    isEndTag = true;
                }
                if ((tag = html.substring(begin, end2).trim()).equalsIgnoreCase("br")) {
                    sb.append('\n');
                    continue;
                }
                if (!tag.equalsIgnoreCase("p") && !tag.equalsIgnoreCase("div") && !tag.equalsIgnoreCase("pre") && !tag.equalsIgnoreCase("blockquote") && !tag.equalsIgnoreCase("dl") && !tag.equalsIgnoreCase("dd") && !tag.equalsIgnoreCase("dt") && !tag.equalsIgnoreCase("ol") && !tag.equalsIgnoreCase("ul") && !tag.equalsIgnoreCase("li") && (tag.length() != 2 || !tag.startsWith("h") || !Character.isDigit(tag.charAt(1)))) continue;
                if (sb.length() > 0 && sb.charAt(sb.length() - 1) != '\n') {
                    sb.append('\n');
                }
                if (tag.equals("li") && !isEndTag) {
                    sb.append("* ");
                }
                if (!tag.equalsIgnoreCase("pre")) continue;
                inPre = !isEndTag;
                continue;
            }
            if (c == '&') {
                end = html.indexOf(59, i);
                if (end > i) {
                    String entity = html.substring(i, end + 1);
                    String s = XmlUtils.fromXmlAttributeValue((String)entity);
                    if (s.startsWith("&")) {
                        if (entity.equalsIgnoreCase("&nbsp;")) {
                            s = " ";
                        } else if (entity.startsWith("&#")) {
                            try {
                                int value = Integer.parseInt(entity.substring(2));
                                s = Character.toString((char)value);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                    }
                    sb.append(s);
                    i = end;
                    continue;
                }
                sb.append(c);
                continue;
            }
            if (Character.isWhitespace(c)) {
                if (inPre) {
                    sb.append(c);
                    continue;
                }
                if (sb.length() != 0 && Character.isWhitespace(sb.charAt(sb.length() - 1))) continue;
                sb.append(' ');
                continue;
            }
            sb.append(c);
        }
        String s = sb.toString();
        s = SdkUtils.wrap((String)s, (int)60, null);
        return s;
    }

    private String fromRaw(String text) {
        assert (this == HTML || this == HTML_WITH_UNICODE || this == TEXT) : this;
        StringBuilder sb = new StringBuilder(3 * text.length() / 2);
        boolean html = this == HTML || this == HTML_WITH_UNICODE;
        boolean escapeUnicode = this == HTML;
        char prev = '\u0000';
        int flushIndex = 0;
        int n = text.length();
        boolean escaped = false;
        for (int i = 0; i < n; ++i) {
            char c = text.charAt(i);
            if (c == '\\' && !escaped) {
                escaped = true;
                if (i > flushIndex) {
                    TextFormat.appendEscapedText(sb, text, html, flushIndex, i, escapeUnicode);
                }
                flushIndex = i + 1;
                continue;
            }
            if (!(escaped || c != '*' && c != '`' || i >= n - 1)) {
                if (!Character.isLetterOrDigit(prev) && !Character.isWhitespace(text.charAt(i + 1))) {
                    int end = text.indexOf(c, i + 1);
                    boolean bold = false;
                    if (end == i + 1 && c == '*') {
                        int end2 = text.indexOf(42, end + 1);
                        if (end2 == end + 1) {
                            if ((end2 = text.indexOf("***", end2 + 1)) == -1) continue;
                            if (i > flushIndex) {
                                TextFormat.appendEscapedText(sb, text, html, flushIndex, i, escapeUnicode);
                            }
                            if (html) {
                                sb.append("<b><i>");
                                TextFormat.appendEscapedText(sb, text, true, i + 3, end2, escapeUnicode);
                                sb.append("</i></b>");
                            } else {
                                TextFormat.appendEscapedText(sb, text, false, i + 3, end2, escapeUnicode);
                            }
                            flushIndex = end2 + 3;
                            i = flushIndex - 1;
                            continue;
                        }
                        if (end2 != -1 && end2 > end + 1 && end2 < n - 1 && text.charAt(end2 + 1) == '*') {
                            end = end2;
                            bold = true;
                        }
                    }
                    if (!(end == -1 || end != n - 1 && Character.isLetter(text.charAt(end + 1)))) {
                        if (i > flushIndex) {
                            TextFormat.appendEscapedText(sb, text, html, flushIndex, i, escapeUnicode);
                        }
                        if (bold) {
                            ++i;
                        }
                        if (html) {
                            String tag = bold ? "b" : (c == '*' ? "i" : "code");
                            sb.append('<').append(tag).append('>');
                            TextFormat.appendEscapedText(sb, text, true, i + 1, end, escapeUnicode);
                            sb.append('<').append('/').append(tag).append('>');
                        } else {
                            TextFormat.appendEscapedText(sb, text, false, i + 1, end, escapeUnicode);
                        }
                        flushIndex = end + 1;
                        if (bold) {
                            ++flushIndex;
                        }
                        i = flushIndex - 1;
                    }
                }
            } else if (html && c == 'h' && i < n - 1 && text.charAt(i + 1) == 't' && (text.startsWith(HTTP_PREFIX, i) || text.startsWith(HTTPS_PREFIX, i)) && !Character.isLetterOrDigit(prev)) {
                char d;
                int end;
                int length = text.startsWith(HTTP_PREFIX, i) ? HTTP_PREFIX.length() : HTTPS_PREFIX.length();
                for (end = i + length; end < n && !Character.isWhitespace(d = text.charAt(end)); ++end) {
                }
                char last = text.charAt(end - 1);
                if (last == '.' || last == ')' || last == '!') {
                    --end;
                }
                if (end > i + length) {
                    if (i > flushIndex) {
                        TextFormat.appendEscapedText(sb, text, true, flushIndex, i, escapeUnicode);
                    }
                    String url = text.substring(i, end);
                    sb.append("<a href=\"");
                    sb.append(url);
                    sb.append('\"').append('>');
                    sb.append(url);
                    sb.append("</a>");
                    flushIndex = end;
                    i = flushIndex - 1;
                }
            }
            prev = c;
            escaped = false;
        }
        if (flushIndex < n) {
            TextFormat.appendEscapedText(sb, text, html, flushIndex, n, escapeUnicode);
        }
        return sb.toString();
    }

    private static String removeNumericEntities(String html) {
        if (!html.contains("&#")) {
            return html;
        }
        StringBuilder sb = new StringBuilder(html.length());
        int n = html.length();
        for (int i = 0; i < n; ++i) {
            int end;
            char c = html.charAt(i);
            if (c == '&' && i < n - 1 && html.charAt(i + 1) == '#' && (end = html.indexOf(59, i + 2)) != -1) {
                String decimal = html.substring(i + 2, end);
                try {
                    c = (char)Integer.parseInt(decimal);
                    sb.append(c);
                    i = end;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static void appendEscapedText(StringBuilder sb, String text, boolean html, int start, int end, boolean escapeUnicode) {
        if (html) {
            for (int i = start; i < end; ++i) {
                char c = text.charAt(i);
                if (c == '<') {
                    sb.append("&lt;");
                    continue;
                }
                if (c == '&') {
                    sb.append("&amp;");
                    continue;
                }
                if (c == '\n') {
                    sb.append("<br/>\n");
                    continue;
                }
                if (c > '\u00ff' && escapeUnicode) {
                    if (c == '\u200b') continue;
                    sb.append("&#");
                    sb.append(Integer.toString(c));
                    sb.append(';');
                    continue;
                }
                if (c == '\u00a0') {
                    sb.append("&nbsp;");
                    continue;
                }
                sb.append(c);
            }
        } else {
            for (int i = start; i < end; ++i) {
                char c = text.charAt(i);
                if (c == '\u200b') continue;
                sb.append(c);
            }
        }
    }

    static {
        $VALUES = new TextFormat[]{RAW, TEXT, HTML, HTML_WITH_UNICODE};
    }
}

