/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.helpers;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.UastParser;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.helpers.DefaultJavaEvaluator;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.impl.light.LightElement;
import java.io.File;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UastContext;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.psi.UElementWithLocation;

public class DefaultUastParser
extends UastParser {
    private final UastContext uastContext;
    private final JavaEvaluator javaEvaluator;

    public DefaultUastParser(Project project, com.intellij.openapi.project.Project p) {
        this.javaEvaluator = this.createEvaluator(project, p);
        this.uastContext = !p.isDisposed() ? (UastContext)ServiceManager.getService((com.intellij.openapi.project.Project)p, UastContext.class) : null;
    }

    protected DefaultJavaEvaluator createEvaluator(Project project, com.intellij.openapi.project.Project p) {
        return new DefaultJavaEvaluator(p, project);
    }

    @Override
    public boolean prepare(List<JavaContext> contexts) {
        return true;
    }

    @Override
    public JavaEvaluator getEvaluator() {
        return this.javaEvaluator;
    }

    @Override
    public UFile parse(JavaContext context) {
        com.intellij.openapi.project.Project ideaProject = this.uastContext.getProject();
        VirtualFile virtualFile = StandardFileSystems.local().findFileByPath(context.file.getAbsolutePath());
        if (virtualFile == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((com.intellij.openapi.project.Project)ideaProject).findFile(virtualFile);
        if (psiFile == null) {
            return null;
        }
        UElement uElement = this.uastContext.convertElementWithParent((PsiElement)psiFile, UFile.class);
        if (!(uElement instanceof UFile)) {
            return null;
        }
        return (UFile)uElement;
    }

    @Override
    public UastContext getUastContext() {
        return this.uastContext;
    }

    @Override
    public Location getLocation(JavaContext context, PsiElement element) {
        if (element instanceof PsiCompiledElement) {
            VirtualFile virtualFile;
            PsiFile containingFile = element.getContainingFile();
            if (containingFile != null && (virtualFile = containingFile.getVirtualFile()) != null) {
                return Location.create(VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile));
            }
            return Location.create(context.file);
        }
        TextRange range = element.getTextRange();
        PsiFile containingFile = element.getContainingFile();
        File file = context.file;
        CharSequence contents = context.getContents();
        if (!containingFile.equals(context.getPsiFile())) {
            if (context.getDriver().getScope().size() == 1) {
                return Location.NONE;
            }
            File ioFile = this.getFile(containingFile);
            if (ioFile == null) {
                return Location.NONE;
            }
            file = ioFile;
            contents = this.getFileContents(containingFile);
        }
        if (range == null) {
            PsiElement parent;
            if (element instanceof LightElement && (parent = element.getParent()) != null) {
                return this.getLocation(context, parent);
            }
            return Location.create(file);
        }
        return Location.create(file, contents, range.getStartOffset(), range.getEndOffset()).setSource(element);
    }

    @Override
    public Location getLocation(JavaContext context, UElement element) {
        if (element instanceof UElementWithLocation) {
            UFile file = UastUtils.getContainingFile((UElement)element);
            if (file == null) {
                return Location.NONE;
            }
            File ioFile = UastUtils.getIoFile((UFile)file);
            if (ioFile == null) {
                return Location.NONE;
            }
            UElementWithLocation segment = (UElementWithLocation)element;
            return Location.create(ioFile, file.getPsi().getText(), segment.getStartOffset(), segment.getEndOffset()).setSource(element);
        }
        PsiElement psiElement = element.getPsi();
        if (psiElement != null) {
            return this.getLocation(context, psiElement);
        }
        UElement parent = element.getUastParent();
        if (parent != null) {
            return this.getLocation(context, parent);
        }
        return Location.NONE;
    }

    @Override
    public Location getCallLocation(JavaContext context, UCallExpression call, boolean includeReceiver, boolean includeArguments) {
        UExpression receiver = call.getReceiver();
        if (!includeReceiver || receiver == null) {
            if (includeArguments) {
                return this.getLocation(context, (UElement)call);
            }
            UIdentifier methodIdentifier = call.getMethodIdentifier();
            if (methodIdentifier != null) {
                return this.getLocation(context, (UElement)methodIdentifier);
            }
        } else {
            UIdentifier methodIdentifier;
            if (!includeArguments && (methodIdentifier = call.getMethodIdentifier()) != null) {
                return this.getRangeLocation(context, (UElement)receiver, 0, (UElement)methodIdentifier, 0);
            }
            return this.getRangeLocation(context, (UElement)receiver, 0, (UElement)call, 0);
        }
        return this.getLocation(context, (UElement)call);
    }

    @Override
    public File getFile(PsiFile file) {
        VirtualFile virtualFile = file.getVirtualFile();
        return virtualFile != null ? VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile) : null;
    }

    @Override
    public CharSequence getFileContents(PsiFile file) {
        return file.getText();
    }

    @Override
    public Location createLocation(PsiElement element) {
        TextRange range = element.getTextRange();
        PsiFile containingFile = element.getContainingFile();
        File file = this.getFile(containingFile);
        if (file == null) {
            return Location.NONE;
        }
        CharSequence contents = this.getFileContents(containingFile);
        return Location.create(file, contents, range.getStartOffset(), range.getEndOffset()).setSource(element);
    }

    @Override
    public Location createLocation(UElement element) {
        if (element instanceof UElementWithLocation) {
            UFile file = UastUtils.getContainingFile((UElement)element);
            if (file == null) {
                return Location.NONE;
            }
            File ioFile = UastUtils.getIoFile((UFile)file);
            if (ioFile == null) {
                return Location.NONE;
            }
            UElementWithLocation segment = (UElementWithLocation)element;
            return Location.create(ioFile, file.getPsi().getText(), segment.getStartOffset(), segment.getEndOffset()).setSource(element);
        }
        PsiElement psiElement = element.getPsi();
        if (psiElement != null) {
            return this.createLocation(psiElement);
        }
        UElement parent = element.getUastParent();
        if (parent != null) {
            return this.createLocation(parent);
        }
        return Location.NONE;
    }

    @Override
    public Location getRangeLocation(JavaContext context, PsiElement from, int fromDelta, PsiElement to, int toDelta) {
        CharSequence contents = context.getContents();
        TextRange fromRange = from.getTextRange();
        int start = Math.max(0, fromRange.getStartOffset() + fromDelta);
        int end = Math.min(contents == null ? Integer.MAX_VALUE : contents.length(), to.getTextRange().getEndOffset() + toDelta);
        if (end <= start) {
            return Location.create(context.file, contents, start, fromRange.getEndOffset()).setSource(from);
        }
        return Location.create(context.file, contents, start, end).setSource(from);
    }

    private static TextRange getTextRange(UElement element) {
        if (element instanceof UElementWithLocation) {
            UElementWithLocation segment = (UElementWithLocation)element;
            return new TextRange(segment.getStartOffset(), segment.getEndOffset());
        }
        PsiElement psiElement = element.getPsi();
        if (psiElement != null) {
            return psiElement.getTextRange();
        }
        return null;
    }

    @Override
    public Location getRangeLocation(JavaContext context, UElement from, int fromDelta, UElement to, int toDelta) {
        CharSequence contents = context.getContents();
        TextRange fromRange = DefaultUastParser.getTextRange(from);
        TextRange toRange = DefaultUastParser.getTextRange(to);
        File file = context.file;
        PsiElement psi = DefaultUastParser.findPsi(from);
        if (psi != null) {
            PsiFile containingFile = psi.getContainingFile();
            contents = context.getContents();
            if (!containingFile.equals(context.getPsiFile())) {
                if (context.getDriver().getScope().size() == 1) {
                    return Location.NONE;
                }
                File ioFile = this.getFile(containingFile);
                if (ioFile == null) {
                    return Location.NONE;
                }
                file = ioFile;
                contents = this.getFileContents(containingFile);
            }
        }
        if (fromRange != null && toRange != null) {
            int start = Math.max(0, fromRange.getStartOffset() + fromDelta);
            int end = Math.min(contents == null ? Integer.MAX_VALUE : contents.length(), toRange.getEndOffset() + toDelta);
            if (end <= start) {
                return Location.create(file, contents, start, fromRange.getEndOffset()).setSource(from);
            }
            return Location.create(file, contents, start, end).setSource(from);
        }
        return Location.create(file).setSource(from);
    }

    private static PsiElement findPsi(UElement element) {
        while (element != null) {
            PsiElement psi = element.getPsi();
            if (psi != null) {
                return psi;
            }
            element = element.getUastParent();
        }
        return null;
    }

    @Override
    public Location getRangeLocation(JavaContext context, PsiElement from, int fromDelta, int toDelta) {
        return this.getRangeLocation(context, from, fromDelta, from, -(from.getTextRange().getLength() - toDelta));
    }

    @Override
    public Location getRangeLocation(JavaContext context, UElement from, int fromDelta, int toDelta) {
        TextRange fromRange = DefaultUastParser.getTextRange(from);
        if (fromRange != null) {
            return this.getRangeLocation(context, from, fromDelta, from, -(fromRange.getLength() - toDelta));
        }
        return Location.create(context.file).setSource(from);
    }

    @Override
    public Location getNameLocation(JavaContext context, PsiElement element) {
        PsiElement nameNode = JavaContext.findNameElement(element);
        if (nameNode != null) {
            element = nameNode;
        }
        return this.getLocation(context, element);
    }

    @Override
    public Location getNameLocation(JavaContext context, UElement element) {
        PsiElement nameIdentifier;
        UElement nameNode = JavaContext.findNameElement(element);
        if (nameNode != null) {
            element = nameNode;
        } else if (element instanceof PsiNameIdentifierOwner && (nameIdentifier = ((PsiNameIdentifierOwner)element).getNameIdentifier()) != null) {
            return this.getLocation(context, nameIdentifier);
        }
        return this.getLocation(context, element);
    }
}

