/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.tools.lint.client.api.SdkInfo;
import com.google.common.annotations.Beta;

@Beta
class DefaultSdkInfo
extends SdkInfo {
    DefaultSdkInfo() {
    }

    @Override
    public String getParentViewName(String name) {
        name = DefaultSdkInfo.getRawType(name);
        return DefaultSdkInfo.getParent(name);
    }

    @Override
    public String getParentViewClass(String fqcn) {
        String parent;
        int index = fqcn.lastIndexOf(46);
        if (index != -1) {
            fqcn = fqcn.substring(index + 1);
        }
        if ((parent = DefaultSdkInfo.getParent(fqcn)) == null) {
            return null;
        }
        if (parent.equals("View") || parent.equals("ViewGroup") || parent.equals("SurfaceView")) {
            return "android.view." + parent;
        }
        return "android.widget." + parent;
    }

    @Override
    public boolean isSubViewOf(String parentType, String childType) {
        String parent = DefaultSdkInfo.getRawType(parentType);
        String child = DefaultSdkInfo.getRawType(childType);
        if (parent.indexOf(46) != -1) {
            parent = parent.substring(parent.lastIndexOf(46) + 1);
        }
        if (child.indexOf(46) != -1) {
            child = child.substring(child.lastIndexOf(46) + 1);
        }
        if (parent.equals("View")) {
            return true;
        }
        while (!child.equals("View")) {
            if (parent.equals(child)) {
                return true;
            }
            if (DefaultSdkInfo.implementsInterface(child, parent)) {
                return true;
            }
            if ((child = DefaultSdkInfo.getParent(child)) != null) continue;
            return true;
        }
        return false;
    }

    private static boolean implementsInterface(String className, String interfaceName) {
        return interfaceName.equals(DefaultSdkInfo.getInterface(className));
    }

    private static String getRawType(String type) {
        int index;
        if (type != null && (index = type.indexOf(60)) != -1) {
            type = type.substring(0, index);
        }
        return type;
    }

    @Override
    public boolean isLayout(String tag) {
        if (super.isLayout(tag)) {
            return true;
        }
        switch (tag) {
            case "TabHost": 
            case "HorizontalScrollView": 
            case "ViewSwitcher": 
            case "TabWidget": 
            case "ViewAnimator": 
            case "ScrollView": 
            case "GridView": 
            case "TableRow": 
            case "RadioGroup": 
            case "ListView": 
            case "ExpandableListView": 
            case "MediaController": 
            case "DialerFilter": 
            case "ViewFlipper": 
            case "SlidingDrawer": 
            case "StackView": 
            case "SearchView": 
            case "TextSwitcher": 
            case "AdapterViewFlipper": 
            case "ImageSwitcher": {
                return true;
            }
        }
        return false;
    }

    private static String getParent(String layout) {
        switch (layout) {
            case "CompoundButton": {
                return "Button";
            }
            case "AbsSpinner": {
                return "AdapterView";
            }
            case "AbsListView": {
                return "AdapterView";
            }
            case "AbsSeekBar": {
                return "ProgressBar";
            }
            case "AdapterView": {
                return "ViewGroup";
            }
            case "ViewGroup": {
                return "View";
            }
            case "TextView": {
                return "View";
            }
            case "CheckedTextView": {
                return "TextView";
            }
            case "RadioButton": {
                return "CompoundButton";
            }
            case "Spinner": {
                return "AbsSpinner";
            }
            case "ImageButton": {
                return "ImageView";
            }
            case "ImageView": {
                return "View";
            }
            case "EditText": {
                return "TextView";
            }
            case "ProgressBar": {
                return "View";
            }
            case "ToggleButton": {
                return "CompoundButton";
            }
            case "ViewStub": {
                return "View";
            }
            case "Button": {
                return "TextView";
            }
            case "SeekBar": {
                return "AbsSeekBar";
            }
            case "CheckBox": {
                return "CompoundButton";
            }
            case "Switch": {
                return "CompoundButton";
            }
            case "Gallery": {
                return "AbsSpinner";
            }
            case "SurfaceView": {
                return "View";
            }
            case "AbsoluteLayout": {
                return "ViewGroup";
            }
            case "LinearLayout": {
                return "ViewGroup";
            }
            case "RelativeLayout": {
                return "ViewGroup";
            }
            case "ListView": {
                return "AbsListView";
            }
            case "ViewSwitcher": {
                return "ViewAnimator";
            }
            case "FrameLayout": {
                return "ViewGroup";
            }
            case "HorizontalScrollView": {
                return "FrameLayout";
            }
            case "ViewAnimator": {
                return "FrameLayout";
            }
            case "TabHost": {
                return "FrameLayout";
            }
            case "TableRow": {
                return "LinearLayout";
            }
            case "RadioGroup": {
                return "LinearLayout";
            }
            case "TabWidget": {
                return "LinearLayout";
            }
            case "ExpandableListView": {
                return "ListView";
            }
            case "TableLayout": {
                return "LinearLayout";
            }
            case "ScrollView": {
                return "FrameLayout";
            }
            case "GridView": {
                return "AbsListView";
            }
            case "WebView": {
                return "AbsoluteLayout";
            }
            case "AutoCompleteTextView": {
                return "EditText";
            }
            case "MultiAutoCompleteTextView": {
                return "AutoCompleteTextView";
            }
            case "MediaController": {
                return "FrameLayout";
            }
            case "SlidingDrawer": {
                return "ViewGroup";
            }
            case "DialerFilter": {
                return "RelativeLayout";
            }
            case "DigitalClock": {
                return "TextView";
            }
            case "Chronometer": {
                return "TextView";
            }
            case "ImageSwitcher": {
                return "ViewSwitcher";
            }
            case "TextSwitcher": {
                return "ViewSwitcher";
            }
            case "AnalogClock": {
                return "View";
            }
            case "TwoLineListItem": {
                return "RelativeLayout";
            }
            case "ZoomControls": {
                return "LinearLayout";
            }
            case "DatePicker": {
                return "FrameLayout";
            }
            case "TimePicker": {
                return "FrameLayout";
            }
            case "VideoView": {
                return "SurfaceView";
            }
            case "ZoomButton": {
                return "ImageButton";
            }
            case "RatingBar": {
                return "AbsSeekBar";
            }
            case "ViewFlipper": {
                return "ViewAnimator";
            }
            case "NumberPicker": {
                return "LinearLayout";
            }
        }
        return null;
    }

    private static String getInterface(String cls) {
        switch (cls) {
            case "CheckedTextView": 
            case "CompoundButton": {
                return "Checkable";
            }
        }
        return null;
    }
}

