/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.SdkInfo;
import com.android.tools.lint.detector.api.CharSequences;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.tools.lint.detector.api.XmlContext;
import com.google.common.annotations.Beta;
import com.intellij.psi.PsiElement;
import java.io.File;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.uast.UElement;
import org.w3c.dom.Node;

@Beta
public class Context {
    public final File file;
    protected final LintDriver driver;
    private final Project project;
    private final Project mainProject;
    private final Configuration configuration;
    private CharSequence contents;
    private Map<String, Object> properties;
    private Boolean containsCommentSuppress;

    public Context(LintDriver driver, Project project, Project main, File file) {
        this.file = file;
        this.driver = driver;
        this.project = project;
        this.mainProject = main;
        this.configuration = project.getConfiguration(driver);
    }

    public EnumSet<Scope> getScope() {
        return this.driver.getScope();
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Project getProject() {
        return this.project;
    }

    public Project getMainProject() {
        return this.mainProject != null ? this.mainProject : this.project;
    }

    public LintClient getClient() {
        return this.driver.getClient();
    }

    public LintDriver getDriver() {
        return this.driver;
    }

    public CharSequence getContents() {
        if (this.contents == null) {
            this.contents = this.driver.getClient().readFile(this.file);
        }
        return this.contents;
    }

    public Object getProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(name);
    }

    public void setProperty(String name, Object value) {
        if (value == null) {
            if (this.properties != null) {
                this.properties.remove(name);
            }
        } else {
            if (this.properties == null) {
                this.properties = new HashMap<String, Object>();
            }
            this.properties.put(name, value);
        }
    }

    public SdkInfo getSdkInfo() {
        return this.project.getSdkInfo();
    }

    public boolean isEnabled(Issue issue) {
        return this.configuration.isEnabled(issue);
    }

    public void report(Issue issue, Location location, String message) {
        this.report(issue, location, message, null);
    }

    public void report(Issue issue, Location location, String message, LintFix quickfixData) {
        Object source = location.getSource();
        if (source instanceof Node) {
            Node node = (Node)source;
            if (this instanceof XmlContext) {
                XmlContext xmlContext = (XmlContext)this;
                if (node.getOwnerDocument() == xmlContext.document) {
                    xmlContext.report(issue, node, location, message, quickfixData);
                    return;
                }
            }
            if (this.driver.isSuppressed(null, issue, node)) {
                return;
            }
        } else if (source instanceof PsiElement) {
            PsiElement element = (PsiElement)source;
            if (this instanceof JavaContext) {
                JavaContext javaContext = (JavaContext)this;
                if (Objects.equals(element.getContainingFile(), javaContext.getPsiFile())) {
                    javaContext.report(issue, element, location, message, quickfixData);
                    return;
                }
            }
            if (this.driver.isSuppressed(null, issue, element)) {
                return;
            }
        } else if (source instanceof UElement) {
            PsiElement element = ((UElement)source).getPsi();
            if (element != null && this instanceof JavaContext) {
                JavaContext javaContext = (JavaContext)this;
                if (Objects.equals(element.getContainingFile(), javaContext.getPsiFile())) {
                    javaContext.report(issue, element, location, message, quickfixData);
                    return;
                }
            }
            if (this.driver.isSuppressed(null, issue, element)) {
                return;
            }
        }
        this.doReport(issue, location, message, quickfixData);
    }

    @Deprecated
    public void report(Issue issue, Location location, String message, Object quickfixData) {
        this.report(issue, location, message);
    }

    void doReport(Issue issue, Location location, String message, LintFix quickfixData) {
        if (location == null) {
            assert (false) : issue;
            return;
        }
        if (location == Location.NONE) {
            return;
        }
        Configuration configuration = this.configuration;
        Project project = this.driver.findProjectFor(location.getFile());
        if (project != null) {
            configuration = project.getConfiguration(this.driver);
        }
        if (configuration != this.configuration && this.configuration.getSeverity(issue) == Severity.IGNORE) {
            return;
        }
        Severity severity = configuration.getSeverity(issue);
        if (severity == Severity.IGNORE) {
            return;
        }
        this.driver.getClient().report(this, issue, severity, location, message, TextFormat.RAW, quickfixData);
    }

    public void log(Throwable exception, String format, Object ... args) {
        this.driver.getClient().log(exception, format, args);
    }

    public int getPhase() {
        return this.driver.getPhase();
    }

    public void requestRepeat(Detector detector, EnumSet<Scope> scope) {
        this.driver.requestRepeat(detector, scope);
    }

    protected String getSuppressCommentPrefix() {
        String path = this.file.getPath();
        if (path.endsWith(".java") || path.endsWith(".gradle")) {
            return "//noinspection ";
        }
        if (path.endsWith(".xml")) {
            return "<!--suppress ";
        }
        if (path.endsWith(".cfg") || path.endsWith(".pro")) {
            return "#suppress ";
        }
        return null;
    }

    public boolean containsCommentSuppress() {
        if (this.containsCommentSuppress == null) {
            CharSequence contents;
            this.containsCommentSuppress = false;
            String prefix = this.getSuppressCommentPrefix();
            if (prefix != null && (contents = this.getContents()) != null) {
                this.containsCommentSuppress = CharSequences.indexOf(contents, prefix) != -1;
            }
        }
        return this.containsCommentSuppress;
    }

    public boolean isSuppressedWithComment(int startOffset, Issue issue) {
        String prefix = this.getSuppressCommentPrefix();
        if (prefix == null) {
            return false;
        }
        if (startOffset <= 0) {
            return false;
        }
        CharSequence contents = this.getContents();
        assert (contents != null);
        if (startOffset >= contents.length()) {
            return false;
        }
        int lineStart = CharSequences.lastIndexOf(contents, 10, startOffset) + 1;
        if (lineStart <= 1) {
            return false;
        }
        int index = Context.findPrefixOnPreviousLine(contents, lineStart, prefix);
        if (index != -1 && index + prefix.length() < lineStart) {
            String line = contents.subSequence(index + prefix.length(), lineStart).toString();
            return line.contains(issue.getId()) || line.contains("all") && line.trim().startsWith("all");
        }
        return false;
    }

    private static int findPrefixOnPreviousLine(CharSequence contents, int lineStart, String prefix) {
        char first = prefix.charAt(0);
        boolean seenNonWhitespace = false;
        for (int offset = lineStart - 2; offset >= 0; --offset) {
            char c = contents.charAt(offset);
            if (seenNonWhitespace && c == '\n') {
                return -1;
            }
            if (!seenNonWhitespace && !Character.isWhitespace(c)) {
                seenNonWhitespace = true;
            }
            if (c != first || !CharSequences.regionMatches(contents, offset, prefix, 0, prefix.length())) continue;
            return offset;
        }
        return -1;
    }
}

