/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.XmlParser;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.ResourceContext;
import com.android.tools.lint.detector.api.XmlContext;
import com.google.common.annotations.Beta;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Beta
class ResourceVisitor {
    private final Map<String, List<Detector.XmlScanner>> elementToCheck = new HashMap<String, List<Detector.XmlScanner>>();
    private final Map<String, List<Detector.XmlScanner>> attributeToCheck = new HashMap<String, List<Detector.XmlScanner>>();
    private final List<Detector.XmlScanner> documentDetectors = new ArrayList<Detector.XmlScanner>();
    private final List<Detector.XmlScanner> allElementDetectors = new ArrayList<Detector.XmlScanner>();
    private final List<Detector.XmlScanner> allAttributeDetectors = new ArrayList<Detector.XmlScanner>();
    private final List<? extends Detector> allDetectors;
    private final List<? extends Detector> binaryDetectors;
    private final XmlParser parser;

    ResourceVisitor(XmlParser parser, List<? extends Detector> allDetectors, List<Detector> binaryDetectors) {
        this.parser = parser;
        this.binaryDetectors = binaryDetectors;
        this.allDetectors = allDetectors;
        for (Detector detector : allDetectors) {
            Detector.XmlScanner xmlDetector = (Detector.XmlScanner)((Object)detector);
            Collection<String> attributes = xmlDetector.getApplicableAttributes();
            if (attributes == Detector.XmlScanner.ALL) {
                this.allAttributeDetectors.add(xmlDetector);
            } else if (attributes != null) {
                for (String attribute : attributes) {
                    List<Detector.XmlScanner> list = this.attributeToCheck.get(attribute);
                    if (list == null) {
                        list = new ArrayList<Detector.XmlScanner>();
                        this.attributeToCheck.put(attribute, list);
                    }
                    list.add(xmlDetector);
                }
            }
            Collection<String> elements = xmlDetector.getApplicableElements();
            if (elements == Detector.XmlScanner.ALL) {
                this.allElementDetectors.add(xmlDetector);
            } else if (elements != null) {
                for (String element : elements) {
                    List<Detector.XmlScanner> list = this.elementToCheck.get(element);
                    if (list == null) {
                        list = new ArrayList<Detector.XmlScanner>();
                        this.elementToCheck.put(element, list);
                    }
                    list.add(xmlDetector);
                }
            }
            if (attributes != null && (!attributes.isEmpty() || attributes == Detector.XmlScanner.ALL) || elements != null && (!elements.isEmpty() || elements == Detector.XmlScanner.ALL)) continue;
            this.documentDetectors.add(xmlDetector);
        }
    }

    void visitFile(XmlContext context) {
        try {
            for (Detector detector : this.allDetectors) {
                detector.beforeCheckFile(context);
            }
            for (Detector.XmlScanner xmlScanner : this.documentDetectors) {
                xmlScanner.visitDocument(context, context.document);
            }
            if (!(this.elementToCheck.isEmpty() && this.attributeToCheck.isEmpty() && this.allAttributeDetectors.isEmpty() && this.allElementDetectors.isEmpty())) {
                this.visitElement(context, context.document.getDocumentElement());
            }
            for (Detector detector : this.allDetectors) {
                detector.afterCheckFile(context);
            }
        }
        catch (RuntimeException e) {
            LintDriver.handleDetectorError(context, e);
        }
    }

    private void visitElement(XmlContext context, Element element) {
        int n;
        List<Detector.XmlScanner> elementChecks = this.elementToCheck.get(element.getLocalName());
        if (elementChecks != null) {
            assert (elementChecks instanceof RandomAccess);
            for (Detector.XmlScanner check : elementChecks) {
                check.visitElement(context, element);
            }
        }
        if (!this.allElementDetectors.isEmpty()) {
            for (Detector.XmlScanner check : this.allElementDetectors) {
                check.visitElement(context, element);
            }
        }
        if (!this.attributeToCheck.isEmpty() || !this.allAttributeDetectors.isEmpty()) {
            NamedNodeMap attributes = element.getAttributes();
            n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                List<Detector.XmlScanner> list;
                Attr attribute = (Attr)attributes.item(i);
                String name = attribute.getLocalName();
                if (name == null) {
                    name = attribute.getName();
                }
                if ((list = this.attributeToCheck.get(name)) != null) {
                    for (Detector.XmlScanner check : list) {
                        check.visitAttribute(context, attribute);
                    }
                }
                if (this.allAttributeDetectors.isEmpty()) continue;
                for (Detector.XmlScanner check : this.allAttributeDetectors) {
                    check.visitAttribute(context, attribute);
                }
            }
        }
        NodeList childNodes = element.getChildNodes();
        n = childNodes.getLength();
        for (int i = 0; i < n; ++i) {
            Node child = childNodes.item(i);
            if (child.getNodeType() != 1) continue;
            this.visitElement(context, (Element)child);
        }
        if (elementChecks != null) {
            for (Detector.XmlScanner check : elementChecks) {
                check.visitElementAfter(context, element);
            }
        }
        if (!this.allElementDetectors.isEmpty()) {
            for (Detector.XmlScanner check : this.allElementDetectors) {
                check.visitElementAfter(context, element);
            }
        }
    }

    public XmlParser getParser() {
        return this.parser;
    }

    public void visitBinaryResource(ResourceContext context) {
        if (this.binaryDetectors == null) {
            return;
        }
        for (Detector detector : this.binaryDetectors) {
            detector.beforeCheckFile(context);
            detector.checkBinaryResource(context);
            detector.afterCheckFile(context);
        }
    }
}

