/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.tools.lint.client.api.ResourceReference;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.ExternalReferenceExpression;
import com.android.tools.lint.detector.api.JavaContext;
import com.google.common.collect.Lists;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiVariable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UPrefixExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UUnaryExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastContext;
import org.jetbrains.uast.UastPrefixOperator;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.UastVisitor;

public class UastLintUtils {
    public static PsiFile getContainingFile(JavaContext context2, PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiFile containingFile = element.getContainingFile();
        if (!containingFile.equals(context2.getPsiFile())) {
            return UastLintUtils.getContainingFile(element);
        }
        return containingFile;
    }

    public static PsiFile getPsiFile(UFile file) {
        if (file == null) {
            return null;
        }
        return UastLintUtils.getContainingFile((PsiElement)file.getPsi());
    }

    public static PsiFile getContainingFile(PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiFile containingFile = element instanceof PsiFile ? (PsiFile)element : element.getContainingFile();
        Class<?> cls = containingFile.getClass();
        String name = cls.getName();
        if (name.startsWith("org.jetbrains.kotlin.asJava.classes.KtLightClassForSourceDeclaration")) {
            try {
                Field declaredField = cls.getSuperclass().getDeclaredField("ktFile");
                declaredField.setAccessible(true);
                Object o = declaredField.get(containingFile);
                if (o instanceof PsiFile) {
                    return (PsiFile)o;
                }
            }
            catch (Throwable declaredField) {}
        } else if (name.equals("org.jetbrains.kotlin.asJava.elements.FakeFileForLightClass")) {
            try {
                Field declaredField = cls.getDeclaredField("ktFile");
                declaredField.setAccessible(true);
                Object o = declaredField.get(containingFile);
                if (o instanceof PsiFile) {
                    return (PsiFile)o;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return containingFile;
    }

    public static String getQualifiedName(PsiElement element) {
        if (element instanceof PsiClass) {
            return ((PsiClass)element).getQualifiedName();
        }
        if (element instanceof PsiMethod) {
            PsiClass containingClass = ((PsiMethod)element).getContainingClass();
            if (containingClass == null) {
                return null;
            }
            String containingClassFqName = UastLintUtils.getQualifiedName((PsiElement)containingClass);
            if (containingClassFqName == null) {
                return null;
            }
            return containingClassFqName + "." + ((PsiMethod)element).getName();
        }
        if (element instanceof PsiField) {
            PsiClass containingClass = ((PsiField)element).getContainingClass();
            if (containingClass == null) {
                return null;
            }
            String containingClassFqName = UastLintUtils.getQualifiedName((PsiElement)containingClass);
            if (containingClassFqName == null) {
                return null;
            }
            return containingClassFqName + "." + ((PsiField)element).getName();
        }
        return null;
    }

    public static PsiElement resolve(ExternalReferenceExpression expression, UElement context2) {
        UDeclaration declaration = (UDeclaration)UastUtils.getParentOfType((UElement)context2, UDeclaration.class);
        if (declaration == null) {
            return null;
        }
        return expression.resolve((PsiElement)declaration.getPsi());
    }

    public static String getClassName(PsiClassType type) {
        PsiClass psiClass = type.resolve();
        if (psiClass == null) {
            return type.getClassName();
        }
        return UastLintUtils.getClassName(psiClass);
    }

    public static String getClassName(PsiClass psiClass) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(psiClass.getName());
        for (psiClass = psiClass.getContainingClass(); psiClass != null; psiClass = psiClass.getContainingClass()) {
            stringBuilder.insert(0, psiClass.getName() + ".");
        }
        return stringBuilder.toString();
    }

    public static UExpression findLastAssignment(PsiVariable variable, UElement call) {
        UExpression lastAssignment = null;
        if (variable instanceof UVariable) {
            variable = ((UVariable)variable).getPsi();
        }
        if (!variable.hasModifierProperty("final") && (variable instanceof PsiLocalVariable || variable instanceof PsiParameter)) {
            UMethod containingFunction = UastUtils.getContainingUMethod((UElement)call);
            if (containingFunction != null) {
                UastContext context2 = UastUtils.getUastContext((UElement)call);
                ConstantEvaluator.LastAssignmentFinder finder = new ConstantEvaluator.LastAssignmentFinder(variable, call, context2, null, -1);
                containingFunction.accept((UastVisitor)finder);
                lastAssignment = finder.getLastAssignment();
            }
        } else {
            UastContext context3 = UastUtils.getUastContext((UElement)call);
            lastAssignment = context3.getInitializerBody(variable);
        }
        if (lastAssignment instanceof UExpression) {
            return lastAssignment;
        }
        return null;
    }

    public static String getReferenceName(UReferenceExpression expression) {
        UExpression selector;
        if (expression instanceof USimpleNameReferenceExpression) {
            return ((USimpleNameReferenceExpression)expression).getIdentifier();
        }
        if (expression instanceof UQualifiedReferenceExpression && (selector = ((UQualifiedReferenceExpression)expression).getSelector()) instanceof USimpleNameReferenceExpression) {
            return ((USimpleNameReferenceExpression)selector).getIdentifier();
        }
        return null;
    }

    public static Object findLastValue(PsiVariable variable, UElement call, UastContext context2, ConstantEvaluator evaluator) {
        Object value = null;
        if (!variable.hasModifierProperty("final") && (variable instanceof PsiLocalVariable || variable instanceof PsiParameter)) {
            UMethod containingFunction = UastUtils.getContainingUMethod((UElement)call);
            if (containingFunction != null) {
                ConstantEvaluator.LastAssignmentFinder finder = new ConstantEvaluator.LastAssignmentFinder(variable, call, context2, evaluator, 1);
                containingFunction.getUastBody().accept((UastVisitor)finder);
                value = finder.getCurrentValue();
            }
        } else {
            UExpression initializer = context2.getInitializerBody(variable);
            if (initializer != null) {
                value = initializer.evaluate();
            }
        }
        return value;
    }

    public static ResourceReference toAndroidReferenceViaResolve(UElement element) {
        return ResourceReference.Companion.get(element);
    }

    public static boolean areIdentifiersEqual(UExpression first, UExpression second) {
        String firstIdentifier = UastLintUtils.getIdentifier(first);
        String secondIdentifier = UastLintUtils.getIdentifier(second);
        return firstIdentifier != null && secondIdentifier != null && firstIdentifier.equals(secondIdentifier);
    }

    public static String getIdentifier(UExpression expression) {
        if (expression instanceof ULiteralExpression) {
            expression.asRenderString();
        } else {
            if (expression instanceof USimpleNameReferenceExpression) {
                return ((USimpleNameReferenceExpression)expression).getIdentifier();
            }
            if (expression instanceof UQualifiedReferenceExpression) {
                UQualifiedReferenceExpression qualified = (UQualifiedReferenceExpression)expression;
                String receiverIdentifier = UastLintUtils.getIdentifier(qualified.getReceiver());
                String selectorIdentifier = UastLintUtils.getIdentifier(qualified.getSelector());
                if (receiverIdentifier == null || selectorIdentifier == null) {
                    return null;
                }
                return receiverIdentifier + "." + selectorIdentifier;
            }
        }
        return null;
    }

    public static boolean isNumber(UElement argument) {
        if (argument instanceof ULiteralExpression) {
            Object value = ((ULiteralExpression)argument).getValue();
            return value instanceof Number;
        }
        if (argument instanceof UPrefixExpression) {
            UPrefixExpression expression = (UPrefixExpression)argument;
            UExpression operand = expression.getOperand();
            return UastLintUtils.isNumber((UElement)operand);
        }
        return false;
    }

    public static boolean isZero(UElement argument) {
        if (argument instanceof ULiteralExpression) {
            Object value = ((ULiteralExpression)argument).getValue();
            return value instanceof Number && ((Number)value).intValue() == 0;
        }
        return false;
    }

    public static boolean isMinusOne(UElement argument) {
        if (argument instanceof UUnaryExpression) {
            UUnaryExpression expression = (UUnaryExpression)argument;
            UExpression operand = expression.getOperand();
            if (operand instanceof ULiteralExpression && expression.getOperator() == UastPrefixOperator.UNARY_MINUS) {
                Object value = ((ULiteralExpression)operand).getValue();
                return value instanceof Number && ((Number)value).intValue() == 1;
            }
            return false;
        }
        return false;
    }

    public static UExpression getAnnotationValue(UAnnotation annotation) {
        UExpression value = annotation.findDeclaredAttributeValue("value");
        if (value == null) {
            value = annotation.findDeclaredAttributeValue(null);
        }
        return value;
    }

    public static long getLongAttribute(JavaContext context2, UAnnotation annotation, String name, long defaultValue) {
        Long value = UastLintUtils.getAnnotationLongValue(annotation, name);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public static double getDoubleAttribute(JavaContext context2, UAnnotation annotation, String name, double defaultValue) {
        Double value = UastLintUtils.getAnnotationDoubleValue(annotation, name);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public static boolean getBoolean(JavaContext context2, UAnnotation annotation, String name, boolean defaultValue) {
        Boolean value = UastLintUtils.getAnnotationBooleanValue(annotation, name);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public static Boolean getAnnotationBooleanValue(UAnnotation annotation, String name) {
        if (annotation != null) {
            Object o;
            UExpression attributeValue = annotation.findDeclaredAttributeValue(name);
            if (attributeValue == null && "value".equals(name)) {
                attributeValue = annotation.findDeclaredAttributeValue(null);
            }
            if (attributeValue != null && (o = ConstantEvaluator.evaluate(null, (UElement)attributeValue)) instanceof Boolean) {
                return (Boolean)o;
            }
        }
        return null;
    }

    public static boolean getAnnotationBooleanValue(UAnnotation annotation, String name, boolean defaultValue) {
        Boolean value = UastLintUtils.getAnnotationBooleanValue(annotation, name);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public static Long getAnnotationLongValue(UAnnotation annotation, String name) {
        if (annotation != null) {
            Object o;
            UExpression attributeValue = annotation.findDeclaredAttributeValue(name);
            if (attributeValue == null && "value".equals(name)) {
                attributeValue = annotation.findDeclaredAttributeValue(null);
            }
            if (attributeValue != null && (o = ConstantEvaluator.evaluate(null, (UElement)attributeValue)) instanceof Number) {
                return ((Number)o).longValue();
            }
        }
        return null;
    }

    public static long getAnnotationLongValue(UAnnotation annotation, String name, long defaultValue) {
        Long value = UastLintUtils.getAnnotationLongValue(annotation, name);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public static Double getAnnotationDoubleValue(UAnnotation annotation, String name) {
        if (annotation != null) {
            Object o;
            UExpression attributeValue = annotation.findDeclaredAttributeValue(name);
            if (attributeValue == null && "value".equals(name)) {
                attributeValue = annotation.findDeclaredAttributeValue(null);
            }
            if (attributeValue != null && (o = ConstantEvaluator.evaluate(null, (UElement)attributeValue)) instanceof Number) {
                return ((Number)o).doubleValue();
            }
        }
        return null;
    }

    public static double getAnnotationDoubleValue(UAnnotation annotation, String name, double defaultValue) {
        Double value = UastLintUtils.getAnnotationDoubleValue(annotation, name);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public static String getAnnotationStringValue(UAnnotation annotation, String name) {
        if (annotation != null) {
            Object o;
            UExpression attributeValue = annotation.findDeclaredAttributeValue(name);
            if (attributeValue == null && "value".equals(name)) {
                attributeValue = annotation.findDeclaredAttributeValue(null);
            }
            if (attributeValue != null && (o = ConstantEvaluator.evaluate(null, (UElement)attributeValue)) instanceof String) {
                return (String)o;
            }
        }
        return null;
    }

    public static String[] getAnnotationStringValues(UAnnotation annotation, String name) {
        if (annotation != null) {
            UExpression attributeValue = annotation.findDeclaredAttributeValue(name);
            if (attributeValue == null && "value".equals(name)) {
                attributeValue = annotation.findDeclaredAttributeValue(null);
            }
            if (attributeValue == null) {
                return null;
            }
            if (UastExpressionUtils.isArrayInitializer((UElement)attributeValue)) {
                List initializers = ((UCallExpression)attributeValue).getValueArguments();
                ArrayList result = Lists.newArrayListWithCapacity((int)initializers.size());
                ConstantEvaluator constantEvaluator = new ConstantEvaluator();
                for (UExpression element : initializers) {
                    Object o = constantEvaluator.evaluate((UElement)element);
                    if (!(o instanceof String)) continue;
                    result.add((String)o);
                }
                if (result.isEmpty()) {
                    return null;
                }
                return result.toArray(new String[0]);
            }
            Object o = ConstantEvaluator.evaluate(null, (UElement)attributeValue);
            if (o instanceof String) {
                return new String[]{(String)o};
            }
            if (o instanceof String[]) {
                return (String[])o;
            }
            if (o instanceof Object[]) {
                Object[] array = (Object[])o;
                ArrayList strings = Lists.newArrayListWithCapacity((int)array.length);
                for (Object element : array) {
                    if (!(element instanceof String)) continue;
                    strings.add((String)element);
                }
                return strings.toArray(new String[0]);
            }
        }
        return null;
    }

    public static boolean containsAnnotation(List<UAnnotation> list2, UAnnotation annotation) {
        for (UAnnotation a : list2) {
            if (a != annotation) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAnnotation(List<UAnnotation> list2, String qualifiedName) {
        for (UAnnotation annotation : list2) {
            if (!qualifiedName.equals(annotation.getQualifiedName())) continue;
            return true;
        }
        return false;
    }
}

