/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.SdkConstants;
import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.Dependencies;
import com.android.builder.model.Variant;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.ide.common.repository.ResourceVisibilityLookup;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.util.PathString;
import com.android.manifmerger.Actions;
import com.android.prefs.AndroidLocation;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressIndicatorAdapter;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.targets.AndroidTargetManager;
import com.android.tools.lint.client.api.BlameFile;
import com.android.tools.lint.client.api.CircularDependencyException;
import com.android.tools.lint.client.api.ClassEntry;
import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.DefaultConfiguration;
import com.android.tools.lint.client.api.DefaultSdkInfo;
import com.android.tools.lint.client.api.GradleVisitor;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.JarFileIssueRegistry;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.LintRequest;
import com.android.tools.lint.client.api.SdkInfo;
import com.android.tools.lint.client.api.UastParser;
import com.android.tools.lint.client.api.XmlParser;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Desugaring;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.utils.CharSequences;
import com.android.utils.Pair;
import com.android.utils.XmlUtils;
import com.google.common.annotations.Beta;
import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.intellij.openapi.util.Computable;
import com.intellij.pom.java.LanguageLevel;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kxml2.io.KXmlParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmlpull.v1.XmlPullParser;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0094\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u000e\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b'\u0018\u0000 \u00cf\u00012\u00020\u0001:\u0006\u00ce\u0001\u00cf\u0001\u00d0\u0001B\u000f\b\u0014\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0007\b\u0014\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u000200H\u0016J2\u00102\u001a\u0002032\f\u00104\u001a\b\u0012\u0004\u0012\u00020\b052\f\u00106\u001a\b\u0012\u0004\u0012\u0002070\u00112\f\u00108\u001a\b\u0012\u0004\u0012\u0002070\u0015H\u0002J,\u00109\u001a\u0002032\f\u00104\u001a\b\u0012\u0004\u0012\u00020\b052\u0006\u0010:\u001a\u0002072\f\u00108\u001a\b\u0012\u0004\u0012\u0002070\u0015H\u0002J\b\u0010;\u001a\u00020<H\u0016J\u0010\u0010=\u001a\u0002032\u0006\u0010>\u001a\u00020?H\u0016J\u0018\u0010@\u001a\u00020\t2\u0006\u0010A\u001a\u00020\b2\u0006\u0010B\u001a\u00020\bH\u0014J\u0010\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020FH\u0016J\u001c\u0010G\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030H2\u0006\u0010I\u001a\u00020\tH\u0016J#\u0010J\u001a\u00020K2\f\u0010L\u001a\b\u0012\u0004\u0012\u00020M0(2\u0006\u0010N\u001a\u00020KH\u0016\u00a2\u0006\u0002\u0010OJ\u0012\u0010P\u001a\u0004\u0018\u00010Q2\u0006\u0010R\u001a\u00020SH\u0016J\u0016\u0010T\u001a\u0002032\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0011H\u0014J\u000e\u0010U\u001a\b\u0012\u0004\u0012\u00020\b0VH\u0016J\u0012\u0010W\u001a\u0004\u0018\u00010X2\u0006\u0010Y\u001a\u00020#H\u0016J \u0010Z\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0006\b\u0001\u0012\u00020#\u0018\u00010$2\u0006\u0010Y\u001a\u00020#H\u0016J\u0012\u0010[\u001a\u0004\u0018\u00010\b2\u0006\u0010\\\u001a\u00020\u0003H\u0016J\u0016\u0010]\u001a\b\u0012\u0004\u0012\u00020\b0V2\u0006\u0010I\u001a\u00020\tH\u0016J\u0016\u0010^\u001a\b\u0012\u0004\u0012\u00020\b0V2\u0006\u0010I\u001a\u00020\tH\u0016J\u0012\u0010_\u001a\u0004\u0018\u00010`2\u0006\u0010I\u001a\u00020\tH\u0016J\u001c\u0010a\u001a\u0004\u0018\u00010\b2\b\u0010b\u001a\u0004\u0018\u00010\u00032\u0006\u0010c\u001a\u00020<H\u0016J\u0010\u0010d\u001a\u00020\u00192\u0006\u0010I\u001a\u00020\tH\u0014J\n\u0010e\u001a\u0004\u0018\u00010\u0003H\u0016J\n\u0010f\u001a\u0004\u0018\u00010\u0003H\u0016J\u0012\u0010g\u001a\u0004\u0018\u00010)2\u0006\u0010I\u001a\u00020\tH\u0016J\u001a\u0010h\u001a\u00020i2\u0006\u0010I\u001a\u00020\t2\b\u0010j\u001a\u0004\u0018\u00010kH\u0016J\u0016\u0010l\u001a\b\u0012\u0004\u0012\u00020n0m2\u0006\u0010I\u001a\u00020\tH\u0016J\u0010\u0010o\u001a\u00020\u00032\u0006\u0010p\u001a\u00020\bH\u0016J\u0016\u0010q\u001a\b\u0012\u0004\u0012\u00020\b0V2\u0006\u0010I\u001a\u00020\tH\u0016J\u0016\u0010r\u001a\b\u0012\u0004\u0012\u00020\b0V2\u0006\u0010I\u001a\u00020\tH\u0016J\b\u0010s\u001a\u00020tH&J\"\u0010u\u001a\u0004\u0018\u00010v2\u0006\u0010w\u001a\u00020x2\u000e\u0010y\u001a\n\u0012\u0004\u0012\u00020v\u0018\u00010zH\u0016J\u0016\u0010{\u001a\b\u0012\u0004\u0012\u00020\b0V2\u0006\u0010I\u001a\u00020\tH\u0016J\u001e\u0010|\u001a\b\u0012\u0004\u0012\u00020\b0V2\u0006\u0010I\u001a\u00020\t2\u0006\u0010}\u001a\u00020<H\u0016J\u0016\u0010~\u001a\b\u0012\u0004\u0012\u00020\b0V2\u0006\u0010I\u001a\u00020\tH\u0016J\u0013\u0010\u007f\u001a\u0005\u0018\u00010\u0080\u00012\u0006\u0010I\u001a\u00020\tH\u0016J\u0019\u0010\u0081\u0001\u001a\u00020\t2\u0006\u0010A\u001a\u00020\b2\u0006\u0010B\u001a\u00020\bH\u0016J\u0011\u0010\u0082\u0001\u001a\u00020\u00032\u0006\u0010I\u001a\u00020\tH\u0016J\n\u0010\u0083\u0001\u001a\u00030\u0084\u0001H\u0016J\u0017\u0010\u0085\u0001\u001a\b\u0012\u0004\u0012\u00020\b0V2\u0006\u0010I\u001a\u00020\tH\u0016J&\u0010\u0086\u0001\u001a\u0005\u0018\u00010\u0087\u00012\u0006\u0010I\u001a\u00020\t2\u0007\u0010\u0088\u0001\u001a\u00020<2\u0007\u0010\u0089\u0001\u001a\u00020<H\u0016J\t\u0010\u008a\u0001\u001a\u00020\u001fH\u0016J\u000b\u0010\u008b\u0001\u001a\u0004\u0018\u00010!H\u0016J\u000b\u0010\u008c\u0001\u001a\u0004\u0018\u00010\bH\u0016J\u0012\u0010\u008d\u0001\u001a\u00030\u008e\u00012\u0006\u0010I\u001a\u00020\tH\u0016J\u001b\u0010\u008f\u0001\u001a\u0004\u0018\u00010\u00032\u0006\u0010I\u001a\u00020\t2\u0006\u0010b\u001a\u00020\u0003H\u0016J\u0015\u0010\u0090\u0001\u001a\b\u0012\u0004\u0012\u00020)0(H\u0016\u00a2\u0006\u0003\u0010\u0091\u0001J\u0017\u0010\u0092\u0001\u001a\b\u0012\u0004\u0012\u00020\b0V2\u0006\u0010I\u001a\u00020\tH\u0016J\u0017\u0010\u0093\u0001\u001a\b\u0012\u0004\u0012\u00020\b0V2\u0006\u0010I\u001a\u00020\tH\u0016J\u0014\u0010\u0094\u0001\u001a\u00030\u0095\u00012\b\u0010I\u001a\u0004\u0018\u00010\tH&J\u0017\u0010\u0096\u0001\u001a\u0002032\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0011H\u0014J\u0011\u0010\u0097\u0001\u001a\u00020<2\u0006\u0010I\u001a\u00020\tH\u0016J\u0010\u0010\u0098\u0001\u001a\u00020<2\u0007\u0010\u0099\u0001\u001a\u00020#J\u0011\u0010\u009a\u0001\u001a\u00020<2\u0006\u0010A\u001a\u00020\bH\u0016J*\u0010\u009b\u0001\u001a\u0004\u0018\u00010<2\u0006\u0010I\u001a\u00020\t2\u0006\u0010b\u001a\u00020\u00032\u0007\u0010\u009c\u0001\u001a\u00020\u0003H\u0016\u00a2\u0006\u0003\u0010\u009d\u0001JE\u0010\u009e\u0001\u001a\u0002032\b\u0010\u009f\u0001\u001a\u00030\u00a0\u00012\n\u0010\u00a1\u0001\u001a\u0005\u0018\u00010\u00a2\u00012\t\u0010\u00a3\u0001\u001a\u0004\u0018\u00010\u00032\u0013\u0010\u00a4\u0001\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010(\"\u00020\u0001H&\u00a2\u0006\u0003\u0010\u00a5\u0001J;\u0010\u009e\u0001\u001a\u0002032\n\u0010\u00a1\u0001\u001a\u0005\u0018\u00010\u00a2\u00012\t\u0010\u00a3\u0001\u001a\u0004\u0018\u00010\u00032\u0013\u0010\u00a4\u0001\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010(\"\u00020\u0001H\u0016\u00a2\u0006\u0003\u0010\u00a6\u0001J\u0014\u0010\u00a7\u0001\u001a\u0004\u0018\u00010?2\u0007\u0010\u00a8\u0001\u001a\u00020MH\u0016J\u001d\u0010\u00a7\u0001\u001a\u0004\u0018\u00010?2\u0007\u0010\u00a8\u0001\u001a\u00020M2\u0007\u0010\u00a9\u0001\u001a\u00020\rH\u0016J\u001d\u0010\u00aa\u0001\u001a\u0002032\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0011H\u0000\u00a2\u0006\u0003\b\u00ab\u0001J\u0017\u0010\u00ac\u0001\u001a\u00020\u00192\u0006\u0010I\u001a\u00020\tH\u0000\u00a2\u0006\u0003\b\u00ad\u0001J\u001d\u0010\u00ae\u0001\u001a\u0002032\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0011H\u0000\u00a2\u0006\u0003\b\u00af\u0001J\u0012\u0010\u00b0\u0001\u001a\u00030\u00b1\u00012\u0006\u0010R\u001a\u00020SH\u0016J\u0012\u0010\u00b0\u0001\u001a\u00030\u00b1\u00012\u0006\u0010p\u001a\u00020\bH\u0016J\u0012\u0010\u00b2\u0001\u001a\u00030\u00b3\u00012\u0006\u0010p\u001a\u00020\bH&J\u0019\u0010\u00b4\u0001\u001a\u0002032\u0006\u0010A\u001a\u00020\b2\u0006\u0010I\u001a\u00020\tH\u0016J&\u0010\u00b5\u0001\u001a\f\u0012\u0007\b\u0001\u0012\u00030\u00b7\u00010\u00b6\u00012\u0011\u0010\u00b8\u0001\u001a\f\u0012\u0007\b\u0001\u0012\u00030\u00b7\u00010\u00b6\u0001H\u0016JO\u0010\u00b9\u0001\u001a\u0002032\b\u0010\u00ba\u0001\u001a\u00030\u00bb\u00012\b\u0010\u00bc\u0001\u001a\u00030\u00bd\u00012\b\u0010\u009f\u0001\u001a\u00030\u00a0\u00012\u0007\u0010\u00be\u0001\u001a\u00020X2\u0007\u0010\u00bf\u0001\u001a\u00020\u00032\b\u0010\u00a3\u0001\u001a\u00030\u00c0\u00012\n\u0010\u00c1\u0001\u001a\u0005\u0018\u00010\u00c2\u0001H&J\u001c\u0010\u00c3\u0001\u001a\u0002032\b\u0010\u00c4\u0001\u001a\u00030\u0080\u00012\u0007\u0010\u00c5\u0001\u001a\u00020\u0001H\u0016J(\u0010\u00c6\u0001\u001a\u0003H\u00c7\u0001\"\u0005\b\u0000\u0010\u00c7\u00012\u000f\u0010\u00c8\u0001\u001a\n\u0012\u0005\u0012\u0003H\u00c7\u00010\u00c9\u0001H\u0016\u00a2\u0006\u0003\u0010\u00ca\u0001J\u0013\u0010\u00c6\u0001\u001a\u0002032\b\u0010\u00cb\u0001\u001a\u00030\u00cc\u0001H\u0016J\t\u0010\u00cd\u0001\u001a\u00020<H\u0016R \u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u0015X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00190\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u001b0\u0007X\u0084\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001c\u0010\u0005\u001a\u0004\b\u001d\u0010\u000bR\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R4\u0010\"\u001a\u001c\u0012\u0004\u0012\u00020#\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\b\u0001\u0012\u00020#0$0\u0007X\u0084\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b%\u0010\u0005\u001a\u0004\b&\u0010\u000bR\u0018\u0010'\u001a\n\u0012\u0004\u0012\u00020)\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010*R\u0012\u0010+\u001a\u00020,X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.\u00a8\u0006\u00d1\u0001"}, d2={"Lcom/android/tools/lint/client/api/LintClient;", "", "clientName", "", "(Ljava/lang/String;)V", "()V", "dirToProject", "", "Ljava/io/File;", "Lcom/android/tools/lint/detector/api/Project;", "getDirToProject", "()Ljava/util/Map;", "highestKnownApiLevel", "", "getHighestKnownApiLevel", "()I", "knownProjects", "", "getKnownProjects", "()Ljava/util/Collection;", "projectDirs", "", "getProjectDirs", "()Ljava/util/Set;", "projectInfo", "Lcom/android/tools/lint/client/api/LintClient$ClassPathInfo;", "reportFileCache", "Lcom/android/tools/lint/client/api/BlameFile;", "reportFileCache$annotations", "getReportFileCache", "resourceVisibilityProvider", "Lcom/android/ide/common/repository/ResourceVisibilityLookup$Provider;", "sdk", "Lcom/android/sdklib/repository/AndroidSdkHandler;", "sourceNodeCache", "Lorg/w3c/dom/Node;", "Lcom/android/utils/Pair;", "sourceNodeCache$annotations", "getSourceNodeCache", "targets", "", "Lcom/android/sdklib/IAndroidTarget;", "[Lcom/android/sdklib/IAndroidTarget;", "xmlParser", "Lcom/android/tools/lint/client/api/XmlParser;", "getXmlParser", "()Lcom/android/tools/lint/client/api/XmlParser;", "addCustomLintRules", "Lcom/android/tools/lint/client/api/IssueRegistry;", "registry", "addLintJarsFromDependencies", "", "lintJars", "", "libraries", "Lcom/android/builder/model/AndroidLibrary;", "seen", "addLintJarsFromDependency", "library", "checkForSuppressComments", "", "closeConnection", "connection", "Ljava/net/URLConnection;", "createProject", "dir", "referenceDir", "createResourceItemHandle", "Lcom/android/tools/lint/detector/api/Location$Handle;", "item", "Lcom/android/ide/common/resources/ResourceItem;", "createSuperClassMap", "", "project", "createUrlClassLoader", "Ljava/lang/ClassLoader;", "urls", "Ljava/net/URL;", "parent", "([Ljava/net/URL;Ljava/lang/ClassLoader;)Ljava/lang/ClassLoader;", "createXmlPullParser", "Lorg/xmlpull/v1/XmlPullParser;", "resourcePath", "Lcom/android/ide/common/util/PathString;", "disposeProjects", "findGlobalRuleJars", "", "findManifestSourceLocation", "Lcom/android/tools/lint/detector/api/Location;", "mergedNode", "findManifestSourceNode", "findResource", "relativePath", "findRuleJars", "getAssetFolders", "getBuildTools", "Lcom/android/sdklib/BuildToolInfo;", "getCacheDir", "name", "create", "getClassPath", "getClientDisplayRevision", "getClientRevision", "getCompileTarget", "getConfiguration", "Lcom/android/tools/lint/client/api/Configuration;", "driver", "Lcom/android/tools/lint/client/api/LintDriver;", "getDesugaring", "", "Lcom/android/tools/lint/detector/api/Desugaring;", "getDisplayPath", "file", "getGeneratedResourceFolders", "getGeneratedSourceFolders", "getGradleVisitor", "Lcom/android/tools/lint/client/api/GradleVisitor;", "getHighestKnownVersion", "Lcom/android/ide/common/repository/GradleVersion;", "coordinate", "Lcom/android/ide/common/repository/GradleCoordinate;", "filter", "Ljava/util/function/Predicate;", "getJavaClassFolders", "getJavaLibraries", "includeProvided", "getJavaSourceFolders", "getMergedManifest", "Lorg/w3c/dom/Document;", "getProject", "getProjectName", "getRepositoryLogger", "Lcom/android/repository/api/ProgressIndicator;", "getResourceFolders", "getResourceRepository", "Lcom/android/ide/common/resources/ResourceRepository;", "includeModuleDependencies", "includeLibraries", "getResourceVisibilityProvider", "getSdk", "getSdkHome", "getSdkInfo", "Lcom/android/tools/lint/client/api/SdkInfo;", "getSuperClass", "getTargets", "()[Lcom/android/sdklib/IAndroidTarget;", "getTestLibraries", "getTestSourceFolders", "getUastParser", "Lcom/android/tools/lint/client/api/UastParser;", "initializeProjects", "isGradleProject", "isMergeManifestNode", "node", "isProjectDirectory", "isSubclassOf", "superClassName", "(Lcom/android/tools/lint/detector/api/Project;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Boolean;", "log", "severity", "Lcom/android/tools/lint/detector/api/Severity;", "exception", "", "format", "args", "(Lcom/android/tools/lint/detector/api/Severity;Ljava/lang/Throwable;Ljava/lang/String;[Ljava/lang/Object;)V", "(Ljava/lang/Throwable;Ljava/lang/String;[Ljava/lang/Object;)V", "openConnection", "url", "timeout", "performDisposeProjects", "performDisposeProjects$lint_api", "performGetClassPath", "performGetClassPath$lint_api", "performInitializeProjects", "performInitializeProjects$lint_api", "readBytes", "", "readFile", "", "registerProject", "replaceDetector", "Ljava/lang/Class;", "Lcom/android/tools/lint/detector/api/Detector;", "detectorClass", "report", "context", "Lcom/android/tools/lint/detector/api/Context;", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "location", "message", "Lcom/android/tools/lint/detector/api/TextFormat;", "fix", "Lcom/android/tools/lint/detector/api/LintFix;", "resolveMergeManifestSources", "mergedManifest", "reportFile", "runReadAction", "T", "computable", "Lcom/intellij/openapi/util/Computable;", "(Lcom/intellij/openapi/util/Computable;)Ljava/lang/Object;", "runnable", "Ljava/lang/Runnable;", "supportsProjectResources", "ClassPathInfo", "Companion", "RepoLogger", "lint-api"})
@Beta
public abstract class LintClient {
    private final Map<Project, ClassPathInfo> projectInfo;
    @NotNull
    private final Map<File, Project> dirToProject;
    @NotNull
    private final Set<File> projectDirs;
    private IAndroidTarget[] targets;
    private AndroidSdkHandler sdk;
    @NotNull
    private final Map<Object, BlameFile> reportFileCache;
    @NotNull
    private final Map<Node, Pair<File, ? extends Node>> sourceNodeCache;
    private ResourceVisibilityLookup.Provider resourceVisibilityProvider;
    private static final String PROP_BIN_DIR = "com.android.tools.lint.bindir";
    private static final int SDK_DATABASE_MIN_VERSION = 26;
    private static final String MERGED_MANIFEST = "lint-merged-manifest";
    @JvmField
    @NotNull
    protected static final Pair<File, Node> NOT_FOUND;
    @NotNull
    public static final String CLIENT_STUDIO = "studio";
    @NotNull
    public static final String CLIENT_GRADLE = "gradle";
    @NotNull
    public static final String CLIENT_CLI = "cli";
    @NotNull
    public static final String CLIENT_UNIT_TESTS = "test";
    @NotNull
    public static final String CLIENT_UNKNOWN = "unknown";
    @NotNull
    private static String clientName;
    public static final Companion Companion;

    @NotNull
    public Configuration getConfiguration(@NotNull Project project, @Nullable LintDriver driver) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        DefaultConfiguration defaultConfiguration = DefaultConfiguration.create(this, project, null);
        Intrinsics.checkExpressionValueIsNotNull((Object)defaultConfiguration, (String)"DefaultConfiguration.create(this, project, null)");
        return defaultConfiguration;
    }

    public abstract void report(@NotNull Context var1, @NotNull Issue var2, @NotNull Severity var3, @NotNull Location var4, @NotNull String var5, @NotNull TextFormat var6, @Nullable LintFix var7);

    public void log(@Nullable Throwable exception, @Nullable String format, Object ... args) {
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        this.log(Severity.WARNING, exception, format, Arrays.copyOf(args, args.length));
    }

    public abstract void log(@NotNull Severity var1, @Nullable Throwable var2, @Nullable String var3, Object ... var4);

    @NotNull
    public abstract XmlParser getXmlParser();

    @NotNull
    public abstract UastParser getUastParser(@Nullable Project var1);

    @NotNull
    public abstract GradleVisitor getGradleVisitor();

    @NotNull
    public Class<? extends Detector> replaceDetector(@NotNull Class<? extends Detector> detectorClass) {
        Intrinsics.checkParameterIsNotNull(detectorClass, (String)"detectorClass");
        return detectorClass;
    }

    @NotNull
    public abstract CharSequence readFile(@NotNull File var1);

    @NotNull
    public byte[] readBytes(@NotNull File file) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return FilesKt.readBytes((File)file);
    }

    @NotNull
    public byte[] readBytes(@NotNull PathString resourcePath) throws IOException {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkParameterIsNotNull((Object)resourcePath, (String)"resourcePath");
                object = resourcePath.toFile();
                if (object == null) break block2;
                byte[] byArray = FilesKt.readBytes((File)object);
                object = byArray;
                if (byArray != null) break block3;
            }
            throw (Throwable)new FileNotFoundException(resourcePath.toString());
        }
        return object;
    }

    @NotNull
    public List<File> getJavaSourceFolders(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return this.getClassPath(project).getSourceFolders();
    }

    @NotNull
    public List<File> getGeneratedSourceFolders(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return this.getClassPath(project).getGeneratedFolders();
    }

    @NotNull
    public List<File> getJavaClassFolders(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return this.getClassPath(project).getClassFolders();
    }

    @NotNull
    public List<File> getJavaLibraries(@NotNull Project project, boolean includeProvided) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return this.getClassPath(project).getLibraries(includeProvided);
    }

    @NotNull
    public List<File> getTestSourceFolders(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return this.getClassPath(project).getTestSourceFolders();
    }

    @NotNull
    public List<File> getTestLibraries(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return this.getClassPath(project).getTestLibraries();
    }

    @NotNull
    public List<File> getResourceFolders(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        File res = new File(project.getDir(), "res");
        if (res.exists()) {
            return CollectionsKt.listOf((Object)res);
        }
        return CollectionsKt.emptyList();
    }

    @NotNull
    public List<File> getGeneratedResourceFolders(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return CollectionsKt.emptyList();
    }

    @NotNull
    public List<File> getAssetFolders(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        File assets = new File(project.getDir(), "assets");
        if (assets.exists()) {
            return CollectionsKt.listOf((Object)assets);
        }
        return CollectionsKt.emptyList();
    }

    @NotNull
    public SdkInfo getSdkInfo(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return new DefaultSdkInfo();
    }

    @Nullable
    public File getCacheDir(@Nullable String name, boolean create) {
        String path2 = System.getenv("ANDROID_SDK_CACHE_DIR");
        if (path2 != null) {
            if (name != null) {
                path2 = path2 + File.separator + name;
            }
            File dir = new File(path2);
            if (create && !dir.exists() && !dir.mkdirs()) {
                return null;
            }
            return dir;
        }
        String home = System.getProperty("user.home");
        String relative = ".android" + File.separator + "cache";
        if (name != null) {
            relative = relative + File.separator + name;
        }
        File dir = new File(home, relative);
        if (create && !dir.exists() && !dir.mkdirs()) {
            return null;
        }
        return dir;
    }

    @Nullable
    public File getSdkHome() {
        String string;
        File binDir = LintClient.Companion.getLintBinDir();
        if (binDir != null) {
            boolean bl = Intrinsics.areEqual((Object)binDir.getName(), (Object)"tools");
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            File root = binDir.getParentFile();
            if (root != null && root.isDirectory()) {
                return root;
            }
        }
        if ((string = System.getenv("ANDROID_SDK_ROOT")) == null) {
            string = System.getenv("ANDROID_HOME");
        }
        if (string == null) {
            return null;
        }
        String home = string;
        return new File(home);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public File findResource(@NotNull String relativePath) {
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        File file = this.getSdkHome();
        if (file == null) {
            LintClient lintClient;
            LintClient $receiver = lintClient = this;
            boolean bl = false;
            File file2 = new File(relativePath);
            return file2.exists() ? file2.getAbsoluteFile() : null;
        }
        File top = file;
        boolean isAnnotationZip = Intrinsics.areEqual((Object)"annotations.zip", (Object)relativePath);
        boolean isApiDatabase = Intrinsics.areEqual((Object)"api-versions.xml", (Object)relativePath);
        if (isAnnotationZip || isApiDatabase) {
            String build;
            File file22;
            String path2;
            if (isAnnotationZip && (path2 = System.getenv("SDK_ANNOTATIONS")) != null && (file22 = new File(path2)).exists()) {
                return file22;
            }
            IAndroidTarget[] targets = this.getTargets();
            int file22 = targets.length;
            --file22;
            boolean bl = false;
            while (file22 >= 0) {
                void i;
                IAndroidTarget target = targets[i];
                if (target.isPlatform()) {
                    File file3;
                    AndroidVersion androidVersion = target.getVersion();
                    Intrinsics.checkExpressionValueIsNotNull((Object)androidVersion, (String)"target.version");
                    if (androidVersion.getFeatureLevel() >= 26 && (file3 = new File(target.getFile(7), relativePath)).isFile()) {
                        return file3;
                    }
                }
                --i;
            }
            File file4 = new File(top, "platform-tools" + File.separator + "api" + File.separator + relativePath);
            if (file4.exists()) {
                return file4;
            }
            if (isApiDatabase && (build = System.getenv("ANDROID_BUILD_TOP")) != null && (file4 = new File(build, StringsKt.replace$default((String)"development/sdk/api-versions.xml", (char)'/', (char)File.separatorChar, (boolean)false, (int)4, null))).exists()) {
                return file4;
            }
            return null;
        }
        File file5 = new File(top, relativePath);
        return file5.exists() ? file5 : null;
    }

    public boolean isGradleProject(@NotNull Project project) {
        File root;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (new File(project.getDir(), "build.gradle").exists() || new File(project.getDir(), "build.gradle.kts").exists()) {
            return true;
        }
        File file = project.getDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.dir");
        File parent = file.getParentFile();
        return parent != null && Intrinsics.areEqual((Object)parent.getName(), (Object)"src") && (root = parent.getParentFile()) != null && (new File(root, "build.gradle").exists() || new File(root, "build.gradle.kts").exists());
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    protected ClassPathInfo getClassPath(@NotNull Project project) {
        block22: {
            block23: {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                info = this.projectInfo.get(project);
                if (info != null) break block22;
                sources = new ArrayList<File>(2);
                classes = new ArrayList<File>(1);
                generated = new ArrayList<File>(1);
                libraries = new ArrayList<File>();
                tests = CollectionsKt.emptyList();
                v0 = project.getDir();
                Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"project.dir");
                projectDir = v0;
                classpathFile = new File(projectDir, ".classpath");
                if (!classpathFile.exists() || (document = CharSequences.parseDocumentSilently((CharSequence)(classpathXml = this.readFile(classpathFile)), (boolean)false)) == null) break block23;
                tags = document.getElementsByTagName("classpathentry");
                v1 = tags;
                Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"tags");
                n = v1.getLength();
                for (i = 0; i < n; ++i) {
                    block24: {
                        block25: {
                            v2 = tags.item(i);
                            if (v2 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type org.w3c.dom.Element");
                            }
                            element = (Element)v2;
                            kind = element.getAttribute("kind");
                            addTo = null;
                            if (kind == null) break block24;
                            switch (var18_21.hashCode()) {
                                case -1005512447: {
                                    if (!var18_21.equals("output")) ** break;
                                    break;
                                }
                                case 107141: {
                                    if (!var18_21.equals("lib")) ** break;
                                    break block25;
                                }
                                case 114148: {
                                    if (!var18_21.equals("src")) ** break;
                                    addTo = sources;
                                    ** break;
                                }
                            }
                            addTo = classes;
                            ** break;
                        }
                        addTo = libraries;
                    }
                    if (addTo == null || !(folder = new File(projectDir, path = element.getAttribute("path"))).exists()) continue;
                    addTo.add(folder);
                }
            }
            if ((libs = new File(project.getDir(), "libs")).isDirectory() && (jars = libs.listFiles()) != null) {
                var14_16 = jars;
                var15_18 = var14_16.length;
                for (i = 0; i < var15_18; ++i) {
                    v3 = jar = var14_16[i];
                    Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"jar");
                    v4 = v3.getPath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"jar.path");
                    if (!Lint.endsWith(v4, ".jar")) {
                        v5 = jar.getPath();
                        Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"jar.path");
                        if (!Lint.endsWith(v5, ".srcjar")) continue;
                    }
                    if (libraries.contains(jar)) continue;
                    libraries.add(jar);
                }
            }
            if (classes.isEmpty()) {
                folder = new File(projectDir, SdkConstants.CLASS_FOLDER);
                if (folder.exists()) {
                    classes.add(folder);
                } else {
                    folder = new File(projectDir, "target" + File.separator + "classes");
                    if (folder.exists()) {
                        classes.add(folder);
                        if (sources.isEmpty()) {
                            src = new File(projectDir, "src" + File.separator + "main" + File.separator + "java");
                            if (src.exists()) {
                                sources.add(src);
                            } else {
                                src = new File(projectDir, "src");
                                if (src.exists()) {
                                    sources.add(src);
                                }
                            }
                            gen = new File(projectDir, "target" + File.separator + "generated-sources" + File.separator + "r");
                            if (gen.exists()) {
                                generated.add(gen);
                            }
                        }
                    }
                }
            }
            if (sources.isEmpty()) {
                src = new File(projectDir, "src");
                if (src.exists()) {
                    sources.add(src);
                }
                if ((gen = new File(projectDir, "gen")).exists()) {
                    generated.add(gen);
                }
            }
            info = new ClassPathInfo((List<? extends File>)sources, (List<? extends File>)classes, (List<? extends File>)libraries, (List<? extends File>)libraries, tests, CollectionsKt.emptyList(), (List<? extends File>)generated);
            var11_11 = this.projectInfo;
            var12_12 = info;
            var11_11.put(project, var12_12);
        }
        return info;
    }

    @NotNull
    protected final Map<File, Project> getDirToProject() {
        return this.dirToProject;
    }

    @NotNull
    public Project getProject(@NotNull File dir, @NotNull File referenceDir) {
        File file;
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        Intrinsics.checkParameterIsNotNull((Object)referenceDir, (String)"referenceDir");
        try {
            file = dir.getCanonicalFile();
        }
        catch (IOException ioe) {
            file = dir;
        }
        File canonicalDir = file;
        Project existingProject = this.dirToProject.get(canonicalDir);
        if (existingProject != null) {
            return existingProject;
        }
        Project project = this.createProject(dir, referenceDir);
        Map<File, Project> map = this.dirToProject;
        File file2 = canonicalDir;
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"canonicalDir");
        File file3 = file2;
        Project project2 = project;
        map.put(file3, project2);
        return project;
    }

    @NotNull
    public final Collection<Project> getKnownProjects() {
        return this.dirToProject.values();
    }

    public void registerProject(@NotNull File dir, @NotNull Project project) {
        boolean bl;
        File file;
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        try {
            file = dir.getCanonicalFile();
        }
        catch (IOException ioe) {
            file = dir;
        }
        File canonicalDir = file;
        boolean bl2 = bl = !this.dirToProject.containsKey(dir);
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            File file2 = dir;
            throw (Throwable)((Object)new AssertionError(file2));
        }
        Map<File, Project> map = this.dirToProject;
        File file3 = canonicalDir;
        Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"canonicalDir");
        File file4 = file3;
        Project project2 = project;
        map.put(file4, project2);
    }

    @NotNull
    protected final Set<File> getProjectDirs() {
        return this.projectDirs;
    }

    @NotNull
    protected Project createProject(@NotNull File dir, @NotNull File referenceDir) {
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        Intrinsics.checkParameterIsNotNull((Object)referenceDir, (String)"referenceDir");
        if (this.projectDirs.contains(dir)) {
            throw (Throwable)new CircularDependencyException("Circular library dependencies; check your project.properties files carefully");
        }
        this.projectDirs.add(dir);
        Project project = Project.create(this, dir, referenceDir);
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"Project.create(this, dir, referenceDir)");
        return project;
    }

    protected void initializeProjects(@NotNull Collection<? extends Project> knownProjects) {
        Intrinsics.checkParameterIsNotNull(knownProjects, (String)"knownProjects");
    }

    protected void disposeProjects(@NotNull Collection<? extends Project> knownProjects) {
        Intrinsics.checkParameterIsNotNull(knownProjects, (String)"knownProjects");
    }

    @NotNull
    public final ClassPathInfo performGetClassPath$lint_api(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return this.getClassPath(project);
    }

    public final void performInitializeProjects$lint_api(@NotNull Collection<? extends Project> knownProjects) {
        Intrinsics.checkParameterIsNotNull(knownProjects, (String)"knownProjects");
        this.initializeProjects(knownProjects);
    }

    public final void performDisposeProjects$lint_api(@NotNull Collection<? extends Project> knownProjects) {
        Intrinsics.checkParameterIsNotNull(knownProjects, (String)"knownProjects");
        this.disposeProjects(knownProjects);
    }

    @NotNull
    public String getProjectName(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        File file = project.getDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.dir");
        String string = file.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.dir.name");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public IAndroidTarget[] getTargets() {
        if (this.targets == null) {
            AndroidSdkHandler sdkHandler = this.getSdk();
            if (sdkHandler != null) {
                void $receiver$iv;
                Collection targets;
                ProgressIndicator logger = this.getRepositoryLogger();
                Collection collection = targets = sdkHandler.getAndroidTargetManager(logger).getTargets(logger);
                Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"targets");
                Collection collection2 = collection;
                LintClient lintClient = this;
                void v1 = $receiver$iv;
                if (v1 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                }
                void thisCollection$iv = v1;
                IAndroidTarget[] iAndroidTargetArray = thisCollection$iv.toArray(new IAndroidTarget[0]);
                if (iAndroidTargetArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                IAndroidTarget[] iAndroidTargetArray2 = iAndroidTargetArray;
                lintClient.targets = iAndroidTargetArray2;
            } else {
                LintClient lintClient = this;
                IAndroidTarget[] iAndroidTargetArray = new IAndroidTarget[]{};
                lintClient.targets = iAndroidTargetArray;
            }
        }
        if (this.targets == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<com.android.sdklib.IAndroidTarget>");
        }
        return this.targets;
    }

    @Nullable
    public AndroidSdkHandler getSdk() {
        if (this.sdk == null) {
            this.sdk = AndroidSdkHandler.getInstance((File)this.getSdkHome());
        }
        return this.sdk;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public IAndroidTarget getCompileTarget(@NotNull Project project) {
        Object object;
        block6: {
            Object[] objectArray;
            ProgressIndicator logger;
            AndroidTargetManager manager22;
            IAndroidTarget target;
            AndroidSdkHandler handler;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            if (!project.isAndroidProject()) {
                return null;
            }
            String compileSdkVersion = project.getBuildTargetHash();
            if (compileSdkVersion != null && (handler = this.getSdk()) != null && (target = (manager22 = handler.getAndroidTargetManager(logger = this.getRepositoryLogger())).getTargetFromHashString(compileSdkVersion, logger)) != null) {
                return target;
            }
            int buildSdk = project.getBuildSdk();
            Object[] targets = this.getTargets();
            int manager22 = targets.length;
            --manager22;
            boolean bl = false;
            while (manager22 >= 0) {
                void i;
                IAndroidTarget target2 = targets[i];
                if (target2.isPlatform()) {
                    AndroidVersion androidVersion = target2.getVersion();
                    Intrinsics.checkExpressionValueIsNotNull((Object)androidVersion, (String)"target.version");
                    if (androidVersion.getApiLevel() == buildSdk) {
                        return target2;
                    }
                }
                --i;
            }
            Object[] objectArray2 = objectArray = targets;
            Iterator iterator = CollectionsKt.reversed((Iterable)((Iterable)ArraysKt.getIndices((Object[])objectArray2))).iterator();
            while (iterator.hasNext()) {
                Object object2;
                int n = ((Number)iterator.next()).intValue();
                Object it = object2 = objectArray2[n];
                boolean bl2 = false;
                if (!it.isPlatform()) continue;
                object = object2;
                break block6;
            }
            object = null;
        }
        return object;
    }

    public final int getHighestKnownApiLevel() {
        int max = 28;
        for (IAndroidTarget target : this.getTargets()) {
            if (!target.isPlatform()) continue;
            AndroidVersion androidVersion = target.getVersion();
            Intrinsics.checkExpressionValueIsNotNull((Object)androidVersion, (String)"target.version");
            int api = androidVersion.getApiLevel();
            if (api <= max) continue;
            AndroidVersion androidVersion2 = target.getVersion();
            Intrinsics.checkExpressionValueIsNotNull((Object)androidVersion2, (String)"target.version");
            if (androidVersion2.isPreview()) continue;
            max = api;
        }
        return max;
    }

    @Nullable
    public BuildToolInfo getBuildTools(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        AndroidSdkHandler sdk = this.getSdk();
        if (sdk != null) {
            IAndroidTarget compileTarget = this.getCompileTarget(project);
            if (compileTarget != null) {
                return compileTarget.getBuildToolInfo();
            }
            return sdk.getLatestBuildTool(this.getRepositoryLogger(), false);
        }
        return null;
    }

    @NotNull
    public Set<Desugaring> getDesugaring(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        GradleVersion gradleVersion = project.getGradleModelVersion();
        if (gradleVersion == null) {
            return Desugaring.DEFAULT;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)gradleVersion, (String)"project.gradleModelVersi\u2026return Desugaring.DEFAULT");
        GradleVersion version = gradleVersion;
        return Companion.getGradleDesugaring(version, Lint.getLanguageLevel(project, LanguageLevel.JDK_1_7));
    }

    @Nullable
    public String getSuperClass(@NotNull Project project, @NotNull String name) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        boolean bl2 = bl = StringsKt.indexOf$default((CharSequence)name, (char)'.', (int)0, (boolean)false, (int)6, null) == -1;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Use VM signatures, e.g. java/lang/Integer";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (Intrinsics.areEqual((Object)"java/lang/Object", (Object)name)) {
            return null;
        }
        String superClass = project.getSuperClassMap().get(name);
        if (superClass != null) {
            return superClass;
        }
        Iterator<Project> iterator = project.getAllLibraries().iterator();
        while (iterator.hasNext()) {
            Project library;
            Project project2 = library = iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"library");
            String librarySuperClass = project2.getSuperClassMap().get(name);
            if (librarySuperClass == null) continue;
            return librarySuperClass;
        }
        return null;
    }

    @NotNull
    public Map<String, String> createSuperClassMap(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        List<File> list2 = project.getJavaLibraries(true);
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"project.getJavaLibraries(true)");
        List<File> libraries = list2;
        List<File> list3 = project.getJavaClassFolders();
        Intrinsics.checkExpressionValueIsNotNull(list3, (String)"project.javaClassFolders");
        List<File> classFolders = list3;
        List<ClassEntry> list4 = ClassEntry.fromClassPath(this, classFolders, true);
        Intrinsics.checkExpressionValueIsNotNull(list4, (String)"ClassEntry.fromClassPath(this, classFolders, true)");
        List<ClassEntry> classEntries = list4;
        if (libraries.isEmpty()) {
            Map<String, String> map = ClassEntry.createSuperClassMap(this, classEntries);
            Intrinsics.checkExpressionValueIsNotNull(map, (String)"ClassEntry.createSuperClassMap(this, classEntries)");
            return map;
        }
        List<ClassEntry> list5 = ClassEntry.fromClassPath(this, libraries, true);
        Intrinsics.checkExpressionValueIsNotNull(list5, (String)"ClassEntry.fromClassPath(this, libraries, true)");
        List<ClassEntry> libraryEntries = list5;
        Map<String, String> map = ClassEntry.createSuperClassMap(this, libraryEntries, classEntries);
        Intrinsics.checkExpressionValueIsNotNull(map, (String)"ClassEntry.createSuperCl\u2026aryEntries, classEntries)");
        return map;
    }

    @Nullable
    public Boolean isSubclassOf(@NotNull Project project, @NotNull String name, @NotNull String superClassName) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)superClassName, (String)"superClassName");
        return null;
    }

    @NotNull
    public List<File> findGlobalRuleJars() {
        String lintClassPath;
        Object lint;
        List files = null;
        try {
            File[] list2;
            String androidHome = AndroidLocation.getFolder();
            lint = new File(androidHome + File.separator + "lint");
            if (((File)lint).exists() && (list2 = ((File)lint).listFiles()) != null) {
                File[] fileArray = list2;
                int n = fileArray.length;
                for (int i = 0; i < n; ++i) {
                    File jarFile;
                    File file = jarFile = fileArray[i];
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"jarFile");
                    String string = file.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"jarFile.name");
                    if (!Lint.endsWith(string, ".jar")) continue;
                    if (files == null) {
                        files = new ArrayList();
                    }
                    files.add(jarFile);
                }
            }
        }
        catch (AndroidLocation.AndroidLocationException androidHome) {
            // empty catch block
        }
        if ((lintClassPath = System.getenv("ANDROID_LINT_JARS")) != null && !((lint = (CharSequence)lintClassPath).length() == 0)) {
            CharSequence charSequence = lintClassPath;
            String[] stringArray = new String[1];
            String string = File.pathSeparator;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"File.pathSeparator");
            stringArray[0] = string;
            List paths = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            for (String path2 : paths) {
                File jarFile = new File(path2);
                if (!jarFile.exists()) continue;
                if (files == null) {
                    files = new ArrayList();
                } else if (files.contains(jarFile)) continue;
                files.add(jarFile);
            }
        }
        return files != null ? files : CollectionsKt.emptyList();
    }

    @NotNull
    public List<File> findRuleJars(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (project.isGradleProject()) {
            if (project.isLibrary() && project.getGradleLibraryModel() != null) {
                File lintJar;
                AndroidLibrary model = project.getGradleLibraryModel();
                if (model != null && (lintJar = model.getLintJar()).exists()) {
                    return CollectionsKt.listOf((Object)lintJar);
                }
            } else if (project.getSubset() != null) {
                Variant variant = project.getCurrentVariant();
                if (variant != null) {
                    ArrayList<File> rules = new ArrayList<File>(4);
                    List list2 = rules;
                    AndroidArtifact androidArtifact = variant.getMainArtifact();
                    Intrinsics.checkExpressionValueIsNotNull((Object)androidArtifact, (String)"variant.mainArtifact");
                    Dependencies dependencies = androidArtifact.getDependencies();
                    Intrinsics.checkExpressionValueIsNotNull((Object)dependencies, (String)"variant.mainArtifact.dependencies");
                    Collection collection = dependencies.getLibraries();
                    Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"variant.mainArtifact.dependencies.libraries");
                    Collection collection2 = collection;
                    List list3 = list2;
                    LintClient lintClient = this;
                    Set set = new LinkedHashSet();
                    lintClient.addLintJarsFromDependencies(list3, collection2, set);
                    Object object = project.getGradleProjectModel();
                    if (object != null && (object = object.getBuildFolder()) != null) {
                        Path[] lintPaths;
                        Object object2;
                        Object it = object2 = object;
                        boolean bl = false;
                        for (Path lintPath : lintPaths = new Path[]{Paths.get("intermediates", "lint"), Paths.get("intermediates", "lint_jar", "global", "prepareLintJar")}) {
                            File[] $receiver$iv;
                            File lintFolder = new File((File)it, ((Object)lintPath).toString());
                            if (!lintFolder.exists() || lintFolder.listFiles() == null) continue;
                            File[] fileArray = $receiver$iv;
                            int n = fileArray.length;
                            for (int i = 0; i < n; ++i) {
                                File element$iv;
                                File lintJar = element$iv = fileArray[i];
                                boolean bl2 = false;
                                File file = lintJar;
                                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"lintJar");
                                String string = file.getPath();
                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"lintJar.path");
                                if (!StringsKt.endsWith$default((String)string, (String)".jar", (boolean)false, (int)2, null)) continue;
                                rules.add(lintJar);
                            }
                        }
                    }
                    if (!rules.isEmpty()) {
                        return rules;
                    }
                }
            } else {
                File lintJar;
                File file = project.getDir();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.dir");
                String string = file.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.dir.path");
                if (StringsKt.endsWith$default((String)string, (String)".aar", (boolean)false, (int)2, null) && (lintJar = new File(project.getDir(), "lint.jar")).exists()) {
                    return CollectionsKt.listOf((Object)lintJar);
                }
            }
        }
        return CollectionsKt.emptyList();
    }

    private final void addLintJarsFromDependencies(List<File> lintJars, Collection<? extends AndroidLibrary> libraries, Set<AndroidLibrary> seen) {
        for (AndroidLibrary androidLibrary : libraries) {
            if (!seen.add(androidLibrary)) {
                return;
            }
            this.addLintJarsFromDependency(lintJars, androidLibrary, seen);
        }
    }

    private final void addLintJarsFromDependency(List<File> lintJars, AndroidLibrary library, Set<AndroidLibrary> seen) {
        File lintJar = library.getLintJar();
        if (lintJar.exists()) {
            File file = lintJar;
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"lintJar");
            lintJars.add(file);
        } else if (library.getProject() != null) {
            Path[] lintPaths;
            File file = library.getFolder();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"library.folder");
            String string = file.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"library.folder.path");
            String buildDir = StringsKt.substringBefore$default((String)string, (String)"intermediates", null, (int)2, null);
            for (Path lintPath : lintPaths = new Path[]{Paths.get(buildDir, "intermediates", "lint", "lint.jar"), Paths.get(buildDir, "intermediates", "lint_publish_jar", "global", "prepareLintJarForPublish", "lint.jar")}) {
                File manualLintJar = lintPath.toFile();
                if (!manualLintJar.exists()) continue;
                File file2 = manualLintJar;
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"manualLintJar");
                lintJars.add(file2);
            }
        }
        List list2 = library.getLibraryDependencies();
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"library.libraryDependencies");
        this.addLintJarsFromDependencies(lintJars, list2, seen);
    }

    @Nullable
    public URLConnection openConnection(@NotNull URL url) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        return this.openConnection(url, 0);
    }

    @Nullable
    public URLConnection openConnection(@NotNull URL url, int timeout) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        URLConnection connection = url.openConnection();
        if (timeout > 0) {
            URLConnection uRLConnection = connection;
            Intrinsics.checkExpressionValueIsNotNull((Object)uRLConnection, (String)"connection");
            uRLConnection.setConnectTimeout(timeout);
            connection.setReadTimeout(timeout);
        }
        return connection;
    }

    public void closeConnection(@NotNull URLConnection connection) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)connection, (String)"connection");
            URLConnection uRLConnection = connection;
            if (!(uRLConnection instanceof HttpURLConnection)) {
                uRLConnection = null;
            }
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
            if (httpURLConnection == null) break block1;
            httpURLConnection.disconnect();
        }
    }

    public boolean isProjectDirectory(@NotNull File dir) {
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        return Lint.isManifestFolder(dir) || Project.isAospFrameworksRelatedProject(dir) || new File(dir, "build.gradle").exists();
    }

    public boolean checkForSuppressComments() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public IssueRegistry addCustomLintRules(@NotNull IssueRegistry registry) {
        List<JarFileIssueRegistry> extraRegistries;
        Collection collection;
        Intrinsics.checkParameterIsNotNull((Object)registry, (String)"registry");
        List<File> jarFiles = this.findGlobalRuleJars();
        if (!jarFiles.isEmpty() && !(collection = (Collection)(extraRegistries = JarFileIssueRegistry.Factory.get(this, (Collection<? extends File>)jarFiles, null))).isEmpty()) {
            void $receiver$iv;
            SpreadBuilder spreadBuilder = new SpreadBuilder(2);
            spreadBuilder.add((Object)registry);
            collection = extraRegistries;
            SpreadBuilder spreadBuilder2 = spreadBuilder;
            SpreadBuilder spreadBuilder3 = spreadBuilder;
            JarFileIssueRegistry.Factory factory = JarFileIssueRegistry.Factory;
            void v1 = $receiver$iv;
            if (v1 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            void thisCollection$iv = v1;
            JarFileIssueRegistry[] jarFileIssueRegistryArray = thisCollection$iv.toArray(new JarFileIssueRegistry[0]);
            if (jarFileIssueRegistryArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            JarFileIssueRegistry[] jarFileIssueRegistryArray2 = jarFileIssueRegistryArray;
            SpreadBuilder spreadBuilder4 = spreadBuilder3;
            spreadBuilder2.addSpread((Object)jarFileIssueRegistryArray2);
            return factory.join((IssueRegistry[])spreadBuilder4.toArray((Object[])new IssueRegistry[spreadBuilder4.size()]));
        }
        return registry;
    }

    @NotNull
    public ClassLoader createUrlClassLoader(@NotNull URL[] urls, @NotNull ClassLoader parent) {
        Intrinsics.checkParameterIsNotNull((Object)urls, (String)"urls");
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        return new URLClassLoader(urls, parent);
    }

    @Nullable
    public Document getMergedManifest(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        List<File> list2 = project.getManifestFiles();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"project.manifestFiles");
        List<File> manifestFiles = list2;
        if (manifestFiles.size() == 1) {
            File primary = manifestFiles.get(0);
            try {
                String xml = Files.asCharSource((File)primary, (Charset)Charsets.UTF_8).read();
                return XmlUtils.parseDocumentSilently((String)xml, (boolean)true);
            }
            catch (IOException e) {
                this.log(Severity.ERROR, e, "Could not read manifest " + primary, new Object[0]);
            }
        }
        return null;
    }

    public void resolveMergeManifestSources(@NotNull Document mergedManifest, @NotNull Object reportFile) {
        Intrinsics.checkParameterIsNotNull((Object)mergedManifest, (String)"mergedManifest");
        Intrinsics.checkParameterIsNotNull((Object)reportFile, (String)"reportFile");
        mergedManifest.setUserData(MERGED_MANIFEST, reportFile, null);
    }

    public final boolean isMergeManifestNode(@NotNull Node node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Document document = node.getOwnerDocument();
        return (document != null ? document.getUserData(MERGED_MANIFEST) : null) != null;
    }

    protected static /* synthetic */ void reportFileCache$annotations() {
    }

    @NotNull
    protected final Map<Object, BlameFile> getReportFileCache() {
        return this.reportFileCache;
    }

    protected static /* synthetic */ void sourceNodeCache$annotations() {
    }

    @NotNull
    protected final Map<Node, Pair<File, ? extends Node>> getSourceNodeCache() {
        return this.sourceNodeCache;
    }

    @Nullable
    public GradleVersion getHighestKnownVersion(@NotNull GradleCoordinate coordinate, @Nullable Predicate<GradleVersion> filter) {
        Intrinsics.checkParameterIsNotNull((Object)coordinate, (String)"coordinate");
        return null;
    }

    @Nullable
    public Pair<File, ? extends Node> findManifestSourceNode(@NotNull Node mergedNode) {
        Pair<File, ? extends Node> pair;
        Intrinsics.checkParameterIsNotNull((Object)mergedNode, (String)"mergedNode");
        Document document = mergedNode.getOwnerDocument();
        if (document == null) {
            return null;
        }
        Document doc = document;
        Object object = doc.getUserData(MERGED_MANIFEST);
        if (object == null) {
            return null;
        }
        Object report2 = object;
        Pair<File, ? extends Node> cached = this.sourceNodeCache.get(mergedNode);
        if (cached != null) {
            if (cached == NOT_FOUND) {
                return null;
            }
            return cached;
        }
        BlameFile blameFile = this.reportFileCache.get(report2);
        if (blameFile == null) {
            Object lines2;
            try {
                Object object2 = report2;
                if (object2 instanceof File) {
                    String string = ((File)report2).getPath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"report.path");
                    if (StringsKt.endsWith$default((String)string, (String)".xml", (boolean)false, (int)2, null)) {
                        return Pair.of((Object)report2, (Object)mergedNode);
                    }
                    blameFile = BlameFile.Companion.parse((File)report2);
                } else if (object2 instanceof String) {
                    Object object3 = lines2 = Splitter.on((char)'\n').splitToList((CharSequence)report2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"lines");
                    blameFile = BlameFile.Companion.parse((List<String>)object3);
                } else if (object2 instanceof Actions) {
                    blameFile = BlameFile.Companion.parse((Actions)report2);
                } else {
                    boolean lines2 = false;
                    if (_Assertions.ENABLED) {
                        boolean bl = false;
                        Object object4 = report2;
                        throw (Throwable)((Object)new AssertionError(object4));
                    }
                    blameFile = BlameFile.Companion.getNONE();
                }
            }
            catch (IOException ignore) {
                blameFile = BlameFile.Companion.getNONE();
            }
            if (blameFile == null) {
                Intrinsics.throwNpe();
            }
            Map<Object, BlameFile> ignore = this.reportFileCache;
            lines2 = blameFile;
            ignore.put(report2, (BlameFile)lines2);
        }
        Pair<File, ? extends Node> source = null;
        if (blameFile != BlameFile.Companion.getNONE()) {
            source = blameFile.findSourceNode(this, mergedNode);
        }
        if ((pair = source) == null) {
            pair = NOT_FOUND;
        }
        Pair<File, ? extends Node> cacheValue = pair;
        Map<Node, Pair<File, ? extends Node>> map = this.sourceNodeCache;
        Pair<File, ? extends Node> pair2 = cacheValue;
        map.put(mergedNode, pair2);
        return source;
    }

    @Nullable
    public Location findManifestSourceLocation(@NotNull Node mergedNode) {
        Intrinsics.checkParameterIsNotNull((Object)mergedNode, (String)"mergedNode");
        Pair<File, ? extends Node> source = this.findManifestSourceNode(mergedNode);
        if (source != null) {
            XmlParser xmlParser = this.getXmlParser();
            Object object = source.getFirst();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"source.first");
            File file = (File)object;
            Object object2 = source.getSecond();
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"source.second");
            return xmlParser.getLocation(file, (Node)object2);
        }
        return null;
    }

    @NotNull
    public String getDisplayPath(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        String string = file.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.path");
        return TextFormat.TEXT.convertTo(string, TextFormat.RAW);
    }

    public boolean supportsProjectResources() {
        return false;
    }

    @Nullable
    public ResourceRepository getResourceRepository(@NotNull Project project, boolean includeModuleDependencies, boolean includeLibraries) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return null;
    }

    @NotNull
    public Location.Handle createResourceItemHandle(@NotNull ResourceItem item) {
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        return new Location.ResourceItemHandle(item);
    }

    @NotNull
    public ResourceVisibilityLookup.Provider getResourceVisibilityProvider() {
        if (this.resourceVisibilityProvider == null) {
            this.resourceVisibilityProvider = new ResourceVisibilityLookup.Provider();
        }
        ResourceVisibilityLookup.Provider provider = this.resourceVisibilityProvider;
        if (provider == null) {
            Intrinsics.throwNpe();
        }
        return provider;
    }

    @Nullable
    public XmlPullParser createXmlPullParser(@NotNull PathString resourcePath) throws IOException {
        byte[] byArray;
        Intrinsics.checkParameterIsNotNull((Object)resourcePath, (String)"resourcePath");
        try {
            byArray = this.readBytes(resourcePath);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        byte[] bytes = byArray;
        KXmlParser parser = new KXmlParser();
        parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        parser.setInput((InputStream)new ByteArrayInputStream(bytes), StandardCharsets.UTF_8.name());
        return (XmlPullParser)parser;
    }

    @Nullable
    public String getClientRevision() {
        return null;
    }

    @Nullable
    public String getClientDisplayRevision() {
        return this.getClientRevision();
    }

    public void runReadAction(@NotNull Runnable runnable) {
        Intrinsics.checkParameterIsNotNull((Object)runnable, (String)"runnable");
        runnable.run();
    }

    public <T> T runReadAction(@NotNull Computable<T> computable) {
        Intrinsics.checkParameterIsNotNull(computable, (String)"computable");
        return (T)computable.compute();
    }

    @NotNull
    public ProgressIndicator getRepositoryLogger() {
        return (ProgressIndicator)new RepoLogger();
    }

    protected LintClient(@NotNull String clientName) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)clientName, (String)"clientName");
        LintClient lintClient = this;
        lintClient.projectInfo = map = (Map)new LinkedHashMap();
        this.dirToProject = new HashMap();
        HashSet hashSet = Sets.newHashSet();
        Intrinsics.checkExpressionValueIsNotNull((Object)hashSet, (String)"Sets.newHashSet<File>()");
        this.projectDirs = hashSet;
        HashMap hashMap = Maps.newHashMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)hashMap, (String)"Maps.newHashMap<Any, BlameFile>()");
        this.reportFileCache = hashMap;
        IdentityHashMap identityHashMap = Maps.newIdentityHashMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)identityHashMap, (String)"Maps.newIdentityHashMap<\u2026, Pair<File, out Node>>()");
        this.sourceNodeCache = identityHashMap;
        LintClient.clientName = clientName;
    }

    protected LintClient() {
        Map map;
        LintClient lintClient = this;
        lintClient.projectInfo = map = (Map)new LinkedHashMap();
        this.dirToProject = new HashMap();
        HashSet hashSet = Sets.newHashSet();
        Intrinsics.checkExpressionValueIsNotNull((Object)hashSet, (String)"Sets.newHashSet<File>()");
        this.projectDirs = hashSet;
        HashMap hashMap = Maps.newHashMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)hashMap, (String)"Maps.newHashMap<Any, BlameFile>()");
        this.reportFileCache = hashMap;
        IdentityHashMap identityHashMap = Maps.newIdentityHashMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)identityHashMap, (String)"Maps.newIdentityHashMap<\u2026, Pair<File, out Node>>()");
        this.sourceNodeCache = identityHashMap;
        clientName = CLIENT_UNKNOWN;
    }

    static {
        Companion = new Companion(null);
        PROP_BIN_DIR = PROP_BIN_DIR;
        Pair pair = Pair.of(null, null);
        Intrinsics.checkExpressionValueIsNotNull((Object)pair, (String)"Pair.of<File, Node>(null, null)");
        NOT_FOUND = pair;
        clientName = CLIENT_UNKNOWN;
    }

    @NotNull
    public static final String getClientName() {
        Companion companion = Companion;
        return clientName;
    }

    private static final void setClientName(String string) {
        Companion companion = Companion;
        clientName = string;
    }

    public static final boolean isStudio() {
        return Companion.isStudio();
    }

    public static final boolean isGradle() {
        return Companion.isGradle();
    }

    public static final boolean isUnitTest() {
        return Companion.isUnitTest();
    }

    @JvmStatic
    @NotNull
    public static final Set<Desugaring> getGradleDesugaring(@NotNull GradleVersion version, @Nullable LanguageLevel languageLevel) {
        return Companion.getGradleDesugaring(version, languageLevel);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001Bg\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u000bJ\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0013\u001a\u00020\u0014R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\r\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/lint/client/api/LintClient$ClassPathInfo;", "", "sourceFolders", "", "Ljava/io/File;", "classFolders", "libraries", "nonProvidedLibraries", "testSourceFolders", "testLibraries", "generatedFolders", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getClassFolders", "()Ljava/util/List;", "getGeneratedFolders", "getSourceFolders", "getTestLibraries", "getTestSourceFolders", "getLibraries", "includeProvided", "", "lint-api"})
    public static final class ClassPathInfo {
        @NotNull
        private final List<File> sourceFolders;
        @NotNull
        private final List<File> classFolders;
        private final List<File> libraries;
        private final List<File> nonProvidedLibraries;
        @NotNull
        private final List<File> testSourceFolders;
        @NotNull
        private final List<File> testLibraries;
        @NotNull
        private final List<File> generatedFolders;

        @NotNull
        public final List<File> getLibraries(boolean includeProvided) {
            return includeProvided ? this.libraries : this.nonProvidedLibraries;
        }

        @NotNull
        public final List<File> getSourceFolders() {
            return this.sourceFolders;
        }

        @NotNull
        public final List<File> getClassFolders() {
            return this.classFolders;
        }

        @NotNull
        public final List<File> getTestSourceFolders() {
            return this.testSourceFolders;
        }

        @NotNull
        public final List<File> getTestLibraries() {
            return this.testLibraries;
        }

        @NotNull
        public final List<File> getGeneratedFolders() {
            return this.generatedFolders;
        }

        public ClassPathInfo(@NotNull List<? extends File> sourceFolders, @NotNull List<? extends File> classFolders, @NotNull List<? extends File> libraries, @NotNull List<? extends File> nonProvidedLibraries, @NotNull List<? extends File> testSourceFolders, @NotNull List<? extends File> testLibraries, @NotNull List<? extends File> generatedFolders) {
            Intrinsics.checkParameterIsNotNull(sourceFolders, (String)"sourceFolders");
            Intrinsics.checkParameterIsNotNull(classFolders, (String)"classFolders");
            Intrinsics.checkParameterIsNotNull(libraries, (String)"libraries");
            Intrinsics.checkParameterIsNotNull(nonProvidedLibraries, (String)"nonProvidedLibraries");
            Intrinsics.checkParameterIsNotNull(testSourceFolders, (String)"testSourceFolders");
            Intrinsics.checkParameterIsNotNull(testLibraries, (String)"testLibraries");
            Intrinsics.checkParameterIsNotNull(generatedFolders, (String)"generatedFolders");
            this.sourceFolders = sourceFolders;
            this.classFolders = classFolders;
            this.libraries = libraries;
            this.nonProvidedLibraries = nonProvidedLibraries;
            this.testSourceFolders = testSourceFolders;
            this.testLibraries = testLibraries;
            this.generatedFolders = generatedFolders;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001a\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/lint/client/api/LintClient$RepoLogger;", "Lcom/android/repository/api/ProgressIndicatorAdapter;", "()V", "logError", "", "s", "", "e", "", "logInfo", "logWarning", "lint-api"})
    private static final class RepoLogger
    extends ProgressIndicatorAdapter {
        public void logError(@NotNull String s, @Nullable Throwable e) {
            Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        }

        public void logInfo(@NotNull String s) {
            Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        }

        public void logWarning(@NotNull String s, @Nullable Throwable e) {
            Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010'\u001a\b\u0012\u0004\u0012\u00020)0(2\u0006\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010-H\u0007JB\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u00042\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\b\u00109\u001a\u0004\u0018\u00010:2\b\u0010;\u001a\u0004\u0018\u00010<J0\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u00042\u0006\u0010=\u001a\u00020\u000f2\b\u00107\u001a\u0004\u0018\u000108J\u0094\u0001\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u00042\n\b\u0002\u0010=\u001a\u0004\u0018\u00010\u000f2\b\b\u0002\u0010>\u001a\u00020?2\n\b\u0002\u0010;\u001a\u0004\u0018\u00010<2\n\b\u0002\u0010@\u001a\u0004\u0018\u00010A2\n\b\u0002\u0010B\u001a\u0004\u0018\u00010C2\n\b\u0002\u0010D\u001a\u0004\u0018\u00010E2\n\b\u0002\u00107\u001a\u0004\u0018\u0001082\n\b\u0002\u0010F\u001a\u0004\u0018\u0001082\n\b\u0002\u00105\u001a\u0004\u0018\u0001062\n\b\u0002\u00109\u001a\u0004\u0018\u00010:R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\u0002R\u0014\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\b\n\u0000\u0012\u0004\b\t\u0010\u0002R\u0014\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000b\u0010\u0002R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e8\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\u00020\u00048\u0002X\u0083D\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0012\u0010\u0002R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082T\u00a2\u0006\u0002\n\u0000R,\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00048\u0006@BX\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0017\u0010\u0002\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u001d8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001e\u0010\u0002\u001a\u0004\b\u001c\u0010\u001fR\u001a\u0010 \u001a\u00020\u001d8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b!\u0010\u0002\u001a\u0004\b \u0010\u001fR\u001a\u0010\"\u001a\u00020\u001d8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b#\u0010\u0002\u001a\u0004\b\"\u0010\u001fR\u0016\u0010$\u001a\u0004\u0018\u00010\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u0006G"}, d2={"Lcom/android/tools/lint/client/api/LintClient$Companion;", "", "()V", "CLIENT_CLI", "", "CLIENT_GRADLE", "CLIENT_STUDIO", "CLIENT_STUDIO$annotations", "CLIENT_UNIT_TESTS", "CLIENT_UNIT_TESTS$annotations", "CLIENT_UNKNOWN", "CLIENT_UNKNOWN$annotations", "MERGED_MANIFEST", "NOT_FOUND", "Lcom/android/utils/Pair;", "Ljava/io/File;", "Lorg/w3c/dom/Node;", "PROP_BIN_DIR", "PROP_BIN_DIR$annotations", "SDK_DATABASE_MIN_VERSION", "", "<set-?>", "clientName", "clientName$annotations", "getClientName", "()Ljava/lang/String;", "setClientName", "(Ljava/lang/String;)V", "isGradle", "", "isGradle$annotations", "()Z", "isStudio", "isStudio$annotations", "isUnitTest", "isUnitTest$annotations", "lintBinDir", "getLintBinDir", "()Ljava/io/File;", "getGradleDesugaring", "", "Lcom/android/tools/lint/detector/api/Desugaring;", "version", "Lcom/android/ide/common/repository/GradleVersion;", "languageLevel", "Lcom/intellij/pom/java/LanguageLevel;", "report", "", "client", "Lcom/android/tools/lint/client/api/LintClient;", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "message", "driver", "Lcom/android/tools/lint/client/api/LintDriver;", "project", "Lcom/android/tools/lint/detector/api/Project;", "location", "Lcom/android/tools/lint/detector/api/Location;", "fix", "Lcom/android/tools/lint/detector/api/LintFix;", "file", "format", "Lcom/android/tools/lint/detector/api/TextFormat;", "configuration", "Lcom/android/tools/lint/client/api/Configuration;", "severity", "Lcom/android/tools/lint/detector/api/Severity;", "context", "Lcom/android/tools/lint/detector/api/Context;", "mainProject", "lint-api"})
    public static final class Companion {
        @JvmStatic
        private static /* synthetic */ void PROP_BIN_DIR$annotations() {
        }

        private final File getLintBinDir() {
            File file;
            CharSequence charSequence;
            String path2 = System.getProperty(PROP_BIN_DIR);
            if (path2 == null || (charSequence = (CharSequence)path2).length() == 0) {
                path2 = System.getenv(PROP_BIN_DIR);
            }
            if (path2 != null && !((charSequence = (CharSequence)path2).length() == 0) && (file = new File(path2)).exists()) {
                return file;
            }
            return null;
        }

        public static /* synthetic */ void CLIENT_STUDIO$annotations() {
        }

        public static /* synthetic */ void CLIENT_UNIT_TESTS$annotations() {
        }

        public static /* synthetic */ void CLIENT_UNKNOWN$annotations() {
        }

        @JvmStatic
        public static /* synthetic */ void clientName$annotations() {
        }

        @NotNull
        public final String getClientName() {
            return clientName;
        }

        private final void setClientName(String string) {
            clientName = string;
        }

        @JvmStatic
        public static /* synthetic */ void isStudio$annotations() {
        }

        public final boolean isStudio() {
            return Intrinsics.areEqual((Object)LintClient.CLIENT_STUDIO, (Object)Companion.getClientName());
        }

        @JvmStatic
        public static /* synthetic */ void isGradle$annotations() {
        }

        public final boolean isGradle() {
            return Intrinsics.areEqual((Object)LintClient.CLIENT_GRADLE, (Object)Companion.getClientName());
        }

        @JvmStatic
        public static /* synthetic */ void isUnitTest$annotations() {
        }

        public final boolean isUnitTest() {
            return Intrinsics.areEqual((Object)LintClient.CLIENT_UNIT_TESTS, (Object)Companion.getClientName());
        }

        @JvmStatic
        @NotNull
        public final Set<Desugaring> getGradleDesugaring(@NotNull GradleVersion version, @Nullable LanguageLevel languageLevel) {
            Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
            if (!version.isAtLeast(2, 4, 0, "alpha", 8, true)) {
                return Desugaring.NONE;
            }
            return languageLevel != null && languageLevel.isAtLeast(LanguageLevel.JDK_1_8) ? Desugaring.DEFAULT : Desugaring.NONE;
        }

        public final void report(@NotNull LintClient client, @NotNull Issue issue, @NotNull String message, @Nullable File file, @NotNull TextFormat format, @Nullable LintFix fix, @Nullable Configuration configuration, @Nullable Severity severity, @Nullable Context context2, @Nullable Project project, @Nullable Project mainProject, @Nullable LintDriver driver, @Nullable Location location) {
            Context context3;
            Severity realSeverity;
            Project project2;
            File realFile;
            Location location2;
            Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
            Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            Intrinsics.checkParameterIsNotNull((Object)((Object)format), (String)"format");
            if (location != null) {
                location2 = location;
            } else if (file != null) {
                location2 = Location.Companion.create(file);
            } else if (context2 != null) {
                location2 = Location.Companion.create(context2.file);
            } else if (project != null) {
                File file2 = project.getDir();
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"project.dir");
                location2 = Location.Companion.create(file2);
            } else {
                String string = "Must supply location or file or project";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Location realLocation = location2;
            File file3 = realFile = file != null ? file : realLocation.getFile();
            if (project != null) {
                project2 = project;
            } else if (context2 != null) {
                project2 = context2.getProject();
            } else {
                File file4;
                if (realFile.isDirectory()) {
                    file4 = realFile;
                } else {
                    file4 = realFile.getParentFile();
                    if (file4 == null) {
                        file4 = new File("").getAbsoluteFile();
                    }
                }
                File dir = file4;
                Project project3 = Project.create(client, dir, dir);
                project2 = project3;
                Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"Project.create(client, dir, dir)");
            }
            Project realProject = project2;
            Severity severity2 = severity != null ? severity : (configuration != null ? configuration.getSeverity(issue) : (context2 != null ? context2.getConfiguration().getSeverity(issue) : (realSeverity = project != null && driver != null ? project.getConfiguration(driver).getSeverity(issue) : issue.getDefaultSeverity())));
            if (context2 != null) {
                context3 = context2;
            } else {
                Project project4;
                LintDriver realDriver2;
                LintDriver lintDriver;
                if (driver != null) {
                    lintDriver = driver;
                } else {
                    LintRequest request = new LintRequest(client, CollectionsKt.emptyList());
                    lintDriver = realDriver2 = new LintDriver(new IssueRegistry(){
                        @NotNull
                        private final List<Issue> issues;

                        @NotNull
                        public List<Issue> getIssues() {
                            return this.issues;
                        }
                        {
                            this.issues = CollectionsKt.emptyList();
                        }
                    }, client, request);
                }
                if ((project4 = mainProject) == null) {
                    project4 = realProject;
                }
                context3 = new Context(realDriver2, realProject, project4, realFile, realFile.isDirectory() ? "" : null);
            }
            Context realContext2 = context3;
            client.report(realContext2, issue, realSeverity, realLocation, message, format, fix);
        }

        public static /* synthetic */ void report$default(Companion companion, LintClient lintClient, Issue issue, String string, File file, TextFormat textFormat, LintFix lintFix, Configuration configuration, Severity severity, Context context2, Project project, Project project2, LintDriver lintDriver, Location location, int n, Object object) {
            if ((n & 8) != 0) {
                file = null;
            }
            if ((n & 0x10) != 0) {
                textFormat = TextFormat.RAW;
            }
            if ((n & 0x20) != 0) {
                lintFix = null;
            }
            if ((n & 0x40) != 0) {
                configuration = null;
            }
            if ((n & 0x80) != 0) {
                severity = null;
            }
            if ((n & 0x100) != 0) {
                context2 = null;
            }
            if ((n & 0x200) != 0) {
                project = null;
            }
            if ((n & 0x400) != 0) {
                project2 = null;
            }
            if ((n & 0x800) != 0) {
                lintDriver = null;
            }
            if ((n & 0x1000) != 0) {
                location = null;
            }
            companion.report(lintClient, issue, string, file, textFormat, lintFix, configuration, severity, context2, project, project2, lintDriver, location);
        }

        public final void report(@NotNull LintClient client, @NotNull Issue issue, @NotNull String message, @NotNull File file, @Nullable Project project) {
            Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
            Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            com.android.tools.lint.client.api.LintClient$Companion.report$default(this, client, issue, message, file, null, null, null, null, null, project, null, null, null, 5616, null);
        }

        public final void report(@NotNull LintClient client, @NotNull Issue issue, @NotNull String message, @NotNull LintDriver driver, @NotNull Project project, @Nullable Location location, @Nullable LintFix fix) {
            Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
            Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            Intrinsics.checkParameterIsNotNull((Object)driver, (String)"driver");
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            File file = null;
            LintFix lintFix = fix;
            Project project2 = null;
            Location location2 = location;
            Context context2 = null;
            Severity severity = null;
            Configuration configuration = null;
            Project project3 = project;
            TextFormat textFormat = null;
            LintDriver lintDriver = driver;
            com.android.tools.lint.client.api.LintClient$Companion.report$default(this, client, issue, message, file, textFormat, lintFix, configuration, severity, context2, project3, project2, lintDriver, location2, 1488, null);
        }

        private Companion() {
        }

        public static final /* synthetic */ String access$getClientName$p(Companion $this) {
            return $this.getClientName();
        }

        public static final /* synthetic */ void access$setClientName$p(Companion $this, String string) {
            $this.setClientName(string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

