/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.tools.lint.detector.api.Location;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.intellij.lang.annotations.Language;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.Nls;

public class LintFix {
    @Nls
    protected final String displayName;
    @Nls
    protected final String familyName;
    public boolean robot = false;
    public boolean independent = false;

    protected LintFix(String displayName) {
        this(displayName, null);
    }

    protected LintFix(String displayName, String familyName) {
        this.displayName = displayName;
        this.familyName = familyName;
    }

    public static Builder create() {
        return new Builder();
    }

    @Nls
    public String getDisplayName() {
        return this.displayName;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public static <T> T getData(LintFix fix, Class<T> key) {
        if (fix instanceof DataMap) {
            return ((DataMap)fix).get(key);
        }
        return null;
    }

    public LintFix autoFix(boolean robot, boolean independent) {
        this.robot = robot;
        this.independent = independent;
        return this;
    }

    public LintFix autoFix() {
        this.autoFix(true, true);
        return this;
    }

    public static class ReplaceString
    extends LintFix {
        public static final String INSERT_BEGINNING = "_lint_insert_begin_";
        public static final String INSERT_END = "_lint_insert_end_";
        public final String oldString;
        public final String oldPattern;
        public final String selectPattern;
        public final String replacement;
        public final Location range;
        public final boolean shortenNames;
        public final boolean reformat;

        private ReplaceString(String displayName, String familyName, String oldString, String oldPattern, String selectPattern, String replacement, boolean shortenNames, boolean reformat, Location range, boolean robot, boolean independent) {
            super(displayName, familyName);
            this.oldString = oldString;
            this.oldPattern = oldPattern;
            this.selectPattern = selectPattern;
            this.replacement = replacement;
            this.shortenNames = shortenNames;
            this.reformat = reformat;
            this.range = range;
            this.robot = robot;
            this.independent = independent;
        }

        @Override
        public String getDisplayName() {
            if (this.displayName != null) {
                return this.displayName;
            }
            if (this.replacement.isEmpty()) {
                if (this.oldString != null) {
                    return "Delete \"" + this.oldString + "\"";
                }
                return "Delete";
            }
            return "Replace with " + this.replacement;
        }

        public String expandBackReferences(Matcher matcher) {
            return ReplaceString.expandBackReferences(this.replacement, matcher);
        }

        public static String expandBackReferences(String replacement, Matcher matcher) {
            if (!replacement.contains("\\k<")) {
                return replacement;
            }
            StringBuilder sb = new StringBuilder();
            int begin = 0;
            while (true) {
                int end;
                if ((end = replacement.indexOf("\\k<", begin)) == -1) break;
                int next = replacement.indexOf(62, end + 3);
                if (next != -1 && Character.isDigit(replacement.charAt(end + 3))) {
                    sb.append(replacement, begin, end);
                    String groupString = replacement.substring(end + 3, next);
                    int group = Integer.parseInt(groupString);
                    if (group <= matcher.groupCount()) {
                        sb.append(matcher.group(group));
                    }
                    begin = next + 1;
                    continue;
                }
                sb.append(replacement, begin, end += 3);
                begin = end;
            }
            sb.append(replacement.substring(begin));
            return sb.toString();
        }
    }

    public static class SetAttribute
    extends LintFix {
        public final String namespace;
        public final String attribute;
        public final String value;
        public final Location range;
        public final int dot;
        public final int mark;

        private SetAttribute(String displayName, String familyName, String namespace, String attribute, String value, Location range, int dot, int mark, boolean robot, boolean independent) {
            super(displayName, familyName);
            this.namespace = namespace;
            this.attribute = attribute;
            this.value = value;
            this.range = range;
            this.dot = dot;
            this.mark = mark;
            this.robot = robot;
            this.independent = independent;
        }

        @Override
        public String getDisplayName() {
            if (this.displayName != null) {
                return this.displayName;
            }
            if (this.value != null) {
                if (this.value.isEmpty() || this.dot > 0) {
                    return "Set " + this.attribute;
                }
                return "Set " + this.attribute + "=\"" + this.value + "\"";
            }
            return "Delete " + this.attribute;
        }
    }

    public static class LintFixGroup
    extends LintFix {
        public final List<LintFix> fixes;
        public final GroupType type;

        public LintFixGroup(String displayName, String familyName, GroupType type, List<LintFix> fixes) {
            super(displayName, familyName);
            this.type = type;
            this.fixes = fixes;
        }

        @Override
        @Nls
        public String getDisplayName() {
            if (this.displayName == null && this.type == GroupType.COMPOSITE) {
                for (LintFix fix : this.fixes) {
                    String name = fix.getDisplayName();
                    if (name == null) continue;
                    return name;
                }
            }
            return this.displayName;
        }
    }

    public static enum GroupType {
        COMPOSITE,
        ALTERNATIVES;

    }

    public static class DataMap
    extends LintFix
    implements Iterable {
        private final Map<Object, Object> map;

        private DataMap(String displayName, String familyName, Map<Object, Object> map) {
            super(displayName, familyName);
            this.map = map;
        }

        public <T> T get(Class<T> key) {
            Object t = this.map.get(key);
            if (t != null) {
                return (T)t;
            }
            for (Map.Entry<Object, Object> entry : this.map.entrySet()) {
                Object k = entry.getKey();
                if (!(k instanceof Class) || !key.isAssignableFrom((Class)k)) continue;
                return (T)entry.getValue();
            }
            Class<?> wrapperClass = DataMap.getWrapperClass(key);
            if (wrapperClass != null) {
                return (T)this.map.get(wrapperClass);
            }
            return null;
        }

        private static Class<?> getWrapperClass(Class<?> primitiveClass) {
            if (primitiveClass == Integer.TYPE) {
                return Integer.class;
            }
            if (primitiveClass == Long.TYPE) {
                return Long.class;
            }
            if (primitiveClass == Boolean.TYPE) {
                return Boolean.class;
            }
            if (primitiveClass == Float.TYPE) {
                return Float.class;
            }
            if (primitiveClass == Double.TYPE) {
                return Double.class;
            }
            if (primitiveClass == Short.TYPE) {
                return Short.class;
            }
            if (primitiveClass == Character.TYPE) {
                return Character.class;
            }
            if (primitiveClass == Byte.TYPE) {
                return Byte.class;
            }
            return null;
        }

        public Object get(String key) {
            return this.map.get(key);
        }

        public Iterator iterator() {
            return this.map.values().iterator();
        }

        public Set<Object> keys() {
            return this.map.keySet();
        }

        public String toString() {
            return this.map.toString();
        }
    }

    public static class FixMapBuilder {
        @Nls
        protected final String displayName;
        @Nls
        protected final String familyName;
        private final Map<Object, Object> map = Maps.newHashMapWithExpectedSize((int)4);

        private FixMapBuilder(String displayName, String familyName) {
            this.displayName = displayName;
            this.familyName = familyName;
        }

        public <T> FixMapBuilder put(T value) {
            if (value == null) {
                return this;
            }
            Class<Object> key = value.getClass();
            if (value instanceof List) {
                key = List.class;
            } else if (value instanceof Map) {
                key = Map.class;
            } else if (value instanceof Set) {
                key = Set.class;
            }
            assert (!this.map.containsKey(key));
            this.map.put(key, value);
            return this;
        }

        public FixMapBuilder put(String key, Object value) {
            if (value == null) {
                return this;
            }
            assert (!this.map.containsKey(key));
            this.map.put(key, value);
            return this;
        }

        public LintFix build() {
            return new DataMap(this.displayName, this.familyName, this.map);
        }
    }

    public static class SetAttributeBuilder {
        @Nls
        protected String displayName;
        @Nls
        protected String familyName;
        private String attribute;
        private String namespace;
        private String value = "";
        private int mark = Integer.MIN_VALUE;
        private int dot = Integer.MIN_VALUE;
        private boolean robot = true;
        private boolean independent = true;
        private Location range;

        private SetAttributeBuilder(String displayName, String familyName) {
            this.displayName = displayName;
            this.familyName = familyName;
        }

        public SetAttributeBuilder name(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public SetAttributeBuilder name(String displayName, String familyName) {
            this.displayName = displayName;
            this.familyName = familyName;
            return this;
        }

        public SetAttributeBuilder sharedName(String familyName) {
            this.familyName = familyName;
            return this;
        }

        public SetAttributeBuilder android() {
            assert (this.namespace == null);
            this.namespace = "http://schemas.android.com/apk/res/android";
            return this;
        }

        public SetAttributeBuilder namespace(String namespace) {
            assert (this.namespace == null);
            this.namespace = namespace;
            return this;
        }

        public SetAttributeBuilder value(String value) {
            this.value = value;
            if (value != null && value.isEmpty()) {
                this.caret(0);
            }
            return this;
        }

        public SetAttributeBuilder attribute(String attribute) {
            assert (attribute.indexOf(58) == -1) : attribute;
            assert (this.attribute == null);
            this.attribute = attribute;
            return this;
        }

        public SetAttributeBuilder remove(String attribute) {
            assert (this.attribute == null);
            this.attribute = attribute;
            this.value = null;
            return this;
        }

        public SetAttributeBuilder selectAll() {
            assert (this.value != null);
            this.mark = 0;
            this.dot = this.value.length();
            return this;
        }

        public SetAttributeBuilder todo(String namespace, String attribute, String prefix, String suffix) {
            this.namespace(namespace);
            this.attribute(attribute);
            StringBuilder sb = new StringBuilder();
            if (prefix != null) {
                sb.append(prefix);
            }
            int start = sb.length();
            sb.append("TODO");
            int end = sb.length();
            if (suffix != null) {
                sb.append(suffix);
            }
            this.value(sb.toString());
            this.select(start, end);
            return this;
        }

        public SetAttributeBuilder range(Location range) {
            this.range = range;
            return this;
        }

        public SetAttributeBuilder todo(String namespace, String attribute) {
            return this.todo(namespace, attribute, null, null);
        }

        public SetAttributeBuilder select(int start, int end) {
            assert (this.value != null);
            this.mark = Math.min(start, end);
            this.dot = Math.max(start, end);
            return this;
        }

        public SetAttributeBuilder caret(int valueStartDelta) {
            this.mark = this.dot = valueStartDelta;
            return this;
        }

        public SetAttributeBuilder caretBegin() {
            return this.caret(0);
        }

        public SetAttributeBuilder caretEnd() {
            assert (this.value != null);
            return this.caret(this.value.length());
        }

        public SetAttributeBuilder robot(boolean robot) {
            this.robot = robot;
            return this;
        }

        public SetAttributeBuilder independent(boolean independent) {
            this.independent = independent;
            return this;
        }

        public SetAttributeBuilder autoFix(boolean robot, boolean independent) {
            this.robot(robot);
            this.independent(independent);
            return this;
        }

        public SetAttributeBuilder autoFix() {
            this.autoFix(true, true);
            return this;
        }

        public LintFix build() {
            return new SetAttribute(this.displayName, this.familyName, this.namespace, this.attribute, this.value, this.range, this.dot, this.mark, this.robot, this.independent);
        }
    }

    public static class ReplaceStringBuilder {
        @Nls
        protected String displayName;
        @Nls
        protected String familyName;
        private String newText;
        private String oldText;
        private String selectPattern;
        private boolean shortenNames;
        private boolean reformat;
        private boolean robot;
        private boolean independent;
        @Language(value="RegExp")
        private String oldPattern;
        private Location range;

        private ReplaceStringBuilder(String displayName, String familyName) {
            this.displayName = displayName;
            this.familyName = familyName;
        }

        public ReplaceStringBuilder name(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public ReplaceStringBuilder name(String displayName, String familyName) {
            this.displayName = displayName;
            this.familyName = familyName;
            return this;
        }

        public ReplaceStringBuilder sharedName(String familyName) {
            this.familyName = familyName;
            return this;
        }

        public ReplaceStringBuilder pattern(@Language(value="RegExp") String oldPattern) {
            assert (this.oldText == null);
            assert (this.oldPattern == null);
            if (oldPattern.indexOf(40) == -1) {
                oldPattern = "(" + oldPattern + ")";
            }
            this.oldPattern = oldPattern;
            return this;
        }

        public ReplaceStringBuilder text(String oldText) {
            assert (this.oldText == null) : "Should not call text, beginning or end more than once";
            assert (this.oldPattern == null);
            this.oldText = oldText;
            return this;
        }

        public ReplaceStringBuilder range(Location range) {
            this.range = range;
            return this;
        }

        public ReplaceStringBuilder all() {
            return this;
        }

        public ReplaceStringBuilder beginning() {
            this.oldText = "_lint_insert_begin_";
            return this;
        }

        public ReplaceStringBuilder end() {
            this.oldText = "_lint_insert_end_";
            return this;
        }

        public ReplaceStringBuilder select(@RegExp String selectPattern) {
            this.selectPattern = selectPattern;
            return this;
        }

        public ReplaceStringBuilder with(String newText) {
            assert (this.newText == null);
            this.newText = newText;
            return this;
        }

        public ReplaceStringBuilder shortenNames() {
            this.shortenNames = true;
            return this;
        }

        public ReplaceStringBuilder reformat(boolean reformat) {
            this.reformat = reformat;
            return this;
        }

        public ReplaceStringBuilder robot(boolean robot) {
            this.robot = robot;
            return this;
        }

        public ReplaceStringBuilder independent(boolean independent) {
            this.independent = !independent;
            return this;
        }

        public ReplaceStringBuilder autoFix(boolean robot, boolean independent) {
            this.robot(robot);
            this.independent(independent);
            return this;
        }

        public ReplaceStringBuilder autoFix() {
            this.autoFix(true, true);
            return this;
        }

        public LintFix build() {
            return new ReplaceString(this.displayName, this.familyName, this.oldText, this.oldPattern, this.selectPattern, this.newText != null ? this.newText : "", this.shortenNames, this.reformat, this.range, this.robot, !this.independent);
        }
    }

    public static class GroupBuilder {
        @Nls
        private String displayName;
        @Nls
        protected String familyName;
        private GroupType type = GroupType.ALTERNATIVES;
        private final List<LintFix> list = Lists.newArrayListWithExpectedSize((int)4);

        private GroupBuilder(String displayName, String familyName) {
            this.displayName = displayName;
            this.familyName = familyName;
        }

        public GroupBuilder name(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public GroupBuilder name(String displayName, String familyName) {
            this.displayName = displayName;
            this.familyName = familyName;
            return this;
        }

        public GroupBuilder sharedName(String familyName) {
            this.familyName = familyName;
            return this;
        }

        public GroupBuilder join(LintFix ... fixes) {
            this.list.addAll(Arrays.asList(fixes));
            return this;
        }

        public GroupBuilder add(LintFix fix) {
            this.list.add(fix);
            return this;
        }

        public GroupBuilder type(GroupType type) {
            this.type = type;
            return this;
        }

        public LintFix build() {
            assert (!this.list.isEmpty());
            return new LintFixGroup(this.displayName, this.familyName, this.type, this.list);
        }
    }

    public static class Builder {
        @Nls
        protected String displayName;
        @Nls
        protected String familyName;

        private Builder() {
        }

        public Builder name(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder name(String displayName, String familyName) {
            this.displayName = displayName;
            this.familyName = familyName;
            return this;
        }

        public Builder name(String displayName, boolean useAsFamilyNameToo) {
            this.name(displayName, useAsFamilyNameToo ? displayName : null);
            return this;
        }

        public Builder sharedName(String familyName) {
            this.familyName = familyName;
            return this;
        }

        public Builder family(String familyName) {
            this.familyName = familyName;
            return this;
        }

        public GroupBuilder group() {
            return new GroupBuilder(this.displayName, this.familyName).type(GroupType.ALTERNATIVES);
        }

        public GroupBuilder alternatives() {
            return this.group();
        }

        public GroupBuilder composite() {
            return new GroupBuilder(this.displayName, this.familyName).type(GroupType.COMPOSITE);
        }

        public LintFix composite(LintFix ... fixes) {
            return new GroupBuilder(this.displayName, this.familyName).type(GroupType.COMPOSITE).join(fixes).build();
        }

        public LintFix group(LintFix ... fixes) {
            return new GroupBuilder(this.displayName, this.familyName).join(fixes).build();
        }

        public LintFix alternatives(LintFix ... fixes) {
            return this.group(fixes);
        }

        public ReplaceStringBuilder replace() {
            return new ReplaceStringBuilder(this.displayName, this.familyName);
        }

        public SetAttributeBuilder set() {
            return new SetAttributeBuilder(this.displayName, this.familyName);
        }

        public SetAttributeBuilder unset() {
            return new SetAttributeBuilder(this.displayName, this.familyName).value(null);
        }

        public SetAttributeBuilder set(String namespace, String attribute, String value) {
            return new SetAttributeBuilder(this.displayName, this.familyName).namespace(namespace).attribute(attribute).value(value);
        }

        public SetAttributeBuilder unset(String namespace, String attribute) {
            return new SetAttributeBuilder(this.displayName, this.familyName).namespace(namespace).attribute(attribute).value(null);
        }

        public FixMapBuilder map() {
            return new FixMapBuilder(this.displayName, this.familyName);
        }

        public FixMapBuilder map(Object ... args) {
            FixMapBuilder builder = this.map();
            for (Object arg : args) {
                builder.put(arg);
            }
            return builder;
        }

        public LintFix data(Object ... args) {
            return this.map(args).build();
        }
    }
}

