/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.SdkConstants;
import com.android.ide.common.util.PathString;
import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.ConfigurationHierarchy;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.XmlParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.model.PathVariables;
import com.android.utils.DomExtensions;
import com.android.utils.SdkUtils;
import com.google.common.annotations.Beta;
import com.google.common.base.Splitter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010 \n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 \u0097\u00012\u00020\u0001:\u0004\u0097\u0001\u0098\u0001B\u0017\b\u0014\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B-\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ,\u00102\u001a\u0002032\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u0002050\u001d2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u000bH\u0016J>\u00109\u001a\u0002032\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u001e0;2\u0006\u0010<\u001a\u00020\u001e2\u0006\u0010\u0011\u001a\u00020\u001e2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u001e2\n\b\u0002\u0010=\u001a\u0004\u0018\u00010\u001eH\u0002J:\u0010>\u001a\u0002032\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u001e0;2\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020\u001e2\b\u0010#\u001a\u0004\u0018\u00010\u001e2\b\u0010=\u001a\u0004\u0018\u00010\u001eH\u0002JJ\u0010B\u001a\u0002032\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020\u001e2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u001e0;2\u0006\u0010?\u001a\u00020@2\u0006\u0010F\u001a\u00020\u001e2\b\u0010#\u001a\u0004\u0018\u00010\u001e2\b\u0010=\u001a\u0004\u0018\u00010\u001eH\u0002J2\u0010G\u001a\u0002032\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u001e0;2\u0006\u0010H\u001a\u0002052\b\u0010#\u001a\u0004\u0018\u00010\u001e2\b\u0010=\u001a\u0004\u0018\u00010\u001eH\u0002J$\u0010I\u001a\u00020\u000b2\u0006\u0010J\u001a\u00020\u001e2\u0012\u0010K\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u000b0LH\u0002J\b\u0010M\u001a\u000203H\u0002J\b\u0010N\u001a\u000203H\u0016J\r\u0010O\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010PJ\r\u0010Q\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010PJ\r\u0010R\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010PJ\r\u0010S\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010PJ\r\u0010T\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010PJ\r\u0010U\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010PJ\u0018\u0010V\u001a\u00020W2\u0006\u0010J\u001a\u00020\u001e2\u0006\u0010X\u001a\u00020\u000bH\u0002J\"\u0010Y\u001a\u0004\u0018\u0001052\u0006\u0010Z\u001a\u00020[2\u0006\u0010\\\u001a\u00020\u00012\u0006\u0010]\u001a\u000205H\u0016J\r\u0010^\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010PJ\r\u0010_\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010PJ\r\u0010`\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010PJ\r\u0010a\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010PJ\u001a\u0010b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0-0,H\u0002J\u000e\u0010c\u001a\b\u0012\u0004\u0012\u00020\b0,H\u0016J*\u0010d\u001a\u0004\u0018\u00010W2\u0006\u0010Z\u001a\u00020\u001e2\u0006\u00108\u001a\u00020\u000b2\u0006\u0010X\u001a\u00020\u000b2\u0006\u0010\\\u001a\u00020\u0001H\u0016J\u001c\u0010e\u001a\u00020W2\u0012\u0010f\u001a\u000e\u0012\u0004\u0012\u00020g\u0012\u0004\u0012\u00020\u000b0LH\u0002J\u0010\u0010e\u001a\u00020W2\u0006\u0010C\u001a\u00020DH\u0002J\u0010\u0010e\u001a\u00020W2\u0006\u0010h\u001a\u00020iH\u0002J$\u0010j\u001a\u0004\u0018\u00010\u001e2\u0006\u0010Z\u001a\u00020[2\u0006\u0010k\u001a\u00020\u001e2\b\u0010l\u001a\u0004\u0018\u00010\u001eH\u0016J$\u0010m\u001a\u0004\u0018\u00010\b2\u0006\u0010Z\u001a\u00020[2\u0006\u0010k\u001a\u00020\u001e2\b\u0010l\u001a\u0004\u0018\u00010\bH\u0016J\u001e\u0010n\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u001d2\b\u0010o\u001a\u0004\u0018\u00010\u001eH\u0002J\u0014\u0010p\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u001dH\u0002J\r\u0010q\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010PJ\r\u0010r\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010PJ*\u0010s\u001a\u0002032\u0006\u0010t\u001a\u00020u2\u0006\u0010Z\u001a\u00020[2\b\u0010v\u001a\u0004\u0018\u00010W2\u0006\u0010w\u001a\u00020\u001eH\u0016J\u0018\u0010s\u001a\u0002032\u0006\u0010Z\u001a\u00020[2\u0006\u0010x\u001a\u00020\bH\u0016J\u0018\u0010s\u001a\u0002032\u0006\u0010y\u001a\u00020\u001e2\u0006\u0010x\u001a\u00020\bH\u0016J&\u0010z\u001a\u00020\u000b2\b\u0010o\u001a\u0004\u0018\u00010\u001e2\b\b\u0002\u0010{\u001a\u00020\u000b2\b\b\u0002\u0010|\u001a\u00020\u000bH\u0002J\u0018\u0010}\u001a\u00020\u000b2\u0006\u0010t\u001a\u00020u2\u0006\u0010~\u001a\u00020\u007fH\u0016J\"\u0010\u0080\u0001\u001a\u00020\u000b2\u0007\u0010\u0081\u0001\u001a\u00020\u001f2\u0006\u0010v\u001a\u00020W2\u0006\u0010t\u001a\u00020uH\u0002J!\u0010\u0080\u0001\u001a\u00020\u000b2\u0006\u0010J\u001a\u00020\u001e2\u0006\u0010v\u001a\u00020W2\u0006\u0010t\u001a\u00020uH\u0002J*\u0010\u0082\u0001\u001a\u00020\u000b2\u0007\u0010\u0081\u0001\u001a\u00020\u001f2\u0006\u0010w\u001a\u00020\u001e2\u0006\u0010v\u001a\u00020W2\u0006\u0010t\u001a\u00020uH\u0002J)\u0010\u0082\u0001\u001a\u00020\u000b2\u0006\u0010J\u001a\u00020\u001e2\u0006\u0010w\u001a\u00020\u001e2\u0006\u0010v\u001a\u00020W2\u0006\u0010t\u001a\u00020uH\u0002J\t\u0010\u0083\u0001\u001a\u000203H\u0002J?\u0010\u0084\u0001\u001a\u0002032\u0006\u0010w\u001a\u00020\u001e2\n\b\u0002\u0010C\u001a\u0004\u0018\u00010D2\n\b\u0002\u0010h\u001a\u0004\u0018\u00010i2\n\b\u0002\u0010v\u001a\u0004\u0018\u00010W2\b\b\u0002\u0010H\u001a\u000205H\u0002J'\u0010\u0085\u0001\u001a\u0002032\u0006\u0010Z\u001a\u00020[2\u0006\u0010k\u001a\u00020\u001e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0003\u0010\u0086\u0001J!\u0010\u0087\u0001\u001a\u0002032\u0006\u0010Z\u001a\u00020[2\u0006\u0010k\u001a\u00020\u001e2\b\u0010\u0011\u001a\u0004\u0018\u00010\bJ'\u0010\u0088\u0001\u001a\u0002032\u0006\u0010Z\u001a\u00020[2\u0006\u0010k\u001a\u00020\u001e2\b\u0010\u0011\u001a\u0004\u0018\u00010@\u00a2\u0006\u0003\u0010\u0089\u0001J!\u0010\u008a\u0001\u001a\u0002032\u0006\u0010Z\u001a\u00020[2\u0006\u0010k\u001a\u00020\u001e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u001eJ\u001b\u0010\u008b\u0001\u001a\u0002032\u0006\u0010Z\u001a\u00020[2\b\u0010H\u001a\u0004\u0018\u000105H\u0016J\t\u0010\u008c\u0001\u001a\u000203H\u0016J\t\u0010\u008d\u0001\u001a\u00020\u001eH\u0016J.\u0010\u008e\u0001\u001a\u0002032\u0007\u0010o\u001a\u00030\u008f\u00012\b\u0010\u0090\u0001\u001a\u00030\u0091\u00012\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u00106\u001a\u000207H\u0016JC\u0010\u008e\u0001\u001a\u0002032\u0007\u0010o\u001a\u00030\u008f\u00012\b\u0010\u0090\u0001\u001a\u00030\u0091\u00012\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u00106\u001a\u0002072\u0013\u0010\u0092\u0001\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u001dH\u0002J#\u0010\u0093\u0001\u001a\u0002032\b\u0010\u0094\u0001\u001a\u00030\u0095\u00012\u0006\u0010k\u001a\u00020\u001e2\u0006\u0010\u0011\u001a\u00020\u001eH\u0002J\t\u0010\u0096\u0001\u001a\u000203H\u0002R\u0010\u0010\r\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000fR(\u0010\u0012\u001a\u0004\u0018\u00010\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000fR(\u0010\u001c\u001a\u001c\u0012\u0004\u0012\u00020\u001e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u001d\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0014R\u0012\u0010!\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0012\u0010\"\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0010\u0010#\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u0012\u0010(\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0012\u0010)\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u001c\u0010*\u001a\u0010\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010+\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0-0,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010.\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010/\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u000e\u00100\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u00101\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000f\u00a8\u0006\u0099\u0001"}, d2={"Lcom/android/tools/lint/client/api/LintXmlConfiguration;", "Lcom/android/tools/lint/client/api/Configuration;", "configurations", "Lcom/android/tools/lint/client/api/ConfigurationHierarchy;", "project", "Lcom/android/tools/lint/detector/api/Project;", "(Lcom/android/tools/lint/client/api/ConfigurationHierarchy;Lcom/android/tools/lint/detector/api/Project;)V", "configFile", "Ljava/io/File;", "dir", "fileLevel", "", "(Lcom/android/tools/lint/client/api/ConfigurationHierarchy;Ljava/io/File;Ljava/io/File;Z)V", "_baselineFile", "abortOnError", "Ljava/lang/Boolean;", "applySuggestions", "value", "baselineFile", "getBaselineFile", "()Ljava/io/File;", "setBaselineFile", "(Ljava/io/File;)V", "bulkEditing", "checkAllWarnings", "checkDependencies", "checkGeneratedSources", "checkTestSources", "clientIssueMaps", "", "", "Lcom/android/tools/lint/client/api/LintXmlConfiguration$IssueData;", "getConfigFile", "explainIssues", "fatalOnly", "fileClients", "getFileLevel", "()Z", "setFileLevel", "(Z)V", "ignoreTestSources", "ignoreWarnings", "issueMap", "issueMaps", "", "", "lintJars", "removeFixedBaselineIssues", "validated", "warningsAsErrors", "addConfiguredIssues", "", "targetMap", "Lcom/android/tools/lint/detector/api/Severity;", "registry", "Lcom/android/tools/lint/client/api/IssueRegistry;", "specificOnly", "addOption", "ids", "", "key", "issueClients", "addPaths", "n", "", "path", "addRegexp", "parser", "Lorg/xmlpull/v1/XmlPullParser;", "idList", "regexp", "addSeverity", "severity", "checkIgnored", "id", "checker", "Lkotlin/Function1;", "ensureInitialized", "finishBulkEditing", "getAbortOnError", "()Ljava/lang/Boolean;", "getApplySuggestions", "getCheckAllWarnings", "getCheckDependencies", "getCheckGeneratedSources", "getCheckTestSources", "getConfigLocation", "Lcom/android/tools/lint/detector/api/Location;", "severityOnly", "getDefinedSeverity", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "source", "visibleDefault", "getExplainIssues", "getFatalOnly", "getIgnoreTestSources", "getIgnoreWarnings", "getIssueMaps", "getLintJars", "getLocalIssueConfigLocation", "getLocation", "filter", "Lorg/w3c/dom/Element;", "exception", "Lorg/xmlpull/v1/XmlPullParserException;", "getOption", "name", "default", "getOptionAsFile", "getOrCreateIssueMap", "client", "getPrimaryIssueMap", "getRemoveFixedBaselineIssues", "getWarningsAsErrors", "ignore", "context", "Lcom/android/tools/lint/detector/api/Context;", "location", "message", "file", "issueId", "isApplicableClient", "checkEquals", "checkOther", "isIgnored", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "isPathIgnored", "issueData", "isPatternIgnored", "readConfig", "reportError", "setBooleanOption", "(Lcom/android/tools/lint/detector/api/Issue;Ljava/lang/String;Ljava/lang/Boolean;)V", "setFileOption", "setIntOption", "(Lcom/android/tools/lint/detector/api/Issue;Ljava/lang/String;Ljava/lang/Integer;)V", "setOption", "setSeverity", "startBulkEditing", "toString", "validateIssueIds", "Lcom/android/tools/lint/client/api/LintClient;", "driver", "Lcom/android/tools/lint/client/api/LintDriver;", "map", "writeAttribute", "writer", "Ljava/io/Writer;", "writeConfig", "Companion", "IssueData", "lint-api"})
@Beta
public class LintXmlConfiguration
extends Configuration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File configFile;
    private boolean fileLevel;
    private boolean bulkEditing;
    @Nullable
    private Boolean checkAllWarnings;
    @Nullable
    private Boolean ignoreWarnings;
    @Nullable
    private Boolean warningsAsErrors;
    @Nullable
    private Boolean fatalOnly;
    @Nullable
    private Boolean checkTestSources;
    @Nullable
    private Boolean ignoreTestSources;
    @Nullable
    private Boolean checkGeneratedSources;
    @Nullable
    private Boolean checkDependencies;
    @Nullable
    private Boolean explainIssues;
    @Nullable
    private Boolean applySuggestions;
    @Nullable
    private Boolean removeFixedBaselineIssues;
    @Nullable
    private Boolean abortOnError;
    @Nullable
    private List<? extends File> lintJars;
    @Nullable
    private Map<String, IssueData> issueMap;
    @NotNull
    private List<? extends Map<String, IssueData>> issueMaps;
    @Nullable
    private Map<String, Map<String, IssueData>> clientIssueMaps;
    @Nullable
    private String fileClients;
    @Nullable
    private File _baselineFile;
    private boolean validated;
    @NotNull
    public static final String CONFIG_FILE_NAME = "lint.xml";
    @NotNull
    public static final String TAG_LINT = "lint";
    @NotNull
    private static final String TAG_ISSUE = "issue";
    @NotNull
    private static final String TAG_IGNORE = "ignore";
    @NotNull
    private static final String TAG_OPTION = "option";
    @NotNull
    private static final String ATTR_ID = "id";
    @NotNull
    private static final String ATTR_IN = "in";
    @NotNull
    private static final String ATTR_SEVERITY = "severity";
    @NotNull
    private static final String ATTR_PATH = "path";
    @NotNull
    private static final String ATTR_REGEXP = "regexp";
    @NotNull
    private static final String ATTR_NAME = "name";
    @NotNull
    private static final String ATTR_VALUE = "value";
    @NotNull
    public static final String VALUE_ALL = "all";
    @NotNull
    private static final String ATTR_BASELINE = "baseline";
    @NotNull
    private static final String RES_PATH_START = Intrinsics.stringPlus((String)"res", (Object)Character.valueOf(File.separatorChar));
    private static final int RES_PATH_START_LEN = RES_PATH_START.length();

    protected LintXmlConfiguration(@NotNull ConfigurationHierarchy configurations, @NotNull File configFile, @Nullable File dir, boolean fileLevel) {
        Intrinsics.checkParameterIsNotNull((Object)configurations, (String)"configurations");
        Intrinsics.checkParameterIsNotNull((Object)configFile, (String)"configFile");
        super(configurations);
        this.configFile = configFile;
        this.fileLevel = fileLevel;
        this.setDir(dir);
        this.issueMaps = CollectionsKt.emptyList();
    }

    public /* synthetic */ LintXmlConfiguration(ConfigurationHierarchy configurationHierarchy, File file, File file2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            file2 = file.getParentFile();
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        this(configurationHierarchy, file, file2, bl);
    }

    @NotNull
    public final File getConfigFile() {
        return this.configFile;
    }

    @Override
    public boolean getFileLevel() {
        return this.fileLevel;
    }

    @Override
    public void setFileLevel(boolean bl) {
        this.fileLevel = bl;
    }

    protected LintXmlConfiguration(@NotNull ConfigurationHierarchy configurations, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)configurations, (String)"configurations");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        File file = project.getDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.dir");
        this(configurations, ConfigurationHierarchy.Companion.getLintXmlFile(file), project.getDir(), true);
    }

    private final boolean checkIgnored(String id, Function1<? super IssueData, Boolean> checker) {
        IssueData it;
        boolean bl;
        Object object;
        IssueData issueData;
        List<Map<String, IssueData>> issueMaps = this.getIssueMaps();
        for (Map<String, IssueData> issueMap : issueMaps) {
            issueData = issueMap.get(id);
            if (issueData == null) continue;
            object = issueData;
            boolean bl2 = false;
            bl = false;
            it = object;
            boolean bl3 = false;
            if (!((Boolean)checker.invoke((Object)it)).booleanValue()) continue;
            return true;
        }
        for (Map<String, IssueData> issueMap : issueMaps) {
            Object severity;
            IssueData issueData2 = issueMap.get(id);
            object = issueData2 == null ? null : issueData2.getSeverity();
            if (object == null || (severity = object) == Severity.IGNORE) continue;
            return false;
        }
        for (Map<String, IssueData> issueMap : issueMaps) {
            issueData = issueMap.get(VALUE_ALL);
            if (issueData == null) continue;
            object = issueData;
            boolean bl4 = false;
            bl = false;
            it = object;
            boolean bl5 = false;
            if (!((Boolean)checker.invoke((Object)it)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isIgnored(@NotNull Context context2, @NotNull Incident incident) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)incident, (String)"incident");
        Location location = incident.getLocation();
        if (Intrinsics.areEqual((Object)location, (Object)Location.NONE)) {
            boolean bl2;
            Configuration configuration = this.getParent();
            return configuration == null ? false : (bl2 = configuration.isIgnored(context2, incident));
        }
        String id = incident.getIssue().getId();
        String message2 = incident.getMessage();
        if (this.isPathIgnored(id, location, context2) || this.isPatternIgnored(id, message2, location, context2)) {
            return true;
        }
        Configuration configuration = this.getParent();
        return configuration == null ? false : (bl = configuration.isIgnored(context2, incident));
    }

    @Override
    @Nullable
    public String getOption(@NotNull Issue issue, @NotNull String name, @Nullable String string) {
        String string2;
        Map<String, String> map;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)TAG_ISSUE);
        Intrinsics.checkParameterIsNotNull((Object)name, (String)ATTR_NAME);
        String id = issue.getId();
        List<Map<String, IssueData>> issueMaps = this.getIssueMaps();
        for (Map<String, IssueData> issueMap : issueMaps) {
            object = issueMap.get(id);
            map = object == null ? null : ((IssueData)object).getOptions();
            if (map == null || (object = map.get(name)) == null) continue;
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            return it;
        }
        for (Map<String, IssueData> issueMap : issueMaps) {
            object = issueMap.get(VALUE_ALL);
            map = object == null ? null : ((IssueData)object).getOptions();
            if (map == null || (object = map.get(name)) == null) continue;
            Object object3 = object;
            boolean bl = false;
            boolean bl4 = false;
            Object it = object3;
            boolean bl5 = false;
            return it;
        }
        Configuration configuration = this.getParent();
        return configuration == null ? string : ((string2 = configuration.getOption(issue, name, string)) == null ? string : string2);
    }

    @Override
    @Nullable
    public File getOptionAsFile(@NotNull Issue issue, @NotNull String name, @Nullable File file) {
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)TAG_ISSUE);
        Intrinsics.checkParameterIsNotNull((Object)name, (String)ATTR_NAME);
        String string = this.getOption(issue, name, null);
        if (string == null) {
            return file;
        }
        String value = string;
        File file2 = new File(StringsKt.replace$default((String)value, (char)'/', (char)File.separatorChar, (boolean)false, (int)4, null));
        if (file2.isAbsolute()) {
            return file2;
        }
        File file3 = this.configFile.getParentFile();
        if (file3 == null) {
            return file2;
        }
        File parent = file3;
        return new File(parent, file2.getPath());
    }

    public final void setOption(@NotNull Issue issue, @NotNull String name, @Nullable String value) {
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)TAG_ISSUE);
        Intrinsics.checkParameterIsNotNull((Object)name, (String)ATTR_NAME);
        if (value != null) {
            LintXmlConfiguration.addOption$default(this, CollectionsKt.listOf((Object)issue.getId()), name, value, null, null, 24, null);
        } else {
            Map<String, String> map;
            IssueData issueData = this.getPrimaryIssueMap().get(issue.getId());
            if (issueData != null && (map = issueData.getOptions()) != null) {
                map.remove(name);
            }
        }
    }

    public final void setBooleanOption(@NotNull Issue issue, @NotNull String name, @Nullable Boolean value) {
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)TAG_ISSUE);
        Intrinsics.checkParameterIsNotNull((Object)name, (String)ATTR_NAME);
        Boolean bl = value;
        this.setOption(issue, name, bl == null ? null : bl.toString());
    }

    public final void setIntOption(@NotNull Issue issue, @NotNull String name, @Nullable Integer value) {
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)TAG_ISSUE);
        Intrinsics.checkParameterIsNotNull((Object)name, (String)ATTR_NAME);
        Integer n = value;
        this.setOption(issue, name, n == null ? null : n.toString());
    }

    public final void setFileOption(@NotNull Issue issue, @NotNull String name, @Nullable File value) {
        String relative;
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)TAG_ISSUE);
        Intrinsics.checkParameterIsNotNull((Object)name, (String)ATTR_NAME);
        String string = relative = value != null && value.isAbsolute() ? this.getClient().getRelativePath(this.configFile.getParentFile(), value) : (String)null;
        if (relative != null) {
            this.setOption(issue, name, StringsKt.replace$default((String)relative, (char)'\\', (char)'/', (boolean)false, (int)4, null));
        } else {
            String string2;
            File file = value;
            this.setOption(issue, name, file == null ? null : ((string2 = file.toString()) == null ? null : StringsKt.replace$default((String)string2, (char)'\\', (char)'/', (boolean)false, (int)4, null)));
        }
    }

    private final boolean isPathIgnored(String id, Location location, Context context2) {
        return this.checkIgnored(id, (Function1<? super IssueData, Boolean>)((Function1)new Function1<IssueData, Boolean>(this, location, context2){
            final /* synthetic */ LintXmlConfiguration this$0;
            final /* synthetic */ Location $location;
            final /* synthetic */ Context $context;
            {
                this.this$0 = $receiver;
                this.$location = $location;
                this.$context = $context;
                super(1);
            }

            public final boolean invoke(@NotNull IssueData data) {
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return LintXmlConfiguration.access$isPathIgnored(this.this$0, data, this.$location, this.$context);
            }
        }));
    }

    private final boolean isPathIgnored(IssueData issueData, Location location, Context context2) {
        Object object;
        List<String> paths = issueData.getPaths();
        if (paths == null || paths.isEmpty()) {
            return false;
        }
        File file = location.getFile();
        File parentFile = this.configFile.getParentFile();
        if (parentFile != null) {
            String string = this.getClient().getRelativePath(parentFile, file);
            if (string == null) {
                return false;
            }
            object = string;
        } else {
            object = file.getPath();
        }
        String relativePath = object;
        for (String string : paths) {
            if (Intrinsics.areEqual((Object)string, (Object)relativePath)) {
                return true;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)relativePath, (String)"relativePath");
            if (!StringsKt.startsWith$default((String)relativePath, (String)string, (boolean)false, (int)2, null)) continue;
            return true;
        }
        HashSet suppressedPathSet = null;
        for (String string : paths) {
            Set set;
            if (!StringsKt.startsWith$default((String)string, (String)RES_PATH_START, (boolean)false, (int)2, null)) continue;
            String string2 = string;
            int n = RES_PATH_START_LEN;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            Path path2 = Paths.get(string4, new String[0]);
            Set set2 = suppressedPathSet;
            if (set2 == null) {
                HashSet hashSet = new HashSet();
                boolean bl2 = false;
                boolean bl3 = false;
                HashSet it = hashSet;
                boolean bl4 = false;
                suppressedPathSet = it;
                set = hashSet;
            } else {
                set = set2;
            }
            Set set3 = set;
            Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)ATTR_PATH);
            set3.add(path2);
        }
        Set set = suppressedPathSet;
        if (set != null) {
            Collection collection = set;
            boolean bl = false;
            if (!collection.isEmpty()) {
                Path path2 = file.toPath();
                for (File resDir : context2.getProject().getResourceFolders()) {
                    Path path3 = resDir.toPath();
                    Path relative = path3.relativize(path2);
                    if (set.contains(relative)) {
                        return true;
                    }
                    if (!set.stream().anyMatch((Predicate)new Predicate<Path>(relative){
                        final /* synthetic */ Path $relative;
                        {
                            this.$relative = $relative;
                        }

                        public final boolean test(Path it) {
                            return this.$relative.startsWith(it);
                        }
                    })) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private final Map<String, IssueData> getOrCreateIssueMap(String client) {
        Map<String, IssueData> map;
        this.ensureInitialized();
        if (client != null) {
            Map<Object, Object> map2;
            Map map3;
            boolean bl;
            Map<Object, Object> map4;
            Map map5 = this.clientIssueMaps;
            if (map5 == null) {
                map4 = new LinkedHashMap();
                boolean bl2 = false;
                bl = false;
                Map<Object, Object> it = map4;
                boolean bl3 = false;
                this.clientIssueMaps = it;
                map3 = map4;
            } else {
                map3 = map5;
            }
            Map clientMap = map3;
            map4 = clientMap.get(client);
            if (map4 == null) {
                HashMap hashMap = new HashMap();
                bl = false;
                boolean bl4 = false;
                HashMap it = hashMap;
                boolean bl5 = false;
                Map map6 = clientMap;
                boolean bl6 = false;
                map6.put(client, it);
                map2 = hashMap;
            } else {
                map2 = map4;
            }
            Map<Object, Object> map7 = map2;
            map = map5;
        } else {
            Map<String, IssueData> map8 = this.issueMap;
            if (map8 == null) {
                Intrinsics.throwNpe();
            }
            map = map8;
        }
        return map;
    }

    private final List<Map<String, IssueData>> getIssueMaps() {
        this.ensureInitialized();
        return this.issueMaps;
    }

    private final Map<String, IssueData> getPrimaryIssueMap() {
        this.ensureInitialized();
        Map<String, IssueData> map = this.issueMap;
        if (map == null) {
            Intrinsics.throwNpe();
        }
        return map;
    }

    private final boolean isPatternIgnored(String id, String message2, Location location, Context context2) {
        return this.checkIgnored(id, (Function1<? super IssueData, Boolean>)((Function1)new Function1<IssueData, Boolean>(this, message2, location, context2){
            final /* synthetic */ LintXmlConfiguration this$0;
            final /* synthetic */ String $message;
            final /* synthetic */ Location $location;
            final /* synthetic */ Context $context;
            {
                this.this$0 = $receiver;
                this.$message = $message;
                this.$location = $location;
                this.$context = $context;
                super(1);
            }

            public final boolean invoke(@NotNull IssueData data) {
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return LintXmlConfiguration.access$isPatternIgnored(this.this$0, data, this.$message, this.$location, this.$context);
            }
        }));
    }

    private final boolean isPatternIgnored(IssueData issueData, String message2, Location location, Context context2) {
        Matcher matcher;
        Object object;
        Object object2;
        Object matcher2;
        List<Pattern> regexps = issueData.getPatterns();
        if (regexps == null || regexps.isEmpty()) {
            return false;
        }
        for (Pattern regexp : regexps) {
            matcher2 = regexp.matcher(message2);
            if (!((Matcher)matcher2).find()) continue;
            return true;
        }
        File file = location.getFile();
        matcher2 = this.configFile.getParentFile();
        if (matcher2 == null) {
            object2 = context2.getProject().getDir();
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"context.project.dir");
            object = object2;
        } else {
            object = matcher2;
        }
        Object relativeTo = object;
        object2 = Project.getRelativePath((File)relativeTo, file);
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"getRelativePath(relativeTo, file)");
        Object relativePath = object2;
        boolean checkUnixPath = false;
        for (Pattern regexp : regexps) {
            matcher = regexp.matcher((CharSequence)relativePath);
            if (matcher.find()) {
                return true;
            }
            String pattern = regexp.pattern();
            Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"pattern");
            if (StringsKt.indexOf$default((CharSequence)pattern, (char)'/', (int)0, (boolean)false, (int)6, null) == -1) continue;
            checkUnixPath = true;
            if (!StringsKt.startsWith$default((String)pattern, (String)".*/", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)pattern, (String)"^.*/", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)pattern, (String)"^.*?/", (boolean)false, (int)2, null) || !regexp.matcher(Intrinsics.stringPlus((String)"/", (Object)relativePath)).find()) continue;
            return true;
        }
        if (checkUnixPath && SdkConstants.CURRENT_PLATFORM == 2) {
            relativePath = StringsKt.replace$default((String)relativePath, (char)'\\', (char)'/', (boolean)false, (int)4, null);
            for (Pattern regexp : regexps) {
                matcher = regexp.matcher((CharSequence)relativePath);
                if (!matcher.find()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void addConfiguredIssues(@NotNull Map<String, Severity> targetMap, @NotNull IssueRegistry registry, boolean specificOnly) {
        boolean bl;
        Object object;
        Object object2;
        Object issue;
        Intrinsics.checkParameterIsNotNull(targetMap, (String)"targetMap");
        Intrinsics.checkParameterIsNotNull((Object)registry, (String)"registry");
        Configuration configuration = this.getParent();
        if (configuration != null) {
            configuration.addConfiguredIssues(targetMap, registry, specificOnly);
        }
        List<Map<String, IssueData>> issueMaps = this.getIssueMaps();
        for (Map<String, IssueData> issueMap : issueMaps) {
            IssueData issueData;
            Object object3;
            IssueData issueData2 = issueMap.get(VALUE_ALL);
            if (issueData2 == null || (object3 = (issueData = issueData2).getSeverity()) == null) continue;
            Severity severity = object3;
            object3 = registry.getIssues().iterator();
            while (object3.hasNext()) {
                issue = (Issue)object3.next();
                object2 = targetMap;
                object = ((Issue)issue).getId();
                bl = false;
                object2.put(object, severity);
            }
        }
        Object configuration2 = issueMaps.iterator();
        while (configuration2.hasNext()) {
            Map<String, IssueData> issueMap;
            Map<String, IssueData> map = issueMap = configuration2.next();
            boolean bl2 = false;
            for (Map.Entry<String, IssueData> entry : map.entrySet()) {
                issue = entry;
                boolean bl3 = false;
                String id = issue.getKey();
                object2 = entry;
                boolean bl4 = false;
                IssueData issueData = (IssueData)object2.getValue();
                object = issueData.getSeverity();
                if (object == null) continue;
                Object severity = object;
                object = targetMap;
                bl = false;
                object.put(id, severity);
            }
        }
        configuration2 = this.getOverrides();
        if (configuration2 != null) {
            ((Configuration)configuration2).addConfiguredIssues(targetMap, registry, specificOnly);
        }
    }

    @Override
    @Nullable
    public Location getLocalIssueConfigLocation(@NotNull String issue, boolean specificOnly, boolean severityOnly, @NotNull Configuration source) {
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)TAG_ISSUE);
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        List<Map<String, IssueData>> issueMaps = this.getIssueMaps();
        for (Map<String, IssueData> issueMap : issueMaps) {
            IssueData data = issueMap.get(issue);
            if (data == null) continue;
            return this.getConfigLocation(issue, severityOnly);
        }
        for (Map<String, IssueData> issueMap : issueMaps) {
            IssueData issueData = issueMap.get(VALUE_ALL);
            if (issueData == null) continue;
            IssueData issueData2 = issueData;
            boolean bl = false;
            boolean bl2 = false;
            IssueData it = issueData2;
            boolean bl3 = false;
            if (!specificOnly) {
                return this.getConfigLocation(VALUE_ALL, severityOnly);
            }
            return null;
        }
        Configuration configuration = this.getParent();
        return configuration == null ? null : configuration.getLocalIssueConfigLocation(issue, specificOnly, severityOnly, source);
    }

    @Override
    @Nullable
    public Severity getDefinedSeverity(@NotNull Issue issue, @NotNull Configuration source, @NotNull Severity visibleDefault) {
        Object severity;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)TAG_ISSUE);
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)((Object)visibleDefault), (String)"visibleDefault");
        if (issue.getSuppressNames() != null) {
            return this.getDefaultSeverity(issue, visibleDefault);
        }
        List<Map<String, IssueData>> issueMaps = this.getIssueMaps();
        for (Map<String, IssueData> issueMap : issueMaps) {
            Object object2;
            Severity severity2;
            Object object3 = issueMap.get(issue.getId());
            Severity severity3 = severity2 = object3 == null ? null : ((IssueData)object3).getSeverity();
            Object object4 = severity2 == null ? ((object3 = issueMap.get(issue.getCategory().getName())) == null ? null : ((IssueData)object3).getSeverity()) : (object = severity2);
            if (object == null) {
                object3 = issueMap.get(issue.getCategory().getFullName());
                Severity severity4 = severity2 = object3 == null ? null : ((IssueData)object3).getSeverity();
                if (severity2 == null) {
                    object3 = this;
                    boolean bl = false;
                    boolean bl2 = false;
                    LintXmlConfiguration $this$getDefinedSeverity_u24lambda_u2d8 = (LintXmlConfiguration)object3;
                    boolean bl3 = false;
                    Severity s = null;
                    for (Category currentCategory = issue.getCategory().getParent(); currentCategory != null; currentCategory = currentCategory.getParent()) {
                        IssueData issueData = issueMap.get(currentCategory.getName());
                        Severity severity5 = s = issueData == null ? null : issueData.getSeverity();
                        if (s != null) break;
                    }
                    object2 = s;
                } else {
                    object2 = severity2;
                }
            } else {
                object2 = object;
            }
            if ((severity = object2) == null) continue;
            return severity;
        }
        for (Map<String, IssueData> issueMap : issueMaps) {
            object = issueMap.get(VALUE_ALL);
            severity = object == null ? null : object.getSeverity();
            if (severity == null) continue;
            return severity;
        }
        Configuration configuration = this.getParent();
        return configuration == null ? null : configuration.getDefinedSeverity(issue, source, visibleDefault);
    }

    private final void ensureInitialized() {
        if (this.issueMap == null) {
            this.readConfig();
        }
    }

    private final Location getConfigLocation(String id, boolean severityOnly) {
        return this.getLocation((Function1<? super Element, Boolean>)((Function1)new Function1<Element, Boolean>(id, severityOnly){
            final /* synthetic */ String $id;
            final /* synthetic */ boolean $severityOnly;
            {
                this.$id = $id;
                this.$severityOnly = $severityOnly;
                super(1);
            }

            public final boolean invoke(@NotNull Element element) {
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                return Intrinsics.areEqual((Object)this.$id, (Object)element.getAttribute("id")) && (!this.$severityOnly || element.hasAttribute("severity"));
            }
        }));
    }

    private final Location getLocation(Function1<? super Element, Boolean> filter) {
        Element element;
        XmlParser parser = this.getClient().getXmlParser();
        Document document = parser.parseXml(this.configFile);
        if (document != null && (element = document.getDocumentElement()) != null) {
            Element element2 = element;
            boolean bl = false;
            boolean bl2 = false;
            Element document2 = element2;
            boolean bl3 = false;
            Iterator iterator = DomExtensions.iterator((Element)document2);
            while (iterator.hasNext()) {
                Element element3 = (Element)iterator.next();
                if (!((Boolean)filter.invoke((Object)element3)).booleanValue()) continue;
                return parser.getLocation(this.getConfigFile(), (Node)element3);
            }
        }
        return Location.Companion.create(this.configFile);
    }

    private final Location getLocation(XmlPullParser parser) {
        String contents = ((Object)this.getClient().readFile(this.configFile)).toString();
        int n = 0;
        int n2 = parser.getLineNumber() - 1;
        boolean bl = false;
        return Location.Companion.create(this.configFile, contents, Math.max(n, n2));
    }

    private final Location getLocation(XmlPullParserException exception) {
        String contents = ((Object)this.getClient().readFile(this.configFile)).toString();
        int n = 0;
        int n2 = exception.getLineNumber() - 1;
        boolean bl = false;
        return Location.Companion.create(this.configFile, contents, Math.max(n, n2));
    }

    private final void reportError(String message2, XmlPullParser parser, XmlPullParserException exception, Location location, Severity severity) {
        LintClient lintClient = this.getClient();
        Issue issue = severity.isError() ? IssueRegistry.LINT_ERROR : IssueRegistry.LINT_WARNING;
        LintClient.Companion.report$default(LintClient.Companion, lintClient, issue, message2, null, null, null, null, null, null, null, null, null, location, 2040, null);
    }

    static /* synthetic */ void reportError$default(LintXmlConfiguration lintXmlConfiguration, String string, XmlPullParser xmlPullParser, XmlPullParserException xmlPullParserException, Location location, Severity severity, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reportError");
        }
        if ((n & 2) != 0) {
            xmlPullParser = null;
        }
        if ((n & 4) != 0) {
            xmlPullParserException = null;
        }
        if ((n & 8) != 0) {
            Location location2 = xmlPullParser != null ? lintXmlConfiguration.getLocation(xmlPullParser) : (location = xmlPullParserException != null ? lintXmlConfiguration.getLocation(xmlPullParserException) : Location.Companion.create(lintXmlConfiguration.configFile));
        }
        if ((n & 0x10) != 0) {
            severity = Severity.WARNING;
        }
        lintXmlConfiguration.reportError(string, xmlPullParser, xmlPullParserException, location, severity);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void readConfig() {
        this.issueMap = issueMap = (Map)new HashMap<K, V>();
        if (!this.configFile.isFile()) {
            this.issueMaps = CollectionsKt.listOf((Object)issueMap);
            return;
        }
        try {
            resourcePath = new PathString(this.configFile);
            var4_5 = this.getClient().createXmlPullParser(resourcePath);
            if (var4_5 == null) {
                return;
            }
            parser = var4_5;
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", false);
            splitter = Splitter.on((char)',').trimResults().omitEmptyStrings();
            idString = "";
            idList = CollectionsKt.emptyList();
            issueClients = null;
            while (parser.next() != 1) {
                eventType = parser.getEventType();
                switch (eventType) {
                    case 2: {
                        var9_20 = parser.getName();
                        if (var9_20 == null) ** GOTO lbl-1000
                        tmp = -1;
                        switch (var9_20.hashCode()) {
                            case 3321859: {
                                if (var9_20.equals("lint")) {
                                    tmp = 1;
                                }
                                break;
                            }
                            case 100509913: {
                                if (var9_20.equals("issue")) {
                                    tmp = 2;
                                }
                                break;
                            }
                            case -1190396462: {
                                if (var9_20.equals("ignore")) {
                                    tmp = 3;
                                }
                                break;
                            }
                            case -1010136971: {
                                if (var9_20.equals("option")) {
                                    tmp = 4;
                                }
                                break;
                            }
                        }
                        switch (tmp) {
                            case 1: {
                                n = parser.getAttributeCount();
                                var11_24 = 0;
                                if (var11_24 >= n) ** GOTO lbl261
                                do {
                                    i = var11_24++;
                                    name = parser.getAttributeName(i);
                                    value = parser.getAttributeValue(i);
                                    var15_46 = name;
                                    if (var15_46 == null) ** GOTO lbl-1000
                                    tmp = -1;
                                    switch (var15_46.hashCode()) {
                                        case 16328217: {
                                            if (var15_46.equals("abortOnError")) {
                                                tmp = 1;
                                            }
                                            break;
                                        }
                                        case 3365: {
                                            if (var15_46.equals("in")) {
                                                tmp = 2;
                                            }
                                            break;
                                        }
                                        case -512969655: {
                                            if (var15_46.equals("ignoreWarnings")) {
                                                tmp = 3;
                                            }
                                            break;
                                        }
                                        case -279687535: {
                                            if (var15_46.equals("explainIssues")) {
                                                tmp = 4;
                                            }
                                            break;
                                        }
                                        case 544724126: {
                                            if (var15_46.equals("checkTestSources")) {
                                                tmp = 5;
                                            }
                                            break;
                                        }
                                        case 1975335316: {
                                            if (var15_46.equals("ignoreTestSources")) {
                                                tmp = 6;
                                            }
                                            break;
                                        }
                                        case -469185887: {
                                            if (var15_46.equals("applySuggestions")) {
                                                tmp = 7;
                                            }
                                            break;
                                        }
                                        case 177327896: {
                                            if (var15_46.equals("lintJar")) {
                                                tmp = 8;
                                            }
                                            break;
                                        }
                                        case -1720785339: {
                                            if (var15_46.equals("baseline")) {
                                                tmp = 9;
                                            }
                                            break;
                                        }
                                        case 2044652113: {
                                            if (var15_46.equals("checkDependencies")) {
                                                tmp = 10;
                                            }
                                            break;
                                        }
                                        case -1992186799: {
                                            if (var15_46.equals("checkGeneratedSources")) {
                                                tmp = 11;
                                            }
                                            break;
                                        }
                                        case -595677489: {
                                            if (var15_46.equals("removeFixedBaselineIssues")) {
                                                tmp = 12;
                                            }
                                            break;
                                        }
                                        case 1202197595: {
                                            if (var15_46.equals("lintJars")) {
                                                tmp = 8;
                                            }
                                            break;
                                        }
                                        case -1639883852: {
                                            if (var15_46.equals("warningsAsErrors")) {
                                                tmp = 13;
                                            }
                                            break;
                                        }
                                        case 327591632: {
                                            if (var15_46.equals("fatalOnly")) {
                                                tmp = 14;
                                            }
                                            break;
                                        }
                                        case -663830800: {
                                            if (var15_46.equals("checkAllWarnings")) {
                                                tmp = 15;
                                            }
                                            break;
                                        }
                                    }
                                    switch (tmp) {
                                        case 2: {
                                            this.fileClients = value;
                                            if (i > 0) {
                                                LintXmlConfiguration.reportError$default(this, "in for the whole file, if specified, must always be the first attribute in <lint>", parser, null, null, null, 28, null);
                                            } else if (Intrinsics.areEqual((Object)value, (Object)"all")) {
                                                LintXmlConfiguration.reportError$default(this, "all not supported for in", parser, null, null, null, 28, null);
                                            }
                                            v0 = Unit.INSTANCE;
                                            break;
                                        }
                                        case 9: {
                                            if (LintXmlConfiguration.readConfig$applies(this)) {
                                                Intrinsics.checkExpressionValueIsNotNull((Object)value, (String)"value");
                                                this.setBaselineFile(new File(StringsKt.replace$default((String)value, (char)'/', (char)File.separatorChar, (boolean)false, (int)4, null)));
                                            }
                                            v0 = Unit.INSTANCE;
                                            break;
                                        }
                                        case 15: {
                                            if (LintXmlConfiguration.readConfig$applies(this)) {
                                                Intrinsics.checkExpressionValueIsNotNull((Object)value, (String)"value");
                                                this.checkAllWarnings = LintXmlConfiguration.readConfig$asBoolean(value);
                                            }
                                            v0 = Unit.INSTANCE;
                                            break;
                                        }
                                        case 3: {
                                            if (LintXmlConfiguration.readConfig$applies(this)) {
                                                Intrinsics.checkExpressionValueIsNotNull((Object)value, (String)"value");
                                                this.ignoreWarnings = LintXmlConfiguration.readConfig$asBoolean(value);
                                            }
                                            v0 = Unit.INSTANCE;
                                            break;
                                        }
                                        case 13: {
                                            if (LintXmlConfiguration.readConfig$applies(this)) {
                                                Intrinsics.checkExpressionValueIsNotNull((Object)value, (String)"value");
                                                this.warningsAsErrors = LintXmlConfiguration.readConfig$asBoolean(value);
                                            }
                                            v0 = Unit.INSTANCE;
                                            break;
                                        }
                                        case 14: {
                                            if (LintXmlConfiguration.readConfig$applies(this)) {
                                                Intrinsics.checkExpressionValueIsNotNull((Object)value, (String)"value");
                                                this.fatalOnly = LintXmlConfiguration.readConfig$asBoolean(value);
                                            }
                                            v0 = Unit.INSTANCE;
                                            break;
                                        }
                                        case 5: {
                                            if (LintXmlConfiguration.readConfig$applies(this)) {
                                                Intrinsics.checkExpressionValueIsNotNull((Object)value, (String)"value");
                                                this.checkTestSources = LintXmlConfiguration.readConfig$asBoolean(value);
                                            }
                                            v0 = Unit.INSTANCE;
                                            break;
                                        }
                                        case 6: {
                                            if (LintXmlConfiguration.readConfig$applies(this)) {
                                                Intrinsics.checkExpressionValueIsNotNull((Object)value, (String)"value");
                                                this.ignoreTestSources = LintXmlConfiguration.readConfig$asBoolean(value);
                                            }
                                            v0 = Unit.INSTANCE;
                                            break;
                                        }
                                        case 11: {
                                            if (LintXmlConfiguration.readConfig$applies(this)) {
                                                Intrinsics.checkExpressionValueIsNotNull((Object)value, (String)"value");
                                                this.checkGeneratedSources = LintXmlConfiguration.readConfig$asBoolean(value);
                                            }
                                            v0 = Unit.INSTANCE;
                                            break;
                                        }
                                        case 10: {
                                            if (LintXmlConfiguration.readConfig$applies(this)) {
                                                Intrinsics.checkExpressionValueIsNotNull((Object)value, (String)"value");
                                                this.checkDependencies = LintXmlConfiguration.readConfig$asBoolean(value);
                                            }
                                            v0 = Unit.INSTANCE;
                                            break;
                                        }
                                        case 4: {
                                            if (LintXmlConfiguration.readConfig$applies(this)) {
                                                Intrinsics.checkExpressionValueIsNotNull((Object)value, (String)"value");
                                                this.explainIssues = LintXmlConfiguration.readConfig$asBoolean(value);
                                            }
                                            v0 = Unit.INSTANCE;
                                            break;
                                        }
                                        case 7: {
                                            if (LintXmlConfiguration.readConfig$applies(this)) {
                                                Intrinsics.checkExpressionValueIsNotNull((Object)value, (String)"value");
                                                this.applySuggestions = LintXmlConfiguration.readConfig$asBoolean(value);
                                            }
                                            v0 = Unit.INSTANCE;
                                            break;
                                        }
                                        case 12: {
                                            if (LintXmlConfiguration.readConfig$applies(this)) {
                                                Intrinsics.checkExpressionValueIsNotNull((Object)value, (String)"value");
                                                this.removeFixedBaselineIssues = LintXmlConfiguration.readConfig$asBoolean(value);
                                            }
                                            v0 = Unit.INSTANCE;
                                            break;
                                        }
                                        case 1: {
                                            if (LintXmlConfiguration.readConfig$applies(this)) {
                                                Intrinsics.checkExpressionValueIsNotNull((Object)value, (String)"value");
                                                this.abortOnError = LintXmlConfiguration.readConfig$asBoolean(value);
                                            }
                                            v0 = Unit.INSTANCE;
                                            break;
                                        }
                                        case 8: {
                                            if (this.getFileLevel()) {
                                                LintXmlConfiguration.reportError$default(this, "`lintJar` can only be specified for lint.xml files at the module level or higher", parser, null, null, null, 28, null);
                                            } else if (LintXmlConfiguration.readConfig$applies(this)) {
                                                Intrinsics.checkExpressionValueIsNotNull((Object)value, (String)"value");
                                                var16_47 /* !! */  = new char[]{';'};
                                                var16_47 /* !! */  = (char[])StringsKt.split$default((CharSequence)value, (char[])var16_47 /* !! */ , (boolean)false, (int)0, (int)6, null);
                                                var27_61 = this;
                                                $i$f$map = false;
                                                var18_52 = $this$map$iv;
                                                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                                $i$f$mapTo = false;
                                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                                    var23_57 = (String)item$iv$iv;
                                                    var28_62 = destination$iv$iv;
                                                    $i$a$-map-LintXmlConfiguration$readConfig$1 = false;
                                                    file = new File((String)path);
                                                    v1 = absolute = file.isAbsolute() != false ? file : new File(this.getConfigFile().getParentFile(), (String)path);
                                                    if (!absolute.exists()) {
                                                        LintXmlConfiguration.reportError$default(this, "lintJar " + absolute + " does not exist", null, null, null, null, 30, null);
                                                    }
                                                    var29_63 = absolute;
                                                    var28_62.add(var29_63);
                                                }
                                                var28_62 = (List)destination$iv$iv;
                                                var27_61.lintJars = CollectionsKt.toList((Iterable)var28_62);
                                            }
                                            v0 = Unit.INSTANCE;
                                            break;
                                        }
                                        default: lbl-1000:
                                        // 2 sources

                                        {
                                            LintXmlConfiguration.reportError$default(this, "Unexpected attribute `" + name + '`', parser, null, null, null, 28, null);
                                            v0 = Unit.INSTANCE;
                                        }
                                    }
                                } while (var11_24 < n);
lbl261:
                                // 2 sources

                                v2 = Unit.INSTANCE;
                                break;
                            }
                            case 2: {
                                n = parser.getAttributeCount();
                                severityString = "";
                                i = 0;
                                if (i >= n) ** GOTO lbl319
                                do {
                                    i = i++;
                                    name = parser.getAttributeName(i);
                                    value = parser.getAttributeValue(i);
                                    $this$map$iv = name;
                                    if ($this$map$iv == null) ** GOTO lbl-1000
                                    tmp = -1;
                                    switch ($this$map$iv.hashCode()) {
                                        case 1478300413: {
                                            if ($this$map$iv.equals("severity")) {
                                                tmp = 1;
                                            }
                                            break;
                                        }
                                        case 3365: {
                                            if ($this$map$iv.equals("in")) {
                                                tmp = 2;
                                            }
                                            break;
                                        }
                                        case 3355: {
                                            if ($this$map$iv.equals("id")) {
                                                tmp = 3;
                                            }
                                            break;
                                        }
                                    }
                                    switch (tmp) {
                                        case 2: {
                                            if (this.fileClients != null) {
                                                LintXmlConfiguration.reportError$default(this, "If you specify `in` on the root <lint> element you cannot specify it anywhere else", parser, null, null, null, 28, null);
                                            } else if (Intrinsics.areEqual((Object)value, (Object)"all")) {
                                                LintXmlConfiguration.reportError$default(this, "all not supported for in", parser, null, null, null, 28, null);
                                            }
                                            issueClients = value;
                                            v3 = Unit.INSTANCE;
                                            break;
                                        }
                                        case 3: {
                                            Intrinsics.checkExpressionValueIsNotNull((Object)value, (String)"value");
                                            idString = value;
                                            var17_49 = splitter.split((CharSequence)idString);
                                            Intrinsics.checkExpressionValueIsNotNull((Object)var17_49, (String)"splitter.split(idString)");
                                            idList = var17_49;
                                            v3 = Unit.INSTANCE;
                                            break;
                                        }
                                        case 1: {
                                            Intrinsics.checkExpressionValueIsNotNull((Object)value, (String)"value");
                                            severityString = value;
                                            v3 = Unit.INSTANCE;
                                            break;
                                        }
                                        default: lbl-1000:
                                        // 2 sources

                                        {
                                            LintXmlConfiguration.reportError$default(this, "Unexpected attribute `" + name + "`, expected `id`, `in` or `severity`", parser, null, null, null, 28, null);
                                            v3 = Unit.INSTANCE;
                                        }
                                    }
                                } while (i < n);
lbl319:
                                // 2 sources

                                i = idString;
                                var13_34 = false;
                                if (i.length() == 0) {
                                    LintXmlConfiguration.reportError$default(this, "Missing required issue `id` attribute", parser, null, null, null, 28, null);
                                } else {
                                    i = severityString;
                                    var13_34 = false;
                                    if (i.length() > 0) {
                                        var13_35 = Severity.Companion.fromName(severityString);
                                        v4 = var13_35 == null ? (Intrinsics.areEqual((Object)severityString, (Object)"hide") || Intrinsics.areEqual((Object)severityString, (Object)"hidden") ? Severity.IGNORE : (Intrinsics.areEqual((Object)severityString, (Object)"info") || Intrinsics.areEqual((Object)severityString, (Object)"information") ? Severity.INFORMATIONAL : null)) : (severity = var13_35);
                                        if (severity != null) {
                                            this.addSeverity((Iterable<String>)idList, severity, this.fileClients, (String)issueClients);
                                        } else {
                                            LintXmlConfiguration.reportError$default(this, "Unknown severity `" + severityString + '`', parser, null, null, null, 28, null);
                                        }
                                    }
                                }
                                v2 = Unit.INSTANCE;
                                break;
                            }
                            case 3: {
                                n = parser.getAttributeCount();
                                if (parser.getDepth() < 3) {
                                    LintXmlConfiguration.reportError$default(this, "`<ignore>` tag should be nested within `<issue>`", parser, null, null, null, 28, null);
                                } else {
                                    path = "";
                                    regexp = "";
                                    var13_36 = 0;
                                    if (var13_36 < n) {
                                        do {
                                            i = var13_36++;
                                            name = parser.getAttributeName(i);
                                            value = parser.getAttributeValue(i);
                                            var17_50 = name;
                                            if (Intrinsics.areEqual((Object)var17_50, (Object)"path")) {
                                                Intrinsics.checkExpressionValueIsNotNull((Object)value, (String)"value");
                                                path = value;
                                                continue;
                                            }
                                            if (Intrinsics.areEqual((Object)var17_50, (Object)"regexp")) {
                                                Intrinsics.checkExpressionValueIsNotNull((Object)value, (String)"value");
                                                regexp = value;
                                                continue;
                                            }
                                            LintXmlConfiguration.reportError$default(this, "Unexpected attribute `" + name + "`, expected `path` or `regexp`", parser, null, null, null, 28, null);
                                        } while (var13_36 < n);
                                    }
                                    var13_37 = path;
                                    i = false;
                                    if (var13_37.length() == 0) {
                                        var13_37 = regexp;
                                        i = false;
                                        if (var13_37.length() == 0) {
                                            LintXmlConfiguration.reportError$default(this, "Missing required attribute `path` or `regexp`", parser, null, null, null, 28, null);
                                        } else {
                                            this.addRegexp(parser, idString, (Iterable<String>)idList, n, regexp, this.fileClients, (String)issueClients);
                                        }
                                    } else {
                                        v5 = path = File.separatorChar == '/' ? StringsKt.replace$default((String)path, (char)'\\', (char)'/', (boolean)false, (int)4, null) : StringsKt.replace$default((String)path, (char)'/', (char)File.separatorChar, (boolean)false, (int)4, null);
                                        if (StringsKt.indexOf$default((CharSequence)path, (char)'*', (int)0, (boolean)false, (int)6, null) != -1) {
                                            var13_37 = SdkUtils.globToRegexp((String)path);
                                            Intrinsics.checkExpressionValueIsNotNull((Object)var13_37, (String)"globToRegexp(path)");
                                            this.addRegexp(parser, idString, (Iterable<String>)idList, n, (String)var13_37, this.fileClients, (String)issueClients);
                                        } else {
                                            this.addPaths((Iterable<String>)idList, n, path, this.fileClients, (String)issueClients);
                                        }
                                    }
                                }
                                v2 = Unit.INSTANCE;
                                break;
                            }
                            case 4: {
                                n = parser.getAttributeCount();
                                if (parser.getDepth() >= 3) ** GOTO lbl383
                                LintXmlConfiguration.reportError$default(this, "`<option>` tag should be nested within `<issue>`", parser, null, null, null, 28, null);
                                ** GOTO lbl411
lbl383:
                                // 1 sources

                                optionKey = "";
                                optionValue = "";
                                var13_38 = 0;
                                if (var13_38 < n) {
                                    do {
                                        i = var13_38++;
                                        name = parser.getAttributeName(i);
                                        value = parser.getAttributeValue(i);
                                        var17_51 = name;
                                        if (Intrinsics.areEqual((Object)var17_51, (Object)"name")) {
                                            Intrinsics.checkExpressionValueIsNotNull((Object)value, (String)"value");
                                            optionKey = value;
                                            continue;
                                        }
                                        if (Intrinsics.areEqual((Object)var17_51, (Object)"value")) {
                                            Intrinsics.checkExpressionValueIsNotNull((Object)value, (String)"value");
                                            optionValue = value;
                                            continue;
                                        }
                                        LintXmlConfiguration.reportError$default(this, "Unexpected attribute `" + name + "`, expected `name` or `value`", parser, null, null, null, 28, null);
                                    } while (var13_38 < n);
                                }
                                var13_39 = optionKey;
                                var14_45 = false;
                                if (var13_39.length() == 0) ** GOTO lbl-1000
                                var13_39 = optionValue;
                                var14_45 = false;
                                if (var13_39.length() == 0) lbl-1000:
                                // 2 sources

                                {
                                    LintXmlConfiguration.reportError$default(this, "Must specify both name and value in <option>", parser, null, null, null, 28, null);
                                } else {
                                    this.addOption((Iterable<String>)idList, optionKey, optionValue, this.fileClients, (String)issueClients);
                                }
lbl411:
                                // 3 sources

                                v2 = Unit.INSTANCE;
                                break;
                            }
                            default: lbl-1000:
                            // 2 sources

                            {
                                LintXmlConfiguration.reportError$default(this, "Unsupported tag <`" + parser.getName() + "`>, expected one of `lint`, `issue`, `ignore` or `option`", parser, null, null, null, 28, null);
                                v2 = Unit.INSTANCE;
                            }
                        }
                        break;
                    }
                    case 3: {
                        if (!Intrinsics.areEqual((Object)parser.getName(), (Object)"issue")) break;
                        issueClients = null;
                        idString = "";
                        idList = CollectionsKt.emptyList();
                    }
                }
            }
        }
        catch (IOException e) {
            this.getClient().log(e, null, new Object[0]);
        }
        catch (XmlPullParserException e) {
            splitter = e.getMessage();
            detail = splitter == null ? "" : splitter;
            index = StringsKt.indexOf$default((CharSequence)detail, (String)" (position:", (int)0, (boolean)false, (int)6, null);
            v6 = new StringBuilder().append("Failed parsing ").append((Object)this.configFile.getName()).append(": ");
            if (index != -1) {
                idList = detail;
                issueClients = 0;
                var8_15 = false;
                v7 = idList.substring(issueClients, index);
                v8 = v7;
                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            } else {
                v8 = detail;
            }
            message = v6.append(v8).toString();
            LintXmlConfiguration.reportError$default(this, message, null, e, null, null, 26, null);
        }
        if ((clientMaps = this.clientIssueMaps) != null) {
            var4_8 = false;
            list = new ArrayList<E>();
            for (Map.Entry<String, Map<String, IssueData>> var5_11 : clientMaps.entrySet()) {
                issueClients = var5_11;
                var8_16 = false;
                key = issueClients.getKey();
                var8_17 = var5_11;
                var9_21 = false;
                map = var8_17.getValue();
                if (!this.isApplicableClient(key, true, false)) continue;
                list.add(map);
            }
            list.add(issueMap);
            for (Map.Entry<String, Map<String, IssueData>> var5_11 : clientMaps.entrySet()) {
                map = var5_11;
                var8_18 = false;
                key = (String)map.getKey();
                var8_19 = var5_11;
                var9_22 = false;
                map = var8_19.getValue();
                if (!this.isApplicableClient(key, false, true)) continue;
                list.add(map);
            }
            this.issueMaps = list;
        } else {
            this.issueMaps = CollectionsKt.listOf((Object)issueMap);
        }
    }

    private final boolean isApplicableClient(String client, boolean checkEquals, boolean checkOther) {
        Object object = client;
        if (object == null) {
            return true;
        }
        if (StringsKt.contains$default((CharSequence)client, (char)',', (boolean)false, (int)2, null)) {
            String[] stringArray = new String[]{","};
            object = StringsKt.splitToSequence$default((CharSequence)client, (String[])stringArray, (boolean)false, (int)0, (int)6, null).iterator();
            while (object.hasNext()) {
                String c;
                String string = c = (String)object.next();
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                if (!this.isApplicableClient(((Object)StringsKt.trim((CharSequence)string2)).toString(), checkEquals, checkOther)) continue;
                return true;
            }
        }
        String host = LintClient.Companion.getClientName();
        if (checkEquals && StringsKt.equals((String)client, (String)host, (boolean)true)) {
            return true;
        }
        return checkOther && StringsKt.startsWith$default((String)client, (String)"!", (boolean)false, (int)2, null) && !StringsKt.regionMatches((String)client, (int)1, (String)host, (int)0, (int)host.length(), (boolean)true);
    }

    static /* synthetic */ boolean isApplicableClient$default(LintXmlConfiguration lintXmlConfiguration, String string, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: isApplicableClient");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        return lintXmlConfiguration.isApplicableClient(string, bl, bl2);
    }

    private final void addSeverity(Iterable<String> idList, Severity severity, String fileClients, String issueClients) {
        String string = issueClients;
        Map<String, IssueData> issueMap = this.getOrCreateIssueMap((String)(string == null ? fileClients : string));
        for (String id : idList) {
            IssueData issueData;
            IssueData issueData2 = issueMap.get(id);
            if (issueData2 == null) {
                IssueData issueData3 = new IssueData(null, null, null, null, 15, null);
                boolean bl = false;
                boolean bl2 = false;
                IssueData it = issueData3;
                boolean bl3 = false;
                Map<String, IssueData> map = issueMap;
                boolean bl4 = false;
                map.put(id, it);
                issueData = issueData3;
            } else {
                issueData = issueData2;
            }
            IssueData data = issueData;
            data.setSeverity(severity);
        }
    }

    private final void addPaths(Iterable<String> ids, int n, String path2, String fileClients, String issueClients) {
        String string = issueClients;
        Map<String, IssueData> issueMap = this.getOrCreateIssueMap((String)(string == null ? fileClients : string));
        for (String id : ids) {
            List list2;
            Object object;
            boolean bl;
            Object object2;
            IssueData issueData = issueMap.get(id);
            if (issueData == null) {
                object2 = new IssueData(null, null, null, null, 15, null);
                boolean bl2 = false;
                bl = false;
                Object it = object2;
                boolean bl3 = false;
                Map<String, IssueData> map = issueMap;
                boolean bl4 = false;
                map.put(id, (IssueData)it);
                object = object2;
            } else {
                object = issueData;
            }
            IssueData data = object;
            object2 = data.getPaths();
            if (object2 == null) {
                ArrayList arrayList = new ArrayList(n / 2 + 1);
                bl = false;
                boolean bl5 = false;
                ArrayList it = arrayList;
                boolean bl6 = false;
                data.setPaths(it);
                list2 = arrayList;
            } else {
                list2 = object2;
            }
            List paths = list2;
            paths.add((String)path2);
        }
    }

    private final void addRegexp(XmlPullParser parser, String idList, Iterable<String> ids, int n, String regexp, String fileClients, String issueClients) {
        try {
            String string = issueClients;
            Map<String, IssueData> issueMap = this.getOrCreateIssueMap(string == null ? fileClients : string);
            Pattern pattern = Pattern.compile(regexp);
            for (String id : ids) {
                List list2;
                Object object;
                boolean bl;
                Object object2;
                IssueData issueData = issueMap.get(id);
                if (issueData == null) {
                    object2 = new IssueData(null, null, null, null, 15, null);
                    boolean bl2 = false;
                    bl = false;
                    Object it = object2;
                    boolean bl3 = false;
                    Map<String, IssueData> map = issueMap;
                    boolean bl4 = false;
                    map.put(id, (IssueData)it);
                    object = object2;
                } else {
                    object = issueData;
                }
                IssueData data = object;
                object2 = data.getPatterns();
                if (object2 == null) {
                    ArrayList arrayList = new ArrayList(n / 2 + 1);
                    bl = false;
                    boolean bl5 = false;
                    ArrayList it = arrayList;
                    boolean bl6 = false;
                    data.setPatterns(it);
                    list2 = arrayList;
                } else {
                    list2 = object2;
                }
                List paths = list2;
                Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"pattern");
                paths.add((Pattern)pattern);
            }
        }
        catch (PatternSyntaxException e) {
            LintXmlConfiguration.reportError$default(this, "Invalid pattern `" + regexp + "` under `" + idList + "`: " + e.getDescription(), parser, null, null, null, 28, null);
        }
    }

    private final void addOption(Iterable<String> ids, String key, String value, String fileClients, String issueClients) {
        String string = issueClients;
        Map<String, IssueData> issueMap = this.getOrCreateIssueMap((String)(string == null ? fileClients : string));
        for (String id : ids) {
            Map options;
            Map map;
            Object object;
            boolean bl;
            boolean bl2;
            Map map2;
            IssueData issueData = issueMap.get(id);
            if (issueData == null) {
                map2 = new IssueData(null, null, null, null, 15, null);
                bl2 = false;
                bl = false;
                Map it = map2;
                boolean bl3 = false;
                Map<String, IssueData> map3 = issueMap;
                boolean bl4 = false;
                map3.put(id, (IssueData)((Object)it));
                object = map2;
            } else {
                object = issueData;
            }
            IssueData data = object;
            map2 = data.getOptions();
            if (map2 == null) {
                LinkedHashMap linkedHashMap = new LinkedHashMap();
                bl = false;
                boolean bl5 = false;
                LinkedHashMap it = linkedHashMap;
                boolean bl6 = false;
                data.setOptions(it);
                map = linkedHashMap;
            } else {
                map = map2;
            }
            map2 = options = map;
            bl2 = false;
            map2.put((String)key, (String)value);
        }
    }

    static /* synthetic */ void addOption$default(LintXmlConfiguration lintXmlConfiguration, Iterable iterable, String string, String string2, String string3, String string4, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addOption");
        }
        if ((n & 8) != 0) {
            string3 = null;
        }
        if ((n & 0x10) != 0) {
            string4 = null;
        }
        lintXmlConfiguration.addOption(iterable, string, string2, string3, string4);
    }

    @Nullable
    public final Boolean getCheckAllWarnings() {
        this.ensureInitialized();
        return this.checkAllWarnings;
    }

    @Nullable
    public final Boolean getIgnoreWarnings() {
        this.ensureInitialized();
        return this.ignoreWarnings;
    }

    @Nullable
    public final Boolean getWarningsAsErrors() {
        this.ensureInitialized();
        return this.warningsAsErrors;
    }

    @Nullable
    public final Boolean getFatalOnly() {
        this.ensureInitialized();
        return this.fatalOnly;
    }

    @Nullable
    public final Boolean getCheckTestSources() {
        this.ensureInitialized();
        return this.checkTestSources;
    }

    @Nullable
    public final Boolean getIgnoreTestSources() {
        this.ensureInitialized();
        return this.ignoreTestSources;
    }

    @Nullable
    public final Boolean getCheckGeneratedSources() {
        this.ensureInitialized();
        return this.checkGeneratedSources;
    }

    @Nullable
    public final Boolean getCheckDependencies() {
        this.ensureInitialized();
        return this.checkDependencies;
    }

    @Nullable
    public final Boolean getExplainIssues() {
        this.ensureInitialized();
        return this.explainIssues;
    }

    @Nullable
    public final Boolean getApplySuggestions() {
        this.ensureInitialized();
        return this.applySuggestions;
    }

    @Nullable
    public final Boolean getRemoveFixedBaselineIssues() {
        this.ensureInitialized();
        return this.removeFixedBaselineIssues;
    }

    @Nullable
    public final Boolean getAbortOnError() {
        this.ensureInitialized();
        return this.abortOnError;
    }

    @Override
    @NotNull
    public List<File> getLintJars() {
        List<File> list2;
        this.ensureInitialized();
        List<File> list3 = this.getParent();
        List<File> list4 = list2 = list3 == null ? null : ((Configuration)((Object)list3)).getLintJars();
        if (list2 == null) {
            list3 = this.lintJars;
            return list3 == null ? CollectionsKt.emptyList() : list3;
        }
        List<File> inheritedJars = list2;
        list3 = this.lintJars;
        if (list3 == null) {
            return inheritedJars;
        }
        List<File> jars = list3;
        return CollectionsKt.plus((Collection)jars, (Iterable)inheritedJars);
    }

    /*
     * Could not resolve type clashes
     */
    private final void writeConfig() {
        try {
            boolean ok;
            Unit unit;
            Unit unit2;
            Unit unit3;
            Unit unit4;
            Unit unit5;
            Unit unit6;
            Unit unit7;
            Unit unit8;
            Unit unit9;
            Unit unit10;
            Unit unit11;
            Unit unit12;
            Unit unit13;
            Object path2;
            Unit unit14;
            boolean bl;
            boolean bl2;
            List<? extends File> list2;
            Unit unit15;
            this.ensureInitialized();
            File file = new File(this.configFile.getParentFile(), Intrinsics.stringPlus((String)this.configFile.getName(), (Object)".new"));
            Writer writer = new BufferedWriter(new FileWriter(file));
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<");
            writer.write(TAG_LINT);
            Object object = this.fileClients;
            if (object == null) {
                unit15 = null;
            } else {
                list2 = object;
                bl2 = false;
                bl = false;
                String it = list2;
                boolean bl3 = false;
                this.writeAttribute(writer, ATTR_IN, it);
                unit15 = Unit.INSTANCE;
            }
            object = this.getBaselineFile();
            if (object == null) {
                unit14 = null;
            } else {
                list2 = object;
                bl2 = false;
                bl = false;
                List<? extends File> baselineFile = list2;
                boolean bl4 = false;
                writer.write(" baseline=\"");
                String string = Project.getRelativePath(this.getConfigFile().getParentFile(), (File)((Object)baselineFile));
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"getRelativePath(configFile.parentFile, baselineFile)");
                path2 = string;
                this.writeAttribute(writer, ATTR_BASELINE, StringsKt.replace$default((String)path2, (char)'\\', (char)'/', (boolean)false, (int)4, null));
                unit14 = Unit.INSTANCE;
            }
            object = this.checkAllWarnings;
            if (object == null) {
                unit13 = null;
            } else {
                list2 = object;
                bl2 = false;
                bl = false;
                boolean it = (Boolean)((Object)list2);
                boolean bl5 = false;
                this.writeAttribute(writer, "checkAllWarnings", String.valueOf(it));
                unit13 = Unit.INSTANCE;
            }
            object = this.ignoreWarnings;
            if (object == null) {
                unit12 = null;
            } else {
                list2 = object;
                bl2 = false;
                bl = false;
                boolean it = (Boolean)((Object)list2);
                boolean bl6 = false;
                this.writeAttribute(writer, "ignoreWarnings", String.valueOf(it));
                unit12 = Unit.INSTANCE;
            }
            object = this.warningsAsErrors;
            if (object == null) {
                unit11 = null;
            } else {
                list2 = object;
                bl2 = false;
                bl = false;
                boolean it = (Boolean)((Object)list2);
                boolean bl7 = false;
                this.writeAttribute(writer, "warningsAsErrors", String.valueOf(it));
                unit11 = Unit.INSTANCE;
            }
            object = this.fatalOnly;
            if (object == null) {
                unit10 = null;
            } else {
                list2 = object;
                bl2 = false;
                bl = false;
                boolean it = (Boolean)((Object)list2);
                boolean bl8 = false;
                this.writeAttribute(writer, "fatalOnly", String.valueOf(it));
                unit10 = Unit.INSTANCE;
            }
            object = this.checkTestSources;
            if (object == null) {
                unit9 = null;
            } else {
                list2 = object;
                bl2 = false;
                bl = false;
                boolean it = (Boolean)((Object)list2);
                boolean bl9 = false;
                this.writeAttribute(writer, "checkTestSources", String.valueOf(it));
                unit9 = Unit.INSTANCE;
            }
            object = this.ignoreTestSources;
            if (object == null) {
                unit8 = null;
            } else {
                list2 = object;
                bl2 = false;
                bl = false;
                boolean it = (Boolean)((Object)list2);
                boolean bl10 = false;
                this.writeAttribute(writer, "ignoreTestSources", String.valueOf(it));
                unit8 = Unit.INSTANCE;
            }
            object = this.checkGeneratedSources;
            if (object == null) {
                unit7 = null;
            } else {
                list2 = object;
                bl2 = false;
                bl = false;
                boolean it = (Boolean)((Object)list2);
                boolean bl11 = false;
                this.writeAttribute(writer, "checkGeneratedSources", String.valueOf(it));
                unit7 = Unit.INSTANCE;
            }
            object = this.checkDependencies;
            if (object == null) {
                unit6 = null;
            } else {
                list2 = object;
                bl2 = false;
                bl = false;
                boolean it = (Boolean)((Object)list2);
                boolean bl12 = false;
                this.writeAttribute(writer, "checkDependencies", String.valueOf(it));
                unit6 = Unit.INSTANCE;
            }
            object = this.explainIssues;
            if (object == null) {
                unit5 = null;
            } else {
                list2 = object;
                bl2 = false;
                bl = false;
                boolean it = (Boolean)((Object)list2);
                boolean bl13 = false;
                this.writeAttribute(writer, "explainIssues", String.valueOf(it));
                unit5 = Unit.INSTANCE;
            }
            object = this.applySuggestions;
            if (object == null) {
                unit4 = null;
            } else {
                list2 = object;
                bl2 = false;
                bl = false;
                boolean it = (Boolean)((Object)list2);
                boolean bl14 = false;
                this.writeAttribute(writer, "applySuggestions", String.valueOf(it));
                unit4 = Unit.INSTANCE;
            }
            object = this.removeFixedBaselineIssues;
            if (object == null) {
                unit3 = null;
            } else {
                list2 = object;
                bl2 = false;
                bl = false;
                boolean it = (Boolean)((Object)list2);
                boolean bl15 = false;
                this.writeAttribute(writer, "removeFixedBaselineIssues", String.valueOf(it));
                unit3 = Unit.INSTANCE;
            }
            object = this.abortOnError;
            if (object == null) {
                unit2 = null;
            } else {
                list2 = object;
                bl2 = false;
                bl = false;
                boolean it = (Boolean)((Object)list2);
                boolean bl16 = false;
                this.writeAttribute(writer, "abortOnError", String.valueOf(it));
                unit2 = Unit.INSTANCE;
            }
            object = this.lintJars;
            if (object == null) {
                unit = null;
            } else {
                list2 = object;
                bl2 = false;
                bl = false;
                List<? extends File> it = list2;
                boolean bl17 = false;
                this.writeAttribute(writer, "lintJars", CollectionsKt.joinToString$default((Iterable)it, (CharSequence)";", null, null, (int)0, null, (Function1)((Function1)new Function1<File, CharSequence>(this){
                    final /* synthetic */ LintXmlConfiguration this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final CharSequence invoke(@NotNull File f) {
                        CharSequence charSequence;
                        String string;
                        Intrinsics.checkParameterIsNotNull((Object)f, (String)"f");
                        String lintPath = f.getPath();
                        Object object = this.this$0.getConfigFile().getParentFile();
                        String xmlPath = object == null ? "" : ((string = ((File)object).getPath()) == null ? "" : string);
                        Intrinsics.checkExpressionValueIsNotNull((Object)lintPath, (String)"lintPath");
                        if (StringsKt.startsWith$default((String)lintPath, (String)xmlPath, (boolean)false, (int)2, null) && !Intrinsics.areEqual((Object)lintPath, (Object)xmlPath) && lintPath.charAt(xmlPath.length()) == File.separatorChar) {
                            object = lintPath;
                            int n = xmlPath.length() + 1;
                            boolean bl = false;
                            String string2 = ((String)object).substring(n);
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                            charSequence = StringsKt.replace$default((String)string2, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
                        } else {
                            charSequence = StringsKt.replace$default((String)lintPath, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
                        }
                        return charSequence;
                    }
                }), (int)30, null));
                unit = Unit.INSTANCE;
            }
            writer.write(">\n");
            for (Map issueMap : this.getIssueMaps()) {
                boolean bl18;
                Iterator<Object> iterator;
                boolean bl19;
                Object $dstr$_u24__u24$v;
                String string;
                Set<Map.Entry<String, Map<String, IssueData>>> set;
                if (issueMap.isEmpty()) continue;
                Map<String, Map<String, IssueData>> map = this.clientIssueMaps;
                Set<Map.Entry<String, Map<String, IssueData>>> set2 = set = map == null ? null : map.entrySet();
                if (set == null) {
                    string = null;
                } else {
                    Object v17;
                    block54: {
                        Iterable $this$firstOrNull$iv = set;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            $dstr$_u24__u24$v = (Map.Entry)element$iv;
                            bl19 = false;
                            iterator = $dstr$_u24__u24$v;
                            bl18 = false;
                            Map v = (Map)iterator.getValue();
                            if (!Intrinsics.areEqual((Object)v, (Object)issueMap)) continue;
                            v17 = element$iv;
                            break block54;
                        }
                        v17 = null;
                    }
                    map = v17;
                    string = map == null ? null : (String)map.getKey();
                }
                String client = string;
                Sequence ids = SequencesKt.sorted((Sequence)CollectionsKt.asSequence((Iterable)issueMap.keySet()));
                for (String id : ids) {
                    block58: {
                        Map<String, String> options;
                        List<String> paths;
                        List<Pattern> regexps;
                        block56: {
                            block57: {
                                block55: {
                                    Object data;
                                    path2 = (IssueData)issueMap.get(id);
                                    if (path2 == null || ((IssueData)(data = path2)).isEmpty()) continue;
                                    writer.write("    <");
                                    writer.write(TAG_ISSUE);
                                    if (client != null) {
                                        this.writeAttribute(writer, ATTR_IN, client);
                                    }
                                    this.writeAttribute(writer, ATTR_ID, id);
                                    Severity severity = ((IssueData)data).getSeverity();
                                    if (severity != null) {
                                        Object element$iv;
                                        element$iv = severity.name();
                                        $dstr$_u24__u24$v = Locale.ROOT;
                                        Intrinsics.checkExpressionValueIsNotNull((Object)$dstr$_u24__u24$v, (String)"ROOT");
                                        bl19 = false;
                                        iterator = element$iv;
                                        bl18 = false;
                                        Map<String, String> map2 = iterator;
                                        if (map2 == null) {
                                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                                        }
                                        String string2 = ((String)((Object)map2)).toLowerCase((Locale)$dstr$_u24__u24$v);
                                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toLowerCase(locale)");
                                        this.writeAttribute(writer, ATTR_SEVERITY, string2);
                                    }
                                    regexps = ((IssueData)data).getPatterns();
                                    paths = ((IssueData)data).getPaths();
                                    options = ((IssueData)data).getOptions();
                                    if (paths == null) break block55;
                                    iterator = paths;
                                    bl18 = false;
                                    if (!iterator.isEmpty()) break block56;
                                }
                                if (regexps == null) break block57;
                                iterator = regexps;
                                bl18 = false;
                                if (!iterator.isEmpty()) break block56;
                            }
                            if (options == null) break block58;
                            iterator = options;
                            bl18 = false;
                            if (!(!iterator.isEmpty())) break block58;
                        }
                        writer.write(62);
                        writer.write(10);
                        if (options != null) {
                            Map<String, String> map3 = options;
                            boolean bl20 = false;
                            for (Map.Entry option : map3.entrySet()) {
                                writer.write("        <");
                                writer.write(TAG_OPTION);
                                this.writeAttribute(writer, ATTR_NAME, (String)option.getKey());
                                this.writeAttribute(writer, ATTR_VALUE, (String)option.getValue());
                                writer.write(" />\n");
                            }
                        }
                        if (paths != null) {
                            for (String path3 : paths) {
                                writer.write("        <");
                                writer.write(TAG_IGNORE);
                                this.writeAttribute(writer, ATTR_PATH, StringsKt.replace$default((String)path3, (char)'\\', (char)'/', (boolean)false, (int)4, null));
                                writer.write(" />\n");
                            }
                        }
                        if (regexps != null) {
                            for (Pattern regexp : regexps) {
                                writer.write("        <");
                                writer.write(TAG_IGNORE);
                                String string3 = regexp.pattern();
                                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"regexp.pattern()");
                                this.writeAttribute(writer, ATTR_REGEXP, string3);
                                writer.write(" />\n");
                            }
                        }
                        writer.write("    </");
                        writer.write(TAG_ISSUE);
                        writer.write(62);
                        writer.write(10);
                        continue;
                    }
                    writer.write(" />\n");
                }
            }
            writer.write("</lint>");
            writer.close();
            File oldFile = new File(this.configFile.getParentFile(), Intrinsics.stringPlus((String)this.configFile.getName(), (Object)"~"));
            if (oldFile.exists()) {
                oldFile.delete();
            }
            if (this.configFile.exists()) {
                this.configFile.renameTo(oldFile);
            }
            if ((ok = file.renameTo(this.configFile)) && oldFile.exists()) {
                oldFile.delete();
            }
        }
        catch (Exception e) {
            this.getClient().log(e, null, new Object[0]);
        }
    }

    private final void writeAttribute(Writer writer, String name, String value) {
        writer.write(32);
        writer.write(name);
        writer.write(61);
        writer.write(34);
        writer.write(value);
        writer.write(34);
    }

    @Override
    public void ignore(@NotNull Context context2, @NotNull Issue issue, @Nullable Location location, @NotNull String message2) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)TAG_ISSUE);
        Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
        if (location != null) {
            this.ignore(issue, location.getFile());
        }
    }

    @Override
    public void ignore(@NotNull Issue issue, @NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)TAG_ISSUE);
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.ignore(issue.getId(), file);
    }

    @Override
    public void ignore(@NotNull String issueId, @NotNull File file) {
        List list2;
        Object object;
        boolean bl;
        Object object2;
        Intrinsics.checkParameterIsNotNull((Object)issueId, (String)"issueId");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Map<String, IssueData> issueMap = this.getPrimaryIssueMap();
        String string = Project.getRelativePath(this.configFile.getParentFile(), file);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"getRelativePath(configFile.parentFile, file)");
        String path2 = string;
        IssueData issueData = issueMap.get(issueId);
        if (issueData == null) {
            object2 = new IssueData(null, null, null, null, 15, null);
            boolean bl2 = false;
            bl = false;
            Object it = object2;
            boolean bl3 = false;
            Map<String, IssueData> map = issueMap;
            boolean bl4 = false;
            map.put(issueId, (IssueData)it);
            object = object2;
        } else {
            object = issueData;
        }
        IssueData data = object;
        object2 = data.getPaths();
        if (object2 == null) {
            ArrayList arrayList = new ArrayList();
            bl = false;
            boolean bl5 = false;
            ArrayList it = arrayList;
            boolean bl6 = false;
            data.setPaths(it);
            list2 = arrayList;
        } else {
            list2 = object2;
        }
        List paths = list2;
        paths.add((String)path2);
        CollectionsKt.sort(paths);
        if (!this.bulkEditing) {
            this.writeConfig();
        }
    }

    @Override
    public void setSeverity(@NotNull Issue issue, @Nullable Severity severity) {
        IssueData issueData;
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)TAG_ISSUE);
        Map<String, IssueData> issueMap = this.getPrimaryIssueMap();
        String id = issue.getId();
        IssueData issueData2 = issueMap.get(id);
        if (issueData2 == null) {
            IssueData issueData3 = new IssueData(null, null, null, null, 15, null);
            boolean bl = false;
            boolean bl2 = false;
            IssueData it = issueData3;
            boolean bl3 = false;
            Map<String, IssueData> map = issueMap;
            boolean bl4 = false;
            map.put(id, it);
            issueData = issueData3;
        } else {
            issueData = issueData2;
        }
        IssueData data = issueData;
        data.setSeverity(severity);
        if (!this.bulkEditing) {
            this.writeConfig();
        }
    }

    @Override
    public void startBulkEditing() {
        this.bulkEditing = true;
    }

    @Override
    public void finishBulkEditing() {
        this.bulkEditing = false;
        this.writeConfig();
    }

    @Override
    @Nullable
    public File getBaselineFile() {
        return this._baselineFile;
    }

    @Override
    public void setBaselineFile(@Nullable File value) {
        File dir;
        this._baselineFile = value != null && !value.isAbsolute() ? ((dir = this.configFile.getParentFile()) != null ? new File(dir, value.getPath()) : value) : value;
    }

    @Override
    public void validateIssueIds(@NotNull LintClient client, @NotNull LintDriver driver, @Nullable Project project, @NotNull IssueRegistry registry) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)driver, (String)"driver");
        Intrinsics.checkParameterIsNotNull((Object)registry, (String)"registry");
        Object object = this.getParent();
        if (object != null) {
            ((Configuration)object).validateIssueIds(client, driver, project, registry);
        }
        if (this.validated) {
            return;
        }
        this.validated = true;
        object = this.getIssueMaps().iterator();
        while (object.hasNext()) {
            Map map;
            Map map2 = map = (Map)object.next();
            boolean bl = false;
            if (!(!map2.isEmpty())) continue;
            Map map3 = map2 = TypeIntrinsics.isMutableMap((Object)map) ? map : null;
            if (map2 == null) continue;
            this.validateIssueIds(client, driver, project, registry, map);
        }
    }

    private final void validateIssueIds(LintClient client, LintDriver driver, Project project, IssueRegistry registry, Map<String, IssueData> map) {
        for (String id : CollectionsKt.toList((Iterable)map.keySet())) {
            IssueData issueData;
            if (Intrinsics.areEqual((Object)id, (Object)VALUE_ALL)) continue;
            Issue issue = registry.getIssue(id);
            if (issue == null) {
                if (registry.isCategoryName(id)) continue;
                this.reportNonExistingIssueId(client, driver, registry, project, id);
                continue;
            }
            if (Intrinsics.areEqual((Object)issue.getId(), (Object)id) || (issueData = map.get(id)) == null) continue;
            IssueData data = issueData;
            IssueData merge = map.get(issue.getId());
            if (merge == null) {
                Map<String, IssueData> map2 = map;
                String string = issue.getId();
                boolean bl = false;
                map2.put(string, data);
                map.remove(id);
                continue;
            }
            merge.plusAssign(data);
        }
        Configuration configuration = this.getParent();
        if (configuration != null) {
            configuration.validateIssueIds(client, driver, project, registry);
        }
    }

    @NotNull
    public String toString() {
        String path2 = PathVariables.toPathString$default((PathVariables)this.getConfigurations().getClient().getPathVariables(), (File)this.configFile, null, (boolean)false, (int)6, null);
        return this.getClass().getSimpleName() + '(' + path2 + ')';
    }

    private static final Boolean readConfig$asBoolean(String $this$readConfig_u24asBoolean) {
        return Intrinsics.areEqual((Object)$this$readConfig_u24asBoolean, (Object)"true") ? Boolean.valueOf(true) : (Intrinsics.areEqual((Object)$this$readConfig_u24asBoolean, (Object)"false") ? Boolean.valueOf(false) : null);
    }

    private static final boolean readConfig$applies(LintXmlConfiguration this$0) {
        return LintXmlConfiguration.isApplicableClient$default(this$0, this$0.fileClients, false, false, 6, null);
    }

    @JvmStatic
    @NotNull
    public static final LintXmlConfiguration create(@NotNull ConfigurationHierarchy configurations, @NotNull File lintFile) {
        return Companion.create(configurations, lintFile);
    }

    public static final /* synthetic */ boolean access$isPathIgnored(LintXmlConfiguration $this, IssueData issueData, Location location, Context context2) {
        return $this.isPathIgnored(issueData, location, context2);
    }

    public static final /* synthetic */ boolean access$isPatternIgnored(LintXmlConfiguration $this, IssueData issueData, String message2, Location location, Context context2) {
        return $this.isPatternIgnored(issueData, message2, location, context2);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BM\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0005\u0012\u0016\b\u0002\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u000b\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0011\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u00c6\u0003J\u0011\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0005H\u00c6\u0003J\u0017\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\nH\u00c6\u0003JQ\u0010\u001e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00052\u0016\b\u0002\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\nH\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\u0006\u0010$\u001a\u00020 J\u0011\u0010%\u001a\u00020&2\u0006\u0010!\u001a\u00020\u0000H\u0086\u0002J\b\u0010'\u001a\u00020\u0006H\u0016R(\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\"\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\"\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0011\"\u0004\b\u0015\u0010\u0013R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006("}, d2={"Lcom/android/tools/lint/client/api/LintXmlConfiguration$IssueData;", "", "severity", "Lcom/android/tools/lint/detector/api/Severity;", "paths", "", "", "patterns", "Ljava/util/regex/Pattern;", "options", "", "(Lcom/android/tools/lint/detector/api/Severity;Ljava/util/List;Ljava/util/List;Ljava/util/Map;)V", "getOptions", "()Ljava/util/Map;", "setOptions", "(Ljava/util/Map;)V", "getPaths", "()Ljava/util/List;", "setPaths", "(Ljava/util/List;)V", "getPatterns", "setPatterns", "getSeverity", "()Lcom/android/tools/lint/detector/api/Severity;", "setSeverity", "(Lcom/android/tools/lint/detector/api/Severity;)V", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "isEmpty", "plusAssign", "", "toString", "lint-api"})
    public static final class IssueData {
        @Nullable
        private Severity severity;
        @Nullable
        private List<String> paths;
        @Nullable
        private List<Pattern> patterns;
        @Nullable
        private Map<String, String> options;

        public IssueData(@Nullable Severity severity, @Nullable List<String> paths, @Nullable List<Pattern> patterns, @Nullable Map<String, String> options) {
            this.severity = severity;
            this.paths = paths;
            this.patterns = patterns;
            this.options = options;
        }

        public /* synthetic */ IssueData(Severity severity, List list2, List list3, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                severity = null;
            }
            if ((n & 2) != 0) {
                list2 = null;
            }
            if ((n & 4) != 0) {
                list3 = null;
            }
            if ((n & 8) != 0) {
                map = null;
            }
            this(severity, list2, list3, map);
        }

        @Nullable
        public final Severity getSeverity() {
            return this.severity;
        }

        public final void setSeverity(@Nullable Severity severity) {
            this.severity = severity;
        }

        @Nullable
        public final List<String> getPaths() {
            return this.paths;
        }

        public final void setPaths(@Nullable List<String> list2) {
            this.paths = list2;
        }

        @Nullable
        public final List<Pattern> getPatterns() {
            return this.patterns;
        }

        public final void setPatterns(@Nullable List<Pattern> list2) {
            this.patterns = list2;
        }

        @Nullable
        public final Map<String, String> getOptions() {
            return this.options;
        }

        public final void setOptions(@Nullable Map<String, String> map) {
            this.options = map;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isEmpty() {
            Object object;
            if (this.severity != null) return false;
            if (this.paths != null) {
                object = this.paths;
                if (object == null) {
                    Intrinsics.throwNpe();
                }
                if (!object.isEmpty()) return false;
            }
            if (this.patterns != null) {
                object = this.patterns;
                if (object == null) {
                    Intrinsics.throwNpe();
                }
                if (!object.isEmpty()) return false;
            }
            if (this.options == null) return true;
            object = this.options;
            if (object == null) {
                Intrinsics.throwNpe();
            }
            if (!object.isEmpty()) return false;
            return true;
        }

        @NotNull
        public String toString() {
            return "IssueData(severity=" + (Object)((Object)this.severity) + ", paths=" + this.paths + ", patterns=" + this.patterns + ", options=" + this.options + ')';
        }

        public final void plusAssign(@NotNull IssueData other) {
            Severity it;
            boolean bl;
            boolean bl2;
            Severity severity;
            Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
            Object object = other.severity;
            if (object != null) {
                severity = object;
                bl2 = false;
                bl = false;
                it = severity;
                boolean bl3 = false;
                this.setSeverity(it);
            }
            object = other.paths;
            if (object != null) {
                severity = object;
                bl2 = false;
                bl = false;
                it = severity;
                boolean bl4 = false;
                List<String> paths = this.getPaths();
                if (paths == null) {
                    this.setPaths(other.getPaths());
                } else {
                    paths.addAll((Collection)((Object)it));
                }
            }
            object = other.patterns;
            if (object != null) {
                severity = object;
                bl2 = false;
                bl = false;
                it = severity;
                boolean bl5 = false;
                List<Pattern> patterns = this.getPatterns();
                if (patterns == null) {
                    this.setPatterns(other.getPatterns());
                } else {
                    patterns.addAll((Collection)((Object)it));
                }
            }
            object = other.options;
            if (object != null) {
                severity = object;
                bl2 = false;
                bl = false;
                it = severity;
                boolean bl6 = false;
                Map<String, String> options = this.getOptions();
                if (options == null) {
                    this.setOptions(other.getOptions());
                } else {
                    options.putAll((Map<String, String>)((Object)it));
                }
            }
        }

        @Nullable
        public final Severity component1() {
            return this.severity;
        }

        @Nullable
        public final List<String> component2() {
            return this.paths;
        }

        @Nullable
        public final List<Pattern> component3() {
            return this.patterns;
        }

        @Nullable
        public final Map<String, String> component4() {
            return this.options;
        }

        @NotNull
        public final IssueData copy(@Nullable Severity severity, @Nullable List<String> paths, @Nullable List<Pattern> patterns, @Nullable Map<String, String> options) {
            return new IssueData(severity, paths, patterns, options);
        }

        public static /* synthetic */ IssueData copy$default(IssueData issueData, Severity severity, List list2, List list3, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                severity = issueData.severity;
            }
            if ((n & 2) != 0) {
                list2 = issueData.paths;
            }
            if ((n & 4) != 0) {
                list3 = issueData.patterns;
            }
            if ((n & 8) != 0) {
                map = issueData.options;
            }
            return issueData.copy(severity, list2, list3, map);
        }

        public int hashCode() {
            int result2 = this.severity == null ? 0 : this.severity.hashCode();
            result2 = result2 * 31 + (this.paths == null ? 0 : ((Object)this.paths).hashCode());
            result2 = result2 * 31 + (this.patterns == null ? 0 : ((Object)this.patterns).hashCode());
            result2 = result2 * 31 + (this.options == null ? 0 : ((Object)this.options).hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IssueData)) {
                return false;
            }
            IssueData issueData = (IssueData)other;
            if (this.severity != issueData.severity) {
                return false;
            }
            if (!Intrinsics.areEqual(this.paths, issueData.paths)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.patterns, issueData.patterns)) {
                return false;
            }
            return Intrinsics.areEqual(this.options, issueData.options);
        }

        public IssueData() {
            this(null, null, null, null, 15, null);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/lint/client/api/LintXmlConfiguration$Companion;", "", "()V", "ATTR_BASELINE", "", "ATTR_ID", "ATTR_IN", "ATTR_NAME", "ATTR_PATH", "ATTR_REGEXP", "ATTR_SEVERITY", "ATTR_VALUE", "CONFIG_FILE_NAME", "RES_PATH_START", "RES_PATH_START_LEN", "", "TAG_IGNORE", "TAG_ISSUE", "TAG_LINT", "TAG_OPTION", "VALUE_ALL", "create", "Lcom/android/tools/lint/client/api/LintXmlConfiguration;", "configurations", "Lcom/android/tools/lint/client/api/ConfigurationHierarchy;", "lintFile", "Ljava/io/File;", "lint-api"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final LintXmlConfiguration create(@NotNull ConfigurationHierarchy configurations, @NotNull File lintFile) {
            Intrinsics.checkParameterIsNotNull((Object)configurations, (String)"configurations");
            Intrinsics.checkParameterIsNotNull((Object)lintFile, (String)"lintFile");
            return new LintXmlConfiguration(configurations, lintFile, null, false, 12, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

