/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Option;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000f\u001a\u00020\u0003H\u0016J\u0015\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0015\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/lint/detector/api/FloatOption;", "Lcom/android/tools/lint/detector/api/Option;", "name", "", "description", "defaultValue", "", "explanation", "min", "max", "(Ljava/lang/String;Ljava/lang/String;FLjava/lang/String;FF)V", "getDefaultValue", "()F", "getMax", "getMin", "defaultAsString", "getValue", "configuration", "Lcom/android/tools/lint/client/api/Configuration;", "(Lcom/android/tools/lint/client/api/Configuration;)Ljava/lang/Float;", "context", "Lcom/android/tools/lint/detector/api/Context;", "(Lcom/android/tools/lint/detector/api/Context;)Ljava/lang/Float;", "rangeAsString", "lint-api"})
public final class FloatOption
extends Option {
    private final float defaultValue;
    private final float min;
    private final float max;

    public FloatOption(@NotNull String name, @NotNull String description, float defaultValue, @Nullable String explanation, float min, float max) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        super(name, description, explanation, null);
        this.defaultValue = defaultValue;
        this.min = min;
        this.max = max;
    }

    public /* synthetic */ FloatOption(String string, String string2, float f, String string3, float f2, float f3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string3 = null;
        }
        if ((n & 0x10) != 0) {
            f2 = Float.MIN_VALUE;
        }
        if ((n & 0x20) != 0) {
            f3 = Float.MAX_VALUE;
        }
        this(string, string2, f, string3, f2, f3);
    }

    public final float getDefaultValue() {
        return this.defaultValue;
    }

    public final float getMin() {
        return this.min;
    }

    public final float getMax() {
        return this.max;
    }

    @Override
    @NotNull
    public Float getValue(@NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.ensureRegistered();
        Float f = (Float)configuration.getOption(this);
        return Float.valueOf(f == null ? this.defaultValue : f.floatValue());
    }

    @Override
    @NotNull
    public Float getValue(@NotNull Context context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return this.getValue(context2.findConfiguration(context2.file));
    }

    @Override
    @Nullable
    public String rangeAsString() {
        if (this.min == Float.MIN_VALUE) {
            if (this.max == Float.MAX_VALUE) {
                return null;
            }
            return Intrinsics.stringPlus((String)"Must be less than ", (Object)Float.valueOf(this.max));
        }
        if (this.max == Float.MAX_VALUE) {
            return Intrinsics.stringPlus((String)"Must be at least ", (Object)Float.valueOf(this.min));
        }
        return "Must be at least " + this.min + " and less than " + this.max;
    }

    @Override
    @NotNull
    public String defaultAsString() {
        return String.valueOf(this.defaultValue);
    }
}

