/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.support.AndroidxNameUtils;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.LintModelModuleProject;
import com.android.tools.lint.detector.api.LintModelModuleProjectKt;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.model.LintModelAndroidArtifact;
import com.android.tools.lint.model.LintModelDependencies;
import com.android.tools.lint.model.LintModelDependency;
import com.android.tools.lint.model.LintModelExternalLibrary;
import com.android.tools.lint.model.LintModelJavaArtifact;
import com.android.tools.lint.model.LintModelLibrary;
import com.android.tools.lint.model.LintModelModule;
import com.android.tools.lint.model.LintModelModuleLibrary;
import com.android.tools.lint.model.LintModelModuleType;
import com.android.tools.lint.model.LintModelSourceProvider;
import com.android.tools.lint.model.LintModelVariant;
import com.android.utils.XmlUtils;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u000e\b\u0016\u0018\u0000 C2\u00020\u0001:\u0001CB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0001J\u0017\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016\u00a2\u0006\u0002\u0010\u001fJ\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0016J\b\u0010!\u001a\u00020\fH\u0016J\b\u0010\"\u001a\u00020#H\u0016J\n\u0010$\u001a\u0004\u0018\u00010\u001eH\u0016J\b\u0010%\u001a\u00020\bH\u0016J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0016J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0016J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0016J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00050\u00102\u0006\u0010*\u001a\u00020\u001cH\u0016J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0016J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0016J\n\u0010-\u001a\u0004\u0018\u00010.H\u0016J\b\u0010/\u001a\u000200H\u0016J\n\u00101\u001a\u0004\u0018\u00010\u001eH\u0016J\u000e\u00102\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0016J\u000e\u00103\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0016J\b\u00104\u001a\u000200H\u0016J\u000e\u00105\u001a\b\u0012\u0004\u0012\u00020\u000506H\u0016J\u000e\u00107\u001a\b\u0012\u0004\u0012\u00020\u000506H\u0016J\u000e\u00108\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0016J\u000e\u00109\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0016J\b\u0010:\u001a\u00020\u001cH\u0016J\b\u0010;\u001a\u00020\u0019H\u0014J\b\u0010<\u001a\u00020\u001cH\u0016J\b\u0010=\u001a\u00020\u001cH\u0016J\u0010\u0010>\u001a\u00020\u00192\u0006\u0010?\u001a\u00020\u0005H\u0002J\u000e\u0010@\u001a\u00020\u00192\u0006\u0010A\u001a\u00020\u001cJ\b\u0010B\u001a\u00020\u001eH\u0016R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0013R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lcom/android/tools/lint/detector/api/LintModelModuleProject;", "Lcom/android/tools/lint/detector/api/Project;", "client", "Lcom/android/tools/lint/client/api/LintClient;", "dir", "Ljava/io/File;", "referenceDir", "variant", "Lcom/android/tools/lint/model/LintModelVariant;", "mergedManifest", "(Lcom/android/tools/lint/client/api/LintClient;Ljava/io/File;Ljava/io/File;Lcom/android/tools/lint/model/LintModelVariant;Ljava/io/File;)V", "model", "Lcom/android/tools/lint/model/LintModelModule;", "getModel", "()Lcom/android/tools/lint/model/LintModelModule;", "sourceProviders", "", "Lcom/android/tools/lint/model/LintModelSourceProvider;", "getSourceProviders", "()Ljava/util/List;", "testFixturesSourceProviders", "getTestFixturesSourceProviders", "testSourceProviders", "getTestSourceProviders", "addDirectLibrary", "", "project", "dependsOn", "", "artifact", "", "(Ljava/lang/String;)Ljava/lang/Boolean;", "getAssetFolders", "getBuildModule", "getBuildSdk", "", "getBuildTargetHash", "getBuildVariant", "getGeneratedResourceFolders", "getGeneratedSourceFolders", "getJavaClassFolders", "getJavaLibraries", "includeProvided", "getJavaSourceFolders", "getManifestFiles", "getMergedManifest", "Lorg/w3c/dom/Document;", "getMinSdkVersion", "Lcom/android/sdklib/AndroidVersion;", "getPackage", "getProguardFiles", "getResourceFolders", "getTargetSdkVersion", "getTestFixturesLibraries", "", "getTestFixturesSourceFolders", "getTestLibraries", "getTestSourceFolders", "hasDynamicFeatures", "initialize", "isAndroidProject", "isLibrary", "readManifest", "manifest", "setExternalLibrary", "external", "toString", "Companion", "lint-api"})
public class LintModelModuleProject
extends Project {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LintModelVariant variant;

    public LintModelModuleProject(@NotNull LintClient client, @NotNull File dir, @NotNull File referenceDir, @NotNull LintModelVariant variant, @Nullable File mergedManifest) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)referenceDir, (String)"referenceDir");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        super(client, dir, referenceDir);
        this.variant = variant;
        this.gradleProject = true;
        this.mergeManifests = true;
        this.directLibraries = new ArrayList();
        File file = mergedManifest;
        if (file != null) {
            File it = file;
            boolean bl = false;
            this.readManifest(it);
        }
        this.manifestMinSdk = this.variant.getMinSdkVersion();
        this.manifestTargetSdk = this.variant.getTargetSdkVersion();
    }

    private final LintModelModule getModel() {
        return this.variant.getModule();
    }

    @Override
    @NotNull
    public String toString() {
        String string = this.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName()");
        return string;
    }

    public final void setExternalLibrary(boolean external) {
        this.externalLibrary = external;
    }

    public final void addDirectLibrary(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.directLibraries.add(project);
    }

    private final void readManifest(File manifest) {
        if (manifest.exists()) {
            try {
                Document document;
                String xml = FilesKt.readText$default((File)manifest, null, (int)1, null);
                Document document2 = document = XmlUtils.parseDocumentSilently((String)xml, (boolean)true);
                if (document2 != null) {
                    Document it = document2;
                    boolean bl = false;
                    this.readManifest(it);
                }
            }
            catch (IOException e) {
                Object[] objectArray = new Object[]{manifest};
                this.client.log(e, "Could not read manifest %1$s", objectArray);
            }
        }
    }

    @Override
    protected void initialize() {
    }

    private final List<LintModelSourceProvider> getSourceProviders() {
        return this.variant.getSourceProviders();
    }

    private final List<LintModelSourceProvider> getTestSourceProviders() {
        return this.variant.getTestSourceProviders();
    }

    private final List<LintModelSourceProvider> getTestFixturesSourceProviders() {
        return this.variant.getTestFixturesSourceProviders();
    }

    @Override
    @NotNull
    public LintModelModule getBuildModule() {
        return this.variant.getModule();
    }

    @Override
    @NotNull
    public LintModelVariant getBuildVariant() {
        return this.variant;
    }

    @Override
    public boolean isLibrary() {
        return this.getModel().getType() == LintModelModuleType.LIBRARY || this.getModel().getType() == LintModelModuleType.JAVA_LIBRARY;
    }

    @Override
    public boolean isAndroidProject() {
        return this.getType() != LintModelModuleType.JAVA_LIBRARY;
    }

    @Override
    public boolean hasDynamicFeatures() {
        return this.getModel().getType() == LintModelModuleType.APP && !this.getModel().getDynamicFeatures().isEmpty();
    }

    @Override
    @NotNull
    public List<File> getManifestFiles() {
        if (this.manifestFiles == null) {
            this.manifestFiles = Lists.newArrayList();
            Iterable $this$forEach$iv = this.getSourceProviders();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LintModelSourceProvider provider = (LintModelSourceProvider)element$iv;
                boolean bl = false;
                File manifestFile = provider.getManifestFile();
                if (!manifestFile.exists()) continue;
                this.manifestFiles.add(manifestFile);
            }
        }
        List list2 = this.manifestFiles;
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"manifestFiles");
        return list2;
    }

    @Override
    @NotNull
    public List<File> getProguardFiles() {
        if (this.proguardFiles == null) {
            this.proguardFiles = CollectionsKt.plus((Collection)this.variant.getProguardFiles(), (Iterable)this.variant.getConsumerProguardFiles());
        }
        List list2 = this.proguardFiles;
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"proguardFiles");
        return list2;
    }

    @Override
    @NotNull
    public List<File> getResourceFolders() {
        if (this.resourceFolders == null) {
            this.resourceFolders = Lists.newArrayList();
            Iterable $this$forEach$iv = this.getSourceProviders();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LintModelSourceProvider provider = (LintModelSourceProvider)element$iv;
                boolean bl = false;
                Sequence $this$forEach$iv2 = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)provider.getResDirectories()), (Function1)getResourceFolders.1.1.INSTANCE);
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    File it = (File)element$iv2;
                    boolean bl2 = false;
                    this.resourceFolders.add(it);
                }
            }
        }
        List list2 = this.resourceFolders;
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"resourceFolders");
        return list2;
    }

    @Override
    @NotNull
    public List<File> getGeneratedResourceFolders() {
        if (this.generatedResourceFolders == null) {
            this.generatedResourceFolders = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.variant.getMainArtifact().getGeneratedResourceFolders()), (Function1)getGeneratedResourceFolders.1.INSTANCE));
        }
        List list2 = this.generatedResourceFolders;
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"generatedResourceFolders");
        return list2;
    }

    @Override
    @NotNull
    public List<File> getAssetFolders() {
        if (this.assetFolders == null) {
            this.assetFolders = Lists.newArrayList();
            Iterable $this$forEach$iv = this.getSourceProviders();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LintModelSourceProvider provider = (LintModelSourceProvider)element$iv;
                boolean bl = false;
                Sequence $this$forEach$iv2 = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)provider.getAssetsDirectories()), (Function1)getAssetFolders.1.1.INSTANCE);
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    File it = (File)element$iv2;
                    boolean bl2 = false;
                    this.assetFolders.add(it);
                }
            }
        }
        List list2 = this.assetFolders;
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"assetFolders");
        return list2;
    }

    @Override
    @NotNull
    public List<File> getJavaSourceFolders() {
        if (this.javaSourceFolders == null) {
            this.javaSourceFolders = Lists.newArrayList();
            Iterable $this$forEach$iv = this.getSourceProviders();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LintModelSourceProvider provider = (LintModelSourceProvider)element$iv;
                boolean bl = false;
                Sequence $this$forEach$iv2 = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)provider.getJavaDirectories()), (Function1)getJavaSourceFolders.1.1.INSTANCE);
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    File it = (File)element$iv2;
                    boolean bl2 = false;
                    this.javaSourceFolders.add(it);
                }
            }
        }
        List list2 = this.javaSourceFolders;
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"javaSourceFolders");
        return list2;
    }

    @Override
    @NotNull
    public List<File> getGeneratedSourceFolders() {
        if (this.generatedSourceFolders == null) {
            LintModelAndroidArtifact artifact = this.variant.getMainArtifact();
            this.generatedSourceFolders = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)artifact.getGeneratedSourceFolders()), (Function1)getGeneratedSourceFolders.1.INSTANCE));
        }
        List list2 = this.generatedSourceFolders;
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"generatedSourceFolders");
        return list2;
    }

    @Override
    @NotNull
    public List<File> getTestSourceFolders() {
        if (this.testSourceFolders == null) {
            this.testSourceFolders = Lists.newArrayList();
            Iterable $this$forEach$iv = this.getTestSourceProviders();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LintModelSourceProvider provider = (LintModelSourceProvider)element$iv;
                boolean bl = false;
                Sequence $this$forEach$iv2 = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)provider.getJavaDirectories()), (Function1)getTestSourceFolders.1.1.INSTANCE);
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    File it = (File)element$iv2;
                    boolean bl2 = false;
                    this.testSourceFolders.add(it);
                }
            }
        }
        List list2 = this.testSourceFolders;
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"testSourceFolders");
        return list2;
    }

    @Override
    @NotNull
    public List<File> getJavaClassFolders() {
        if (this.javaClassFolders == null) {
            this.javaClassFolders = new ArrayList(3);
            LintModelAndroidArtifact mainArtifact = this.variant.getMainArtifact();
            for (File outputClassFolder : mainArtifact.getClassOutputs()) {
                if (!outputClassFolder.exists()) continue;
                this.javaClassFolders.add(outputClassFolder);
            }
            if (this.javaClassFolders.isEmpty() && this.isLibrary()) {
                for (LintModelVariant variant : this.getModel().getVariants()) {
                    if (Intrinsics.areEqual((Object)variant, (Object)this.variant)) continue;
                    mainArtifact = variant.getMainArtifact();
                    boolean found = false;
                    for (File outputClassFolder : mainArtifact.getClassOutputs()) {
                        if (!outputClassFolder.exists()) continue;
                        this.javaClassFolders.add(outputClassFolder);
                        found = true;
                    }
                    if (!found) continue;
                }
            }
        }
        List list2 = this.javaClassFolders;
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"javaClassFolders");
        return list2;
    }

    @Override
    @NotNull
    public List<File> getJavaLibraries(boolean includeProvided) {
        List list2;
        if (includeProvided) {
            if (this.javaLibraries == null) {
                LintModelDependencies dependencies = this.variant.getMainArtifact().getDependencies();
                List direct = dependencies.getCompileDependencies().getRoots();
                this.javaLibraries = Lists.newArrayListWithExpectedSize((int)direct.size());
                for (LintModelDependency graphItem : direct) {
                    LintModelLibrary library2;
                    if (graphItem.findLibrary() == null || !(library2 instanceof LintModelExternalLibrary)) continue;
                    LintModelExternalLibrary lintModelExternalLibrary = (LintModelExternalLibrary)library2;
                    List list3 = this.javaLibraries;
                    Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"javaLibraries");
                    LintModelModuleProjectKt.addJars(lintModelExternalLibrary, list3, false);
                }
            }
            List list4 = this.javaLibraries;
            Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"{\n            if (javaLi\u2026  javaLibraries\n        }");
            list2 = list4;
        } else {
            if (this.nonProvidedJavaLibraries == null) {
                LintModelDependencies dependencies = this.variant.getMainArtifact().getDependencies();
                List direct = dependencies.getPackageDependencies().getRoots();
                this.nonProvidedJavaLibraries = Lists.newArrayListWithExpectedSize((int)direct.size());
                for (LintModelDependency graphItem : direct) {
                    LintModelLibrary library3;
                    if (graphItem.findLibrary() == null || !(library3 instanceof LintModelExternalLibrary)) continue;
                    LintModelExternalLibrary lintModelExternalLibrary = (LintModelExternalLibrary)library3;
                    List list5 = this.nonProvidedJavaLibraries;
                    Intrinsics.checkNotNullExpressionValue((Object)list5, (String)"nonProvidedJavaLibraries");
                    LintModelModuleProjectKt.addJars(lintModelExternalLibrary, list5, true);
                }
            }
            List list6 = this.nonProvidedJavaLibraries;
            Intrinsics.checkNotNullExpressionValue((Object)list6, (String)"{\n            // Skip pr\u2026edJavaLibraries\n        }");
            list2 = list6;
        }
        return list2;
    }

    @Override
    @NotNull
    public List<File> getTestLibraries() {
        if (this.testLibraries == null) {
            LintModelAndroidArtifact artifact;
            this.testLibraries = Lists.newArrayListWithExpectedSize((int)6);
            LintModelAndroidArtifact lintModelAndroidArtifact = this.variant.getAndroidTestArtifact();
            if (lintModelAndroidArtifact != null) {
                artifact = lintModelAndroidArtifact;
                boolean bl = false;
                for (LintModelLibrary library2 : artifact.getDependencies().getAll()) {
                    if (!(library2 instanceof LintModelExternalLibrary)) continue;
                    LintModelExternalLibrary lintModelExternalLibrary = (LintModelExternalLibrary)library2;
                    List list2 = this.testLibraries;
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"testLibraries");
                    LintModelModuleProjectKt.addJars(lintModelExternalLibrary, list2, false);
                }
            }
            LintModelJavaArtifact lintModelJavaArtifact = this.variant.getTestArtifact();
            if (lintModelJavaArtifact != null) {
                artifact = lintModelJavaArtifact;
                boolean bl = false;
                for (LintModelLibrary library2 : artifact.getDependencies().getAll()) {
                    if (!(library2 instanceof LintModelExternalLibrary)) continue;
                    LintModelExternalLibrary lintModelExternalLibrary = (LintModelExternalLibrary)library2;
                    List list3 = this.testLibraries;
                    Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"testLibraries");
                    LintModelModuleProjectKt.addJars(lintModelExternalLibrary, list3, false);
                }
            }
        }
        List list4 = this.testLibraries;
        Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"testLibraries");
        return list4;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<File> getTestFixturesSourceFolders() {
        if (this.testFixturesSourceFolders == null) {
            this.testFixturesSourceFolders = Lists.newArrayList();
            Iterable $this$forEach$iv = this.getTestFixturesSourceProviders();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$forEach$iv2;
                void $this$filterTo$iv$iv;
                LintModelSourceProvider provider = (LintModelSourceProvider)element$iv;
                boolean bl = false;
                Iterable $this$filter$iv = provider.getJavaDirectories();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    File it = (File)element$iv$iv;
                    boolean bl2 = false;
                    if (!it.exists()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    File it = (File)element$iv2;
                    boolean bl3 = false;
                    this.testFixturesSourceFolders.add(it);
                }
            }
        }
        List list2 = this.testFixturesSourceFolders;
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"testFixturesSourceFolders");
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<File> getTestFixturesLibraries() {
        if (this.testFixturesLibraries == null) {
            this.testFixturesLibraries = Lists.newArrayList();
            LintModelAndroidArtifact lintModelAndroidArtifact = this.variant.getTestFixturesArtifact();
            if (lintModelAndroidArtifact != null) {
                void $this$filterIsInstanceTo$iv$iv;
                LintModelAndroidArtifact artifact = lintModelAndroidArtifact;
                boolean bl = false;
                Iterable $this$filterIsInstance$iv = artifact.getDependencies().getAll();
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof LintModelExternalLibrary)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$forEach$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    LintModelExternalLibrary it = (LintModelExternalLibrary)element$iv;
                    boolean bl2 = false;
                    List list2 = this.testFixturesLibraries;
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"testFixturesLibraries");
                    LintModelModuleProjectKt.addJars(it, list2, false);
                }
            }
        }
        List list3 = this.testFixturesLibraries;
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"testFixturesLibraries");
        return list3;
    }

    @Override
    @Nullable
    public String getPackage() {
        String packageName;
        if (this.pkg == null && (packageName = this.variant.getPackage()) != null) {
            return packageName;
        }
        return this.pkg;
    }

    @Override
    @NotNull
    public AndroidVersion getMinSdkVersion() {
        AndroidVersion androidVersion;
        AndroidVersion androidVersion2 = this.manifestMinSdk;
        if (androidVersion2 == null) {
            AndroidVersion minSdk;
            LintModelModuleProject $this$getMinSdkVersion_u24lambda_u2d18 = this;
            boolean bl = false;
            AndroidVersion androidVersion3 = $this$getMinSdkVersion_u24lambda_u2d18.variant.getMinSdkVersion();
            if (androidVersion3 == null) {
                AndroidVersion androidVersion4 = super.getMinSdkVersion();
                androidVersion3 = androidVersion4;
                Intrinsics.checkNotNullExpressionValue((Object)androidVersion4, (String)"super.getMinSdkVersion()");
            }
            $this$getMinSdkVersion_u24lambda_u2d18.manifestMinSdk = minSdk = androidVersion3;
            androidVersion = minSdk;
        } else {
            androidVersion = androidVersion2;
        }
        return androidVersion;
    }

    @Override
    @NotNull
    public AndroidVersion getTargetSdkVersion() {
        AndroidVersion androidVersion;
        AndroidVersion androidVersion2 = this.manifestTargetSdk;
        if (androidVersion2 == null) {
            AndroidVersion targetSdk;
            LintModelModuleProject $this$getTargetSdkVersion_u24lambda_u2d19 = this;
            boolean bl = false;
            AndroidVersion androidVersion3 = $this$getTargetSdkVersion_u24lambda_u2d19.variant.getTargetSdkVersion();
            if (androidVersion3 == null) {
                androidVersion3 = $this$getTargetSdkVersion_u24lambda_u2d19.getMinSdkVersion();
            }
            $this$getTargetSdkVersion_u24lambda_u2d19.manifestTargetSdk = targetSdk = androidVersion3;
            androidVersion = targetSdk;
        } else {
            androidVersion = androidVersion2;
        }
        return androidVersion;
    }

    @Override
    public int getBuildSdk() {
        if (this.buildSdk == -1) {
            AndroidVersion version;
            String compileTarget = this.getModel().getCompileTarget();
            AndroidVersion androidVersion = version = AndroidTargetHash.getPlatformVersion((String)compileTarget);
            this.buildSdk = androidVersion != null ? androidVersion.getFeatureLevel() : super.getBuildSdk();
        }
        return this.buildSdk;
    }

    @Override
    @Nullable
    public String getBuildTargetHash() {
        return this.getModel().getCompileTarget();
    }

    @Override
    @Nullable
    public Boolean dependsOn(@NotNull String artifact) {
        Boolean bl;
        String id;
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        String string = id = AndroidxNameUtils.getCoordinateMapping((String)artifact);
        if (Intrinsics.areEqual((Object)string, (Object)"androidx.appcompat:appcompat")) {
            if (this.appCompat == null) {
                LintModelAndroidArtifact a = this.variant.getMainArtifact();
                this.appCompat = a.findCompileDependency("androidx.appcompat:appcompat") != null || a.findCompileDependency("com.android.support:appcompat-v7") != null;
            }
            bl = this.appCompat;
        } else if (Intrinsics.areEqual((Object)string, (Object)"androidx.leanback:leanback")) {
            if (this.leanback == null) {
                LintModelAndroidArtifact a = this.variant.getMainArtifact();
                this.leanback = a.findCompileDependency("androidx.leanback:leanback") != null || a.findCompileDependency("com.android.support:leanback-v17") != null;
            }
            bl = this.leanback;
        } else {
            bl = this.variant.getMainArtifact().findCompileDependency(artifact) != null ? Boolean.valueOf(true) : super.dependsOn(id);
        }
        return bl;
    }

    @Override
    @Nullable
    public Document getMergedManifest() {
        Document document;
        File file = this.variant.getMergedManifest();
        if (file == null) {
            return super.getMergedManifest();
        }
        File manifest = file;
        try {
            File manifestMergeReport;
            String string = Files.asCharSource((File)manifest, (Charset)Charsets.UTF_8).read();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asCharSource(manifest, Charsets.UTF_8).read()");
            String xml = string;
            Document document2 = XmlUtils.parseDocumentSilently((String)xml, (boolean)true);
            if (document2 == null) {
                Object[] objectArray = new Object[]{manifest};
                this.client.log(null, "Could not read %1$s", objectArray);
                return null;
            }
            File file2 = manifestMergeReport = this.variant.getManifestMergeReport();
            if (file2 != null) {
                File it = file2;
                boolean bl = false;
                this.client.resolveMergeManifestSources(document2, it);
            }
            document = document2;
        }
        catch (IOException ioe) {
            Object[] objectArray = new Object[]{manifest};
            this.client.log(ioe, "Could not read %1$s", objectArray);
            document = null;
        }
        return document;
    }

    @JvmStatic
    @NotNull
    public static final List<LintModelModuleProject> resolveDependencies(@NotNull Collection<? extends LintModelModuleProject> projects, boolean reporting) {
        return Companion.resolveDependencies(projects, reporting);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lcom/android/tools/lint/detector/api/LintModelModuleProject$Companion;", "", "()V", "resolveDependencies", "", "Lcom/android/tools/lint/detector/api/LintModelModuleProject;", "projects", "", "reporting", "", "lint-api"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final List<LintModelModuleProject> resolveDependencies(@NotNull Collection<? extends LintModelModuleProject> projects, boolean reporting) {
            Intrinsics.checkNotNullParameter(projects, (String)"projects");
            Map projectMap = new HashMap();
            for (LintModelModuleProject lintModelModuleProject : projects) {
                boolean bl;
                LintModelModule lintModelModule = lintModelModuleProject.getModel();
                String modulePath = lintModelModule.getModulePath();
                boolean bl2 = bl = projectMap.get(modulePath) == null;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                projectMap.put(modulePath, lintModelModuleProject);
            }
            for (LintModelModuleProject lintModelModuleProject : projects) {
                LintModelVariant lintModelVariant = lintModelModuleProject.getBuildVariant();
                List roots = lintModelVariant.getMainArtifact().getDependencies().getCompileDependencies().getRoots();
                for (LintModelDependency dependency : roots) {
                    LintModelLibrary library2 = dependency.findLibrary();
                    if (!(library2 instanceof LintModelModuleLibrary)) continue;
                    String projectPath = ((LintModelModuleLibrary)library2).getProjectPath();
                    LintModelModuleProject dependsOn = (LintModelModuleProject)projectMap.get(projectPath);
                    if (dependsOn == null) {
                        Iterable $this$filterIsInstanceTo$iv$iv;
                        Iterable $this$filterIsInstance$iv;
                        LintModelModuleLibrary it;
                        boolean bl;
                        Collection collection;
                        void $this$mapTo$iv$iv;
                        Iterable $this$map$iv;
                        Iterable iterable = lintModelVariant.getMainArtifact().getDependencies().getPackageDependencies().getRoots();
                        boolean $i$f$map = false;
                        void var16_29 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            LintModelDependency lintModelDependency = (LintModelDependency)item$iv$iv;
                            collection = destination$iv$iv;
                            bl = false;
                            collection.add(it.findLibrary());
                        }
                        $this$map$iv = (List)destination$iv$iv;
                        boolean $i$f$filterIsInstance = false;
                        $this$mapTo$iv$iv = $this$filterIsInstance$iv;
                        destination$iv$iv = new ArrayList();
                        boolean $i$f$filterIsInstanceTo = false;
                        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                            if (!(element$iv$iv instanceof LintModelModuleLibrary)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filterIsInstance$iv = (List)destination$iv$iv;
                        $i$f$map = false;
                        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            it = (LintModelModuleLibrary)item$iv$iv;
                            collection = destination$iv$iv;
                            bl = false;
                            collection.add(it.getProjectPath());
                        }
                        List packageDependencies = (List)destination$iv$iv;
                        if (!packageDependencies.contains(projectPath)) continue;
                        throw new IllegalStateException(("Missing lint model for " + projectPath + ", which is a dependency of " + lintModelModuleProject.getName()).toString());
                    }
                    if (reporting && lintModelModuleProject.getType() == LintModelModuleType.DYNAMIC_FEATURE && dependsOn.getType() != LintModelModuleType.DYNAMIC_FEATURE) {
                        dependsOn.addDirectLibrary(lintModelModuleProject);
                        continue;
                    }
                    lintModelModuleProject.addDirectLibrary(dependsOn);
                }
            }
            LinkedHashSet<LintModelModuleProject> roots = new LinkedHashSet<LintModelModuleProject>();
            Iterable iterable = projects;
            boolean bl = false;
            for (Object element$iv : iterable) {
                LintModelModuleProject it = (LintModelModuleProject)element$iv;
                boolean bl3 = false;
                roots.add(it);
            }
            for (LintModelModuleProject lintModelModuleProject : projects) {
                for (Project dependency : lintModelModuleProject.getDirectLibraries()) {
                    TypeIntrinsics.asMutableCollection((Object)roots).remove(dependency);
                }
            }
            return CollectionsKt.toList((Iterable)roots);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

