/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.helpers;

import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.UastParser;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.android.tools.lint.helpers.DefaultJavaEvaluator;
import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.elements.KtLightIdentifier;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UDeclarationsExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UastFacade;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.psi.UElementWithLocation;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 =2\u00020\u0001:\u0001=B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\u0013\u001a\u00020\u000f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0015H\u0004J\u001a\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001b\u001a\u00020\u0005H\u0014J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0010H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0014\u0010 \u001a\u0004\u0018\u00010\u00102\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J(\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u000fH\u0016J\u0012\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020-2\u0006\u0010*\u001a\u00020+H\u0016J\u0018\u0010.\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020\u0010H\u0016J\u0018\u0010.\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010/\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020\u0010H\u0016J\u0018\u0010/\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J0\u00100\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#2\u0006\u00101\u001a\u00020\u00102\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u00102\u0006\u00105\u001a\u000203H\u0016J(\u00100\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#2\u0006\u00101\u001a\u00020\u00102\u0006\u00102\u001a\u0002032\u0006\u00105\u001a\u000203H\u0016J(\u00100\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#2\u0006\u00101\u001a\u00020\u001f2\u0006\u00102\u001a\u0002032\u0006\u00105\u001a\u000203H\u0016J0\u00100\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#2\u0006\u00101\u001a\u00020\u001f2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u001f2\u0006\u00105\u001a\u000203H\u0016J\u0012\u00106\u001a\u0004\u0018\u0001072\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u001e\u00108\u001a\u00020\u000f2\u0006\u00109\u001a\u00020+2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0004J\u0012\u0010;\u001a\u0004\u0018\u00010<2\u0006\u0010\"\u001a\u00020#H\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000e\u001a\u00020\u000f*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006>"}, d2={"Lcom/android/tools/lint/helpers/DefaultUastParser;", "Lcom/android/tools/lint/client/api/UastParser;", "project", "Lcom/android/tools/lint/detector/api/Project;", "ideaProject", "Lcom/intellij/openapi/project/Project;", "(Lcom/android/tools/lint/detector/api/Project;Lcom/intellij/openapi/project/Project;)V", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "getEvaluator", "()Lcom/android/tools/lint/client/api/JavaEvaluator;", "getIdeaProject", "()Lcom/intellij/openapi/project/Project;", "javaEvaluator", "hasValidSourceLocation", "", "Lcom/intellij/psi/PsiElement;", "getHasValidSourceLocation", "(Lcom/intellij/psi/PsiElement;)Z", "containsAnnotation", "names", "", "", "annotations", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "createEvaluator", "Lcom/android/tools/lint/helpers/DefaultJavaEvaluator;", "p", "createLocation", "Lcom/android/tools/lint/detector/api/Location;", "element", "Lorg/jetbrains/uast/UElement;", "findPsi", "getCallLocation", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "call", "Lorg/jetbrains/uast/UCallExpression;", "includeReceiver", "includeArguments", "getFile", "Ljava/io/File;", "file", "Lcom/intellij/psi/PsiFile;", "getFileContents", "", "getLocation", "getNameLocation", "getRangeLocation", "from", "fromDelta", "", "to", "toDelta", "getTextRange", "Lcom/intellij/openapi/util/TextRange;", "isAnnotatedWithSkipAnnotation", "psiFile", "skipAnnotations", "parse", "Lorg/jetbrains/uast/UFile;", "Companion", "lint-api"})
public class DefaultUastParser
extends UastParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final com.intellij.openapi.project.Project ideaProject;
    @NotNull
    private final JavaEvaluator javaEvaluator;
    @NotNull
    private final JavaEvaluator evaluator;
    private static boolean warnedAboutLargeFiles;

    public DefaultUastParser(@Nullable Project project, @NotNull com.intellij.openapi.project.Project ideaProject) {
        Intrinsics.checkNotNullParameter((Object)ideaProject, (String)"ideaProject");
        this.ideaProject = ideaProject;
        this.javaEvaluator = this.createEvaluator(project, this.ideaProject);
        this.evaluator = this.javaEvaluator;
    }

    @NotNull
    public final com.intellij.openapi.project.Project getIdeaProject() {
        return this.ideaProject;
    }

    @NotNull
    protected DefaultJavaEvaluator createEvaluator(@Nullable Project project, @NotNull com.intellij.openapi.project.Project p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Project project2 = project;
        Intrinsics.checkNotNull((Object)project2);
        return new DefaultJavaEvaluator(p, project2);
    }

    @Override
    @NotNull
    public JavaEvaluator getEvaluator() {
        return this.evaluator;
    }

    @Override
    @Nullable
    public UFile parse(@NotNull JavaContext context2) {
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (context2.getUastFile() != null) {
            return context2.getUastFile();
        }
        if (this.ideaProject.isDisposed()) {
            return null;
        }
        File file = context2.file;
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
        String path2 = StringsKt.replace$default((String)string, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
        int srcJarIndex = StringsKt.indexOf$default((CharSequence)path2, (String)"srcjar!/", (int)0, (boolean)false, (int)6, null);
        if (srcJarIndex != -1) {
            String string2 = path2.substring(0, srcJarIndex + 8);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String jarFile = string2;
            String string3 = path2.substring(srcJarIndex + 8);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
            String name = string3;
            VirtualFile virtualFile2 = StandardFileSystems.jar().findFileByPath(jarFile);
            if (virtualFile2 == null) {
                return null;
            }
            VirtualFile root = virtualFile2;
            virtualFile = root.findFileByRelativePath(name);
            if (virtualFile == null) {
                return null;
            }
        } else {
            String string4 = file.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"file.absolutePath");
            String absPath = StringsKt.replace$default((String)string4, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
            virtualFile = StandardFileSystems.local().findFileByPath(absPath);
            if (virtualFile == null) {
                return null;
            }
        }
        VirtualFile virtualFile3 = virtualFile;
        PsiFile psiFile = PsiManager.getInstance((com.intellij.openapi.project.Project)this.ideaProject).findFile(virtualFile3);
        if (psiFile == null) {
            return null;
        }
        PsiFile psiFile2 = psiFile;
        if (Intrinsics.areEqual((Object)psiFile2.getLanguage(), (Object)Language.ANY)) {
            String string5 = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"file.path");
            if (StringsKt.endsWith$default((String)string5, (String)".kt", (boolean)false, (int)2, null)) {
                context2.getClient().log(Severity.ERROR, null, "Could not process " + context2.getProject().getRelativePath(file) + ": Kotlin not configured correctly", new Object[0]);
                return null;
            }
        }
        if (psiFile2 instanceof PsiPlainTextFile) {
            if (!warnedAboutLargeFiles) {
                warnedAboutLargeFiles = true;
                int max = Math.max(FileUtilRt.getUserFileSizeLimit(), FileUtilRt.getUserContentLoadLimit()) / 1024;
                long size = file.length() / (long)1024;
                int sizeRoundedUp = (int)Math.pow(2.0, Math.ceil(Math.log10(size) / Math.log10(2.0) + 0.2));
                Context.report$default(context2, IssueRegistry.LINT_ERROR, Location.Companion.create(file), "Source file too large for lint to process (" + size + "KB); the current max size is " + max + "KB. You can increase the limit by setting this system property: `idea.max.intellisense.filesize=" + sizeRoundedUp + "` (or even higher)", null, 8, null);
            }
            return null;
        }
        List<String> skipAnnotations = context2.getDriver().getSkipAnnotations();
        if (skipAnnotations != null && this.isAnnotatedWithSkipAnnotation(psiFile2, skipAnnotations)) {
            return null;
        }
        UElement uElement = UastFacade.INSTANCE.convertElementWithParent((PsiElement)psiFile2, UFile.class);
        UFile uFile = uElement instanceof UFile ? (UFile)uElement : null;
        if (uFile == null) {
            return null;
        }
        return uFile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final boolean isAnnotatedWithSkipAnnotation(@NotNull PsiFile psiFile, @NotNull List<String> skipAnnotations) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter(skipAnnotations, (String)"skipAnnotations");
        if (psiFile instanceof PsiJavaFile) {
            PsiClass[] psiClassArray = ((PsiJavaFile)psiFile).getClasses();
            Intrinsics.checkNotNullExpressionValue((Object)psiClassArray, (String)"psiFile.classes");
            PsiClass psiClass = (PsiClass)ArraysKt.firstOrNull((Object[])psiClassArray);
            if (psiClass == null) {
                return false;
            }
            PsiClass topLevel = psiClass;
            PsiAnnotation[] psiAnnotationArray = topLevel.getAnnotations();
            Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationArray, (String)"topLevel.annotations");
            Object[] $this$any$iv = psiAnnotationArray;
            boolean $i$f$any = false;
            int n = 0;
            int n2 = $this$any$iv.length;
            while (n < n2) {
                Object element$iv = $this$any$iv[n];
                PsiAnnotation it = (PsiAnnotation)element$iv;
                boolean bl = false;
                if (CollectionsKt.contains((Iterable)skipAnnotations, (Object)it.getQualifiedName())) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        if (!(psiFile instanceof KtFile)) return false;
        if (this.containsAnnotation(skipAnnotations, ((KtFile)psiFile).getAnnotationEntries())) return true;
        KtDeclaration ktDeclaration = (KtDeclaration)CollectionsKt.firstOrNull((List)((KtFile)psiFile).getDeclarations());
        List list2 = ktDeclaration != null ? ktDeclaration.getAnnotationEntries() : null;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        if (!this.containsAnnotation(skipAnnotations, list2)) return false;
        return true;
    }

    protected final boolean containsAnnotation(@NotNull List<String> names, @NotNull List<? extends KtAnnotationEntry> annotations) {
        Intrinsics.checkNotNullParameter(names, (String)"names");
        Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
        for (KtAnnotationEntry ktAnnotationEntry : annotations) {
            UAnnotation uAnnotation;
            boolean bl;
            block5: {
                Iterable $this$any$iv = names;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        Object object = ktAnnotationEntry.getShortName();
                        if (object == null || (object = object.getIdentifier()) == null) {
                            object = "?";
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"annotation.shortName?.identifier ?: \"?\"");
                        if (!StringsKt.endsWith$default((String)it, (String)object, (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            UElement uElement = UastFacade.INSTANCE.convertElement((PsiElement)ktAnnotationEntry, null, UAnnotation.class);
            UAnnotation uAnnotation2 = uElement instanceof UAnnotation ? (UAnnotation)uElement : null;
            if (uAnnotation2 == null || !CollectionsKt.contains((Iterable)names, (Object)(uAnnotation = uAnnotation2).getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public Location getLocation(@NotNull JavaContext context2, @NotNull PsiElement element) {
        CharSequence contents;
        File file;
        TextRange range;
        block16: {
            PsiFile containingFile;
            block15: {
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                range = null;
                if (!this.getHasValidSourceLocation(element)) {
                    if (element instanceof LightElement) {
                        range = element.getTextRange();
                    }
                    if (range == null || Intrinsics.areEqual((Object)TextRange.EMPTY_RANGE, (Object)range)) {
                        VirtualFile virtualFile;
                        PsiFile containingFile2 = element.getContainingFile();
                        if (containingFile2 != null && (virtualFile = containingFile2.getVirtualFile()) != null) {
                            File file2 = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
                            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"virtualToIoFile(virtualFile)");
                            return Location.Companion.create(file2);
                        }
                        return Location.Companion.create(context2.file);
                    }
                } else {
                    range = element.getTextRange();
                }
                containingFile = UastLintUtils.Companion.getContainingFile(context2, element);
                file = context2.file;
                CharSequence charSequence = context2.getContents();
                if (charSequence == null) {
                    charSequence = contents = (CharSequence)"";
                }
                if (containingFile == null || containingFile.isEquivalentTo((PsiElement)context2.getPsiFile())) break block15;
                PsiFile psiFile = context2.getPsiFile();
                if (!Intrinsics.areEqual((Object)containingFile.getName(), (Object)(psiFile != null ? psiFile.getName() : null))) break block15;
                String string = containingFile.getClass().getSimpleName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"containingFile.javaClass.simpleName");
                if (StringsKt.contains$default((CharSequence)string, (CharSequence)"fakeFile", (boolean)false, (int)2, null)) break block16;
            }
            if (containingFile != null && !Intrinsics.areEqual((Object)containingFile, (Object)context2.getPsiFile())) {
                File ioFile;
                if (context2.getDriver().getScope().size() == 1) {
                    return Location.NONE;
                }
                File file3 = this.getFile(containingFile);
                if (file3 == null) {
                    return Location.NONE;
                }
                file = ioFile = file3;
                contents = this.getFileContents(containingFile);
            }
        }
        if (range == null) {
            PsiElement parent;
            if (element instanceof LightElement && (parent = element.getParent()) != null) {
                return this.getLocation(context2, parent);
            }
            return Location.Companion.create(file);
        }
        return Location.Companion.create(file, contents, range.getStartOffset(), range.getEndOffset()).setSource(element);
    }

    private final boolean getHasValidSourceLocation(PsiElement $this$hasValidSourceLocation) {
        if ($this$hasValidSourceLocation instanceof PsiCompiledElement) {
            return false;
        }
        if ($this$hasValidSourceLocation instanceof KtLightIdentifier && ((KtLightIdentifier)$this$hasValidSourceLocation).getOrigin() == null) {
            return false;
        }
        return $this$hasValidSourceLocation.getTextOffset() >= 0;
    }

    @Override
    @NotNull
    public Location getLocation(@NotNull JavaContext context2, @NotNull UElement element) {
        PsiElement psiElement;
        UDeclaration ioFile2;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof UElementWithLocation) {
            UFile uFile = UastUtils.getContainingUFile((UElement)element);
            if (uFile == null) {
                return Location.NONE;
            }
            UFile file = uFile;
            File file2 = UastUtils.getIoFile((UFile)file);
            if (file2 == null) {
                return Location.NONE;
            }
            File ioFile2 = file2;
            String string = file.getSourcePsi().getText();
            if (string == null) {
                PsiElement psiElement2 = file.getJavaPsi();
                string = psiElement2 != null ? psiElement2.getText() : null;
                if (string == null) {
                    string = "";
                }
            }
            String text = string;
            Location location2 = Location.Companion.create(ioFile2, text, ((UElementWithLocation)element).getStartOffset(), ((UElementWithLocation)element).getEndOffset());
            location2.setSource(element);
            return location2;
        }
        if (Lint.isPolyadicFromStringTemplate(element) && ((UPolyadicExpression)element).getOperands().size() == 1) {
            UExpression literal = (UExpression)((UPolyadicExpression)element).getOperands().get(0);
            return this.getLocation(context2, (UElement)literal).withSource(literal);
        }
        PsiElement psiElement3 = element.getSourcePsi();
        if (psiElement3 != null) {
            return this.getLocation(context2, psiElement3).withSource(element);
        }
        if (element instanceof UDeclarationsExpression && (ioFile2 = (UDeclaration)CollectionsKt.firstOrNull((List)((UDeclarationsExpression)element).getDeclarations())) != null && (psiElement = ioFile2.getSourcePsi()) != null) {
            PsiElement firstDeclarationPsi = psiElement;
            boolean bl = false;
            return this.getLocation(context2, firstDeclarationPsi).withSource(element);
        }
        UElement parent = element.getUastParent();
        if (parent != null) {
            return this.getLocation(context2, parent);
        }
        return Location.NONE;
    }

    @Override
    @NotNull
    public Location getCallLocation(@NotNull JavaContext context2, @NotNull UCallExpression call, boolean includeReceiver, boolean includeArguments) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        if (includeArguments) {
            UExpression uExpression = (UExpression)CollectionsKt.lastOrNull((List)call.getValueArguments());
            if (uExpression != null) {
                Integer callEnds;
                UExpression lastArgument = uExpression;
                boolean bl = false;
                PsiElement psiElement = lastArgument.getSourcePsi();
                Integer argumentsEnd = psiElement != null ? Integer.valueOf(PsiUtilsKt.getEndOffset((PsiElement)psiElement)) : null;
                PsiElement psiElement2 = call.getSourcePsi();
                Integer n = callEnds = psiElement2 != null ? Integer.valueOf(PsiUtilsKt.getEndOffset((PsiElement)psiElement2)) : null;
                if (argumentsEnd != null && callEnds != null && argumentsEnd > callEnds) {
                    UExpression uExpression2;
                    if (includeReceiver) {
                        uExpression2 = call.getReceiver();
                        if (uExpression2 == null) {
                            uExpression2 = (UExpression)call;
                        }
                    } else {
                        uExpression2 = (UExpression)call;
                    }
                    UExpression startElement = uExpression2;
                    PsiElement psiElement3 = lastArgument.getSourcePsi();
                    KtLiteralStringTemplateEntry ktLiteralStringTemplateEntry = psiElement3 instanceof KtLiteralStringTemplateEntry ? (KtLiteralStringTemplateEntry)psiElement3 : null;
                    PsiElement psiElement4 = ktLiteralStringTemplateEntry != null ? ktLiteralStringTemplateEntry.getNextSibling() : null;
                    TreeElement next = psiElement4 instanceof TreeElement ? (TreeElement)psiElement4 : null;
                    int delta = next != null && Intrinsics.areEqual((Object)next.getElementType(), (Object)KtTokens.CLOSING_QUOTE) ? next.getTextLength() : 0;
                    return this.getRangeLocation(context2, (UElement)startElement, 0, (UElement)lastArgument, delta);
                }
            }
        }
        UExpression receiver = call.getReceiver();
        if (!includeReceiver || receiver == null) {
            if (includeArguments) {
                return this.getLocation(context2, (UElement)call);
            }
            UIdentifier methodIdentifier = call.getMethodIdentifier();
            if (methodIdentifier != null) {
                return this.getLocation(context2, (UElement)methodIdentifier);
            }
        } else {
            UIdentifier methodIdentifier;
            if (!includeArguments && (methodIdentifier = call.getMethodIdentifier()) != null) {
                return this.getRangeLocation(context2, (UElement)receiver, 0, (UElement)methodIdentifier, 0);
            }
            return this.getRangeLocation(context2, (UElement)receiver, 0, (UElement)call, 0);
        }
        return this.getLocation(context2, (UElement)call);
    }

    @Override
    @Nullable
    public File getFile(@NotNull PsiFile file) {
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VirtualFile virtualFile2 = virtualFile = file.getVirtualFile();
        return virtualFile2 != null ? VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile2) : null;
    }

    @Override
    @NotNull
    public CharSequence getFileContents(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.text");
        return string;
    }

    @Override
    @NotNull
    public Location createLocation(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        TextRange range = element.getTextRange();
        PsiFile containingFile = element.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)containingFile, (String)"containingFile");
        File file = this.getFile(containingFile);
        if (file == null) {
            return Location.NONE;
        }
        File file2 = file;
        CharSequence contents = this.getFileContents(containingFile);
        return Location.Companion.create(file2, contents, range.getStartOffset(), range.getEndOffset()).setSource(element);
    }

    @Override
    @NotNull
    public Location createLocation(@NotNull UElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof UElementWithLocation) {
            UFile uFile = UastUtils.getContainingUFile((UElement)element);
            if (uFile == null) {
                return Location.NONE;
            }
            UFile file = uFile;
            File file2 = UastUtils.getIoFile((UFile)file);
            if (file2 == null) {
                return Location.NONE;
            }
            File ioFile = file2;
            String text = file.getSourcePsi().getText();
            Location location2 = Location.Companion.create(ioFile, text, ((UElementWithLocation)element).getStartOffset(), ((UElementWithLocation)element).getEndOffset());
            location2.setSource(element);
            return location2;
        }
        PsiElement psiElement = element.getSourcePsi();
        if (psiElement != null) {
            return this.createLocation(psiElement).withSource(element);
        }
        UElement parent = element.getUastParent();
        if (parent != null) {
            return this.createLocation(parent);
        }
        return Location.NONE;
    }

    @Override
    @NotNull
    public Location getRangeLocation(@NotNull JavaContext context2, @NotNull PsiElement from, int fromDelta, @NotNull PsiElement to, int toDelta) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        CharSequence contents = context2.getContents();
        TextRange fromRange = from.getTextRange();
        int start = Math.max(0, fromRange.getStartOffset() + fromDelta);
        CharSequence charSequence = contents;
        int n = charSequence != null ? charSequence.length() : Integer.MAX_VALUE;
        int n2 = to.getTextRange().getEndOffset() + toDelta;
        int end = Math.min(n, n2);
        if (end <= start) {
            return Location.Companion.create(context2.file, contents, start, fromRange.getEndOffset()).setSource(from);
        }
        return Location.Companion.create(context2.file, contents, start, end).setSource(from);
    }

    private final TextRange getTextRange(UElement element) {
        if (element instanceof UElementWithLocation) {
            return new TextRange(((UElementWithLocation)element).getStartOffset(), ((UElementWithLocation)element).getEndOffset());
        }
        PsiElement psiElement = element.getSourcePsi();
        if (psiElement != null) {
            return psiElement.getTextRange();
        }
        return null;
    }

    @Override
    @NotNull
    public Location getRangeLocation(@NotNull JavaContext context2, @NotNull UElement from, int fromDelta, @NotNull UElement to, int toDelta) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        CharSequence contents = context2.getContents();
        TextRange fromRange = this.getTextRange(from);
        TextRange toRange = this.getTextRange(to);
        if (fromRange != null && toRange != null && fromRange.getStartOffset() > toRange.getStartOffset()) {
            return this.getRangeLocation(context2, to, toDelta, from, fromDelta);
        }
        File file = context2.file;
        PsiElement psi = this.findPsi(from);
        if (psi != null) {
            PsiFile containingFile = psi.getContainingFile();
            contents = context2.getContents();
            if (!Intrinsics.areEqual((Object)containingFile, (Object)context2.getPsiFile())) {
                File ioFile;
                if (context2.getDriver().getScope().size() == 1) {
                    return Location.NONE;
                }
                Intrinsics.checkNotNullExpressionValue((Object)containingFile, (String)"containingFile");
                File file2 = this.getFile(containingFile);
                if (file2 == null) {
                    return Location.NONE;
                }
                file = ioFile = file2;
                contents = this.getFileContents(containingFile);
            }
        }
        if (fromRange != null && toRange != null) {
            int n;
            int start = Math.max(0, fromRange.getStartOffset() + fromDelta);
            CharSequence charSequence = contents;
            int n2 = charSequence != null ? charSequence.length() : Integer.MAX_VALUE;
            int end = Math.min(n2, n = toRange.getEndOffset() + toDelta);
            if (end <= start) {
                return Location.Companion.create(file, contents, start, fromRange.getEndOffset()).setSource(from);
            }
            return Location.Companion.create(file, contents, start, end).setSource(from);
        }
        return Location.Companion.create(file).setSource(from);
    }

    private final PsiElement findPsi(UElement element) {
        for (UElement currentElement = element; currentElement != null; currentElement = currentElement.getUastParent()) {
            PsiElement psi = currentElement.getSourcePsi();
            if (psi == null) continue;
            return psi;
        }
        return null;
    }

    @Override
    @NotNull
    public Location getRangeLocation(@NotNull JavaContext context2, @NotNull PsiElement from, int fromDelta, int toDelta) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        return this.getRangeLocation(context2, from, fromDelta, from, -(from.getTextRange().getLength() - toDelta));
    }

    @Override
    @NotNull
    public Location getRangeLocation(@NotNull JavaContext context2, @NotNull UElement from, int fromDelta, int toDelta) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        TextRange fromRange = this.getTextRange(from);
        if (fromRange != null) {
            return this.getRangeLocation(context2, from, fromDelta, from, -(fromRange.getLength() - toDelta));
        }
        return Location.Companion.create(context2.file).setSource(from);
    }

    @Override
    @NotNull
    public Location getNameLocation(@NotNull JavaContext context2, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement namedElement = element;
        PsiElement nameNode = JavaContext.Companion.findNameElement(namedElement);
        if (nameNode != null) {
            namedElement = nameNode;
        }
        return this.getLocation(context2, namedElement);
    }

    @Override
    @NotNull
    public Location getNameLocation(@NotNull JavaContext context2, @NotNull UElement element) {
        PsiElement nameIdentifier;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement sourcePsi = element.getSourcePsi();
        if (sourcePsi instanceof KtPropertyAccessor) {
            KtProperty ktProperty = ((KtPropertyAccessor)sourcePsi).getProperty();
            Intrinsics.checkNotNullExpressionValue((Object)ktProperty, (String)"sourcePsi.property");
            return context2.getNameLocation((PsiElement)ktProperty);
        }
        UElement namedElement = element;
        UElement nameNode = JavaContext.Companion.findNameElement(namedElement);
        if (nameNode != null) {
            namedElement = nameNode;
        } else if (namedElement instanceof PsiNameIdentifierOwner && (nameIdentifier = ((PsiNameIdentifierOwner)namedElement).getNameIdentifier()) != null) {
            return this.getLocation(context2, nameIdentifier);
        }
        return this.getLocation(context2, namedElement);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/android/tools/lint/helpers/DefaultUastParser$Companion;", "", "()V", "warnedAboutLargeFiles", "", "getWarnedAboutLargeFiles", "()Z", "setWarnedAboutLargeFiles", "(Z)V", "lint-api"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getWarnedAboutLargeFiles() {
            return warnedAboutLargeFiles;
        }

        public final void setWarnedAboutLargeFiles(boolean bl) {
            warnedAboutLargeFiles = bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

