/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.tools.lint.client.api.AndroidPlatformAnnotations;
import com.android.tools.lint.client.api.ResourceReference;
import com.android.tools.lint.detector.api.AnnotationValuesExtractor;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.ConstantEvaluatorImpl;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.UastLintUtilsKt;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.elements.FakeFileForLightClass;
import org.jetbrains.kotlin.asJava.elements.KtLightMember;
import org.jetbrains.kotlin.asJava.elements.KtLightParameter;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnnotationUseSiteTarget;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UPrefixExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UUnaryExpression;
import org.jetbrains.uast.UVariableEx;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastFacade;
import org.jetbrains.uast.UastLanguagePlugin;
import org.jetbrains.uast.UastPrefixOperator;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/lint/detector/api/UastLintUtils;", "", "<init>", "()V", "Companion", "lint-api"})
public final class UastLintUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    @Nullable
    public static final UDeclaration tryResolveUDeclaration(@NotNull UElement $this$tryResolveUDeclaration) {
        return Companion.tryResolveUDeclaration($this$tryResolveUDeclaration);
    }

    @JvmStatic
    @Nullable
    public static final PsiFile getContainingFile(@NotNull JavaContext context2, @Nullable PsiElement element) {
        return Companion.getContainingFile(context2, element);
    }

    @JvmStatic
    @Nullable
    public static final PsiFile getPsiFile(@Nullable UFile file) {
        return Companion.getPsiFile(file);
    }

    @JvmStatic
    @Nullable
    public static final PsiFile getContainingFile(@Nullable PsiElement element) {
        return Companion.getContainingFile(element);
    }

    @JvmStatic
    @Nullable
    public static final String getQualifiedName(@NotNull PsiElement element) {
        return Companion.getQualifiedName(element);
    }

    @JvmStatic
    @NotNull
    public static final String getClassName(@NotNull PsiClassType type) {
        return Companion.getClassName(type);
    }

    @JvmStatic
    @NotNull
    public static final String getClassName(@NotNull PsiClass psiClass) {
        return Companion.getClassName(psiClass);
    }

    @JvmStatic
    @Nullable
    public static final UExpression findLastAssignment(@NotNull PsiVariable variable, @NotNull UElement endAt) {
        return Companion.findLastAssignment(variable, endAt);
    }

    @JvmStatic
    @Nullable
    public static final UExpression findArgument(@NotNull UCallExpression node, @NotNull PsiMethod method, @NotNull String type) {
        return Companion.findArgument(node, method, type);
    }

    @JvmStatic
    @Nullable
    public static final UExpression findArgument(@NotNull UCallExpression node, @NotNull String type) {
        return Companion.findArgument(node, type);
    }

    @JvmStatic
    @Nullable
    public static final String getReferenceName(@NotNull UReferenceExpression expression) {
        return Companion.getReferenceName(expression);
    }

    @JvmStatic
    @Nullable
    public static final Object findLastValue(@NotNull PsiVariable variable, @NotNull UElement call, @NotNull ConstantEvaluator evaluator) {
        return Companion.findLastValue(variable, call, evaluator);
    }

    @JvmStatic
    @Nullable
    public static final ResourceReference toAndroidReferenceViaResolve(@NotNull UElement element) {
        return Companion.toAndroidReferenceViaResolve(element);
    }

    @JvmStatic
    public static final boolean areIdentifiersEqual(@NotNull UExpression first, @NotNull UExpression second) {
        return Companion.areIdentifiersEqual(first, second);
    }

    @JvmStatic
    @Nullable
    public static final String getIdentifier(@NotNull UExpression expression) {
        return Companion.getIdentifier(expression);
    }

    @JvmStatic
    public static final boolean isNumber(@NotNull UElement argument) {
        return Companion.isNumber(argument);
    }

    @JvmStatic
    public static final boolean isZero(@NotNull UElement argument) {
        return Companion.isZero(argument);
    }

    @JvmStatic
    public static final boolean isMinusOne(@NotNull UElement argument) {
        return Companion.isMinusOne(argument);
    }

    @JvmStatic
    @Nullable
    public static final UExpression getAnnotationValue(@NotNull UAnnotation annotation) {
        return Companion.getAnnotationValue(annotation);
    }

    @JvmStatic
    public static final long getLongAttribute(@NotNull JavaContext context2, @NotNull UAnnotation annotation, @NotNull String name, long defaultValue) {
        return Companion.getLongAttribute(context2, annotation, name, defaultValue);
    }

    @JvmStatic
    public static final long getLongAttribute(@NotNull UAnnotation annotation, @NotNull String name, long defaultValue) {
        return Companion.getLongAttribute(annotation, name, defaultValue);
    }

    @JvmStatic
    public static final double getDoubleAttribute(@NotNull JavaContext context2, @NotNull UAnnotation annotation, @NotNull String name, double defaultValue) {
        return Companion.getDoubleAttribute(context2, annotation, name, defaultValue);
    }

    @JvmStatic
    public static final boolean getBoolean(@NotNull JavaContext context2, @NotNull UAnnotation annotation, @NotNull String name, boolean defaultValue) {
        return Companion.getBoolean(context2, annotation, name, defaultValue);
    }

    @JvmStatic
    @Nullable
    public static final Boolean getAnnotationBooleanValue(@Nullable UAnnotation annotation, @NotNull String name) {
        return Companion.getAnnotationBooleanValue(annotation, name);
    }

    @JvmStatic
    public static final boolean getAnnotationBooleanValue(@Nullable UAnnotation annotation, @NotNull String name, boolean defaultValue) {
        return Companion.getAnnotationBooleanValue(annotation, name, defaultValue);
    }

    @JvmStatic
    @Nullable
    public static final Long getAnnotationLongValue(@Nullable UAnnotation annotation, @NotNull String name) {
        return Companion.getAnnotationLongValue(annotation, name);
    }

    @JvmStatic
    public static final long getAnnotationLongValue(@Nullable UAnnotation annotation, @NotNull String name, long defaultValue) {
        return Companion.getAnnotationLongValue(annotation, name, defaultValue);
    }

    @JvmStatic
    @Nullable
    public static final Double getAnnotationDoubleValue(@Nullable UAnnotation annotation, @NotNull String name) {
        return Companion.getAnnotationDoubleValue(annotation, name);
    }

    @JvmStatic
    public static final double getAnnotationDoubleValue(@Nullable UAnnotation annotation, @NotNull String name, double defaultValue) {
        return Companion.getAnnotationDoubleValue(annotation, name, defaultValue);
    }

    @JvmStatic
    @Nullable
    public static final String getAnnotationStringValue(@Nullable UAnnotation annotation, @NotNull String name) {
        return Companion.getAnnotationStringValue(annotation, name);
    }

    @JvmStatic
    @Nullable
    public static final String[] getAnnotationStringValues(@Nullable UAnnotation annotation, @NotNull String name) {
        return Companion.getAnnotationStringValues(annotation, name);
    }

    @JvmStatic
    public static final boolean containsAnnotation(@NotNull List<? extends UAnnotation> list, @NotNull UAnnotation annotation) {
        return Companion.containsAnnotation(list, annotation);
    }

    @JvmStatic
    public static final boolean containsAnnotation(@NotNull List<? extends UAnnotation> list, @NotNull String qualifiedName) {
        return Companion.containsAnnotation(list, qualifiedName);
    }

    @JvmStatic
    @Nullable
    public static final List<UAnnotation> getDefaultUseSiteAnnotations(@NotNull PsiModifierListOwner owner) {
        return Companion.getDefaultUseSiteAnnotations(owner);
    }

    @JvmStatic
    @Nullable
    public static final List<UAnnotation> getDefaultUseSiteAnnotations(@NotNull UAnnotated annotated) {
        return Companion.getDefaultUseSiteAnnotations(annotated);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u0006H\u0007J\u001c\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007J\u0014\u0010\r\u001a\u0004\u0018\u00010\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007J\u0014\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0006H\u0007J\"\u0010\u001c\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0013\u001a\u00020\u0011H\u0007J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u0011H\u0007J*\u0010!\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\"\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00062\b\b\u0002\u0010$\u001a\u00020%J\"\u0010&\u001a\u00020%2\u0006\u0010\"\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010$\u001a\u00020%H\u0002J \u0010'\u001a\u00020%2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00112\b\b\u0002\u0010+\u001a\u00020%J\u0018\u0010,\u001a\u00020%2\b\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020\u0011J\u0012\u0010-\u001a\u0004\u0018\u00010\u00112\u0006\u0010.\u001a\u00020/H\u0007J\"\u00100\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u00101\u001a\u00020\u00062\u0006\u00102\u001a\u000203H\u0007J\u0012\u00104\u001a\u0004\u0018\u0001052\u0006\u0010\u000b\u001a\u00020\u0006H\u0007J\u0018\u00106\u001a\u00020%2\u0006\u00107\u001a\u00020\u00182\u0006\u00108\u001a\u00020\u0018H\u0007J\u0012\u00109\u001a\u0004\u0018\u00010\u00112\u0006\u0010.\u001a\u00020\u0018H\u0007J\u0010\u0010:\u001a\u00020%2\u0006\u0010;\u001a\u00020\u0006H\u0007J\u0010\u0010<\u001a\u00020%2\u0006\u0010;\u001a\u00020\u0006H\u0007J\u0010\u0010=\u001a\u00020%2\u0006\u0010;\u001a\u00020\u0006H\u0007J\u0012\u0010>\u001a\u0004\u0018\u00010\u00182\u0006\u0010?\u001a\u00020@H\u0007J(\u0010A\u001a\u00020B2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010?\u001a\u00020@2\u0006\u0010C\u001a\u00020\u00112\u0006\u0010D\u001a\u00020BH\u0007J \u0010A\u001a\u00020B2\u0006\u0010?\u001a\u00020@2\u0006\u0010C\u001a\u00020\u00112\u0006\u0010D\u001a\u00020BH\u0007J(\u0010E\u001a\u00020F2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010?\u001a\u00020@2\u0006\u0010C\u001a\u00020\u00112\u0006\u0010D\u001a\u00020FH\u0007J(\u0010G\u001a\u00020%2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010?\u001a\u00020@2\u0006\u0010C\u001a\u00020\u00112\u0006\u0010D\u001a\u00020%H\u0007J!\u0010H\u001a\u0004\u0018\u00010%2\b\u0010?\u001a\u0004\u0018\u00010@2\u0006\u0010C\u001a\u00020\u0011H\u0007\u00a2\u0006\u0002\u0010IJ\"\u0010H\u001a\u00020%2\b\u0010?\u001a\u0004\u0018\u00010@2\u0006\u0010C\u001a\u00020\u00112\u0006\u0010D\u001a\u00020%H\u0007J!\u0010J\u001a\u0004\u0018\u00010B2\b\u0010?\u001a\u0004\u0018\u00010@2\u0006\u0010C\u001a\u00020\u0011H\u0007\u00a2\u0006\u0002\u0010KJ\"\u0010J\u001a\u00020B2\b\u0010?\u001a\u0004\u0018\u00010@2\u0006\u0010C\u001a\u00020\u00112\u0006\u0010D\u001a\u00020BH\u0007J!\u0010L\u001a\u0004\u0018\u00010F2\b\u0010?\u001a\u0004\u0018\u00010@2\u0006\u0010C\u001a\u00020\u0011H\u0007\u00a2\u0006\u0002\u0010MJ\"\u0010L\u001a\u00020F2\b\u0010?\u001a\u0004\u0018\u00010@2\u0006\u0010C\u001a\u00020\u00112\u0006\u0010D\u001a\u00020FH\u0007J\u001c\u0010N\u001a\u0004\u0018\u00010\u00112\b\u0010?\u001a\u0004\u0018\u00010@2\u0006\u0010C\u001a\u00020\u0011H\u0007J'\u0010O\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010P2\b\u0010?\u001a\u0004\u0018\u00010@2\u0006\u0010C\u001a\u00020\u0011H\u0007\u00a2\u0006\u0002\u0010QJ\u001e\u0010R\u001a\u00020%2\f\u0010S\u001a\b\u0012\u0004\u0012\u00020@0T2\u0006\u0010?\u001a\u00020@H\u0007J\u001e\u0010R\u001a\u00020%2\f\u0010S\u001a\b\u0012\u0004\u0012\u00020@0T2\u0006\u0010U\u001a\u00020\u0011H\u0007J\u0018\u0010V\u001a\n\u0012\u0004\u0012\u00020@\u0018\u00010T2\u0006\u0010W\u001a\u00020XH\u0007J\u0018\u0010V\u001a\n\u0012\u0004\u0012\u00020@\u0018\u00010T2\u0006\u0010Y\u001a\u00020ZH\u0007J\u001e\u0010V\u001a\n\u0012\u0004\u0012\u00020@\u0018\u00010T2\f\u0010[\u001a\b\u0012\u0004\u0012\u00020\\0TH\u0002\u00a8\u0006]"}, d2={"Lcom/android/tools/lint/detector/api/UastLintUtils$Companion;", "", "<init>", "()V", "tryResolveUDeclaration", "Lorg/jetbrains/uast/UDeclaration;", "Lorg/jetbrains/uast/UElement;", "getContainingFile", "Lcom/intellij/psi/PsiFile;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "element", "Lcom/intellij/psi/PsiElement;", "getPsiFile", "file", "Lorg/jetbrains/uast/UFile;", "getQualifiedName", "", "getClassName", "type", "Lcom/intellij/psi/PsiClassType;", "psiClass", "Lcom/intellij/psi/PsiClass;", "findLastAssignment", "Lorg/jetbrains/uast/UExpression;", "variable", "Lcom/intellij/psi/PsiVariable;", "endAt", "findArgument", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "findConstruction", "fullQualifiedClassName", "origExpression", "includeSubClass", "", "isFactoryMethodForClass", "isMemberInSubClassOf", "member", "Lcom/intellij/psi/PsiMember;", "className", "strict", "isMemberInClass", "getReferenceName", "expression", "Lorg/jetbrains/uast/UReferenceExpression;", "findLastValue", "call", "evaluator", "Lcom/android/tools/lint/detector/api/ConstantEvaluator;", "toAndroidReferenceViaResolve", "Lcom/android/tools/lint/client/api/ResourceReference;", "areIdentifiersEqual", "first", "second", "getIdentifier", "isNumber", "argument", "isZero", "isMinusOne", "getAnnotationValue", "annotation", "Lorg/jetbrains/uast/UAnnotation;", "getLongAttribute", "", "name", "defaultValue", "getDoubleAttribute", "", "getBoolean", "getAnnotationBooleanValue", "(Lorg/jetbrains/uast/UAnnotation;Ljava/lang/String;)Ljava/lang/Boolean;", "getAnnotationLongValue", "(Lorg/jetbrains/uast/UAnnotation;Ljava/lang/String;)Ljava/lang/Long;", "getAnnotationDoubleValue", "(Lorg/jetbrains/uast/UAnnotation;Ljava/lang/String;)Ljava/lang/Double;", "getAnnotationStringValue", "getAnnotationStringValues", "", "(Lorg/jetbrains/uast/UAnnotation;Ljava/lang/String;)[Ljava/lang/String;", "containsAnnotation", "list", "", "qualifiedName", "getDefaultUseSiteAnnotations", "owner", "Lcom/intellij/psi/PsiModifierListOwner;", "annotated", "Lorg/jetbrains/uast/UAnnotated;", "entries", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "lint-api"})
    @SourceDebugExtension(value={"SMAP\nUastLintUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UastLintUtils.kt\ncom/android/tools/lint/detector/api/UastLintUtils$Companion\n+ 2 UastContext.kt\norg/jetbrains/uast/UastContextKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,1278:1\n171#2:1279\n1#3:1280\n1310#4,2:1281\n*S KotlinDebug\n*F\n+ 1 UastLintUtils.kt\ncom/android/tools/lint/detector/api/UastLintUtils$Companion\n*L\n136#1:1279\n244#1:1281,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final UDeclaration tryResolveUDeclaration(@NotNull UElement $this$tryResolveUDeclaration) {
            Intrinsics.checkNotNullParameter((Object)$this$tryResolveUDeclaration, (String)"<this>");
            UResolvable uResolvable = $this$tryResolveUDeclaration instanceof UResolvable ? (UResolvable)$this$tryResolveUDeclaration : null;
            PsiElement $this$toUElementOfType$iv = uResolvable != null ? uResolvable.resolve() : null;
            boolean $i$f$toUElementOfType = false;
            return (UDeclaration)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UDeclaration.class);
        }

        @JvmStatic
        @Nullable
        public final PsiFile getContainingFile(@NotNull JavaContext context2, @Nullable PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            if (element == null) {
                return null;
            }
            PsiFile containingFile = element.getContainingFile();
            return !Intrinsics.areEqual((Object)containingFile, (Object)context2.getPsiFile()) ? this.getContainingFile(element) : containingFile;
        }

        @JvmStatic
        @Nullable
        public final PsiFile getPsiFile(@Nullable UFile file) {
            PsiFile psiFile;
            UFile uFile = file;
            if (uFile != null) {
                UFile it = uFile;
                boolean bl = false;
                psiFile = Companion.getContainingFile(it.getJavaPsi());
            } else {
                psiFile = null;
            }
            return psiFile;
        }

        @JvmStatic
        @Nullable
        public final PsiFile getContainingFile(@Nullable PsiElement element) {
            if (element == null) {
                return null;
            }
            PsiFile psiFile = element instanceof PsiFile ? (PsiFile)element : null;
            if (psiFile == null && (psiFile = element.getContainingFile()) == null) {
                return null;
            }
            PsiFile containingFile = psiFile;
            if (containingFile instanceof FakeFileForLightClass) {
                return (PsiFile)((FakeFileForLightClass)containingFile).getKtFile();
            }
            return containingFile;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        @Nullable
        public final String getQualifiedName(@NotNull PsiElement element) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            PsiElement psiElement = element;
            if (psiElement instanceof PsiClass) {
                object = ((PsiClass)element).getQualifiedName();
                return object;
            } else if (psiElement instanceof PsiMethod) {
                PsiClass psiClass = ((PsiMethod)element).getContainingClass();
                Object object2 = psiClass;
                if (psiClass == null) return null;
                PsiClass it = object2;
                boolean bl = false;
                String string = Companion.getQualifiedName((PsiElement)it);
                object2 = string;
                if (string == null) return null;
                it = object2;
                boolean bl2 = false;
                object = (String)it + "." + ((PsiMethod)element).getName();
                return object;
            } else {
                if (!(psiElement instanceof PsiField)) return null;
                PsiClass psiClass = ((PsiField)element).getContainingClass();
                Object object3 = psiClass;
                if (psiClass == null) return null;
                PsiClass it = object3;
                boolean bl = false;
                String string = Companion.getQualifiedName((PsiElement)it);
                object3 = string;
                if (string == null) return null;
                it = object3;
                boolean bl3 = false;
                object = (String)it + "." + ((PsiField)element).getName();
            }
            return object;
        }

        @JvmStatic
        @NotNull
        public final String getClassName(@NotNull PsiClassType type) {
            Object object;
            block3: {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                    PsiClass psiClass = type.resolve();
                    object = psiClass;
                    if (object == null) break block2;
                    PsiClass it = object;
                    boolean bl = false;
                    String string = Companion.getClassName(it);
                    object = string;
                    if (string != null) break block3;
                }
                String string = type.getClassName();
                object = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getClassName(...)");
            }
            return object;
        }

        @JvmStatic
        @NotNull
        public final String getClassName(@NotNull PsiClass psiClass) {
            Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(psiClass.getName());
            for (PsiClass currPsiClass = psiClass.getContainingClass(); currPsiClass != null; currPsiClass = currPsiClass.getContainingClass()) {
                stringBuilder.insert(0, currPsiClass.getName() + ".");
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        @JvmStatic
        @Nullable
        public final UExpression findLastAssignment(@NotNull PsiVariable variable, @NotNull UElement endAt) {
            UElement uElement;
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            Intrinsics.checkNotNullParameter((Object)endAt, (String)"endAt");
            PsiVariable currVariable = variable;
            UElement lastAssignment = null;
            if (currVariable instanceof UVariableEx) {
                currVariable = ((UVariableEx)currVariable).getJavaPsi();
            }
            if (!currVariable.hasModifierProperty("final") && (currVariable instanceof PsiLocalVariable || currVariable instanceof PsiParameter)) {
                UMethod containingFunction = UastUtils.getContainingUMethod((UElement)endAt);
                if (containingFunction != null) {
                    ConstantEvaluatorImpl.LastAssignmentFinder finder = new ConstantEvaluatorImpl.LastAssignmentFinder(currVariable, endAt, null, -1);
                    containingFunction.accept((UastVisitor)finder);
                    lastAssignment = finder.getLastAssignment();
                }
            } else {
                lastAssignment = (UElement)UastFacade.INSTANCE.getInitializerBody(currVariable);
            }
            return (uElement = lastAssignment) instanceof UExpression ? (UExpression)uElement : null;
        }

        @JvmStatic
        @Nullable
        public final UExpression findArgument(@NotNull UCallExpression node, @NotNull PsiMethod method, @NotNull String type) {
            UExpression argument;
            Object object;
            block2: {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                PsiParameter[] psiParameterArray = method.getParameterList().getParameters();
                Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"getParameters(...)");
                Object[] $this$firstOrNull$iv = psiParameterArray;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PsiParameter it = (PsiParameter)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getType().getCanonicalText(), (Object)type)) continue;
                    object = element$iv;
                    break block2;
                }
                object = null;
            }
            PsiParameter psiParameter = (PsiParameter)object;
            if (psiParameter == null) {
                return null;
            }
            PsiParameter psiParameter2 = psiParameter;
            UExpression uExpression = argument = node.getArgumentForParameter(KtPsiUtilKt.parameterIndex((PsiElement)((PsiElement)psiParameter2)));
            return uExpression != null ? UastUtils.skipParenthesizedExprDown((UExpression)uExpression) : null;
        }

        @JvmStatic
        @Nullable
        public final UExpression findArgument(@NotNull UCallExpression node, @NotNull String type) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            PsiMethod psiMethod = node.resolve();
            if (psiMethod == null) {
                return null;
            }
            return this.findArgument(node, psiMethod, type);
        }

        @Nullable
        public final UCallExpression findConstruction(@NotNull String fullQualifiedClassName, @NotNull UExpression origExpression, @NotNull UElement endAt, boolean includeSubClass) {
            Object object;
            PsiElement resolved;
            Intrinsics.checkNotNullParameter((Object)fullQualifiedClassName, (String)"fullQualifiedClassName");
            Intrinsics.checkNotNullParameter((Object)origExpression, (String)"origExpression");
            Intrinsics.checkNotNullParameter((Object)endAt, (String)"endAt");
            UExpression expression = UastUtils.skipParenthesizedExprDown((UExpression)origExpression);
            UCallExpression call = UastUtils.getUCallExpression((UElement)((UElement)expression), (int)1);
            if (call != null) {
                UReferenceExpression classRef = call.getClassReference();
                if (classRef != null) {
                    PsiElement psiElement;
                    UReferenceExpression uReferenceExpression = call.getClassReference();
                    if (Intrinsics.areEqual((Object)(uReferenceExpression != null ? UastUtils.getQualifiedName((UReferenceExpression)uReferenceExpression) : null), (Object)fullQualifiedClassName) || includeSubClass && InheritanceUtil.isInheritor((PsiClass)((psiElement = classRef.resolve()) instanceof PsiClass ? (PsiClass)psiElement : null), (boolean)true, (String)fullQualifiedClassName)) {
                        return call;
                    }
                }
                if (expression instanceof UQualifiedReferenceExpression) {
                    return UastLintUtilsKt.isReturningContext(call) ? this.findConstruction(fullQualifiedClassName, ((UQualifiedReferenceExpression)expression).getReceiver(), endAt, includeSubClass) : this.findConstruction(fullQualifiedClassName, (UExpression)call, endAt, includeSubClass);
                }
            }
            if ((resolved = UastUtils.tryResolve((UElement)((UElement)expression))) instanceof PsiVariable) {
                UExpression uExpression = this.findLastAssignment((PsiVariable)resolved, endAt);
                if (uExpression == null) {
                    return null;
                }
                UExpression assignment = uExpression;
                object = this.findConstruction(fullQualifiedClassName, assignment, endAt, includeSubClass);
            } else {
                object = resolved instanceof PsiMethod ? (this.isFactoryMethodForClass(fullQualifiedClassName, (PsiMethod)resolved, includeSubClass) ? (expression instanceof UCallExpression ? (UCallExpression)expression : null) : null) : null;
            }
            return object;
        }

        public static /* synthetic */ UCallExpression findConstruction$default(Companion companion, String string, UExpression uExpression, UElement uElement, boolean bl, int n, Object object) {
            if ((n & 8) != 0) {
                bl = false;
            }
            return companion.findConstruction(string, uExpression, uElement, bl);
        }

        private final boolean isFactoryMethodForClass(String fullQualifiedClassName, PsiMethod method, boolean includeSubClass) {
            PsiType psiType = method.getReturnType();
            return (Intrinsics.areEqual((Object)(psiType != null ? psiType.getCanonicalText() : null), (Object)fullQualifiedClassName) || method.isConstructor()) && (this.isMemberInClass((PsiMember)method, fullQualifiedClassName) || includeSubClass && com.android.tools.lint.detector.api.UastLintUtils$Companion.isMemberInSubClassOf$default(this, (PsiMember)method, fullQualifiedClassName, false, 4, null));
        }

        static /* synthetic */ boolean isFactoryMethodForClass$default(Companion companion, String string, PsiMethod psiMethod, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            return companion.isFactoryMethodForClass(string, psiMethod, bl);
        }

        public final boolean isMemberInSubClassOf(@NotNull PsiMember member, @NotNull String className, boolean strict) {
            Intrinsics.checkNotNullParameter((Object)member, (String)"member");
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            PsiClass containingClass = member.getContainingClass();
            return containingClass != null && InheritanceUtil.isInheritor((PsiClass)containingClass, (boolean)strict, (String)className);
        }

        public static /* synthetic */ boolean isMemberInSubClassOf$default(Companion companion, PsiMember psiMember, String string, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            return companion.isMemberInSubClassOf(psiMember, string, bl);
        }

        public final boolean isMemberInClass(@Nullable PsiMember member, @NotNull String className) {
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            if (member == null) {
                return false;
            }
            PsiClass psiClass = member.getContainingClass();
            String containingClass = psiClass != null ? psiClass.getQualifiedName() : null;
            return Intrinsics.areEqual((Object)className, (Object)containingClass);
        }

        @JvmStatic
        @Nullable
        public final String getReferenceName(@NotNull UReferenceExpression expression) {
            UExpression selector;
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            if (expression instanceof USimpleNameReferenceExpression) {
                return ((USimpleNameReferenceExpression)expression).getIdentifier();
            }
            if (expression instanceof UQualifiedReferenceExpression && (selector = ((UQualifiedReferenceExpression)expression).getSelector()) instanceof USimpleNameReferenceExpression) {
                return ((USimpleNameReferenceExpression)selector).getIdentifier();
            }
            return null;
        }

        @JvmStatic
        @Nullable
        public final Object findLastValue(@NotNull PsiVariable variable, @NotNull UElement call, @NotNull ConstantEvaluator evaluator) {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            Intrinsics.checkNotNullParameter((Object)evaluator, (String)"evaluator");
            Object value = null;
            if (!variable.hasModifierProperty("final") && (variable instanceof PsiLocalVariable || variable instanceof PsiParameter)) {
                UExpression body;
                UMethod containingFunction = UastUtils.getContainingUMethod((UElement)call);
                if (containingFunction != null && (body = containingFunction.getUastBody()) != null) {
                    ConstantEvaluatorImpl.LastAssignmentFinder finder = new ConstantEvaluatorImpl.LastAssignmentFinder(variable, call, evaluator, 1);
                    body.accept((UastVisitor)finder);
                    value = finder.getCurrentValue();
                    if (value == null && finder.getLastAssignment() != null) {
                        return ConstantEvaluatorImpl.LastAssignmentFinder.LastAssignmentValueUnknown.INSTANCE;
                    }
                }
            } else {
                UExpression initializer = UastFacade.INSTANCE.getInitializerBody(variable);
                if (initializer != null) {
                    value = initializer.evaluate();
                }
            }
            return value;
        }

        @JvmStatic
        @Nullable
        public final ResourceReference toAndroidReferenceViaResolve(@NotNull UElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return ResourceReference.Companion.get(element);
        }

        @JvmStatic
        public final boolean areIdentifiersEqual(@NotNull UExpression first, @NotNull UExpression second) {
            Intrinsics.checkNotNullParameter((Object)first, (String)"first");
            Intrinsics.checkNotNullParameter((Object)second, (String)"second");
            String firstIdentifier = this.getIdentifier(first);
            String secondIdentifier = this.getIdentifier(second);
            return firstIdentifier != null && secondIdentifier != null && Intrinsics.areEqual((Object)firstIdentifier, (Object)secondIdentifier);
        }

        @JvmStatic
        @Nullable
        public final String getIdentifier(@NotNull UExpression expression) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            UExpression uExpression = expression;
            if (uExpression instanceof ULiteralExpression) {
                object = ((ULiteralExpression)expression).asRenderString();
            } else if (uExpression instanceof UQualifiedReferenceExpression) {
                String receiverIdentifier = this.getIdentifier(((UQualifiedReferenceExpression)expression).getReceiver());
                String selectorIdentifier = this.getIdentifier(((UQualifiedReferenceExpression)expression).getSelector());
                object = receiverIdentifier == null || selectorIdentifier == null ? null : receiverIdentifier + "." + selectorIdentifier;
            } else {
                object = null;
            }
            return object;
        }

        @JvmStatic
        public final boolean isNumber(@NotNull UElement argument) {
            Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
            UElement uElement = argument;
            return uElement instanceof ULiteralExpression ? ((ULiteralExpression)argument).getValue() instanceof Number : (uElement instanceof UPrefixExpression ? this.isNumber((UElement)((UPrefixExpression)argument).getOperand()) : false);
        }

        @JvmStatic
        public final boolean isZero(@NotNull UElement argument) {
            Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
            if (argument instanceof ULiteralExpression) {
                Object value = ((ULiteralExpression)argument).getValue();
                return value instanceof Number && ((Number)value).intValue() == 0;
            }
            return false;
        }

        @JvmStatic
        public final boolean isMinusOne(@NotNull UElement argument) {
            Object value;
            UExpression operand;
            Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
            boolean bl = argument instanceof UUnaryExpression ? ((operand = ((UUnaryExpression)argument).getOperand()) instanceof ULiteralExpression && ((UUnaryExpression)argument).getOperator() == UastPrefixOperator.UNARY_MINUS ? (value = ((ULiteralExpression)operand).getValue()) instanceof Number && ((Number)value).intValue() == 1 : false) : false;
            return bl;
        }

        @JvmStatic
        @Nullable
        public final UExpression getAnnotationValue(@NotNull UAnnotation annotation) {
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            return annotation.findDeclaredAttributeValue("value");
        }

        @JvmStatic
        public final long getLongAttribute(@NotNull JavaContext context2, @NotNull UAnnotation annotation, @NotNull String name, long defaultValue) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return this.getLongAttribute(annotation, name, defaultValue);
        }

        @JvmStatic
        public final long getLongAttribute(@NotNull UAnnotation annotation, @NotNull String name, long defaultValue) {
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return this.getAnnotationLongValue(annotation, name, defaultValue);
        }

        @JvmStatic
        public final double getDoubleAttribute(@NotNull JavaContext context2, @NotNull UAnnotation annotation, @NotNull String name, double defaultValue) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return this.getAnnotationDoubleValue(annotation, name, defaultValue);
        }

        @JvmStatic
        public final boolean getBoolean(@NotNull JavaContext context2, @NotNull UAnnotation annotation, @NotNull String name, boolean defaultValue) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return this.getAnnotationBooleanValue(annotation, name, defaultValue);
        }

        @JvmStatic
        @Nullable
        public final Boolean getAnnotationBooleanValue(@Nullable UAnnotation annotation, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return AnnotationValuesExtractor.Companion.getAnnotationValuesExtractor$lint_api(annotation).getAnnotationBooleanValue$lint_api(annotation, name);
        }

        @JvmStatic
        public final boolean getAnnotationBooleanValue(@Nullable UAnnotation annotation, @NotNull String name, boolean defaultValue) {
            Boolean value;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Boolean bl = value = this.getAnnotationBooleanValue(annotation, name);
            return bl != null ? bl : defaultValue;
        }

        @JvmStatic
        @Nullable
        public final Long getAnnotationLongValue(@Nullable UAnnotation annotation, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return AnnotationValuesExtractor.Companion.getAnnotationValuesExtractor$lint_api(annotation).getAnnotationLongValue$lint_api(annotation, name);
        }

        @JvmStatic
        public final long getAnnotationLongValue(@Nullable UAnnotation annotation, @NotNull String name, long defaultValue) {
            Long value;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Long l = value = this.getAnnotationLongValue(annotation, name);
            return l != null ? l : defaultValue;
        }

        @JvmStatic
        @Nullable
        public final Double getAnnotationDoubleValue(@Nullable UAnnotation annotation, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return AnnotationValuesExtractor.Companion.getAnnotationValuesExtractor$lint_api(annotation).getAnnotationDoubleValue$lint_api(annotation, name);
        }

        @JvmStatic
        public final double getAnnotationDoubleValue(@Nullable UAnnotation annotation, @NotNull String name, double defaultValue) {
            Double value;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Double d = value = this.getAnnotationDoubleValue(annotation, name);
            return d != null ? d : defaultValue;
        }

        @JvmStatic
        @Nullable
        public final String getAnnotationStringValue(@Nullable UAnnotation annotation, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return AnnotationValuesExtractor.Companion.getAnnotationValuesExtractor$lint_api(annotation).getAnnotationStringValue$lint_api(annotation, name);
        }

        @JvmStatic
        @Nullable
        public final String[] getAnnotationStringValues(@Nullable UAnnotation annotation, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return AnnotationValuesExtractor.Companion.getAnnotationValuesExtractor$lint_api(annotation).getAnnotationStringValues$lint_api(annotation, name);
        }

        @JvmStatic
        public final boolean containsAnnotation(@NotNull List<? extends UAnnotation> list, @NotNull UAnnotation annotation) {
            Intrinsics.checkNotNullParameter(list, (String)"list");
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            Function1 function1 = (Function1)new Function1<UAnnotation, Boolean>(annotation){
                final /* synthetic */ UAnnotation $annotation;
                {
                    this.$annotation = $annotation;
                    super(1);
                }

                public final Boolean invoke(UAnnotation e) {
                    return e == this.$annotation;
                }
            };
            return list.stream().anyMatch(new Predicate(function1){
                private final /* synthetic */ Function1 function;
                {
                    Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                    this.function = function;
                }

                public final /* synthetic */ boolean test(Object p0) {
                    return (Boolean)this.function.invoke(p0);
                }
            });
        }

        @JvmStatic
        public final boolean containsAnnotation(@NotNull List<? extends UAnnotation> list, @NotNull String qualifiedName) {
            Intrinsics.checkNotNullParameter(list, (String)"list");
            Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
            Function1 function1 = (Function1)new Function1<UAnnotation, Boolean>(qualifiedName){
                final /* synthetic */ String $qualifiedName;
                {
                    this.$qualifiedName = $qualifiedName;
                    super(1);
                }

                public final Boolean invoke(UAnnotation e) {
                    return Intrinsics.areEqual((Object)e.getQualifiedName(), (Object)this.$qualifiedName);
                }
            };
            return list.stream().anyMatch(new /* invalid duplicate definition of identical inner class */);
        }

        @JvmStatic
        @Nullable
        public final List<UAnnotation> getDefaultUseSiteAnnotations(@NotNull PsiModifierListOwner owner) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            if (owner instanceof KtLightMember) {
                PsiElement origin = LightClassUtilsKt.getUnwrapped((PsiElement)((PsiElement)owner));
                if (origin instanceof KtProperty) {
                    List list = ((KtProperty)origin).getAnnotationEntries();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAnnotationEntries(...)");
                    return this.getDefaultUseSiteAnnotations(list);
                }
            } else if (owner instanceof KtLightParameter) {
                KtDeclaration origin;
                PsiElement psiElement = LightClassUtilsKt.getUnwrapped((PsiElement)((PsiElement)((KtLightParameter)owner).getMethod()));
                KtDeclaration ktDeclaration = origin = psiElement instanceof KtDeclaration ? (KtDeclaration)psiElement : null;
                if (origin instanceof KtProperty || origin instanceof KtParameter) {
                    List list = origin.getAnnotationEntries();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAnnotationEntries(...)");
                    return this.getDefaultUseSiteAnnotations(list);
                }
            }
            return null;
        }

        @JvmStatic
        @Nullable
        public final List<UAnnotation> getDefaultUseSiteAnnotations(@NotNull UAnnotated annotated) {
            List list;
            Intrinsics.checkNotNullParameter((Object)annotated, (String)"annotated");
            PsiElement origin = annotated.getSourcePsi();
            if (origin instanceof KtParameter) {
                list = ((KtParameter)origin).getAnnotationEntries();
            } else if (origin instanceof KtProperty) {
                list = ((KtProperty)origin).getAnnotationEntries();
            } else {
                return null;
            }
            List list2 = list;
            Intrinsics.checkNotNull((Object)list2);
            List entries = list2;
            return this.getDefaultUseSiteAnnotations(entries);
        }

        private final List<UAnnotation> getDefaultUseSiteAnnotations(List<? extends KtAnnotationEntry> entries) {
            List annotations = null;
            for (KtAnnotationEntry ktAnnotationEntry : entries) {
                String signature;
                UAnnotation it;
                UElement uElement;
                AnnotationUseSiteTarget site;
                KtAnnotationUseSiteTarget ktAnnotationUseSiteTarget = ktAnnotationEntry.getUseSiteTarget();
                Object object = site = ktAnnotationUseSiteTarget != null ? ktAnnotationUseSiteTarget.getAnnotationUseSiteTarget() : null;
                if (site != null && site != AnnotationUseSiteTarget.PROPERTY || ((uElement = UastLanguagePlugin.convertElement$default((UastLanguagePlugin)((UastLanguagePlugin)UastFacade.INSTANCE), (PsiElement)((PsiElement)ktAnnotationEntry), null, null, (int)4, null)) instanceof UAnnotation ? (UAnnotation)uElement : null) == null) continue;
                it = it;
                boolean bl = false;
                String string = it.getQualifiedName();
                if (string == null) {
                    string = "";
                }
                UAnnotation annotation = AndroidPlatformAnnotations.Companion.isPlatformAnnotation(signature = string) ? AndroidPlatformAnnotations.Companion.fromPlatformAnnotation(it, signature) : it;
                List list = annotations;
                if (list == null) {
                    List list2;
                    List it2 = list2 = (List)new ArrayList();
                    boolean bl2 = false;
                    annotations = it2;
                    list = list2;
                }
                List list3 = list;
                list3.add(annotation);
            }
            return annotations;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

