/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintBaseline;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.tools.lint.model.LintModelModule;
import com.android.tools.lint.model.PathVariables;
import com.android.utils.XmlUtils;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 L2\u00020\u0001:\u0004LMNOB\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u00100\u001a\u000201J\u000e\u00102\u001a\u00020#2\u0006\u00103\u001a\u000204J:\u00102\u001a\u00020#2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\t2\b\u0010:\u001a\u0004\u0018\u00010;2\u000e\u0010<\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u001cH\u0002J\u0010\u0010=\u001a\u0004\u0018\u00010\t2\u0006\u0010>\u001a\u00020\tJ\b\u0010?\u001a\u000201H\u0002J\u001d\u0010@\u001a\u0002012\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020DH\u0000\u00a2\u0006\u0002\bEJ\u001e\u0010F\u001a\u00020#2\u0006\u00105\u001a\u0002062\u0006\u0010G\u001a\u00020\t2\u0006\u0010H\u001a\u00020\tJ\u0016\u0010I\u001a\u0002012\u0006\u0010>\u001a\u00020\t2\u0006\u0010J\u001a\u00020\tJ\u000e\u0010K\u001a\u0002012\u0006\u0010\u0004\u001a\u00020\u0005R\u001c\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\b\u0012\u00060\fR\u00020\u0000\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0014R\u001e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0014R6\u0010\u001a\u001a*\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u001c0\u001bj\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u001c`\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\u001e\u001aB\u0012\f\u0012\n  *\u0004\u0018\u00010\t0\t\u0012\f\u0012\n  *\u0004\u0018\u00010!0!  * \u0012\f\u0012\n  *\u0004\u0018\u00010\t0\t\u0012\f\u0012\n  *\u0004\u0018\u00010!0!\u0018\u00010\u001f0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010(\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010%\"\u0004\b*\u0010'R\u001e\u0010+\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u0014R$\u0010-\u001a\u00020#2\u0006\u0010-\u001a\u00020#@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010%\"\u0004\b/\u0010'\u00a8\u0006P"}, d2={"Lcom/android/tools/lint/client/api/LintBaseline;", "", "client", "Lcom/android/tools/lint/client/api/LintClient;", "file", "Ljava/io/File;", "(Lcom/android/tools/lint/client/api/LintClient;Ljava/io/File;)V", "attributes", "", "", "entriesToWrite", "", "Lcom/android/tools/lint/client/api/LintBaseline$ReportedEntry;", "getFile", "()Ljava/io/File;", "setFile", "(Ljava/io/File;)V", "fixedCount", "", "getFixedCount", "()I", "<set-?>", "foundErrorCount", "getFoundErrorCount", "foundWarningCount", "getFoundWarningCount", "idToMessages", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "messageToEntry", "Lcom/google/common/collect/ArrayListMultimap;", "kotlin.jvm.PlatformType", "Lcom/android/tools/lint/client/api/LintBaseline$Entry;", "omitLineNumbers", "", "getOmitLineNumbers", "()Z", "setOmitLineNumbers", "(Z)V", "removeFixed", "getRemoveFixed", "setRemoveFixed", "totalCount", "getTotalCount", "writeOnClose", "getWriteOnClose", "setWriteOnClose", "close", "", "findAndMark", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "location", "Lcom/android/tools/lint/detector/api/Location;", "message", "severity", "Lcom/android/tools/lint/detector/api/Severity;", "alreadyChecked", "getAttribute", "name", "readBaselineFile", "reportBaselineIssues", "driver", "Lcom/android/tools/lint/client/api/LintDriver;", "project", "Lcom/android/tools/lint/detector/api/Project;", "reportBaselineIssues$lint_api", "sameMessage", "new", "old", "setAttribute", "value", "write", "Companion", "Entry", "LightLocation", "ReportedEntry", "lint-api"})
@SourceDebugExtension(value={"SMAP\nLintBaseline.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintBaseline.kt\ncom/android/tools/lint/client/api/LintBaseline\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,1010:1\n1#2:1011\n603#3:1012\n1313#3,2:1013\n*S KotlinDebug\n*F\n+ 1 LintBaseline.kt\ncom/android/tools/lint/client/api/LintBaseline\n*L\n532#1:1012\n533#1:1013,2\n*E\n"})
public final class LintBaseline {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final LintClient client;
    @NotNull
    private File file;
    private int foundErrorCount;
    private int foundWarningCount;
    private int totalCount;
    private final ArrayListMultimap<String, Entry> messageToEntry;
    @NotNull
    private final HashMap<String, Set<String>> idToMessages;
    private boolean writeOnClose;
    private boolean removeFixed;
    private boolean omitLineNumbers;
    @Nullable
    private List<ReportedEntry> entriesToWrite;
    @Nullable
    private Map<String, String> attributes;
    @NotNull
    public static final String VARIANT_ALL = "all";
    @NotNull
    public static final String VARIANT_FATAL = "fatal";

    public LintBaseline(@Nullable LintClient client, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.client = client;
        this.file = file;
        this.messageToEntry = ArrayListMultimap.create((int)100, (int)20);
        this.idToMessages = new HashMap(30);
        this.readBaselineFile();
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    public final void setFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
        this.file = file;
    }

    public final int getFoundErrorCount() {
        return this.foundErrorCount;
    }

    public final int getFoundWarningCount() {
        return this.foundWarningCount;
    }

    public final int getTotalCount() {
        return this.totalCount;
    }

    public final boolean getWriteOnClose() {
        return this.writeOnClose;
    }

    public final void setWriteOnClose(boolean writeOnClose) {
        if (writeOnClose) {
            int count = this.totalCount > 0 ? this.totalCount + 10 : 30;
            this.entriesToWrite = new ArrayList(count);
        }
        this.writeOnClose = writeOnClose;
    }

    public final boolean getRemoveFixed() {
        return this.removeFixed;
    }

    public final void setRemoveFixed(boolean bl) {
        this.removeFixed = bl;
    }

    public final boolean getOmitLineNumbers() {
        return this.omitLineNumbers;
    }

    public final void setOmitLineNumbers(boolean bl) {
        this.omitLineNumbers = bl;
    }

    public final int getFixedCount() {
        return this.totalCount - this.foundErrorCount - this.foundWarningCount;
    }

    public final void reportBaselineIssues$lint_api(@NotNull LintDriver driver, @NotNull Project project) {
        int fixedCount;
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (this.foundErrorCount > 0 || this.foundWarningCount > 0) {
            LintClient client = driver.getClient();
            File baselineFile = this.file;
            String message2 = Companion.describeBaselineFilter(this.foundErrorCount, this.foundWarningCount, LintBaseline.Companion.getDisplayPath(client, project, baselineFile));
            LintClient.Companion.report$default(LintClient.Companion, client, IssueRegistry.BASELINE, message2, baselineFile, null, null, null, null, null, project, null, driver, null, 5616, null);
        }
        if (!((fixedCount = this.getFixedCount()) <= 0 || this.writeOnClose && this.removeFixed)) {
            LintClient client = driver.getClient();
            File baselineFile = this.file;
            HashMap ids = Maps.newHashMap();
            for (Entry entry : this.messageToEntry.values()) {
                String id = entry.getIssueId();
                if (IssueRegistry.Companion.isDeletedIssueId(id)) continue;
                Integer count = (Integer)ids.get(id);
                count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
                Intrinsics.checkNotNullExpressionValue((Object)ids, (String)"ids");
                ((Map)ids).put(id, count);
            }
            if (ids.isEmpty()) {
                return;
            }
            ArrayList sorted = Lists.newArrayList((Iterable)ids.keySet());
            Intrinsics.checkNotNullExpressionValue((Object)sorted, (String)"sorted");
            CollectionsKt.sort((List)sorted);
            StringBuilder issueTypes = new StringBuilder();
            for (String id : sorted) {
                if (((CharSequence)issueTypes).length() > 0) {
                    issueTypes.append(", ");
                }
                issueTypes.append(id);
                Integer count = (Integer)ids.get(id);
                if (count == null || count <= 1) continue;
                issueTypes.append(" (").append(count.toString()).append(")");
            }
            String string = "%1$d errors/warnings were listed in the baseline file (%2$s) but not found in the project; perhaps they have been fixed?";
            Object[] objectArray = new Object[]{fixedCount, TextFormat.TEXT.convertTo(LintBaseline.Companion.getDisplayPath(client, project, baselineFile), TextFormat.RAW)};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            Object message3 = string2;
            if (LintClient.Companion.isGradle() && project.getBuildModule() != null) {
                LintModelModule lintModelModule = project.getBuildModule();
                boolean bl = lintModelModule != null && (lintModelModule = lintModelModule.getLintOptions()) != null ? !lintModelModule.getCheckDependencies() : false;
                if (bl) {
                    message3 = (String)message3 + " Another possible explanation is that lint recently stopped analyzing (and including results from) dependent projects by default. You can turn this back on with `android.lintOptions.checkDependencies=true`.";
                }
            }
            message3 = (String)message3 + " Unmatched issue types: " + issueTypes;
            LintClient.Companion.report$default(LintClient.Companion, client, IssueRegistry.BASELINE, (String)message3, baselineFile, null, null, null, null, null, project, null, driver, null, 5616, null);
        }
    }

    public final boolean findAndMark(@NotNull Incident incident) {
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        Issue issue = incident.getIssue();
        Location location2 = incident.getLocation();
        String message2 = incident.getMessage();
        Severity severity = incident.getSeverity();
        boolean found = this.findAndMark(issue, location2, message2, severity, null);
        if (this.writeOnClose && (!this.removeFixed || found) && this.entriesToWrite != null && !Intrinsics.areEqual((Object)issue.getId(), (Object)IssueRegistry.BASELINE.getId())) {
            Project project = incident.getProject();
            List<ReportedEntry> list2 = this.entriesToWrite;
            Intrinsics.checkNotNull(list2);
            list2.add(new ReportedEntry(issue, project, location2, message2));
        }
        return found;
    }

    private final boolean findAndMark(Issue issue, Location location2, String message2, Severity severity, Set<String> alreadyChecked) {
        if (((CharSequence)message2).length() == 0) {
            return false;
        }
        List entries = this.messageToEntry.get((Object)message2);
        if (entries == null || entries.isEmpty()) {
            Set<String> messages = this.idToMessages.get(issue.getId());
            if (messages != null && !((Collection)messages).isEmpty() && (messages.size() > 1 || messages.size() == 1 && !Intrinsics.areEqual((Object)CollectionsKt.first((Iterable)messages), (Object)message2))) {
                Set<String> set = alreadyChecked;
                if (set == null) {
                    Object object;
                    Object $this$findAndMark_u24lambda_u240 = object = (Set)new LinkedHashSet();
                    boolean bl = false;
                    $this$findAndMark_u24lambda_u240.add(message2);
                    set = object;
                }
                Set<String> checked = set;
                for (String oldMessage : messages) {
                    if (!checked.add(oldMessage) || !this.sameMessage(issue, message2, oldMessage) || !this.findAndMark(issue, location2, oldMessage, severity, checked)) continue;
                    return true;
                }
            }
            return false;
        }
        File file = location2.getFile();
        String path2 = file.getPath();
        String issueId = issue.getId();
        for (Entry entry : entries) {
            if (entry == null || !Intrinsics.areEqual((Object)entry.getIssueId(), (Object)issueId) && (!IssueRegistry.Companion.isDeletedIssueId(entry.getIssueId()) || !Intrinsics.areEqual((Object)IssueRegistry.Companion.getNewId(entry.getIssueId()), (Object)issueId))) continue;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
            if (!Companion.isSamePathSuffix(path2, entry.getPath())) continue;
            Entry curr = entry;
            while (curr.getPrevious() != null) {
                curr = curr.getPrevious();
            }
            while (curr != null) {
                String currMessage = curr.getMessage();
                this.messageToEntry.remove((Object)currMessage, (Object)curr);
                List remaining = this.messageToEntry.get((Object)currMessage);
                if (remaining == null || remaining.isEmpty()) {
                    Set<String> set = this.idToMessages.get(issue.getId());
                    if (set != null) {
                        set.remove(currMessage);
                    }
                }
                curr = curr.getNext();
            }
            Severity severity2 = severity;
            if (severity2 == null) {
                severity2 = issue.getDefaultSeverity();
            }
            if (severity2.isError()) {
                int n = this.foundErrorCount;
                this.foundErrorCount = n + 1;
            } else {
                int n = this.foundWarningCount;
                this.foundWarningCount = n + 1;
            }
            return true;
        }
        return false;
    }

    public final boolean sameMessage(@NotNull Issue issue, @NotNull String string, @NotNull String old) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)string, (String)"new");
        Intrinsics.checkNotNullParameter((Object)old, (String)"old");
        return switch (issue.getId()) {
            case "InvalidPackage" -> LintBaseline.Companion.sameSuffixFrom("not included in", string, old);
            case "IconDensities" -> true;
            case "UselessLeaf" -> true;
            case "NonResizeableActivity" -> true;
            case "ScopedStorage" -> LintBaseline.Companion.sameSuffixFrom("MANAGE_EXTERNAL_STORAGE", string, old);
            case "SmallSp" -> LintBaseline.Companion.sameSuffixFrom("sp:", string, old);
            case "BatteryLife" -> {
                String s = "Use of REQUEST_IGNORE_BATTERY_OPTIMIZATIONS";
                if (StringsKt.startsWith$default((String)old, (String)s, (boolean)false, (int)2, null) && StringsKt.startsWith$default((String)string, (String)s, (boolean)false, (int)2, null)) {
                    yield true;
                }
                yield false;
            }
            case "ContentDescription" -> com.android.tools.lint.client.api.LintBaseline$Companion.stringsEquivalent$default(Companion, StringsKt.removePrefix((String)old, (CharSequence)"[Accessibility] "), string, 0, 0, 12, null);
            case "HardcodedText" -> com.android.tools.lint.client.api.LintBaseline$Companion.stringsEquivalent$default(Companion, StringsKt.removePrefix((String)old, (CharSequence)"[I18N] "), string, 0, 0, 12, null);
            case "InlinedApi", "NewApi", "UnusedAttribute" -> Companion.stringsEquivalent(old, string, (Function2<? super String, ? super Integer, Boolean>)((Function2)sameMessage.1.INSTANCE));
            case "RestrictedApi" -> {
                int index1 = StringsKt.indexOf$default((CharSequence)old, (char)'(', (int)0, (boolean)false, (int)6, null);
                int index2 = StringsKt.indexOf$default((CharSequence)string, (char)'(', (int)0, (boolean)false, (int)6, null);
                if (index1 != -1) {
                    if (index1 == index2 && StringsKt.regionMatches$default((String)old, (int)0, (String)string, (int)0, (int)index1, (boolean)false, (int)16, null)) {
                        yield true;
                    }
                    yield false;
                }
                yield com.android.tools.lint.client.api.LintBaseline$Companion.stringsEquivalent$default(Companion, old, string, 0, 0, 12, null);
            }
            case "IconMissingDensityFolder", "IconXmlAndPng" -> com.android.tools.lint.client.api.LintBaseline$Companion.sameWithAbsolutePath$default(Companion, string, old, null, null, 12, null);
            case "MissingQuantity" -> LintBaseline.Companion.sameSuffixFrom("should also be defined", string, old);
            case "RtlCompat" -> Companion.stringsEquivalent(old, string, (Function2<? super String, ? super Integer, Boolean>)((Function2)sameMessage.2.INSTANCE));
            default -> com.android.tools.lint.client.api.LintBaseline$Companion.stringsEquivalent$default(Companion, old, string, 0, 0, 12, null);
        };
    }

    @Nullable
    public final String getAttribute(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Map<String, String> map = this.attributes;
        return map != null ? map.get(name) : null;
    }

    public final void setAttribute(@NotNull String name, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Map map = this.attributes;
        if (map == null) {
            Map newMap;
            LintBaseline $this$setAttribute_u24lambda_u241 = this;
            boolean bl = false;
            $this$setAttribute_u24lambda_u241.attributes = newMap = (Map)new LinkedHashMap();
            map = newMap;
        }
        Map attributes = map;
        attributes.put((String)name, (String)value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void readBaselineFile() {
        if (!this.file.exists()) {
            return;
        }
        try {
            var1_1 = this.file;
            var2_4 = Charsets.UTF_8;
            var3_5 = 8192;
            var4_9 = var1_1;
            var4_9 = new InputStreamReader((InputStream)new FileInputStream((File)var4_9), (Charset)var2_4);
            var1_1 = var4_9 instanceof BufferedReader != false ? (BufferedReader)var4_9 : new BufferedReader((Reader)var4_9, var3_5);
            var2_4 = null;
            try {
                reader = (BufferedReader)var1_1;
                $i$a$-use-LintBaseline$readBaselineFile$1 = false;
                parser = new KXmlParser();
                parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", false);
                parser.setInput((Reader)reader);
                issue = null;
                message = null;
                path /* !! */  = null;
                currentEntry = null;
                v0 = this.client;
                v1 /* !! */  = pathVariables = v0 != null ? v0.getPathVariables() : null;
                while (parser.next() != 1) {
                    eventType = parser.getEventType();
                    if (eventType == 3) {
                        tag = parser.getName();
                        if (Intrinsics.areEqual((Object)tag, (Object)"location")) {
                            if (issue != null && message != null && path /* !! */  != null) {
                                v2 = pathVariables;
                                if (v2 == null || (v2 = PathVariables.fromPathString$default((PathVariables)v2, (String)path /* !! */ , null, (boolean)false, (int)6, null)) == null || (v2 = v2.getPath()) == null) {
                                    v2 = path /* !! */ ;
                                }
                                path /* !! */  = v2;
                                entry = new Entry(issue, message, (String)path /* !! */ );
                                if (currentEntry != null) {
                                    currentEntry.setNext(entry);
                                }
                                entry.setPrevious(currentEntry);
                                currentEntry = entry;
                                this.messageToEntry.put((Object)entry.getMessage(), (Object)entry);
                                var14_22 = this.idToMessages.get(issue);
                                if (var14_22 == null) {
                                    it = var15_23 = new HashSet<E>();
                                    $i$a$-also-LintBaseline$readBaselineFile$1$messages$1 = false;
                                    ((Map)this.idToMessages).put(issue, it);
                                    v3 = (Set)var15_23;
                                } else {
                                    v3 = var14_22;
                                }
                                messages = v3;
                                messages.add((String)message);
                            }
                        } else if (Intrinsics.areEqual((Object)tag, (Object)"issue")) {
                            if (issue != null && !IssueRegistry.Companion.isDeletedIssueId(issue)) {
                                entry = this.totalCount;
                                this.totalCount = entry + 1;
                            }
                            issue = null;
                            message = null;
                            path /* !! */  = null;
                            currentEntry = null;
                        }
                    } else if (eventType != 2) continue;
                    n = parser.getAttributeCount();
                    block22: for (i = 0; i < n; ++i) {
                        name = parser.getAttributeName(i);
                        value = parser.getAttributeValue(i);
                        var15_23 = name;
                        if (var15_23 == null) ** GOTO lbl-1000
                        tmp = -1;
                        switch (var15_23.hashCode()) {
                            case 3143036: {
                                if (var15_23.equals("file")) {
                                    tmp = 1;
                                }
                                break;
                            }
                            case 3159: {
                                if (var15_23.equals("by")) {
                                    tmp = 2;
                                }
                                break;
                            }
                            case -1268779017: {
                                if (var15_23.equals("format")) {
                                    tmp = 2;
                                }
                                break;
                            }
                            case 3355: {
                                if (var15_23.equals("id")) {
                                    tmp = 3;
                                }
                                break;
                            }
                            case 954925063: {
                                if (var15_23.equals("message")) {
                                    tmp = 4;
                                }
                                break;
                            }
                        }
                        switch (tmp) {
                            case 3: {
                                issue = value;
                                continue block22;
                            }
                            case 4: {
                                if (parser.getDepth() != 2) continue block22;
                                message = value;
                                continue block22;
                            }
                            case 1: {
                                path /* !! */  = value;
                                continue block22;
                            }
                            default: lbl-1000:
                            // 2 sources

                            {
                                if (parser.getDepth() != 1) continue block22;
                                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                                Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                                this.setAttribute(name, value);
                            }
                            case 2: 
                        }
                    }
                }
                var3_6 = Unit.INSTANCE;
            }
            catch (Throwable var3_7) {
                var2_4 = var3_7;
                throw var3_7;
            }
            finally {
                CloseableKt.closeFinally((Closeable)var1_1, (Throwable)var2_4);
            }
        }
        catch (IOException e) {
            if (this.client != null) {
                this.client.log(e, null, new Object[0]);
            } else {
                e.printStackTrace();
            }
        }
        catch (XmlPullParserException e) {
            if (this.client != null) {
                this.client.log(e, null, new Object[0]);
            }
            e.printStackTrace();
        }
    }

    public final void close() {
        if (this.writeOnClose) {
            this.write(this.file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void write(@NotNull File file) {
        boolean mkdirs2;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        File parentFile = file.getParentFile();
        if (parentFile != null && !parentFile.exists() && !(mkdirs2 = parentFile.mkdirs())) {
            LintClient lintClient = this.client;
            Intrinsics.checkNotNull((Object)lintClient);
            Object[] objectArray = new Object[]{parentFile};
            lintClient.log(null, "Couldn't create %1$s", objectArray);
            return;
        }
        try {
            Object mkdirs2 = file;
            Object object = Charsets.UTF_8;
            int n = 8192;
            Object object2 = mkdirs2;
            object2 = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object2), (Charset)object);
            mkdirs2 = object2 instanceof BufferedWriter ? (BufferedWriter)object2 : new BufferedWriter((Writer)object2, n);
            object = null;
            try {
                BufferedWriter writer = (BufferedWriter)mkdirs2;
                boolean bl = false;
                writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                writer.write("<");
                writer.write("issues");
                writer.write(" format=\"5\"");
                LintClient lintClient = this.client;
                Intrinsics.checkNotNull((Object)lintClient);
                String revision = lintClient.getClientDisplayRevision();
                if (revision != null) {
                    String string = " by=\"lint %1$s\"";
                    Object[] objectArray = new Object[]{revision};
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
                    writer.write(string2);
                }
                Map<String, String> map = this.attributes;
                if (map != null) {
                    void $this$forEach$iv;
                    Sequence $this$sortedBy$iv;
                    Map<String, String> map2 = map;
                    boolean bl2 = false;
                    Sequence sequence = MapsKt.asSequence(map2);
                    boolean $i$f$sortedBy = false;
                    $this$sortedBy$iv = SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            Map.Entry it = (Map.Entry)a;
                            boolean bl = false;
                            Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                            it = (Map.Entry)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.getKey()))));
                        }
                    });
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Map.Entry it = (Map.Entry)element$iv;
                        boolean bl3 = false;
                        writer.write(" " + it.getKey() + "=\"" + XmlUtils.toXmlAttributeValue((String)((String)it.getValue())) + "\"");
                    }
                }
                writer.write(">\n");
                this.totalCount = 0;
                if (this.entriesToWrite != null) {
                    List<ReportedEntry> list2 = this.entriesToWrite;
                    Intrinsics.checkNotNull(list2);
                    CollectionsKt.sort(list2);
                    List<ReportedEntry> list3 = this.entriesToWrite;
                    Intrinsics.checkNotNull(list3);
                    for (ReportedEntry entry : list3) {
                        entry.write(writer, this.client);
                        int n2 = this.totalCount;
                        this.totalCount = n2 + 1;
                    }
                }
                writer.write("\n</");
                writer.write("issues");
                writer.write(">\n");
                writer.close();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)mkdirs2, (Throwable)object);
            }
        }
        catch (IOException ioe) {
            LintClient lintClient = this.client;
            Intrinsics.checkNotNull((Object)lintClient);
            lintClient.log(ioe, null, new Object[0]);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0004J\"\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\bH\u0002J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004J\u0016\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u0004J \u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0004H\u0002J*\u0010&\u001a\u00020\u00172\u0006\u0010'\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u00042\b\b\u0002\u0010)\u001a\u00020\u00042\b\b\u0002\u0010\u001e\u001a\u00020\u0004J0\u0010*\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u00042\u0006\u0010,\u001a\u00020\u00042\u0018\u0010-\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00170.J*\u0010*\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u00042\u0006\u0010,\u001a\u00020\u00042\b\b\u0002\u0010/\u001a\u00020\b2\b\b\u0002\u00100\u001a\u00020\bJ\u0016\u00101\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u0004J(\u00102\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\b2\u0006\u00103\u001a\u00020\u00042\u0006\u00104\u001a\u00020\u0004H\u0002J\u001a\u00105\u001a\u00020\u0017*\u00020\u00042\u0006\u00106\u001a\u00020\u00042\u0006\u00107\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/android/tools/lint/client/api/LintBaseline$Companion;", "", "()V", "VARIANT_ALL", "", "VARIANT_FATAL", "describeBaselineFilter", "errors", "", "warnings", "baselineDisplayPath", "getDisplayPath", "client", "Lcom/android/tools/lint/client/api/LintClient;", "project", "Lcom/android/tools/lint/detector/api/Project;", "file", "Ljava/io/File;", "indent", "", "writer", "Ljava/io/Writer;", "isFilteredMessage", "", "errorMessage", "format", "Lcom/android/tools/lint/detector/api/TextFormat;", "isFixedMessage", "isSamePathSuffix", "path", "suffix", "prefixMatchLength", "a", "b", "sameSuffixFrom", "target", "new", "old", "sameWithAbsolutePath", "relative", "full", "prefix", "stringsEquivalent", "s1", "s2", "skipTokenAt", "Lkotlin/Function2;", "start1", "start2", "suffixMatchLength", "writeAttribute", "name", "value", "tokenPrecededBy", "prev", "offset", "lint-api"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isFilteredMessage(@NotNull String errorMessage, @NotNull TextFormat format) {
            Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
            Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
            return StringsKt.contains$default((CharSequence)format.toText(errorMessage), (CharSequence)"filtered out because", (boolean)false, (int)2, null);
        }

        public final boolean isFixedMessage(@NotNull String errorMessage, @NotNull TextFormat format) {
            Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
            Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
            return StringsKt.contains$default((CharSequence)format.toText(errorMessage), (CharSequence)"perhaps they have been fixed", (boolean)false, (int)2, null);
        }

        @NotNull
        public final String describeBaselineFilter(int errors, int warnings, @NotNull String baselineDisplayPath) {
            Intrinsics.checkNotNullParameter((Object)baselineDisplayPath, (String)"baselineDisplayPath");
            String counts = Lint.describeCounts(errors, warnings, false, true);
            String escapedPath = TextFormat.TEXT.convertTo(baselineDisplayPath, TextFormat.RAW);
            return errors + warnings == 1 ? counts + " was filtered out because it is listed in the baseline file, " + escapedPath + "\n" : counts + " were filtered out because they are listed in the baseline file, " + escapedPath + "\n";
        }

        public final boolean isSamePathSuffix(@NotNull String path2, @NotNull String suffix) {
            char c;
            int begin;
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
            int i = path2.length() - 1;
            int j = suffix.length() - 1;
            for (begin = 0; begin < j && ((c = suffix.charAt(begin)) == '.' || c == '/' || c == '\\'); ++begin) {
            }
            if (j - begin > i) {
                return false;
            }
            while (j > begin) {
                int c2;
                int c1 = path2.charAt(i);
                if (c1 != (c2 = suffix.charAt(j))) {
                    if (c1 == 92) {
                        c1 = 47;
                    }
                    if (c2 == 92) {
                        c2 = 47;
                    }
                    if (c1 != c2) {
                        return false;
                    }
                }
                --i;
                --j;
            }
            return true;
        }

        private final String getDisplayPath(LintClient client, Project project, File file) {
            String path2 = file.getPath();
            if (project == null) {
                String string = path2;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path");
                return string;
            }
            String string = path2;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path");
            String string2 = project.getReferenceDir().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"project.referenceDir.path");
            if (StringsKt.startsWith$default((String)string, (String)string2, (boolean)false, (int)2, null)) {
                int chop = project.getReferenceDir().getPath().length();
                if (path2.length() > chop && path2.charAt(chop) == File.separatorChar) {
                    ++chop;
                }
                String string3 = path2;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"path");
                String string4 = string3.substring(chop);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
                String string5 = path2 = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"path");
                if (((CharSequence)string5).length() == 0) {
                    path2 = file.getName();
                }
            } else if (file.isAbsolute() && file.exists()) {
                String string6 = client.getRelativePath(project.getReferenceDir(), file);
                if (string6 == null) {
                    string6 = file.getPath();
                }
                path2 = string6;
            }
            String string7 = path2;
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"path");
            return string7;
        }

        private final boolean sameSuffixFrom(String target, String string, String old) {
            int i1 = StringsKt.indexOf$default((CharSequence)string, (String)target, (int)0, (boolean)false, (int)6, null);
            int i2 = StringsKt.indexOf$default((CharSequence)old, (String)target, (int)0, (boolean)false, (int)6, null);
            return i1 != -1 && i2 != -1 && this.stringsEquivalent(string, old, i1 + target.length(), i2 + target.length());
        }

        public final boolean sameWithAbsolutePath(@NotNull String relative, @NotNull String full, @NotNull String prefix, @NotNull String suffix) {
            Intrinsics.checkNotNullParameter((Object)relative, (String)"relative");
            Intrinsics.checkNotNullParameter((Object)full, (String)"full");
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
            if (!(StringsKt.startsWith$default((String)relative, (String)prefix, (boolean)false, (int)2, null) && StringsKt.startsWith$default((String)full, (String)prefix, (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)relative, (String)suffix, (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)full, (String)suffix, (boolean)false, (int)2, null))) {
                return false;
            }
            if (relative.length() > full.length()) {
                return false;
            }
            int first = this.prefixMatchLength(relative, full);
            int last = this.suffixMatchLength(relative, full);
            int relativeLength = relative.length() - first - last;
            return StringsKt.regionMatches$default((String)relative, (int)first, (String)full, (int)(full.length() - last - relativeLength), (int)relativeLength, (boolean)false, (int)16, null);
        }

        public static /* synthetic */ boolean sameWithAbsolutePath$default(Companion companion, String string, String string2, String string3, String string4, int n, Object object) {
            if ((n & 4) != 0) {
                string3 = "";
            }
            if ((n & 8) != 0) {
                string4 = "";
            }
            return companion.sameWithAbsolutePath(string, string2, string3, string4);
        }

        public final int prefixMatchLength(@NotNull String a, @NotNull String b) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            int n = a.length();
            for (int i = 0; i < n; ++i) {
                char bc;
                if (i == b.length()) {
                    return i;
                }
                char ac = a.charAt(i);
                if (ac == (bc = b.charAt(i))) continue;
                return i;
            }
            return a.length();
        }

        public final int suffixMatchLength(@NotNull String a, @NotNull String b) {
            char bc;
            char ac;
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            int ai = a.length() - 1;
            int bi = b.length() - 1;
            int index = 0;
            while (ai >= 0 && bi >= 0 && (ac = a.charAt(ai--)) == (bc = b.charAt(bi--))) {
                ++index;
            }
            return index;
        }

        public final boolean stringsEquivalent(@NotNull String s1, @NotNull String s2, int start1, int start2) {
            Intrinsics.checkNotNullParameter((Object)s1, (String)"s1");
            Intrinsics.checkNotNullParameter((Object)s2, (String)"s2");
            int i1 = start1;
            int i2 = start2;
            int n1 = s1.length();
            int n2 = s2.length();
            if (start1 == n1 || start2 == n2) {
                return true;
            }
            while (true) {
                char c2;
                char c1;
                if ((c1 = s1.charAt(i1)) != (c2 = s2.charAt(i2))) {
                    while (i1 < n1 && (s1.charAt(i1) == '`' || s1.charAt(i1) == ' ')) {
                        ++i1;
                    }
                    while (i2 < n2 && (s2.charAt(i2) == '`' || s2.charAt(i2) == ' ')) {
                        ++i2;
                    }
                    if (i1 == n1 || i2 == n2) {
                        return true;
                    }
                    if (s1.charAt(i1) != s2.charAt(i2)) {
                        int http = StringsKt.lastIndexOf$default((CharSequence)s1, (String)"http", (int)i1, (boolean)false, (int)4, null);
                        if (http != -1) {
                            int blank1 = StringsKt.indexOf$default((CharSequence)s1, (char)' ', (int)http, (boolean)false, (int)4, null);
                            int blank2 = StringsKt.indexOf$default((CharSequence)s2, (char)' ', (int)http, (boolean)false, (int)4, null);
                            if (blank1 == -1 || blank2 == -1) {
                                return true;
                            }
                            if (i1 < blank1) {
                                i1 = blank1;
                                i2 = blank2;
                                continue;
                            }
                        }
                        return false;
                    }
                }
                if (++i1 == n1 || ++i2 == n2) break;
            }
            return true;
        }

        public static /* synthetic */ boolean stringsEquivalent$default(Companion companion, String string, String string2, int n, int n2, int n3, Object object) {
            if ((n3 & 4) != 0) {
                n = 0;
            }
            if ((n3 & 8) != 0) {
                n2 = 0;
            }
            return companion.stringsEquivalent(string, string2, n, n2);
        }

        public final boolean tokenPrecededBy(@NotNull String $this$tokenPrecededBy, @NotNull String prev, int offset) {
            int i;
            Intrinsics.checkNotNullParameter((Object)$this$tokenPrecededBy, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)prev, (String)"prev");
            if (offset < 0 || offset >= $this$tokenPrecededBy.length()) {
                throw new IndexOutOfBoundsException("index: " + offset + ", size: " + $this$tokenPrecededBy.length());
            }
            for (i = offset; i > 0 && !CharsKt.isWhitespace((char)$this$tokenPrecededBy.charAt(i)) && !CharsKt.isWhitespace((char)$this$tokenPrecededBy.charAt(i - 1)); --i) {
            }
            return (i -= prev.length()) < 0 ? false : StringsKt.regionMatches((String)$this$tokenPrecededBy, (int)i, (String)prev, (int)0, (int)prev.length(), (boolean)false);
        }

        public final boolean stringsEquivalent(@NotNull String s1, @NotNull String s2, @NotNull Function2<? super String, ? super Integer, Boolean> skipTokenAt) {
            Intrinsics.checkNotNullParameter((Object)s1, (String)"s1");
            Intrinsics.checkNotNullParameter((Object)s2, (String)"s2");
            Intrinsics.checkNotNullParameter(skipTokenAt, (String)"skipTokenAt");
            int i1 = 0;
            int i2 = 0;
            int n1 = s1.length();
            int n2 = s2.length();
            block0: while (i1 < n1) {
                if (i2 >= n2) {
                    return false;
                }
                if (s1.charAt(i1) != s2.charAt(i2)) {
                    if (((Boolean)skipTokenAt.invoke((Object)s1, (Object)i1)).booleanValue()) {
                        while (i1 < n1 && !CharsKt.isWhitespace((char)s1.charAt(i1))) {
                            ++i1;
                        }
                        while (true) {
                            if (i2 >= n2 || CharsKt.isWhitespace((char)s2.charAt(i2))) continue block0;
                            ++i2;
                        }
                    }
                    return false;
                }
                ++i1;
                ++i2;
            }
            return i2 >= n2;
        }

        private final void writeAttribute(Writer writer, int indent, String name, String value) throws IOException {
            writer.write("\n");
            this.indent(writer, indent);
            writer.write(name);
            writer.write("=\"");
            writer.write(XmlUtils.toXmlAttributeValue((String)value));
            writer.write("\"");
        }

        private final void indent(Writer writer, int indent) throws IOException {
            for (int level = 0; level < indent; ++level) {
                writer.write("    ");
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u001c\u0010\n\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\bR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\f\"\u0004\b\u0012\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/lint/client/api/LintBaseline$Entry;", "", "issueId", "", "message", "path", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getIssueId", "()Ljava/lang/String;", "getMessage", "next", "getNext", "()Lcom/android/tools/lint/client/api/LintBaseline$Entry;", "setNext", "(Lcom/android/tools/lint/client/api/LintBaseline$Entry;)V", "getPath", "previous", "getPrevious", "setPrevious", "lint-api"})
    private static final class Entry {
        @NotNull
        private final String issueId;
        @NotNull
        private final String message;
        @NotNull
        private final String path;
        @Nullable
        private Entry next;
        @Nullable
        private Entry previous;

        public Entry(@NotNull String issueId, @NotNull String message2, @NotNull String path2) {
            Intrinsics.checkNotNullParameter((Object)issueId, (String)"issueId");
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            this.issueId = issueId;
            this.message = message2;
            this.path = path2;
        }

        @NotNull
        public final String getIssueId() {
            return this.issueId;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @Nullable
        public final Entry getNext() {
            return this.next;
        }

        public final void setNext(@Nullable Entry entry) {
            this.next = entry;
        }

        @Nullable
        public final Entry getPrevious() {
            return this.previous;
        }

        public final void setPrevious(@Nullable Entry entry) {
            this.previous = entry;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/lint/client/api/LintBaseline$LightLocation;", "", "location", "Lcom/android/tools/lint/detector/api/Location;", "(Lcom/android/tools/lint/detector/api/Location;)V", "column", "", "getColumn", "()I", "file", "Ljava/io/File;", "getFile", "()Ljava/io/File;", "line", "getLine", "secondary", "getSecondary", "()Lcom/android/tools/lint/client/api/LintBaseline$LightLocation;", "lint-api"})
    @SourceDebugExtension(value={"SMAP\nLintBaseline.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintBaseline.kt\ncom/android/tools/lint/client/api/LintBaseline$LightLocation\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1010:1\n1#2:1011\n*E\n"})
    private static final class LightLocation {
        @NotNull
        private final File file;
        private final int line;
        private final int column;
        @Nullable
        private final LightLocation secondary;

        /*
         * WARNING - void declaration
         */
        public LightLocation(@NotNull Location location2) {
            LightLocation lightLocation;
            Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
            this.file = location2.getFile();
            Position position = location2.getStart();
            this.line = position != null ? position.getLine() : -1;
            Position position2 = location2.getStart();
            this.column = position2 != null ? position2.getColumn() : -1;
            LightLocation lightLocation2 = this;
            Location location3 = location2.getSecondary();
            if (location3 != null) {
                void it;
                Location location4 = location3;
                LightLocation lightLocation3 = lightLocation2;
                boolean bl = false;
                lightLocation = new LightLocation((Location)it);
                lightLocation2 = lightLocation3;
            } else {
                lightLocation = null;
            }
            lightLocation2.secondary = lightLocation;
        }

        @NotNull
        public final File getFile() {
            return this.file;
        }

        public final int getLine() {
            return this.line;
        }

        public final int getColumn() {
            return this.column;
        }

        @Nullable
        public final LightLocation getSecondary() {
            return this.secondary;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\f\u0012\b\u0012\u00060\u0000R\u00020\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0015\u0010\u0015\u001a\u00020\u00162\n\u0010\u0017\u001a\u00060\u0000R\u00020\u0002H\u0096\u0002J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/lint/client/api/LintBaseline$ReportedEntry;", "", "Lcom/android/tools/lint/client/api/LintBaseline;", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "project", "Lcom/android/tools/lint/detector/api/Project;", "location", "Lcom/android/tools/lint/detector/api/Location;", "message", "", "(Lcom/android/tools/lint/client/api/LintBaseline;Lcom/android/tools/lint/detector/api/Issue;Lcom/android/tools/lint/detector/api/Project;Lcom/android/tools/lint/detector/api/Location;Ljava/lang/String;)V", "getIssue", "()Lcom/android/tools/lint/detector/api/Issue;", "Lcom/android/tools/lint/client/api/LintBaseline$LightLocation;", "getLocation", "()Lcom/android/tools/lint/client/api/LintBaseline$LightLocation;", "getMessage", "()Ljava/lang/String;", "getProject", "()Lcom/android/tools/lint/detector/api/Project;", "compareTo", "", "other", "write", "", "writer", "Ljava/io/Writer;", "client", "Lcom/android/tools/lint/client/api/LintClient;", "lint-api"})
    private final class ReportedEntry
    implements Comparable<ReportedEntry> {
        @NotNull
        private final Issue issue;
        @Nullable
        private final Project project;
        @NotNull
        private final String message;
        @NotNull
        private final LightLocation location;

        public ReportedEntry(@Nullable Issue issue, @NotNull Project project, @NotNull Location location2, String message2) {
            Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
            Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            this.issue = issue;
            this.project = project;
            this.message = message2;
            this.location = new LightLocation(location2);
        }

        @NotNull
        public final Issue getIssue() {
            return this.issue;
        }

        @Nullable
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        @NotNull
        public final LightLocation getLocation() {
            return this.location;
        }

        @Override
        public int compareTo(@NotNull ReportedEntry other) {
            File secondaryFile2;
            LightLocation secondary2;
            LightLocation secondary1;
            int otherLine;
            String id2;
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            int categoryDelta = this.issue.getCategory().compareTo(other.issue.getCategory());
            if (categoryDelta != 0) {
                return categoryDelta;
            }
            int priorityDelta = other.issue.getPriority() - this.issue.getPriority();
            if (priorityDelta != 0) {
                return priorityDelta;
            }
            String id1 = this.issue.getId();
            int idDelta = id1.compareTo(id2 = other.issue.getId());
            if (idDelta != 0) {
                return idDelta;
            }
            File file = this.location.getFile();
            File otherFile = other.location.getFile();
            String string = file.getName();
            String string2 = otherFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"otherFile.name");
            int fileDelta = string.compareTo(string2);
            if (fileDelta != 0) {
                return fileDelta;
            }
            int line = this.location.getLine();
            if (line != (otherLine = other.location.getLine())) {
                return line - otherLine;
            }
            int delta = this.message.compareTo(other.message);
            if (delta != 0) {
                return delta;
            }
            delta = file.compareTo(otherFile);
            if (delta != 0) {
                return delta;
            }
            LightLocation lightLocation = secondary1 = this.location.getSecondary();
            File secondaryFile1 = lightLocation != null ? lightLocation.getFile() : null;
            LightLocation lightLocation2 = secondary2 = other.location.getSecondary();
            File file2 = secondaryFile2 = lightLocation2 != null ? lightLocation2.getFile() : null;
            if (secondaryFile1 != null) {
                return secondaryFile2 != null ? secondaryFile1.compareTo(secondaryFile2) : -1;
            }
            if (secondaryFile2 != null) {
                return 1;
            }
            if (line != -1 && otherLine != -1 && (delta = this.location.getColumn() - other.location.getColumn()) != 0) {
                return delta;
            }
            return 0;
        }

        public final void write(@NotNull Writer writer, @NotNull LintClient client) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            try {
                writer.write("\n");
                Companion.indent(writer, 1);
                writer.write("<");
                writer.write("issue");
                Companion.writeAttribute(writer, 2, "id", this.issue.getId());
                Companion.writeAttribute(writer, 2, "message", this.message);
                writer.write(">\n");
                for (LightLocation currentLocation = this.location; currentLocation != null; currentLocation = currentLocation.getSecondary()) {
                    Companion.indent(writer, 2);
                    writer.write("<");
                    writer.write("location");
                    String path2 = StringsKt.replace$default((String)Companion.getDisplayPath(client, this.project, currentLocation.getFile()), (char)'\\', (char)'/', (boolean)false, (int)4, null);
                    Companion.writeAttribute(writer, 3, "file", path2);
                    int line = currentLocation.getLine();
                    if (line >= 0 && !LintBaseline.this.getOmitLineNumbers()) {
                        Companion.writeAttribute(writer, 3, "line", String.valueOf(line + 1));
                    }
                    writer.write("/>\n");
                }
                Companion.indent(writer, 1);
                writer.write("</");
                writer.write("issue");
                writer.write(">\n");
            }
            catch (IOException ioe) {
                client.log(ioe, null, new Object[0]);
            }
        }
    }
}

