/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceMergerItem;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceType;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.DomExtensions;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.xml.parsers.ParserConfigurationException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H&J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H&J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H&J:\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\nJ\u0018\u0010\u001e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020 J.\u0010\u001e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000eH\u0016J \u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H&J\u0018\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H&J(\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u0018H&J\u0018\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H&J\u0018\u0010#\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020 J \u0010#\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H&J\u0018\u0010#\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H&J \u0010$\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H&J\u0018\u0010$\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H&J \u0010%\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H&J\u0018\u0010%\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H&J\u0018\u0010&\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020 J \u0010&\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020'H&J\u0018\u0010&\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020'H&J\u0012\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010\u0012\u001a\u00020\u0013H&J\u0012\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010\u0007\u001a\u00020\bH&J\u001a\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020+2\u0006\u0010\u0007\u001a\u00020\bH&J\f\u0010,\u001a\u0004\u0018\u00010\b*\u00020 \u00a8\u0006-"}, d2={"Lcom/android/tools/lint/client/api/XmlParser;", "", "()V", "createLocation", "Lcom/android/tools/lint/detector/api/Location;", "client", "Lcom/android/tools/lint/client/api/LintClient;", "file", "Ljava/io/File;", "name", "", "type", "Lcom/android/resources/ResourceType;", "nameOnly", "", "valueOnly", "createLocationHandle", "Lcom/android/tools/lint/detector/api/Location$Handle;", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "node", "Lorg/w3c/dom/Node;", "findNodeAt", "offset", "", "getElementLocation", "element", "Lorg/w3c/dom/Element;", "namespace", "attribute", "getLocation", "item", "Lcom/android/ide/common/resources/ResourceItem;", "start", "end", "getNameLocation", "getNodeEndOffset", "getNodeStartOffset", "getValueLocation", "Lorg/w3c/dom/Attr;", "parseXml", "Lorg/w3c/dom/Document;", "xml", "", "getFile", "lint-api"})
public abstract class XmlParser {
    @Nullable
    public abstract Document parseXml(@NotNull File var1) throws IOException, SAXException, ParserConfigurationException;

    @Nullable
    public abstract Document parseXml(@NotNull CharSequence var1, @NotNull File var2);

    @Nullable
    public abstract Document parseXml(@NotNull XmlContext var1);

    @NotNull
    public abstract Location getLocation(@NotNull XmlContext var1, @NotNull Node var2);

    @NotNull
    public abstract Location getLocation(@NotNull File var1, @NotNull Node var2);

    @NotNull
    public abstract Location getLocation(@NotNull XmlContext var1, @NotNull Node var2, int var3, int var4);

    @NotNull
    public abstract Location getNameLocation(@NotNull XmlContext var1, @NotNull Node var2);

    @NotNull
    public abstract Location getValueLocation(@NotNull XmlContext var1, @NotNull Attr var2);

    @NotNull
    public final Location getElementLocation(@NotNull XmlContext context2, @NotNull Element element, @Nullable Node node, @Nullable String namespace, @Nullable String attribute) {
        Location location2;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (node != null) {
            return this.getLocation(context2, node);
        }
        if (attribute != null) {
            Attr attr;
            Attr attr2 = attr = namespace != null ? element.getAttributeNodeNS(namespace, attribute) : element.getAttributeNode(attribute);
            if (attr != null) {
                return this.getLocation(context2, (Node)attr);
            }
        }
        if ((location2 = this.getLocation(context2, (Node)element)).isSingleLine()) {
            return location2;
        }
        return this.getNameLocation(context2, element);
    }

    public static /* synthetic */ Location getElementLocation$default(XmlParser xmlParser, XmlContext xmlContext, Element element, Node node, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getElementLocation");
        }
        if ((n & 4) != 0) {
            node = null;
        }
        if ((n & 8) != 0) {
            string = null;
        }
        if ((n & 0x10) != 0) {
            string2 = null;
        }
        return xmlParser.getElementLocation(xmlContext, element, node, string, string2);
    }

    @NotNull
    public abstract Location.Handle createLocationHandle(@NotNull XmlContext var1, @NotNull Node var2);

    public abstract int getNodeStartOffset(@NotNull XmlContext var1, @NotNull Node var2);

    public abstract int getNodeEndOffset(@NotNull XmlContext var1, @NotNull Node var2);

    @Nullable
    public abstract Node findNodeAt(@NotNull XmlContext var1, int var2);

    @Nullable
    public abstract Node findNodeAt(@NotNull Node var1, int var2);

    @NotNull
    public abstract Location getLocation(@NotNull LintClient var1, @NotNull File var2, @NotNull Node var3);

    public abstract int getNodeStartOffset(@NotNull LintClient var1, @NotNull File var2, @NotNull Node var3);

    public abstract int getNodeEndOffset(@NotNull LintClient var1, @NotNull File var2, @NotNull Node var3);

    @NotNull
    public abstract Location getNameLocation(@NotNull LintClient var1, @NotNull File var2, @NotNull Node var3);

    @NotNull
    public abstract Location getValueLocation(@NotNull LintClient var1, @NotNull File var2, @NotNull Attr var3);

    @Nullable
    public final Location getLocation(@NotNull LintClient client, @NotNull ResourceItem item) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return this.getLocation(client, item, false, false);
    }

    @Nullable
    public Location getLocation(@NotNull LintClient client, @NotNull ResourceItem item, boolean nameOnly, boolean valueOnly) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (item instanceof Location.LocationAware) {
            Location location2 = ((Location.LocationAware)item).getLocation();
            if ((nameOnly || valueOnly) && location2.getFile().isFile()) {
                File file = location2.getFile();
                String string = item.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"item.name");
                ResourceType resourceType = item.getType();
                Intrinsics.checkNotNullExpressionValue((Object)resourceType, (String)"item.type");
                Location adjustedLocation = this.createLocation(client, file, string, resourceType, nameOnly, valueOnly);
                if (adjustedLocation != null) {
                    return adjustedLocation;
                }
            }
            return location2;
        }
        File file = this.getFile(item);
        if (file == null) {
            return null;
        }
        File file2 = file;
        if (item.isFileBased()) {
            return Location.Companion.create(file2);
        }
        String string = file2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
        if (StringsKt.startsWith$default((String)string, (String)"$", (boolean)false, (int)2, null)) {
            return Location.Companion.create(file2);
        }
        String string2 = item.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"item.name");
        ResourceType resourceType = item.getType();
        Intrinsics.checkNotNullExpressionValue((Object)resourceType, (String)"item.type");
        return this.createLocation(client, file2, string2, resourceType, nameOnly, valueOnly);
    }

    public static /* synthetic */ Location getLocation$default(XmlParser xmlParser, LintClient lintClient, ResourceItem resourceItem, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getLocation");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        return xmlParser.getLocation(lintClient, resourceItem, bl, bl2);
    }

    private final Location createLocation(LintClient client, File file, String name, ResourceType type, boolean nameOnly, boolean valueOnly) {
        CharSequence text = client.readFile(file);
        if (type == ResourceType.ID && StringsKt.contains$default((CharSequence)text, (CharSequence)"@+id/", (boolean)false, (int)2, null)) {
            return Location.Companion.create(file, text, -1, "@+id//" + name, null, null);
        }
        Document document = client.getXmlDocument(file, text);
        Element element = document != null ? document.getDocumentElement() : null;
        if (element == null) {
            return null;
        }
        Element document2 = element;
        Iterator iterator = DomExtensions.iterator((Element)document2);
        while (iterator.hasNext()) {
            String tag;
            Element element2 = (Element)iterator.next();
            if (!Intrinsics.areEqual((Object)element2.getAttribute("name"), (Object)name) || !Intrinsics.areEqual((Object)(tag = element2.getTagName()), (Object)type.getName()) && !Intrinsics.areEqual((Object)element2.getAttribute("type"), (Object)type.getName())) continue;
            if (nameOnly) {
                Attr attr = element2.getAttributeNode("name");
                if (attr != null) {
                    Attr it = attr;
                    boolean bl = false;
                    return this.getNameLocation(client, file, it);
                }
            } else if (valueOnly) {
                Node firstChild = element2.getFirstChild();
                Node lastChild = element2.getLastChild();
                if (firstChild != null) {
                    Location startLocation = this.getLocation(file, firstChild);
                    if (lastChild == firstChild) {
                        return startLocation;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)lastChild, (String)"lastChild");
                    Location endLocation = this.getLocation(file, lastChild);
                    if (startLocation.getStart() != null && endLocation.getEnd() != null) {
                        return Location.Companion.create(file, startLocation.getStart(), endLocation.getEnd());
                    }
                }
            }
            return this.getLocation(client, file, element2);
        }
        return null;
    }

    @Nullable
    public final Location getNameLocation(@NotNull LintClient client, @NotNull ResourceItem item) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return XmlParser.getLocation$default(this, client, item, true, false, 8, null);
    }

    @Nullable
    public final Location getValueLocation(@NotNull LintClient client, @NotNull ResourceItem item) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return XmlParser.getLocation$default(this, client, item, false, true, 4, null);
    }

    @Nullable
    public final File getFile(@NotNull ResourceItem $this$getFile) {
        File file;
        Intrinsics.checkNotNullParameter((Object)$this$getFile, (String)"<this>");
        if ($this$getFile instanceof ResourceMergerItem) {
            file = ((ResourceMergerItem)$this$getFile).getFile();
        } else {
            PathString pathString = $this$getFile.getSource();
            file = pathString != null ? pathString.toFile() : null;
        }
        return file;
    }
}

