/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.Vendor;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Option;
import com.android.tools.lint.detector.api.Platform;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 P2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0002PQB]\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u000e\u0010<\u001a\u00020\u00002\u0006\u0010=\u001a\u00020\u0003J\u0011\u0010>\u001a\u00020\t2\u0006\u0010?\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010@\u001a\u00020\u001b2\b\u0010?\u001a\u0004\u0018\u00010&H\u0096\u0002J\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00030\u0015J\u000e\u0010B\u001a\u00020\u00032\u0006\u0010C\u001a\u00020DJ\u000e\u0010E\u001a\u00020\u00032\u0006\u0010C\u001a\u00020DJ\f\u0010F\u001a\b\u0012\u0004\u0012\u00020(0\u0015J\b\u0010G\u001a\u00020\tH\u0016J\u0006\u0010H\u001a\u00020\u001bJ\u0006\u0010I\u001a\u00020\u001bJ\u0016\u0010J\u001a\u00020\u00002\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0015J\u000e\u0010K\u001a\u00020\u00002\u0006\u0010L\u001a\u00020\u001bJ\u000e\u0010M\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001bJ\u0014\u0010N\u001a\u00020\u00002\f\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u0015J\b\u0010O\u001a\u00020\u0003H\u0016R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00030\u00158F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000e0\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u001c\u0010.\u001a\u0004\u0018\u00010/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u0019\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u001c\u00106\u001a\u0004\u0018\u000107X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00109\"\u0004\b:\u0010;\u00a8\u0006R"}, d2={"Lcom/android/tools/lint/detector/api/Issue;", "", "id", "", "briefDescription", "explanation", "category", "Lcom/android/tools/lint/detector/api/Category;", "priority", "", "defaultSeverity", "Lcom/android/tools/lint/detector/api/Severity;", "platforms", "Ljava/util/EnumSet;", "Lcom/android/tools/lint/detector/api/Platform;", "suppressNames", "", "implementation", "Lcom/android/tools/lint/detector/api/Implementation;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/android/tools/lint/detector/api/Category;ILcom/android/tools/lint/detector/api/Severity;Ljava/util/EnumSet;Ljava/util/Collection;Lcom/android/tools/lint/detector/api/Implementation;)V", "aliases", "", "getCategory", "()Lcom/android/tools/lint/detector/api/Category;", "getDefaultSeverity", "()Lcom/android/tools/lint/detector/api/Severity;", "enabledByDefault", "", "getId", "()Ljava/lang/String;", "getImplementation", "()Lcom/android/tools/lint/detector/api/Implementation;", "setImplementation", "(Lcom/android/tools/lint/detector/api/Implementation;)V", "moreInfo", "getMoreInfo", "()Ljava/util/List;", "moreInfoUrls", "", "options", "Lcom/android/tools/lint/detector/api/Option;", "<set-?>", "getPlatforms", "()Ljava/util/EnumSet;", "getPriority", "()I", "registry", "Lcom/android/tools/lint/client/api/IssueRegistry;", "getRegistry", "()Lcom/android/tools/lint/client/api/IssueRegistry;", "setRegistry", "(Lcom/android/tools/lint/client/api/IssueRegistry;)V", "getSuppressNames", "()Ljava/util/Collection;", "vendor", "Lcom/android/tools/lint/client/api/Vendor;", "getVendor", "()Lcom/android/tools/lint/client/api/Vendor;", "setVendor", "(Lcom/android/tools/lint/client/api/Vendor;)V", "addMoreInfo", "moreInfoUrl", "compareTo", "other", "equals", "getAliases", "getBriefDescription", "format", "Lcom/android/tools/lint/detector/api/TextFormat;", "getExplanation", "getOptions", "hashCode", "isAndroidSpecific", "isEnabledByDefault", "setAliases", "setAndroidSpecific", "value", "setEnabledByDefault", "setOptions", "toString", "Companion", "IgnoredIdProvider", "lint-api"})
public final class Issue
implements Comparable<Issue> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private final String briefDescription;
    @NotNull
    private final String explanation;
    @NotNull
    private final Category category;
    private final int priority;
    @NotNull
    private final Severity defaultSeverity;
    @Nullable
    private final Collection<String> suppressNames;
    @NotNull
    private Implementation implementation;
    @Nullable
    private Object moreInfoUrls;
    private boolean enabledByDefault;
    @NotNull
    private EnumSet<Platform> platforms;
    @NotNull
    private List<String> aliases;
    @NotNull
    private List<? extends Option> options;
    @Nullable
    private IssueRegistry registry;
    @Nullable
    private Vendor vendor;

    private Issue(String id, String briefDescription, String explanation, Category category, int priority, Severity defaultSeverity, EnumSet<Platform> platforms, Collection<String> suppressNames, Implementation implementation) {
        boolean bl;
        this.id = id;
        this.briefDescription = briefDescription;
        this.explanation = explanation;
        this.category = category;
        this.priority = priority;
        this.defaultSeverity = defaultSeverity;
        this.suppressNames = suppressNames;
        this.implementation = implementation;
        this.enabledByDefault = true;
        this.platforms = platforms;
        this.aliases = CollectionsKt.emptyList();
        this.options = CollectionsKt.emptyList();
        boolean bl2 = bl = ((CharSequence)this.briefDescription).length() > 0;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        boolean bl3 = bl = ((CharSequence)this.explanation).length() > 0;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final Category getCategory() {
        return this.category;
    }

    public final int getPriority() {
        return this.priority;
    }

    @NotNull
    public final Severity getDefaultSeverity() {
        return this.defaultSeverity;
    }

    @Nullable
    public final Collection<String> getSuppressNames() {
        return this.suppressNames;
    }

    @NotNull
    public final Implementation getImplementation() {
        return this.implementation;
    }

    public final void setImplementation(@NotNull Implementation implementation) {
        Intrinsics.checkNotNullParameter((Object)implementation, (String)"<set-?>");
        this.implementation = implementation;
    }

    @NotNull
    public final EnumSet<Platform> getPlatforms() {
        return this.platforms;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Issue setAndroidSpecific(boolean value) {
        if (value) {
            EnumSet<Platform> enumSet;
            if (this.platforms.isEmpty()) {
                enumSet = Platform.ANDROID_SET;
            } else {
                EnumSet<Platform> enumSet2 = EnumSet.copyOf(this.platforms);
                enumSet2.add(Platform.ANDROID);
                EnumSet<Platform> enumSet3 = enumSet2;
                Intrinsics.checkNotNull(enumSet3);
                enumSet = enumSet3;
            }
            this.platforms = enumSet;
        } else {
            EnumSet<Platform> enumSet;
            if (Intrinsics.areEqual(this.platforms, Platform.ANDROID_SET)) {
                enumSet = Platform.UNSPECIFIED;
            } else {
                void var3_3;
                EnumSet<Platform> enumSet4 = EnumSet.copyOf(this.platforms);
                enumSet4.remove((Object)Platform.ANDROID);
                void var2_5 = var3_3;
                Intrinsics.checkNotNull((Object)var2_5);
                enumSet = var2_5;
            }
            this.platforms = enumSet;
        }
        return this;
    }

    public final boolean isAndroidSpecific() {
        return this.platforms.contains((Object)Platform.ANDROID);
    }

    @NotNull
    public final Issue setAliases(@Nullable List<String> aliases) {
        boolean bl = this.aliases.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        List list = aliases;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        this.aliases = list;
        return this;
    }

    @NotNull
    public final List<String> getAliases() {
        return this.aliases;
    }

    @NotNull
    public final Issue setOptions(@NotNull List<? extends Option> options) {
        Intrinsics.checkNotNullParameter(options, (String)"options");
        boolean bl = this.options.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.options = options;
        for (Option option : options) {
            option.setIssue(this);
        }
        return this;
    }

    @NotNull
    public final List<Option> getOptions() {
        return this.options;
    }

    @NotNull
    public final List<String> getMoreInfo() {
        List list;
        Object urls = this.moreInfoUrls;
        if (urls == null) {
            list = CollectionsKt.emptyList();
        } else if (urls instanceof String) {
            list = CollectionsKt.listOf((Object)urls);
        } else if (urls instanceof List) {
            list = (List)urls;
        } else {
            throw new IllegalStateException("Unexpected `moreInfoUrls` of " + urls);
        }
        return list;
    }

    @NotNull
    public final String getBriefDescription(@NotNull TextFormat format) {
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        String trimmed = StringsKt.trimIndent((String)this.briefDescription);
        String message2 = StringsKt.replace$default((String)trimmed, (String)"\\\n", (String)"", (boolean)false, (int)4, null);
        return TextFormat.RAW.convertTo(message2, format);
    }

    @NotNull
    public final String getExplanation(@NotNull TextFormat format) {
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        String trimmed = StringsKt.trimIndent((String)this.explanation);
        String message2 = StringsKt.replace$default((String)trimmed, (String)"\\\n", (String)"", (boolean)false, (int)4, null);
        return TextFormat.RAW.convertTo(message2, format);
    }

    @NotNull
    public final Issue addMoreInfo(@NotNull String moreInfoUrl) {
        Intrinsics.checkNotNullParameter((Object)moreInfoUrl, (String)"moreInfoUrl");
        Object existing = this.moreInfoUrls;
        if (existing == null) {
            this.moreInfoUrls = moreInfoUrl;
        } else if (existing instanceof String) {
            Object[] objectArray = new String[]{existing, moreInfoUrl};
            this.moreInfoUrls = CollectionsKt.mutableListOf((Object[])objectArray);
        } else if (TypeIntrinsics.isMutableList((Object)existing)) {
            TypeIntrinsics.asMutableList((Object)existing).add(moreInfoUrl);
        } else {
            throw new IllegalStateException("Unexpected `moreInfoUrls`: " + existing);
        }
        return this;
    }

    public final boolean isEnabledByDefault() {
        return this.enabledByDefault;
    }

    @Override
    public int compareTo(@NotNull Issue other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.id.compareTo(other.id);
    }

    @NotNull
    public final Issue setEnabledByDefault(boolean enabledByDefault) {
        this.enabledByDefault = enabledByDefault;
        return this;
    }

    @NotNull
    public String toString() {
        return this.id;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof Issue && Intrinsics.areEqual((Object)this.id, (Object)((Issue)other).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Nullable
    public final IssueRegistry getRegistry() {
        return this.registry;
    }

    public final void setRegistry(@Nullable IssueRegistry issueRegistry) {
        this.registry = issueRegistry;
    }

    @Nullable
    public final Vendor getVendor() {
        return this.vendor;
    }

    public final void setVendor(@Nullable Vendor vendor) {
        this.vendor = vendor;
    }

    @JvmStatic
    @NotNull
    public static final Issue create(@NotNull String id, @NotNull String briefDescription, @NotNull String explanation, @NotNull Category category, int priority, @NotNull Severity severity, @NotNull Implementation implementation) {
        return Companion.create(id, briefDescription, explanation, category, priority, severity, implementation);
    }

    public /* synthetic */ Issue(String id, String briefDescription, String explanation, Category category, int priority, Severity defaultSeverity, EnumSet platforms, Collection suppressNames, Implementation implementation, DefaultConstructorMarker $constructor_marker) {
        this(id, briefDescription, explanation, category, priority, defaultSeverity, platforms, suppressNames, implementation);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J@\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u008f\u0001\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0010\b\u0002\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00162\u0010\b\u0002\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0019\u00a2\u0006\u0002\u0010\u001aJ\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u001c\u001a\u00020\u0013H\u0002J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u001e\u001a\u00020\u0010H\u0002J\u0016\u0010\u001f\u001a\u00020\u00132\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u0016H\u0002\u00a8\u0006\""}, d2={"Lcom/android/tools/lint/detector/api/Issue$Companion;", "", "()V", "create", "Lcom/android/tools/lint/detector/api/Issue;", "id", "", "briefDescription", "explanation", "category", "Lcom/android/tools/lint/detector/api/Category;", "priority", "", "severity", "Lcom/android/tools/lint/detector/api/Severity;", "implementation", "Lcom/android/tools/lint/detector/api/Implementation;", "moreInfo", "enabledByDefault", "", "androidSpecific", "platforms", "Ljava/util/EnumSet;", "Lcom/android/tools/lint/detector/api/Platform;", "suppressAnnotations", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/android/tools/lint/detector/api/Implementation;Ljava/lang/String;Lcom/android/tools/lint/detector/api/Category;ILcom/android/tools/lint/detector/api/Severity;ZLjava/lang/Boolean;Ljava/util/EnumSet;Ljava/util/Collection;)Lcom/android/tools/lint/detector/api/Issue;", "platformsFromAndroidSpecificFlag", "specific", "platformsFromImplementation", "impl", "scopeImpliesAndroid", "scope", "Lcom/android/tools/lint/detector/api/Scope;", "lint-api"})
    @SourceDebugExtension(value={"SMAP\nIssue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Issue.kt\ncom/android/tools/lint/detector/api/Issue$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,429:1\n1#2:430\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Issue create(@NotNull String id, @NotNull String briefDescription, @NotNull String explanation, @NotNull Category category, int priority, @NotNull Severity severity, @NotNull Implementation implementation) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)briefDescription, (String)"briefDescription");
            Intrinsics.checkNotNullParameter((Object)explanation, (String)"explanation");
            Intrinsics.checkNotNullParameter((Object)category, (String)"category");
            Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
            Intrinsics.checkNotNullParameter((Object)implementation, (String)"implementation");
            return new Issue(id, briefDescription, explanation, category, priority, severity, this.platformsFromImplementation(implementation), null, implementation, null);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Issue create(@NotNull String id, @NotNull String briefDescription, @NotNull String explanation, @NotNull Implementation implementation, @Nullable String moreInfo, @NotNull Category category, int priority, @NotNull Severity severity, boolean enabledByDefault, @Nullable Boolean androidSpecific, @Nullable EnumSet<Platform> platforms, @Nullable Collection<String> suppressAnnotations) {
            Issue issue;
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)briefDescription, (String)"briefDescription");
            Intrinsics.checkNotNullParameter((Object)explanation, (String)"explanation");
            Intrinsics.checkNotNullParameter((Object)implementation, (String)"implementation");
            Intrinsics.checkNotNullParameter((Object)category, (String)"category");
            Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
            String string = id;
            String string2 = briefDescription;
            String string3 = explanation;
            Category category2 = category;
            int n = priority;
            Severity severity2 = severity;
            EnumSet<Platform> enumSet = platforms;
            if (enumSet == null) {
                EnumSet<Platform> enumSet2;
                Boolean bl = androidSpecific;
                if (bl != null) {
                    void p0;
                    boolean bl2 = bl;
                    Severity severity3 = severity2;
                    int n2 = n;
                    Category category3 = category2;
                    String string4 = string3;
                    String string5 = string2;
                    String string6 = string;
                    boolean bl3 = false;
                    EnumSet<Platform> enumSet3 = this.platformsFromAndroidSpecificFlag((boolean)p0);
                    string = string6;
                    string2 = string5;
                    string3 = string4;
                    category2 = category3;
                    n = n2;
                    severity2 = severity3;
                    enumSet2 = enumSet3;
                } else {
                    enumSet2 = enumSet = null;
                }
                if (enumSet2 == null) {
                    enumSet = this.platformsFromImplementation(implementation);
                }
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            Implementation implementation2 = implementation;
            Collection<String> collection = suppressAnnotations;
            EnumSet<Platform> enumSet4 = enumSet;
            Severity severity4 = severity2;
            int n3 = n;
            Category category4 = category2;
            String string7 = string3;
            String string8 = string2;
            String string9 = string;
            Issue $this$create_u24lambda_u240 = issue = new Issue(string9, string8, string7, category4, n3, severity4, enumSet4, collection, implementation2, defaultConstructorMarker);
            boolean bl = false;
            if (moreInfo != null) {
                $this$create_u24lambda_u240.addMoreInfo(moreInfo);
            }
            if (!enabledByDefault) {
                $this$create_u24lambda_u240.setEnabledByDefault(false);
            }
            return issue;
        }

        public static /* synthetic */ Issue create$default(Companion companion, String string, String string2, String string3, Implementation implementation, String string4, Category category, int n, Severity severity, boolean bl, Boolean bl2, EnumSet enumSet, Collection collection, int n2, Object object) {
            if ((n2 & 0x10) != 0) {
                string4 = null;
            }
            if ((n2 & 0x20) != 0) {
                category = Category.CORRECTNESS;
            }
            if ((n2 & 0x40) != 0) {
                n = 5;
            }
            if ((n2 & 0x80) != 0) {
                severity = Severity.WARNING;
            }
            if ((n2 & 0x100) != 0) {
                bl = true;
            }
            if ((n2 & 0x200) != 0) {
                bl2 = null;
            }
            if ((n2 & 0x400) != 0) {
                enumSet = null;
            }
            if ((n2 & 0x800) != 0) {
                collection = null;
            }
            return companion.create(string, string2, string3, implementation, string4, category, n, severity, bl, bl2, enumSet, collection);
        }

        private final EnumSet<Platform> platformsFromAndroidSpecificFlag(boolean specific) {
            return specific ? Platform.ANDROID_SET : Platform.JDK_SET;
        }

        private final EnumSet<Platform> platformsFromImplementation(Implementation impl) {
            EnumSet<Scope> enumSet = impl.getScope();
            Intrinsics.checkNotNullExpressionValue(enumSet, (String)"getScope(...)");
            return this.scopeImpliesAndroid(enumSet) ? Platform.ANDROID_SET : Platform.UNSPECIFIED;
        }

        private final boolean scopeImpliesAndroid(EnumSet<Scope> scope) {
            return scope.contains((Object)Scope.MANIFEST) || scope.contains((Object)Scope.RESOURCE_FILE) || scope.contains((Object)Scope.BINARY_RESOURCE_FILE) || scope.contains((Object)Scope.ALL_RESOURCE_FILES);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/lint/detector/api/Issue$IgnoredIdProvider;", "", "getIgnoredIds", "", "lint-api"})
    public static interface IgnoredIdProvider {
        @NotNull
        public String getIgnoredIds();
    }
}

