/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Arrays;
import java.util.Collection;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class HardcodedValuesDetector
extends LayoutDetector {
    public static final Issue ISSUE = Issue.create((String)"HardcodedText", (String)"Hardcoded text", (String)"Hardcoding text attributes directly in layout files is bad for several reasons:\n\n* When creating configuration variations (for example for landscape or portrait)you have to repeat the actual text (and keep it up to date when making changes)\n\n* The application cannot be translated to other languages by just adding new translations for existing string resources.\n\nThere are quickfixes to automatically extract this hardcoded string into a resource lookup.", (Category)Category.I18N, (int)5, (Severity)Severity.WARNING, (Implementation)new Implementation(HardcodedValuesDetector.class, Scope.RESOURCE_FILE_SCOPE));

    public Collection<String> getApplicableAttributes() {
        return Arrays.asList("text", "contentDescription", "hint", "label", "prompt", "textOn", "textOff", "title", "description");
    }

    public boolean appliesTo(ResourceFolderType folderType) {
        return folderType == ResourceFolderType.LAYOUT || folderType == ResourceFolderType.MENU || folderType == ResourceFolderType.XML;
    }

    public void visitAttribute(XmlContext context, Attr attribute) {
        String value = attribute.getValue();
        if (!value.isEmpty() && value.charAt(0) != '@' && value.charAt(0) != '?') {
            String tagName;
            if (!"http://schemas.android.com/apk/res/android".equals(attribute.getNamespaceURI())) {
                return;
            }
            if (value.equals("Hello World!")) {
                return;
            }
            if (value.equals("Large Text") || value.equals("Medium Text") || value.equals("Small Text") || value.startsWith("New ") && (value.equals("New Text") || value.equals("New " + attribute.getOwnerElement().getTagName()))) {
                return;
            }
            if (context.getResourceFolderType() == ResourceFolderType.XML && !(tagName = attribute.getOwnerDocument().getDocumentElement().getTagName()).equals("restrictions")) {
                return;
            }
            context.report(ISSUE, (Node)attribute, context.getLocation((Node)attribute), String.format("Hardcoded string \"%1$s\", should use `@string` resource", value));
        }
    }
}

