/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UClass;

public class GetContentDescriptionOverrideDetector
extends Detector
implements Detector.UastScanner {
    public static final Issue ISSUE = Issue.create((String)"GetContentDescriptionOverride", (String)"Overriding `getContentDescription()` on a View", (String)"Overriding `getContentDescription()` may prevent some accessibility services from properly navigating content exposed by your view. Instead, call `setContentDescription()` when the content description needs to be changed.", (Category)Category.A11Y, (int)9, (Severity)Severity.ERROR, (Implementation)new Implementation(GetContentDescriptionOverrideDetector.class, Scope.JAVA_FILE_SCOPE));

    public List<String> applicableSuperClasses() {
        return Collections.singletonList("android.view.View");
    }

    public void visitClass(JavaContext context, UClass declaration) {
        JavaEvaluator evaluator = context.getEvaluator();
        for (PsiMethod method : declaration.findMethodsByName("getContentDescription", false)) {
            if (evaluator.getParameterCount(method) != 0) continue;
            context.report(ISSUE, (PsiElement)method, context.getNameLocation((PsiElement)method), "Overriding `getContentDescription()` on a View is not recommended");
        }
    }
}

