/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.lint.client.api.ResourceReference;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.Pair;
import com.android.utils.SdkUtils;
import com.intellij.psi.PsiClass;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OverdrawDetector
extends LayoutDetector
implements Detector.UastScanner {
    private static final String SET_THEME = "setTheme";
    public static final Issue ISSUE = Issue.create((String)"Overdraw", (String)"Overdraw: Painting regions more than once", (String)"If you set a background drawable on a root view, then you should use a custom theme where the theme background is null. Otherwise, the theme background will be painted first, only to have your custom background completely cover it; this is called \"overdraw\".\n\nNOTE: This detector relies on figuring out which layouts are associated with which activities based on scanning the Java code, and it's currently doing that using an inexact pattern matching algorithm. Therefore, it can incorrectly conclude which activity the layout is associated with and then wrongly complain that a background-theme is hidden.\n\nIf you want your custom background on multiple pages, then you should consider making a custom theme with your custom background and just using that theme instead of a root element background.\n\nOf course it's possible that your custom drawable is translucent and you want it to be mixed with the background. However, you will get better performance if you pre-mix the background with your drawable and use that resulting image or color as a custom theme background instead.\n", (Category)Category.PERFORMANCE, (int)3, (Severity)Severity.WARNING, (Implementation)new Implementation(OverdrawDetector.class, EnumSet.of(Scope.MANIFEST, Scope.JAVA_FILE, Scope.ALL_RESOURCE_FILES)));
    private Map<String, String> activityToTheme;
    private String manifestTheme;
    private Map<String, List<String>> layoutToActivity;
    private List<String> blankThemes;
    private List<String> validDrawables;
    private List<Pair<Location, String>> rootAttributes;

    public boolean appliesTo(ResourceFolderType folderType) {
        return super.appliesTo(folderType) || folderType == ResourceFolderType.VALUES || folderType == ResourceFolderType.DRAWABLE;
    }

    private boolean isBlankTheme(String name) {
        if (name.startsWith("@android:style/Theme_") && (name.contains("NoFrame") || name.contains("Theme_Wallpaper") || name.contains("Theme_Holo_Wallpaper") || name.contains("Theme_Translucent") || name.contains("Theme_Dialog_NoFrame") || name.contains("Theme_Holo_Dialog_Alert") || name.contains("Theme_Holo_Light_Dialog_Alert") || name.contains("Theme_Dialog_Alert") || name.contains("Theme_Panel") || name.contains("Theme_Light_Panel") || name.contains("Theme_Holo_Panel") || name.contains("Theme_Holo_Light_Panel"))) {
            return true;
        }
        return this.blankThemes != null && this.blankThemes.contains(name);
    }

    public void afterCheckProject(Context context) {
        if (this.rootAttributes != null) {
            for (Pair<Location, String> pair : this.rootAttributes) {
                String theme;
                Location location = (Location)pair.getFirst();
                Object clientData = location.getClientData();
                if (clientData instanceof Node && context.getDriver().isSuppressed(null, ISSUE, (Node)clientData)) {
                    return;
                }
                String layoutName = location.getFile().getName();
                if (LintUtils.endsWith((String)layoutName, (String)".xml")) {
                    layoutName = layoutName.substring(0, layoutName.length() - ".xml".length());
                }
                if ((theme = this.getTheme(context, layoutName)) != null && this.isBlankTheme(theme)) continue;
                String drawable = (String)pair.getSecond();
                String message = String.format("Possible overdraw: Root element paints background `%1$s` with a theme that also paints a background (inferred theme is `%2$s`)", drawable, theme);
                context.report(ISSUE, location, message);
            }
        }
    }

    private String getTheme(Context context, String layoutName) {
        List<String> activities;
        if (this.activityToTheme != null && this.layoutToActivity != null && (activities = this.layoutToActivity.get(layoutName)) != null) {
            for (String activity : activities) {
                String theme = this.activityToTheme.get(activity);
                if (theme == null) continue;
                return theme;
            }
        }
        if (this.manifestTheme != null) {
            return this.manifestTheme;
        }
        Project project = context.getMainProject();
        int apiLevel = project.getTargetSdk();
        if (apiLevel == -1) {
            apiLevel = project.getMinSdk();
        }
        if (apiLevel >= 11) {
            return "@android:style/Theme.Holo";
        }
        return "@android:style/Theme";
    }

    public void visitAttribute(XmlContext context, Attr attribute) {
        if (!"http://schemas.android.com/apk/res/android".equals(attribute.getNamespaceURI())) {
            return;
        }
        Element documentElement = attribute.getOwnerDocument().getDocumentElement();
        if (documentElement == attribute.getOwnerElement()) {
            String background = attribute.getValue();
            if (this.validDrawables != null && this.validDrawables.contains(background)) {
                return;
            }
            if (background.equals("@android:color/transparent") || background.equals("@null")) {
                return;
            }
            if (background.startsWith("@android:drawable/")) {
                return;
            }
            String name = context.file.getName();
            if (name.contains("list_") || name.contains("_item")) {
                return;
            }
            if (!context.getProject().getReportIssues()) {
                return;
            }
            Location location = context.getLocation((Node)attribute);
            location.setClientData((Object)attribute);
            if (this.rootAttributes == null) {
                this.rootAttributes = new ArrayList<Pair<Location, String>>();
            }
            this.rootAttributes.add((Pair<Location, String>)Pair.of((Object)location, (Object)attribute.getValue()));
            String activity = documentElement.getAttributeNS("http://schemas.android.com/tools", "context");
            if (activity != null && !activity.isEmpty()) {
                if (activity.startsWith(".")) {
                    activity = context.getProject().getPackage() + activity;
                }
                this.registerLayoutActivity(LintUtils.getLayoutName((File)context.file), activity);
            }
        }
    }

    public Collection<String> getApplicableAttributes() {
        return Collections.singletonList("background");
    }

    public Collection<String> getApplicableElements() {
        return Arrays.asList("activity", "application", "style", "bitmap");
    }

    public void beforeCheckFile(Context context) {
        File parent;
        ResourceFolderType type;
        if (LintUtils.endsWith((String)context.file.getName(), (String)".xml") && (type = ResourceFolderType.getFolderType((String)(parent = context.file.getParentFile()).getName())) == ResourceFolderType.DRAWABLE) {
            if (this.validDrawables == null) {
                this.validDrawables = new ArrayList<String>();
            }
            String resource = OverdrawDetector.getDrawableResource(context.file);
            this.validDrawables.add(resource);
        }
    }

    public void visitElement(XmlContext context, Element element) {
        String tag = element.getTagName();
        if (tag.equals("style")) {
            this.scanTheme(element);
        } else if (tag.equals("activity")) {
            this.scanActivity((Context)context, element);
        } else if (tag.equals("application")) {
            if (element.hasAttributeNS("http://schemas.android.com/apk/res/android", "theme")) {
                this.manifestTheme = element.getAttributeNS("http://schemas.android.com/apk/res/android", "theme");
            }
        } else if (tag.equals("bitmap")) {
            this.scanBitmap((Context)context, element);
        }
    }

    private static String getDrawableResource(File drawableFile) {
        String resource = drawableFile.getName();
        if (LintUtils.endsWith((String)resource, (String)".xml")) {
            resource = resource.substring(0, resource.length() - ".xml".length());
        }
        return "@drawable/" + resource;
    }

    private void scanBitmap(Context context, Element element) {
        String tileMode = element.getAttributeNS("http://schemas.android.com/apk/res/android", "tileMode");
        if (!tileMode.equals("disabled") && !tileMode.isEmpty() && this.validDrawables != null) {
            String resource = OverdrawDetector.getDrawableResource(context.file);
            this.validDrawables.remove(resource);
        }
    }

    private void scanActivity(Context context, Element element) {
        String theme;
        String pkg;
        String name = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
        if (name.indexOf(36) != -1) {
            name = name.replace('$', '.');
        }
        if (name.startsWith(".") && (pkg = context.getProject().getPackage()) != null && !pkg.isEmpty()) {
            name = pkg + name;
        }
        if ((theme = element.getAttributeNS("http://schemas.android.com/apk/res/android", "theme")) != null && !theme.isEmpty()) {
            if (this.activityToTheme == null) {
                this.activityToTheme = new HashMap<String, String>();
            }
            this.activityToTheme.put(name, SdkUtils.getResourceFieldName((String)theme));
        }
    }

    private void scanTheme(Element element) {
        int index;
        String styleName = element.getAttribute("name");
        String parent = element.getAttribute("parent");
        if (parent == null) {
            parent = "";
        }
        if (parent.isEmpty() && (index = styleName.lastIndexOf(46)) != -1) {
            parent = styleName.substring(0, index);
        }
        parent = parent.replace('.', '_');
        String resource = "@style/" + SdkUtils.getResourceFieldName((String)styleName);
        NodeList items = element.getChildNodes();
        int n = items.getLength();
        for (int i = 0; i < n; ++i) {
            Element item;
            String name;
            if (items.item(i).getNodeType() != 1 || !(name = (item = (Element)items.item(i)).getAttribute("name")).equals("android:windowBackground")) continue;
            NodeList textNodes = item.getChildNodes();
            int m = textNodes.getLength();
            for (int j = 0; j < m; ++j) {
                String text;
                String trim;
                Node textNode = textNodes.item(j);
                if (textNode.getNodeType() != 3 || (trim = (text = textNode.getNodeValue()).trim()).isEmpty() || !trim.equals("@null") && !trim.equals("@android:color/transparent") && (this.validDrawables == null || !this.validDrawables.contains(trim))) continue;
                if (this.blankThemes == null) {
                    this.blankThemes = new ArrayList<String>();
                }
                this.blankThemes.add(resource);
            }
            return;
        }
        if (this.isBlankTheme(parent)) {
            if (this.blankThemes == null) {
                this.blankThemes = new ArrayList<String>();
            }
            this.blankThemes.add(resource);
        }
    }

    private void registerLayoutActivity(String layout, String classFqn) {
        List<String> list;
        if (this.layoutToActivity == null) {
            this.layoutToActivity = new HashMap<String, List<String>>();
        }
        if ((list = this.layoutToActivity.get(layout)) == null) {
            list = new ArrayList<String>();
            this.layoutToActivity.put(layout, list);
        }
        list.add(classFqn);
    }

    public List<String> applicableSuperClasses() {
        return Collections.singletonList("android.app.Activity");
    }

    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return Collections.singletonList(UClass.class);
    }

    public void visitClass(JavaContext context, UClass declaration) {
        if (!context.getProject().getReportIssues()) {
            return;
        }
        String name = declaration.getQualifiedName();
        if (name != null) {
            declaration.accept((UastVisitor)new OverdrawVisitor(name, (PsiClass)declaration));
        }
    }

    private class OverdrawVisitor
    extends AbstractUastVisitor {
        private final String name;
        private final PsiClass cls;

        public OverdrawVisitor(String name, PsiClass cls) {
            this.name = name;
            this.cls = cls;
        }

        public boolean visitClass(UClass node) {
            if (this.cls.equals(node.getPsi())) {
                return true;
            }
            return super.visitClass(node);
        }

        public boolean visitSimpleNameReferenceExpression(USimpleNameReferenceExpression node) {
            ResourceReference reference = ResourceReference.get((UElement)node);
            if (reference != null && reference.getType() == ResourceType.LAYOUT) {
                OverdrawDetector.this.registerLayoutActivity(reference.getName(), this.name);
            }
            return super.visitSimpleNameReferenceExpression(node);
        }

        public boolean visitCallExpression(UCallExpression node) {
            UExpression arg;
            ResourceReference reference;
            if (OverdrawDetector.SET_THEME.equals(node.getMethodName()) && node.getValueArgumentCount() == 1 && (reference = ResourceReference.get((UElement)(arg = (UExpression)node.getValueArguments().get(0)))) != null && reference.getType() == ResourceType.STYLE) {
                String style = reference.getName();
                if (OverdrawDetector.this.activityToTheme == null) {
                    OverdrawDetector.this.activityToTheme = new HashMap();
                }
                OverdrawDetector.this.activityToTheme.put(this.name, "@style/" + style);
            }
            return super.visitCallExpression(node);
        }
    }
}

