/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.builder.model.MavenCoordinates;
import com.android.tools.lint.checks.AbstractAnnotationDetector;
import com.android.tools.lint.checks.AnnotationDetector;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 +2\u00020\u00012\u00020\u0002:\u0001+B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016JD\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005H\u0002JL\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0002JD\u0010\u0015\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005H\u0002J\u0016\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005H\u0002J\u0018\u0010\u0019\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\fH\u0002J\u0018\u0010\u001b\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\fH\u0002J:\u0010\u001c\u001a\u00020\b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u0017H\u0002J \u0010!\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\u0006H\u0002Jr\u0010#\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010$\u001a\u00020\f2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005H\u0016\u00a8\u0006,"}, d2={"Lcom/android/tools/lint/checks/RestrictToDetector;", "Lcom/android/tools/lint/checks/AbstractAnnotationDetector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "applicableAnnotations", "", "", "checkRestrictTo", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UElement;", "method", "Lcom/intellij/psi/PsiMethod;", "annotation", "Lorg/jetbrains/uast/UAnnotation;", "allMethodAnnotations", "allClassAnnotations", "scope", "", "checkVisibleForTesting", "containsRestrictionAnnotation", "", "list", "isGmsContext", "element", "isTestContext", "reportRestriction", "where", "containingClass", "Lcom/intellij/psi/PsiClass;", "isClassAnnotation", "reportVisibilityError", "desc", "visitAnnotationUsage", "usage", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "qualifiedName", "annotations", "allMemberAnnotations", "allPackageAnnotations", "Companion", "lint-checks"})
public final class RestrictToDetector
extends AbstractAnnotationDetector
implements SourceCodeScanner {
    private static final Implementation IMPLEMENTATION;
    private static final String ATTR_OTHERWISE = "otherwise";
    private static final int VISIBILITY_PRIVATE = 2;
    private static final int VISIBILITY_PACKAGE_PRIVATE = 3;
    private static final int VISIBILITY_PROTECTED = 4;
    private static final int VISIBILITY_NONE = 5;
    private static final int RESTRICT_TO_LIBRARY_GROUP = 1;
    private static final int RESTRICT_TO_LIBRARY = 2;
    private static final int RESTRICT_TO_TESTS = 4;
    private static final int RESTRICT_TO_SUBCLASSES = 8;
    private static final int RESTRICT_TO_ALL = 16;
    @JvmField
    @NotNull
    public static final Issue RESTRICTED;
    @JvmField
    @NotNull
    public static final Issue TEST_VISIBILITY;
    public static final Companion Companion;

    @NotNull
    public List<String> applicableAnnotations() {
        return CollectionsKt.listOf((Object[])new String[]{AnnotationDetector.RESTRICT_TO_ANNOTATION.oldName(), AnnotationDetector.RESTRICT_TO_ANNOTATION.newName(), "com.google.android.gms.common.internal.Hide", AnnotationDetector.VISIBLE_FOR_TESTING_ANNOTATION.oldName(), AnnotationDetector.VISIBLE_FOR_TESTING_ANNOTATION.newName(), "com.google.common.annotations.VisibleForTesting"});
    }

    public void visitAnnotationUsage(@NotNull JavaContext context, @NotNull UElement usage, @NotNull AnnotationUsageType type, @NotNull UAnnotation annotation, @NotNull String qualifiedName, @Nullable PsiMethod method, @NotNull List<? extends UAnnotation> annotations, @NotNull List<? extends UAnnotation> allMemberAnnotations, @NotNull List<? extends UAnnotation> allClassAnnotations, @NotNull List<? extends UAnnotation> allPackageAnnotations) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)usage, (String)"usage");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)annotation, (String)"annotation");
        Intrinsics.checkParameterIsNotNull((Object)qualifiedName, (String)"qualifiedName");
        Intrinsics.checkParameterIsNotNull(annotations, (String)"annotations");
        Intrinsics.checkParameterIsNotNull(allMemberAnnotations, (String)"allMemberAnnotations");
        Intrinsics.checkParameterIsNotNull(allClassAnnotations, (String)"allClassAnnotations");
        Intrinsics.checkParameterIsNotNull(allPackageAnnotations, (String)"allPackageAnnotations");
        String string = qualifiedName;
        if (Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.RESTRICT_TO_ANNOTATION.oldName()) || Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.RESTRICT_TO_ANNOTATION.newName()) || Intrinsics.areEqual((Object)string, (Object)"com.google.android.gms.common.internal.Hide")) {
            if (method != null) {
                this.checkRestrictTo(context, usage, method, annotation, allMemberAnnotations, allClassAnnotations);
            }
        } else if ((Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.VISIBLE_FOR_TESTING_ANNOTATION.oldName()) || Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.VISIBLE_FOR_TESTING_ANNOTATION.newName()) || Intrinsics.areEqual((Object)string, (Object)"com.google.common.annotations.VisibleForTesting")) && method != null) {
            this.checkVisibleForTesting(context, usage, method, annotation, allMemberAnnotations, allClassAnnotations);
        }
    }

    private final boolean isGmsContext(JavaContext context, UElement element) {
        String qualifiedName;
        JavaEvaluator evaluator = context.getEvaluator();
        PsiPackage psiPackage = evaluator.getPackage(element);
        if (psiPackage == null) {
            return false;
        }
        PsiPackage pkg = psiPackage;
        String string = qualifiedName = pkg.getQualifiedName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"qualifiedName");
        if (!StringsKt.startsWith$default((String)string, (String)"com.google.", (boolean)false, (int)2, null)) {
            return false;
        }
        return StringsKt.startsWith$default((String)qualifiedName, (String)"com.google.firebase", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)qualifiedName, (String)"com.google.android.gms", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)qualifiedName, (String)"com.google.ads", (boolean)false, (int)2, null);
    }

    private final boolean isTestContext(JavaContext context, UElement element) {
        UElement current = element;
        if (context.isTestSource()) {
            return true;
        }
        while ((UAnnotated)UastUtils.getParentOfType((UElement)current, UAnnotated.class, (boolean)true) != null) {
            UAnnotated owner;
            for (UAnnotation annotation : owner.getAnnotations()) {
                int restrictionScope;
                String name = annotation.getQualifiedName();
                if (!(AnnotationDetector.RESTRICT_TO_ANNOTATION.isEquals(name) ? ((restrictionScope = RestrictToDetector.Companion.getRestrictionScope(annotation)) & 4) != 0 : AnnotationDetector.VISIBLE_FOR_TESTING_ANNOTATION.isEquals(name))) continue;
                return true;
            }
            current = (UElement)owner;
        }
        return false;
    }

    private final void checkVisibleForTesting(JavaContext context, UElement node, PsiMethod method, UAnnotation annotation, List<? extends UAnnotation> allMethodAnnotations, List<? extends UAnnotation> allClassAnnotations) {
        int visibility = RestrictToDetector.Companion.getVisibilityForTesting(annotation);
        if (visibility == 5) {
            this.checkRestrictTo(context, node, method, annotation, allMethodAnnotations, allClassAnnotations, 4);
        } else {
            boolean bl;
            PsiPackage methodPackage;
            PsiFile containingFile2;
            UFile uFile = UastUtils.getContainingUFile((UElement)node);
            PsiFile containingFile1 = UastLintUtils.getPsiFile((UFile)uFile);
            if (Intrinsics.areEqual((Object)containingFile1, (Object)(containingFile2 = UastLintUtils.getContainingFile((PsiElement)((PsiElement)method)))) || containingFile2 == null) {
                return;
            }
            PsiFile psiFile = containingFile1;
            if (Intrinsics.areEqual((Object)(psiFile != null ? psiFile.getVirtualFile() : null), (Object)containingFile2.getVirtualFile())) {
                return;
            }
            if (visibility == 2) {
                if (!this.isTestContext(context, node)) {
                    this.reportVisibilityError(context, node, "private");
                }
                return;
            }
            JavaEvaluator evaluator = context.getEvaluator();
            PsiPackage pkg = evaluator.getPackage(node);
            if (Intrinsics.areEqual((Object)pkg, (Object)(methodPackage = evaluator.getPackage((PsiElement)method)))) {
                return;
            }
            if (visibility == 3) {
                if (!this.isTestContext(context, node)) {
                    this.reportVisibilityError(context, node, "package private");
                }
                return;
            }
            boolean bl2 = bl = visibility == 4;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            PsiClass methodClass = method.getContainingClass();
            UClass thisClass = (UClass)UastUtils.getParentOfType((UElement)node, UClass.class, (boolean)true);
            if (thisClass == null || methodClass == null) {
                return;
            }
            String qualifiedName = methodClass.getQualifiedName();
            if (qualifiedName == null || evaluator.inheritsFrom((PsiClass)thisClass, qualifiedName, false)) {
                return;
            }
            if (!this.isTestContext(context, node)) {
                this.reportVisibilityError(context, node, "protected");
            }
        }
    }

    private final void reportVisibilityError(JavaContext context, UElement node, String desc) {
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "This method should only be accessed from tests or within %1$s scope";
        Object[] objectArray = new Object[]{desc};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
        String message2 = string2;
        Location location = node instanceof UCallExpression ? context.getCallLocation((UCallExpression)node, false, false) : context.getLocation(node);
        this.report(context, TEST_VISIBILITY, node, location, message2);
    }

    private final void checkRestrictTo(JavaContext context, UElement node, PsiMethod method, UAnnotation annotation, List<? extends UAnnotation> allMethodAnnotations, List<? extends UAnnotation> allClassAnnotations) {
        int scope = RestrictToDetector.Companion.getRestrictionScope(annotation);
        if (scope != 0) {
            this.checkRestrictTo(context, node, method, annotation, allMethodAnnotations, allClassAnnotations, scope);
        }
    }

    private final void checkRestrictTo(JavaContext context, UElement node, PsiMethod method, UAnnotation annotation, List<? extends UAnnotation> allMethodAnnotations, List<? extends UAnnotation> allClassAnnotations, int scope) {
        StringCompanionObject stringCompanionObject;
        String methodGroup;
        String thisGroup;
        MavenCoordinates methodCoordinates;
        MavenCoordinates thisCoordinates;
        JavaEvaluator evaluator;
        PsiClass psiClass = method.getContainingClass();
        if (psiClass == null) {
            return;
        }
        PsiClass containingClass = psiClass;
        boolean isClassAnnotation = false;
        if (UastLintUtils.containsAnnotation(allMethodAnnotations, (UAnnotation)annotation)) {
            if (context.getEvaluator().isInherited(annotation, (PsiModifierListOwner)method)) {
                return;
            }
        } else {
            if (this.containsRestrictionAnnotation(allMethodAnnotations)) {
                return;
            }
            isClassAnnotation = UastLintUtils.containsAnnotation(allClassAnnotations, (UAnnotation)annotation);
            if (isClassAnnotation) {
                JavaEvaluator javaEvaluator = context.getEvaluator();
                PsiClass psiClass2 = containingClass;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiClass2, (String)"containingClass");
                if (javaEvaluator.isInherited(annotation, (PsiModifierListOwner)psiClass2)) {
                    return;
                }
            } else if (this.containsRestrictionAnnotation(allClassAnnotations)) {
                return;
            }
        }
        if ((scope & 1) != 0) {
            evaluator = context.getEvaluator();
            thisCoordinates = evaluator.getLibrary(node);
            methodCoordinates = evaluator.getLibrary((PsiElement)method);
            MavenCoordinates mavenCoordinates = thisCoordinates;
            thisGroup = mavenCoordinates != null ? mavenCoordinates.getGroupId() : null;
            MavenCoordinates mavenCoordinates2 = methodCoordinates;
            String string = methodGroup = mavenCoordinates2 != null ? mavenCoordinates2.getGroupId() : null;
            if (Intrinsics.areEqual((Object)thisGroup, (Object)methodGroup) ^ true && methodGroup != null) {
                StringCompanionObject stringCompanionObject2 = StringCompanionObject.INSTANCE;
                String string2 = "from within the same library group (groupId=%1$s)";
                StringCompanionObject stringCompanionObject3 = stringCompanionObject = new StringCompanionObject[]{methodGroup};
                String string3 = String.format(string2, Arrays.copyOf(stringCompanionObject3, ((Object[])stringCompanionObject3).length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
                String where = string3;
                PsiClass psiClass3 = containingClass;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiClass3, (String)"containingClass");
                this.reportRestriction(where, psiClass3, method, context, node, isClassAnnotation);
            }
        }
        if ((scope & 2) != 0) {
            evaluator = context.getEvaluator();
            thisCoordinates = evaluator.getLibrary(node);
            methodCoordinates = evaluator.getLibrary((PsiElement)method);
            MavenCoordinates mavenCoordinates = thisCoordinates;
            thisGroup = mavenCoordinates != null ? mavenCoordinates.getGroupId() : null;
            MavenCoordinates mavenCoordinates3 = methodCoordinates;
            String string = methodGroup = mavenCoordinates3 != null ? mavenCoordinates3.getGroupId() : null;
            if (Intrinsics.areEqual((Object)thisGroup, (Object)methodGroup) ^ true && methodGroup != null) {
                String methodArtifact;
                MavenCoordinates mavenCoordinates4 = thisCoordinates;
                String thisArtifact = mavenCoordinates4 != null ? mavenCoordinates4.getArtifactId() : null;
                if (Intrinsics.areEqual((Object)thisArtifact, (Object)(methodArtifact = methodCoordinates.getArtifactId())) ^ true) {
                    stringCompanionObject = StringCompanionObject.INSTANCE;
                    String string4 = "from within the same library (%1$s:%2$s)";
                    Object[] objectArray = new Object[]{methodGroup, methodArtifact};
                    String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"java.lang.String.format(format, *args)");
                    String where = string5;
                    PsiClass psiClass4 = containingClass;
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiClass4, (String)"containingClass");
                    this.reportRestriction(where, psiClass4, method, context, node, isClassAnnotation);
                }
            }
        }
        if ((scope & 4) != 0 && !this.isTestContext(context, node)) {
            PsiClass psiClass5 = containingClass;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiClass5, (String)"containingClass");
            this.reportRestriction("from tests", psiClass5, method, context, node, isClassAnnotation);
        }
        if ((scope & 0x10) != 0 && !this.isGmsContext(context, node)) {
            PsiClass psiClass6 = containingClass;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiClass6, (String)"containingClass");
            this.reportRestriction(null, psiClass6, method, context, node, isClassAnnotation);
        }
        if ((scope & 8) != 0) {
            PsiClass psiClass7 = containingClass;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiClass7, (String)"containingClass");
            String qualifiedName = psiClass7.getQualifiedName();
            if (qualifiedName != null) {
                UClass outer;
                JavaEvaluator evaluator2 = context.getEvaluator();
                boolean isSubClass = false;
                UElement prev = node;
                while ((outer = (UClass)UastUtils.getParentOfType((UElement)prev, UClass.class, (boolean)true)) != null) {
                    if (evaluator2.inheritsFrom((PsiClass)outer, qualifiedName, false)) {
                        isSubClass = true;
                        break;
                    }
                    if (evaluator2.isStatic((PsiModifierListOwner)outer)) break;
                    prev = (UElement)outer;
                }
                if (!isSubClass) {
                    this.reportRestriction("from subclasses", containingClass, method, context, node, isClassAnnotation);
                }
            }
        }
    }

    private final void reportRestriction(String where, PsiClass containingClass, PsiMethod method, JavaContext context, UElement node, boolean isClassAnnotation) {
        String message2;
        String api = method.isConstructor() ? method.getName() + " constructor" : containingClass.getName() + "." + method.getName();
        UElement locationNode = node;
        if (node instanceof UCallExpression) {
            UIdentifier nameElement = ((UCallExpression)node).getMethodIdentifier();
            if (nameElement != null) {
                locationNode = (UElement)nameElement;
            }
            if (isClassAnnotation) {
                UExpression qualifier = ((UCallExpression)node).getReceiver();
                String className = containingClass.getName();
                if (qualifier != null && className != null && Intrinsics.areEqual((Object)qualifier.asSourceString(), (Object)className)) {
                    locationNode = (UElement)qualifier;
                    api = className;
                }
            }
        }
        if (where == null) {
            message2 = "" + api + " is marked as internal and should not be accessed from apps";
        } else {
            message2 = "" + api + " can only be called " + where;
            if (Intrinsics.areEqual((Object)where, (Object)"from within the same library (groupId=com.android.support)")) {
                message2 = "This API is marked as internal to the support library and should not be accessed from apps";
            }
        }
        Location location = locationNode instanceof UCallExpression ? context.getCallLocation((UCallExpression)locationNode, false, false) : context.getLocation(locationNode);
        this.report(context, RESTRICTED, node, location, message2, null);
    }

    private final boolean containsRestrictionAnnotation(List<? extends UAnnotation> list) {
        return UastLintUtils.containsAnnotation(list, (String)AnnotationDetector.RESTRICT_TO_ANNOTATION.oldName()) || UastLintUtils.containsAnnotation(list, (String)AnnotationDetector.RESTRICT_TO_ANNOTATION.newName());
    }

    static {
        Companion = new Companion(null);
        IMPLEMENTATION = new Implementation(RestrictToDetector.class, Scope.JAVA_FILE_SCOPE);
        RESTRICTED = Issue.Companion.create("RestrictedApi", "Restricted API", "\n                This API has been flagged with a restriction that has not been met.\n\n                Examples of API restrictions:\n                * Method can only be invoked by a subclass\n                * Method can only be accessed from within the same library (defined by the Gradle library group id)\n                * Method can only be accessed from tests.\n\n                You can add your own API restrictions with the `@RestrictTo` annotation.", Category.CORRECTNESS, 4, Severity.ERROR, RestrictToDetector.Companion.getIMPLEMENTATION());
        TEST_VISIBILITY = Issue.Companion.create("VisibleForTests", "Visible Only For Tests", "\n                With the `@VisibleForTesting` annotation you can specify an `otherwise=` \\\n                attribute which specifies the intended visibility if the method had not \\\n                been made more widely visible for the tests.\n\n                This check looks for accesses from production code (e.g. not tests) where \\\n                the access would not have been allowed with the intended production \\\n                visibility.", Category.CORRECTNESS, 4, Severity.WARNING, RestrictToDetector.Companion.getIMPLEMENTATION());
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0012\u0010\u0016\u001a\u00020\f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/lint/checks/RestrictToDetector$Companion;", "", "()V", "ATTR_OTHERWISE", "", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "getIMPLEMENTATION", "()Lcom/android/tools/lint/detector/api/Implementation;", "RESTRICTED", "Lcom/android/tools/lint/detector/api/Issue;", "RESTRICT_TO_ALL", "", "RESTRICT_TO_LIBRARY", "RESTRICT_TO_LIBRARY_GROUP", "RESTRICT_TO_SUBCLASSES", "RESTRICT_TO_TESTS", "TEST_VISIBILITY", "VISIBILITY_NONE", "VISIBILITY_PACKAGE_PRIVATE", "VISIBILITY_PRIVATE", "VISIBILITY_PROTECTED", "getRestrictionScope", "annotation", "Lorg/jetbrains/uast/UAnnotation;", "expression", "Lorg/jetbrains/uast/UExpression;", "getVisibilityForTesting", "lint-checks"})
    public static final class Companion {
        private final Implementation getIMPLEMENTATION() {
            return IMPLEMENTATION;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final int getVisibilityForTesting(UAnnotation annotation) {
            String name;
            String string;
            UExpression value = annotation.findDeclaredAttributeValue(RestrictToDetector.ATTR_OTHERWISE);
            if (value instanceof ULiteralExpression) {
                Object v = ((ULiteralExpression)value).getValue();
                if (!(v instanceof Integer)) return 2;
                return (Integer)v;
            }
            if (!(value instanceof UReferenceExpression)) return 2;
            String string2 = string = (name = ((UReferenceExpression)value).getResolvedName());
            if (string2 == null) return 2;
            switch (string2.hashCode()) {
                case 2402104: {
                    if (!string.equals("NONE")) return 2;
                    return 5;
                }
                case -2116912242: {
                    if (!string.equals("PROTECTED")) return 2;
                    return 4;
                }
                case 403485027: {
                    if (!string.equals("PRIVATE")) return 2;
                    return 2;
                }
                case 1152750154: {
                    if (!string.equals("PACKAGE_PRIVATE")) return 2;
                    return 3;
                }
            }
            return 2;
        }

        private final int getRestrictionScope(UAnnotation annotation) {
            UExpression value = annotation.findDeclaredAttributeValue("value");
            if (value != null) {
                return this.getRestrictionScope(value);
            }
            if (Intrinsics.areEqual((Object)"com.google.android.gms.common.internal.Hide", (Object)annotation.getQualifiedName())) {
                return 16;
            }
            return 0;
        }

        private final int getRestrictionScope(UExpression expression) {
            int scope = 0;
            if (expression != null) {
                PsiElement resolved;
                if (UastExpressionUtils.isArrayInitializer((UElement)((UElement)expression))) {
                    UCallExpression initializerExpression = (UCallExpression)expression;
                    List initializers = initializerExpression.getValueArguments();
                    for (UExpression initializer : initializers) {
                        scope |= this.getRestrictionScope(initializer);
                    }
                } else if (expression instanceof UReferenceExpression && (resolved = ((UReferenceExpression)expression).resolve()) instanceof PsiField) {
                    String name = ((PsiField)resolved).getName();
                    if (Intrinsics.areEqual((Object)"GROUP_ID", (Object)name) || Intrinsics.areEqual((Object)"LIBRARY_GROUP", (Object)name)) {
                        scope |= 1;
                    } else if (Intrinsics.areEqual((Object)"SUBCLASSES", (Object)name)) {
                        scope |= 8;
                    } else if (Intrinsics.areEqual((Object)"TESTS", (Object)name)) {
                        scope |= 4;
                    } else if (Intrinsics.areEqual((Object)"LIBRARY", (Object)name)) {
                        scope |= 2;
                    }
                }
            }
            return scope;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

