/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.checks.ResourceCycleDetector;
import com.android.tools.lint.checks.ResourceCycleDetector$WhenMappings;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.XmlUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Supplier;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 12\u00020\u0001:\u00011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002JH\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\u001b\u001a\u00020\u00072\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00070\u001dH\u0002J,\u0010\u001f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u00052\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\tH\u0002J\u0010\u0010!\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\"H\u0016J\u0010\u0010#\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\"H\u0016J\u001e\u0010$\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010 \u001a\u00020\u0005H\u0002J\u001e\u0010%\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0018\u00010\t2\u0006\u0010 \u001a\u00020\u0005H\u0002J0\u0010&\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00162\u0006\u0010'\u001a\u00020(2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\u0007H\u0002J(\u0010*\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00162\u0006\u0010'\u001a\u00020(2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0007H\u0002J \u0010+\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\u0007H\u0002J\u0018\u0010,\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00162\u0006\u0010-\u001a\u00020.H\u0016J\u0018\u0010/\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00162\u0006\u00100\u001a\u00020\u0018H\u0016R(\u0010\u0003\u001a\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0006\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\b\u001a\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\t\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u000b\u001a\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\t\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/android/tools/lint/checks/ResourceCycleDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "()V", "mChains", "", "Lcom/android/resources/ResourceType;", "", "", "mLocations", "Lcom/google/common/collect/Multimap;", "Lcom/android/tools/lint/detector/api/Location;", "mReferences", "afterCheckRootProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "appliesTo", "", "folderType", "Lcom/android/resources/ResourceFolderType;", "beforeCheckRootProject", "checkCrashItem", "Lcom/android/tools/lint/detector/api/XmlContext;", "item", "Lorg/w3c/dom/Element;", "dfs", "map", "from", "visiting", "", "visited", "findCycles", "type", "getApplicableAttributes", "", "getApplicableElements", "getLocationMap", "getTypeMap", "handleReference", "node", "Lorg/w3c/dom/Node;", "to", "recordLocation", "recordReference", "visitAttribute", "attribute", "Lorg/w3c/dom/Attr;", "visitElement", "element", "Companion", "lint-checks"})
public final class ResourceCycleDetector
extends ResourceXmlDetector {
    private Map<ResourceType, Multimap<String, String>> mReferences;
    private Map<ResourceType, Multimap<String, Location>> mLocations;
    private Map<ResourceType, List<List<String>>> mChains;
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue CYCLE;
    @JvmField
    @NotNull
    public static final Issue CRASH;
    public static final Companion Companion;

    public void beforeCheckRootProject(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (context.getScope().contains(Scope.ALL_RESOURCE_FILES)) {
            this.mReferences = Maps.newEnumMap(ResourceType.class);
        }
    }

    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkParameterIsNotNull((Object)folderType, (String)"folderType");
        return folderType == ResourceFolderType.VALUES || folderType == ResourceFolderType.FONT || folderType == ResourceFolderType.COLOR || folderType == ResourceFolderType.DRAWABLE || folderType == ResourceFolderType.LAYOUT;
    }

    @Nullable
    public Collection<String> getApplicableElements() {
        return Arrays.asList("include", "style", "color", "item", "font", "string", "dimen");
    }

    @Nullable
    public Collection<String> getApplicableAttributes() {
        return ResourceXmlDetector.ALL;
    }

    private final void recordReference(ResourceType type, String from, String to) {
        String string;
        CharSequence charSequence = to;
        if (charSequence.length() == 0 || StringsKt.startsWith$default((String)to, (String)"@android:", (boolean)false, (int)2, null)) {
            return;
        }
        Multimap<String, String> multimap = this.getTypeMap(type);
        if (multimap == null) {
            return;
        }
        Multimap<String, String> map = multimap;
        if (to.charAt(0) == '@') {
            int index = StringsKt.indexOf$default((CharSequence)to, (char)'/', (int)0, (boolean)false, (int)6, null);
            if (index != -1) {
                String string2 = to;
                int n = index + 1;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.substring(n);
                string = string4;
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            } else {
                string = to;
            }
        } else {
            string = to;
        }
        String name = string;
        map.put((Object)from, (Object)name);
    }

    private final Multimap<String, String> getTypeMap(ResourceType type) {
        Map<ResourceType, Multimap<String, String>> map = this.mReferences;
        if (map == null) {
            return null;
        }
        Map<ResourceType, Multimap<String, String>> references = map;
        Multimap<String, String> map2 = references.get(type);
        if (map2 != null) {
            return map2;
        }
        ListMultimap listMultimap = Multimaps.newListMultimap((Map)new TreeMap(), (Supplier)getTypeMap.newMap.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)listMultimap, (String)"Multimaps.newListMultima\u2026Size<String>(6)\n        }");
        Multimap newMap2 = (Multimap)listMultimap;
        Map<ResourceType, Multimap<String, String>> map3 = references;
        Multimap multimap = newMap2;
        map3.put(type, (Multimap<String, String>)multimap);
        return newMap2;
    }

    private final void recordLocation(XmlContext context, Node node, ResourceType type, String from) {
        Multimap<String, Location> multimap = this.getLocationMap(type);
        if (multimap == null) {
            return;
        }
        Multimap<String, Location> map = multimap;
        Location location = context.getLocation(node);
        map.put((Object)from, (Object)location);
    }

    private final Multimap<String, Location> getLocationMap(ResourceType type) {
        Map<ResourceType, Multimap<String, Location>> map = this.mLocations;
        if (map == null) {
            return null;
        }
        Map<ResourceType, Multimap<String, Location>> locations = map;
        Multimap<String, Location> map2 = locations.get(type);
        if (map2 != null) {
            return map2;
        }
        ArrayListMultimap arrayListMultimap = ArrayListMultimap.create((int)30, (int)4);
        Intrinsics.checkExpressionValueIsNotNull((Object)arrayListMultimap, (String)"ArrayListMultimap.create(30, 4)");
        Multimap newMap2 = (Multimap)arrayListMultimap;
        Map<ResourceType, Multimap<String, Location>> map3 = locations;
        Multimap multimap = newMap2;
        map3.put(type, (Multimap<String, Location>)multimap);
        return newMap2;
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Attr text;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        String tagName = element.getTagName();
        if (Intrinsics.areEqual((Object)tagName, (Object)"item")) {
            String drawable;
            if (this.mReferences == null) {
                return;
            }
            ResourceFolderType folderType = context.getResourceFolderType();
            if (folderType == ResourceFolderType.VALUES) {
                Attr typeNode = element.getAttributeNode("type");
                if (typeNode != null) {
                    String typeName = typeNode.getValue();
                    ResourceType type = ResourceType.fromXmlValue((String)typeName);
                    Attr nameNode22 = element.getAttributeNode("name");
                    if (type != null && nameNode22 != null) {
                        NodeList childNodes2 = element.getChildNodes();
                        NodeList nodeList = childNodes2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)nodeList, (String)"childNodes");
                        int n = nodeList.getLength();
                        block0: for (int i = 0; i < n; ++i) {
                            char c;
                            Node child;
                            Node node = child = childNodes2.item(i);
                            Intrinsics.checkExpressionValueIsNotNull((Object)node, (String)"child");
                            if (node.getNodeType() != 3) continue;
                            String text2 = child.getNodeValue();
                            int max = text2.length();
                            for (int k = 0; k < max && !Character.isWhitespace(c = text2.charAt(k)) && c == '@'; ++k) {
                                String string = text2;
                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"text");
                                String string2 = type.getName();
                                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"type.getName()");
                                if (!StringsKt.startsWith$default((String)string, (String)string2, (int)(k + 1), (boolean)false, (int)4, null)) continue block0;
                                String $receiver$iv = text2;
                                CharSequence $receiver$iv$iv = $receiver$iv;
                                int startIndex$iv$iv = 0;
                                int endIndex$iv$iv = $receiver$iv$iv.length() - 1;
                                boolean startFound$iv$iv = false;
                                while (startIndex$iv$iv <= endIndex$iv$iv) {
                                    boolean match$iv$iv;
                                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                                    char it = $receiver$iv$iv.charAt(index$iv$iv);
                                    boolean bl = match$iv$iv = it <= ' ';
                                    if (!startFound$iv$iv) {
                                        if (!match$iv$iv) {
                                            startFound$iv$iv = true;
                                            continue;
                                        }
                                        ++startIndex$iv$iv;
                                        continue;
                                    }
                                    if (!match$iv$iv) break;
                                    --endIndex$iv$iv;
                                }
                                String to = ((Object)$receiver$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                                if (this.mReferences == null) continue;
                                String name = nameNode22.getValue();
                                if (this.mLocations != null) {
                                    String string3 = name;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"name");
                                    this.recordLocation(context, child, type, string3);
                                    continue;
                                }
                                String string4 = name;
                                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"name");
                                this.recordReference(type, string4, to);
                            }
                        }
                    }
                }
            } else if (folderType == ResourceFolderType.COLOR) {
                String color = element.getAttributeNS("http://schemas.android.com/apk/res/android", "color");
                if (color != null && StringsKt.startsWith$default((String)color, (String)"@color/", (boolean)false, (int)2, null)) {
                    String string = context.file.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"context.file.name");
                    String currentColor = Lint.getBaseName((String)string);
                    String type = color;
                    int nameNode22 = "@color/".length();
                    String string5 = currentColor;
                    ResourceType resourceType = ResourceType.COLOR;
                    Node node = element;
                    XmlContext xmlContext = context;
                    ResourceCycleDetector resourceCycleDetector = this;
                    String string6 = type.substring(nameNode22);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
                    String string7 = string6;
                    resourceCycleDetector.handleReference(xmlContext, node, resourceType, string5, string7);
                }
            } else if (folderType == ResourceFolderType.DRAWABLE && (drawable = element.getAttributeNS("http://schemas.android.com/apk/res/android", "drawable")) != null && StringsKt.startsWith$default((String)drawable, (String)"@drawable/", (boolean)false, (int)2, null)) {
                String string = context.file.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"context.file.name");
                String currentColor = Lint.getBaseName((String)string);
                String type = drawable;
                int nameNode22 = "@drawable/".length();
                String string8 = currentColor;
                ResourceType resourceType = ResourceType.DRAWABLE;
                Node node = element;
                XmlContext xmlContext = context;
                ResourceCycleDetector resourceCycleDetector = this;
                String string9 = type.substring(nameNode22);
                Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"(this as java.lang.String).substring(startIndex)");
                String string10 = string9;
                resourceCycleDetector.handleReference(xmlContext, node, resourceType, string8, string10);
            }
        } else if (Intrinsics.areEqual((Object)tagName, (Object)"style")) {
            int i;
            String childNodes2;
            String name;
            Attr nameNode = element.getAttributeNode("name");
            Attr parentNode = element.getAttributeNode("parent");
            if (parentNode != null && nameNode != null) {
                CharSequence nameNode22;
                String parent;
                name = nameNode.getValue();
                String string = parent = parentNode.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"parent");
                if (StringsKt.startsWith$default((String)string, (String)"@style/", (boolean)false, (int)2, null)) {
                    String string11 = name;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string11, (String)"name");
                    if (StringsKt.startsWith$default((String)parent, (String)string11, (int)"@style/".length(), (boolean)false, (int)4, null) && StringsKt.startsWith$default((String)parent, (String)".", (int)("@style/".length() + name.length()), (boolean)false, (int)4, null)) {
                        if (context.isEnabled(CYCLE) && context.getDriver().getPhase() == 1) {
                            String nameNode22 = parent;
                            int childNodes2 = "@style/".length();
                            StringBuilder stringBuilder = new StringBuilder().append("Potential cycle: `").append(name).append("` is the implied parent of `");
                            Location location = context.getLocation((Node)parentNode);
                            Node node = parentNode;
                            Issue issue = CYCLE;
                            XmlContext xmlContext = context;
                            String string12 = nameNode22.substring(childNodes2);
                            Intrinsics.checkExpressionValueIsNotNull((Object)string12, (String)"(this as java.lang.String).substring(startIndex)");
                            String string13 = string12;
                            XmlContext.report$default((XmlContext)xmlContext, (Issue)issue, (Node)node, (Location)location, (String)stringBuilder.append(string13).append("` and ").append("this defines the opposite").toString(), null, (int)16, null);
                        }
                        return;
                    }
                }
                if (!((nameNode22 = (CharSequence)parent).length() == 0) && !StringsKt.startsWith$default((String)parent, (String)"@android:style/", (boolean)false, (int)2, null)) {
                    childNodes2 = parent;
                    i = StringsKt.lastIndexOf$default((CharSequence)parent, (char)'/', (int)0, (boolean)false, (int)6, null) + 1;
                    String string14 = childNodes2.substring(i);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string14, (String)"(this as java.lang.String).substring(startIndex)");
                    String parentName = string14;
                    Node node = parentNode;
                    String string15 = name;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string15, (String)"name");
                    this.handleReference(context, node, ResourceType.STYLE, string15, parentName);
                }
            } else if (this.mReferences != null && nameNode != null) {
                String string = name = nameNode.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
                int index = StringsKt.lastIndexOf$default((CharSequence)string, (char)'.', (int)0, (boolean)false, (int)6, null);
                if (index > 0) {
                    childNodes2 = name;
                    i = 0;
                    String string16 = childNodes2.substring(i, index);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string16, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    String parent = string16;
                    if (this.mReferences != null) {
                        if (this.mLocations != null) {
                            Attr node;
                            Attr attr = node = element.getAttributeNode("name");
                            Intrinsics.checkExpressionValueIsNotNull((Object)attr, (String)"node");
                            this.recordLocation(context, attr, ResourceType.STYLE, name);
                        } else {
                            this.recordReference(ResourceType.STYLE, name, parent);
                        }
                    }
                }
            }
            if (context.isEnabled(CRASH) && context.getDriver().getPhase() == 1) {
                for (Element item : XmlUtils.getSubTags((Node)element)) {
                    if (!Intrinsics.areEqual((Object)"android:id", (Object)item.getAttribute("name"))) continue;
                    Element element2 = item;
                    Intrinsics.checkExpressionValueIsNotNull((Object)element2, (String)"item");
                    this.checkCrashItem(context, element2);
                }
            }
        } else if (Intrinsics.areEqual((Object)tagName, (Object)"include")) {
            Attr layoutNode = element.getAttributeNode("layout");
            if (layoutNode != null) {
                String layout;
                String string = layout = layoutNode.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"layout");
                if (StringsKt.startsWith$default((String)string, (String)"@layout/", (boolean)false, (int)2, null)) {
                    String string17 = context.file.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string17, (String)"context.file.name");
                    String currentLayout = Lint.getBaseName((String)string17);
                    this.handleReference(context, layoutNode, ResourceType.LAYOUT, currentLayout, layout);
                }
            }
        } else if (Intrinsics.areEqual((Object)tagName, (Object)"color") || Intrinsics.areEqual((Object)tagName, (Object)"string") || Intrinsics.areEqual((Object)tagName, (Object)"dimen")) {
            NodeList childNodes = element.getChildNodes();
            NodeList nodeList = childNodes;
            Intrinsics.checkExpressionValueIsNotNull((Object)nodeList, (String)"childNodes");
            int n = nodeList.getLength();
            block4: for (int i = 0; i < n; ++i) {
                char c;
                Node child;
                Node node = child = childNodes.item(i);
                Intrinsics.checkExpressionValueIsNotNull((Object)node, (String)"child");
                if (node.getNodeType() != 3) continue;
                String text3 = child.getNodeValue();
                int max = text3.length();
                for (int k = 0; k < max && !Character.isWhitespace(c = text3.charAt(k)) && c == '@'; ++k) {
                    String to;
                    String string = text3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"text");
                    if (!StringsKt.startsWith$default((String)string, (String)tagName, (int)(k + 1), (boolean)false, (int)4, null)) continue block4;
                    String $receiver$iv = text3;
                    CharSequence $receiver$iv$iv22 = $receiver$iv;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $receiver$iv$iv22.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it = $receiver$iv$iv22.charAt(index$iv$iv);
                        boolean bl = match$iv$iv = it <= ' ';
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    $receiver$iv = ((Object)$receiver$iv$iv22.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                    int $receiver$iv$iv22 = tagName.length() + 2;
                    String string18 = $receiver$iv;
                    if (string18 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string18.substring($receiver$iv$iv22), (String)"(this as java.lang.String).substring(startIndex)");
                    String name = element.getAttribute("name");
                    ResourceType type = ResourceType.fromXmlTagName((String)tagName);
                    if (type == null) continue;
                    String string19 = name;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string19, (String)"name");
                    this.handleReference(context, child, type, string19, to);
                }
            }
        } else if (Intrinsics.areEqual((Object)tagName, (Object)"font") && (text = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "font")) != null) {
            String string = text.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"text.value");
            if (StringsKt.startsWith$default((String)string, (String)"@font/", (boolean)false, (int)2, null)) {
                String string20 = text.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)string20, (String)"text.value");
                String $receiver$iv = string20;
                CharSequence $receiver$iv$iv = $receiver$iv;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $receiver$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $receiver$iv$iv.charAt(index$iv$iv);
                    boolean bl = match$iv$iv = it <= ' ';
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                $receiver$iv = ((Object)$receiver$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                int n = "@font/".length();
                String string21 = $receiver$iv;
                if (string21 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string22 = string21.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string22, (String)"(this as java.lang.String).substring(startIndex)");
                String font = string22;
                String string23 = context.file.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string23, (String)"context.file.name");
                String currentFont = Lint.getBaseName((String)string23);
                this.handleReference(context, text, ResourceType.FONT, currentFont, font);
            }
        }
    }

    public void afterCheckRootProject(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Map<ResourceType, Multimap<String, String>> map = this.mReferences;
        if (map == null) {
            return;
        }
        Map<ResourceType, Multimap<String, String>> references = map;
        int phase = context.getDriver().getPhase();
        if (phase == 1) {
            Map<ResourceType, Multimap<String, String>> map2 = references;
            Iterator<Map.Entry<ResourceType, Multimap<String, String>>> iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ResourceType, Multimap<String, String>> entry;
                Map.Entry<ResourceType, Multimap<String, String>> entry2 = entry = iterator.next();
                ResourceType type = entry2.getKey();
                entry2 = entry;
                Multimap<String, String> map3 = entry2.getValue();
                this.findCycles(context, type, map3);
            }
        } else {
            boolean bl;
            boolean bl2 = bl = phase == 2;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            Map<ResourceType, List<List<String>>> map4 = this.mChains;
            if (map4 == null) {
                return;
            }
            Map<ResourceType, List<List<String>>> chainsMap = map4;
            Map<ResourceType, Multimap<String, Location>> map5 = this.mLocations;
            if (map5 == null) {
                return;
            }
            Map<ResourceType, Multimap<String, Location>> locationMap = map5;
            Map<ResourceType, List<List<String>>> map6 = chainsMap;
            Iterator<Map.Entry<ResourceType, List<List<String>>>> iterator = map6.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ResourceType, List<List<String>>> entry;
                Map.Entry<ResourceType, List<List<String>>> entry3 = entry = iterator.next();
                ResourceType type = entry3.getKey();
                entry3 = entry;
                List<List<String>> chains = entry3.getValue();
                Multimap multimap = locationMap.get(type);
                if (multimap == null) {
                    ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
                    Intrinsics.checkExpressionValueIsNotNull((Object)arrayListMultimap, (String)"ArrayListMultimap.create()");
                    multimap = (Multimap)arrayListMultimap;
                }
                Multimap locations = multimap;
                for (List<String> chain : chains) {
                    String message2;
                    boolean bl3;
                    Location location = null;
                    boolean bl4 = bl3 = !chain.isEmpty();
                    if (_Assertions.ENABLED && !bl3) {
                        String string = "Assertion failed";
                        throw (Throwable)((Object)new AssertionError((Object)string));
                    }
                    int n = chain.size();
                    for (int i = 0; i < n; ++i) {
                        String item = chain.get(i);
                        Collection itemLocations = locations.get((Object)item);
                        if (itemLocations.isEmpty()) continue;
                        Location itemLocation = (Location)itemLocations.iterator().next();
                        String next = chain.get((i + 1) % chain.size());
                        String label = "Reference from @" + type.getName() + "/" + item + " to " + type.getName() + "/" + next + " here";
                        itemLocation.setMessage(label);
                        itemLocation.setSecondary(location);
                        location = itemLocation;
                    }
                    if (location == null) {
                        File file = context.getProject().getDir();
                        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"context.project.dir");
                        location = Location.Companion.create(file);
                    } else {
                        Location curr = location.getSecondary();
                        while (curr != null) {
                            Location next = curr.getSecondary();
                            if (next == location) {
                                curr.setSecondary((Location)null);
                                break;
                            }
                            curr = next;
                        }
                    }
                    StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                    String string = "%1$s Resource definition cycle: %2$s";
                    Object[] objectArray = new Object[]{type.getDisplayName(), Joiner.on((String)" => ").join((Iterable)chain)};
                    Intrinsics.checkExpressionValueIsNotNull((Object)String.format(string, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(format, *args)");
                    Context.report$default((Context)context, (Issue)CYCLE, (Location)location, (String)message2, null, (int)8, null);
                }
            }
        }
    }

    public void visitAttribute(@NotNull XmlContext context, @NotNull Attr attribute) {
        String primary;
        String value;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attribute, (String)"attribute");
        ResourceFolderType resourceFolderType = context.getResourceFolderType();
        if (resourceFolderType == null || resourceFolderType == ResourceFolderType.VALUES) {
            return;
        }
        String string = value = attribute.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"value");
        CharSequence charSequence = string;
        if (charSequence.length() == 0 || !StringsKt.startsWith$default((String)value, (String)"@", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)value, (String)"@+id/", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)value, (String)"@id/", (boolean)false, (int)2, null)) {
            return;
        }
        List types = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)resourceFolderType);
        String string2 = primary = ((ResourceType)types.get(0)).getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"primary");
        if (!StringsKt.regionMatches((String)value, (int)1, (String)string2, (int)0, (int)primary.length(), (boolean)false)) {
            return;
        }
        ResourceUrl resourceUrl = ResourceUrl.parse((String)value);
        if (resourceUrl == null) {
            return;
        }
        ResourceUrl url = resourceUrl;
        if (!types.contains(url.type)) {
            return;
        }
        if (Intrinsics.areEqual((Object)"http://schemas.android.com/tools", (Object)attribute.getNamespaceURI())) {
            return;
        }
        String string3 = context.file.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"context.file.name");
        String from = Lint.getBaseName((String)string3);
        Node node = attribute;
        ResourceType resourceType = url.type;
        Intrinsics.checkExpressionValueIsNotNull((Object)resourceType, (String)"url.type");
        String string4 = url.name;
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"url.name");
        this.handleReference(context, node, resourceType, from, string4);
    }

    private final void handleReference(XmlContext context, Node node, ResourceType type, String from, String to) {
        if (Intrinsics.areEqual((Object)from, (Object)to)) {
            if (context.isEnabled(CYCLE) && context.getDriver().getPhase() == 1) {
                String string;
                Location location = context.getLocation(node);
                StringBuilder stringBuilder = new StringBuilder().append("").append(type.getDisplayName()).append(" `").append(to).append("` should not ");
                switch (ResourceCycleDetector$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                    case 1: {
                        string = "include";
                        break;
                    }
                    case 2: {
                        string = "extend";
                        break;
                    }
                    default: {
                        string = "reference";
                    }
                }
                XmlContext.report$default((XmlContext)context, (Issue)CYCLE, (Node)node, (Location)location, (String)stringBuilder.append(string).append(" itself").toString(), null, (int)16, null);
            }
        } else if (this.mReferences != null) {
            if (this.mLocations != null) {
                this.recordLocation(context, node, type, from);
            } else {
                this.recordReference(type, from, to);
            }
        }
    }

    private final void findCycles(Context context, ResourceType type, Multimap<String, String> map) {
        HashSet visiting = Sets.newHashSet();
        HashSet visited = Sets.newHashSetWithExpectedSize((int)map.size());
        HashSet seen = Sets.newHashSetWithExpectedSize((int)map.size());
        for (String from : map.keySet()) {
            if (seen.contains(from)) continue;
            String string = from;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"from");
            HashSet hashSet = visiting;
            Intrinsics.checkExpressionValueIsNotNull((Object)hashSet, (String)"visiting");
            Set set = hashSet;
            HashSet hashSet2 = visited;
            Intrinsics.checkExpressionValueIsNotNull((Object)hashSet2, (String)"visited");
            List<String> chain = this.dfs(map, string, set, hashSet2);
            if (chain == null || chain.size() <= 2) continue;
            seen.addAll((Collection)chain);
            CollectionsKt.reverse(chain);
            Map map2 = this.mChains;
            if (map2 == null) {
                ResourceCycleDetector resourceCycleDetector;
                ResourceCycleDetector $receiver = resourceCycleDetector = this;
                EnumMap newMap2 = Maps.newEnumMap(ResourceType.class);
                $receiver.mChains = newMap2;
                $receiver.mLocations = Maps.newEnumMap(ResourceType.class);
                context.getDriver().requestRepeat((Detector)$receiver, Scope.RESOURCE_FILE_SCOPE);
                EnumMap enumMap = newMap2;
                Intrinsics.checkExpressionValueIsNotNull((Object)enumMap, (String)"run {\n                  \u2026Map\n                    }");
                map2 = enumMap;
            }
            Map chains = map2;
            List<List<String>> list = chains.get(type);
            if (list == null) {
                Map map3 = chains;
                List list2 = CollectionsKt.mutableListOf((Object[])new List[]{chain});
                map3.put((ResourceType)type, (List<List<String>>)list2);
                continue;
            }
            list.add(chain);
        }
    }

    private final void checkCrashItem(XmlContext context, Element item) {
        NodeList childNodes = item.getChildNodes();
        NodeList nodeList = childNodes;
        Intrinsics.checkExpressionValueIsNotNull((Object)nodeList, (String)"childNodes");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node child;
            Node node = child = childNodes.item(i);
            Intrinsics.checkExpressionValueIsNotNull((Object)node, (String)"child");
            if (node.getNodeType() != 3) continue;
            String text = child.getNodeValue();
            int max = text.length();
            for (int k = 0; k < max; ++k) {
                String name;
                String string;
                int n2;
                char c = text.charAt(k);
                if (Character.isWhitespace(c)) {
                    return;
                }
                String string2 = text;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"text");
                if (StringsKt.startsWith$default((String)string2, (String)"@+id/", (int)k, (boolean)false, (int)4, null)) {
                    String $receiver$iv = text;
                    CharSequence $receiver$iv$iv = $receiver$iv;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $receiver$iv$iv.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it = $receiver$iv$iv.charAt(index$iv$iv);
                        boolean bl = match$iv$iv = it <= ' ';
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    $receiver$iv = ((Object)$receiver$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                    n2 = "@+id/".length();
                    string = $receiver$iv;
                    if (string == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                } else {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string.substring(n2), (String)"(this as java.lang.String).substring(startIndex)");
                String message2 = "This construct can potentially crash `aapt` during a build. Change `@+id/" + name + "` to `@id/" + name + "` and define " + "the id explicitly using " + "`<item type=\"id\" name=\"" + name + "\"/>` instead.";
                XmlContext.report$default((XmlContext)context, (Issue)CRASH, (Node)item, (Location)context.getLocation((Node)item), (String)message2, null, (int)16, null);
            }
        }
    }

    private final List<String> dfs(Multimap<String, String> map, String from, Set<String> visiting, Set<String> visited) {
        visiting.add(from);
        visited.add(from);
        Collection targets = map.get((Object)from);
        if (targets != null && !targets.isEmpty()) {
            for (String target : targets) {
                List<Object> chain;
                if (visiting.contains(target)) {
                    chain = Lists.newArrayList();
                    ((ArrayList)chain).add(target);
                    ((ArrayList)chain).add(from);
                    return chain;
                }
                if (visited.contains(target)) continue;
                String string = target;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"target");
                chain = this.dfs(map, string, visiting, visited);
                if (chain == null) continue;
                chain.add(from);
                return chain;
            }
        }
        visiting.remove(from);
        return null;
    }

    static {
        Companion = new Companion(null);
        IMPLEMENTATION = new Implementation(ResourceCycleDetector.class, Scope.RESOURCE_FILE_SCOPE);
        CYCLE = Issue.Companion.create("ResourceCycle", "Cycle in resource definitions", "\n                There should be no cycles in resource definitions as this can lead to \\\n                runtime exceptions.", Category.CORRECTNESS, 8, Severity.FATAL, IMPLEMENTATION);
        CRASH = Issue.Companion.create("AaptCrash", "Potential AAPT crash", "\n                Defining a style which sets `android:id` to a dynamically generated id can \\\n                cause many versions of `aapt`, the resource packaging tool, to crash. \\\n                To work around this, declare the id explicitly with \\\n                `<item type=\"id\" name=\"...\" />` instead.", Category.CORRECTNESS, 8, Severity.FATAL, IMPLEMENTATION);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/tools/lint/checks/ResourceCycleDetector$Companion;", "", "()V", "CRASH", "Lcom/android/tools/lint/detector/api/Issue;", "CYCLE", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

