/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCallableReferenceExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u00012\u00020\u0002:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\f\u001a\u0012\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e\u0018\u00010\rH\u0016J\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/lint/checks/SamDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "checkLambda", "", "node", "Lorg/jetbrains/uast/UExpression;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "reportError", "storesLambda", "", "method", "Lorg/jetbrains/uast/UMethod;", "parameter", "Lcom/intellij/psi/PsiParameter;", "Issues", "lint-checks"})
public final class SamDetector
extends Detector
implements SourceCodeScanner {
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    private static final String HANDLER_CLASS = "android.os.Handler";
    private static final String DRAWABLE_CALLBACK_CLASS = "android.graphics.drawable.Drawable.Callback";
    private static final String RUNNABLE_CLASS = "java.lang.Runnable";
    public static final Issues Issues;

    @Nullable
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return CollectionsKt.listOf((Object[])new Class[]{ULambdaExpression.class, UCallableReferenceExpression.class});
    }

    @Nullable
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        UFile uFile = context.getUastFile();
        if (uFile == null || (uFile = uFile.getSourcePsi()) == null) {
            return null;
        }
        UFile psi = uFile;
        if (Lint.isJava((PsiElement)psi)) {
            return null;
        }
        return new UElementHandler(this, context){
            final /* synthetic */ SamDetector this$0;
            final /* synthetic */ JavaContext $context;

            public void visitLambdaExpression(@NotNull ULambdaExpression node) {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                SamDetector.access$checkLambda(this.this$0, (UExpression)node, this.$context);
            }

            public void visitCallableReferenceExpression(@NotNull UCallableReferenceExpression node) {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                SamDetector.access$checkLambda(this.this$0, (UExpression)node, this.$context);
            }
            {
                this.this$0 = $outer;
                this.$context = $captured_local_variable$1;
            }
        };
    }

    private final void checkLambda(UExpression node, JavaContext context) {
        UElement uElement = node.getUastParent();
        if (!(uElement instanceof UCallExpression)) {
            uElement = null;
        }
        UCallExpression uCallExpression = (UCallExpression)uElement;
        if (uCallExpression == null) {
            return;
        }
        UCallExpression call = uCallExpression;
        PsiMethod psiMethod = call.resolve();
        if (psiMethod == null) {
            return;
        }
        PsiMethod psiMethod2 = psiMethod;
        JavaEvaluator evaluator = context.getEvaluator();
        if (psiMethod2 instanceof PsiCompiledElement) {
            PsiClass containingClass = psiMethod2.getContainingClass();
            if (evaluator.isMemberInClass((PsiMember)psiMethod2, HANDLER_CLASS) || evaluator.inheritsFrom(containingClass, "android.view.View", false) || evaluator.inheritsFrom(containingClass, DRAWABLE_CALLBACK_CLASS, false)) {
                Map map = evaluator.computeArgumentMapping(call, psiMethod2);
                PsiParameter psiParameter = (PsiParameter)map.get(node);
                if (psiParameter == null) {
                    return;
                }
                PsiParameter psiParameter2 = psiParameter;
                PsiType psiType = psiParameter2.getType();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiType, (String)"psiParameter.type");
                if (Intrinsics.areEqual((Object)psiType.getCanonicalText(), (Object)RUNNABLE_CLASS)) {
                    this.reportError(context, node);
                }
            }
            return;
        }
        if (!Lint.isJava((PsiElement)((PsiElement)psiMethod2))) {
            return;
        }
        Map map = evaluator.computeArgumentMapping(call, psiMethod2);
        PsiParameter psiParameter = (PsiParameter)map.get(node);
        if (psiParameter == null) {
            return;
        }
        PsiParameter psiParameter3 = psiParameter;
        UMethod uMethod = (UMethod)UastContextKt.toUElement((PsiElement)((PsiElement)psiMethod2), UMethod.class);
        if (uMethod == null) {
            return;
        }
        UMethod method = uMethod;
        if (this.storesLambda(method, psiParameter3)) {
            this.reportError(context, node);
        }
    }

    private final void reportError(JavaContext context, UExpression node) {
        JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)((UElement)node), (Location)context.getLocation((UElement)node), (String)"Implicit new instance being passed to method which ends up checking instance equality; this can lead to subtle bugs", null, (int)16, null);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean storesLambda(UMethod method, PsiParameter parameter) {
        void storesLambda2;
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        method.accept((UastVisitor)new AbstractUastVisitor(parameter, (Ref.BooleanRef)storesLambda2){
            final /* synthetic */ PsiParameter $parameter;
            final /* synthetic */ Ref.BooleanRef $storesLambda;

            public boolean visitSimpleNameReferenceExpression(@NotNull USimpleNameReferenceExpression node) {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                PsiElement resolved = node.resolve();
                if (Intrinsics.areEqual((Object)resolved, (Object)this.$parameter)) {
                    UElement parent = node.getUastParent();
                    if (parent instanceof UCallExpression) {
                        String methodName = ((UCallExpression)parent).getMethodName();
                        if (methodName != null && (StringsKt.startsWith$default((String)methodName, (String)"add", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)methodName, (String)"put", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)methodName, (String)"set", (boolean)false, (int)2, null))) {
                            this.$storesLambda.element = true;
                        }
                    } else if (parent instanceof UBinaryExpression) {
                        PsiElement lhs;
                        UastBinaryOperator kind = ((UBinaryExpression)parent).getOperator();
                        if (Intrinsics.areEqual((Object)kind, (Object)UastBinaryOperator.IDENTITY_EQUALS) || Intrinsics.areEqual((Object)kind, (Object)UastBinaryOperator.IDENTITY_NOT_EQUALS)) {
                            this.$storesLambda.element = true;
                        } else if (Intrinsics.areEqual((Object)kind, (Object)UastBinaryOperator.ASSIGN) && Intrinsics.areEqual((Object)((UBinaryExpression)parent).getRightOperand(), (Object)node) && (lhs = UastUtils.tryResolve((UElement)((UElement)((UBinaryExpression)parent).getLeftOperand()))) instanceof PsiField) {
                            this.$storesLambda.element = true;
                        }
                    }
                }
                return super.visitSimpleNameReferenceExpression(node);
            }
            {
                this.$parameter = $captured_local_variable$0;
                this.$storesLambda = $captured_local_variable$1;
            }
        });
        return storesLambda2.element;
    }

    static {
        Issues = new Issues(null);
        Collection collection = null;
        EnumSet enumSet = null;
        Implementation implementation = new Implementation(SamDetector.class, Scope.JAVA_FILE_SCOPE);
        boolean bl = false;
        Boolean bl2 = null;
        Severity severity = Severity.WARNING;
        int n = 6;
        String string = null;
        Category category = Category.CORRECTNESS;
        ISSUE = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"ImplicitSamInstance", (String)"Implicit SAM Instances", (String)"\n                Kotlin's support for SAM (single accessor method) interfaces lets you pass \\\n                a lambda to the interface. This will create a new instance on the fly even \\\n                though there is no explicit constructor call. If you pass one of these \\\n                lambdas or method references into a method which (for example) stores or \\\n                compares the object identity, unexpected results may happen.\n            ", (Implementation)implementation, string, (Category)category, (int)n, (Severity)severity, (boolean)bl, bl2, enumSet, collection, (int)3088, null);
    }

    public static final /* synthetic */ void access$checkLambda(SamDetector $this, UExpression node, JavaContext context) {
        $this.checkLambda(node, context);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/lint/checks/SamDetector$Issues;", "", "()V", "DRAWABLE_CALLBACK_CLASS", "", "HANDLER_CLASS", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "RUNNABLE_CLASS", "lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

