/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;

public class PowerManagerDetector
extends Detector
implements Detector.UastScanner {
    private static final String POWER_MANAGER_CLASS_NAME = "android.os.PowerManager";
    private static final Implementation IMPLEMENTATION = new Implementation(PowerManagerDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue INVALID_WAKE_LOCK_TAG = Issue.create((String)"InvalidWakeLockTag", (String)"Invalid Wake Lock Tag", (String)"Wake Lock tags must follow the naming conventions defined in the`PowerManager` documentation.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION).setAndroidSpecific(true).addMoreInfo("https://developer.android.com/reference/android/os/PowerManager.html");

    public void visitMethodCall(JavaContext context, UCallExpression call, PsiMethod method) {
        if (!context.getEvaluator().isMemberInClass((PsiMember)method, POWER_MANAGER_CLASS_NAME)) {
            return;
        }
        List expressions = call.getValueArguments();
        if (expressions.size() < 2) {
            return;
        }
        UElement secondArgumentExpression = (UElement)expressions.get(1);
        String value = ConstantEvaluator.evaluateString((JavaContext)context, (UElement)secondArgumentExpression, (boolean)false);
        if (value == null) {
            return;
        }
        String error = PowerManagerDetector.getErrorForTagName(value);
        if (error != null) {
            context.report(INVALID_WAKE_LOCK_TAG, (UElement)call, context.getLocation((UElement)call), error);
        }
    }

    public List<String> getApplicableMethodNames() {
        return Collections.singletonList("newWakeLock");
    }

    private static String getErrorForTagName(String tagName) {
        if (tagName.isEmpty()) {
            return "Tag name should not be empty to make wake lock problems easier to debug";
        }
        if (PowerManagerDetector.isReservedTagName(tagName)) {
            return String.format("`%1$s` is a reserved platform tag name and cannot be used", tagName);
        }
        if (tagName.indexOf(58) == -1) {
            String message2 = "Tag name should use a unique prefix followed by a colon (found %1$s). For instance `myapp:mywakelocktag`. This will help with debugging";
            return String.format(message2, tagName);
        }
        return null;
    }

    private static boolean isReservedTagName(String tagName) {
        if (tagName.length() < 2) {
            return false;
        }
        return tagName.charAt(0) == '*' && tagName.indexOf(42, 1) != -1;
    }
}

