/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiMethod;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UReferenceExpression;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u00012\u00020\u0002:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/lint/checks/ChromeOsSourceDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "determinePropertyString", "", "node", "Lorg/jetbrains/uast/UCallExpression;", "getApplicableMethodNames", "", "reportRearCameraOnlySystemFeatureViolations", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "reportUnsupportedOrientationViolations", "visitMethodCall", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "lint-checks"})
public final class ChromeOsSourceDetector
extends Detector
implements SourceCodeScanner {
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue UNSUPPORTED_LOCKED_ORIENTATION;
    @JvmField
    @NotNull
    public static final Issue UNSUPPORTED_CAMERA_FEATURE;
    @NotNull
    private static final Set<String> UNSUPPORTED_ORIENTATIONS;
    @NotNull
    public static final String UNSPECIFIED_ORIENTATION_VALUE = "SCREEN_ORIENTATION_UNSPECIFIED";
    @NotNull
    public static final String FEATURE_CAMERA_ANY_STRING = "FEATURE_CAMERA_ANY";
    @NotNull
    public static final String FEATURE_CAMERA_STRING = "FEATURE_CAMERA";
    public static final Companion Companion;

    @Nullable
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object[])new String[]{"setRequestedOrientation", "hasSystemFeature"});
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        String string = method.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"method.name");
        String name = string;
        if (Intrinsics.areEqual((Object)"setRequestedOrientation", (Object)name)) {
            this.reportUnsupportedOrientationViolations(node, context);
        } else if (Intrinsics.areEqual((Object)"hasSystemFeature", (Object)name)) {
            this.reportRearCameraOnlySystemFeatureViolations(node, context);
        }
    }

    private final void reportRearCameraOnlySystemFeatureViolations(UCallExpression node, JavaContext context) {
        String cameraFeatureRequested = this.determinePropertyString(node);
        if (Intrinsics.areEqual((Object)FEATURE_CAMERA_STRING, (Object)cameraFeatureRequested)) {
            String message2 = "You should look for any camera on the device, not just the rear";
            LintFix fix = this.fix().name("Switch to look for FEATURE_CAMERA_ANY").replace().text(cameraFeatureRequested).with(FEATURE_CAMERA_ANY_STRING).build();
            context.report(UNSUPPORTED_CAMERA_FEATURE, (UElement)node, context.getLocation((UElement)node), message2, fix);
        }
    }

    private final void reportUnsupportedOrientationViolations(UCallExpression node, JavaContext context) {
        String string = this.determinePropertyString(node);
        if (string == null) {
            return;
        }
        String orientationValue = string;
        if (UNSUPPORTED_ORIENTATIONS.contains(orientationValue)) {
            String message2 = "You should not lock orientation of your activities, so that you can support a good user experience for any device or orientation";
            LintFix fix = this.fix().name("Set the orientation to SCREEN_ORIENTATION_UNSPECIFIED").replace().text(orientationValue).with(UNSPECIFIED_ORIENTATION_VALUE).build();
            context.report(UNSUPPORTED_LOCKED_ORIENTATION, (UElement)node, context.getLocation((UElement)node), message2, fix);
        }
    }

    private final String determinePropertyString(UCallExpression node) {
        UExpression firstArgument = (UExpression)CollectionsKt.firstOrNull((List)node.getValueArguments());
        UExpression uExpression = firstArgument;
        if (!(uExpression instanceof UReferenceExpression)) {
            uExpression = null;
        }
        UReferenceExpression uReferenceExpression = (UReferenceExpression)uExpression;
        if (uReferenceExpression == null) {
            return null;
        }
        UReferenceExpression reference = uReferenceExpression;
        return reference.getResolvedName();
    }

    static {
        Companion = new Companion(null);
        IMPLEMENTATION = new Implementation(ChromeOsSourceDetector.class, Scope.JAVA_FILE_SCOPE);
        Collection collection = null;
        EnumSet enumSet = null;
        Implementation implementation = IMPLEMENTATION;
        boolean bl = false;
        Boolean bl2 = true;
        Severity severity = Severity.ERROR;
        int n = 4;
        String string = null;
        Category category = Category.CHROME_OS;
        UNSUPPORTED_LOCKED_ORIENTATION = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"SourceLockedOrientationActivity", (String)"Activity is locked to an orientation", (String)"\n                The `Activity` should not be locked to any orientation so that users\n                can take advantage of the multi-window environments and larger screens\n                available on Chrome OS. To fix the issue, consider calling `setRequestedOrientation`\n                with the `ActivityInfo.SCREEN_ORIENTATION_FULL_SENSOR` or\n                `ActivityInfo.SCREEN_ORIENTATION_UNSPECIFIED` options or removing the call\n                all together.\n                ", (Implementation)implementation, string, (Category)category, (int)n, (Severity)severity, (boolean)bl, (Boolean)bl2, enumSet, collection, (int)3344, null).setEnabledByDefault(false);
        collection = null;
        enumSet = null;
        implementation = IMPLEMENTATION;
        bl = false;
        bl2 = true;
        severity = Severity.ERROR;
        n = 4;
        string = null;
        category = Category.CHROME_OS;
        UNSUPPORTED_CAMERA_FEATURE = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"UnsupportedChromeOsCameraSystemFeature", (String)"Looking for Rear Camera only feature", (String)"\n                You should look for the `FEATURE_CAMERA_ANY` features to include all\n                possible cameras that may be on the device. Looking for `FEATURE_CAMERA`\n                only looks for a rear facing camera, which certain tablets or Chrome OS\n                devices don't have. To fix the issue, look for `FEATURE_CAMERA_ANY` instead.\n                ", (Implementation)implementation, string, (Category)category, (int)n, (Severity)severity, (boolean)bl, (Boolean)bl2, enumSet, collection, (int)3344, null).setEnabledByDefault(false);
        UNSUPPORTED_ORIENTATIONS = SetsKt.setOf((Object[])new String[]{"SCREEN_ORIENTATION_LANDSCAPE", "SCREEN_ORIENTATION_PORTRAIT", "SCREEN_ORIENTATION_REVERSE_LANDSCAPE", "SCREEN_ORIENTATION_REVERSE_PORTRAIT", "SCREEN_ORIENTATION_SENSOR_LANDSCAPE", "SCREEN_ORIENTATION_SENSOR_PORTRAIT", "SCREEN_ORIENTATION_USER_LANDSCAPE", "SCREEN_ORIENTATION_USER_PORTRAIT"});
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/lint/checks/ChromeOsSourceDetector$Companion;", "", "()V", "FEATURE_CAMERA_ANY_STRING", "", "FEATURE_CAMERA_STRING", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "UNSPECIFIED_ORIENTATION_VALUE", "UNSUPPORTED_CAMERA_FEATURE", "Lcom/android/tools/lint/detector/api/Issue;", "UNSUPPORTED_LOCKED_ORIENTATION", "UNSUPPORTED_ORIENTATIONS", "", "getUNSUPPORTED_ORIENTATIONS", "()Ljava/util/Set;", "lint-checks"})
    public static final class Companion {
        @NotNull
        public final Set<String> getUNSUPPORTED_ORIENTATIONS() {
            return UNSUPPORTED_ORIENTATIONS;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

