/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.google.common.collect.ListMultimap;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/lint/checks/UnusedNavigationDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "()V", "appliesTo", "", "folderType", "Lcom/android/resources/ResourceFolderType;", "referencesThis", "parser", "Lorg/xmlpull/v1/XmlPullParser;", "target", "", "visitDocument", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "document", "Lorg/w3c/dom/Document;", "Companion", "lint-checks"})
public final class UnusedNavigationDetector
extends ResourceXmlDetector {
    private static final Implementation IMPLEMENTATION_XML;
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    public static final Companion Companion;

    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkParameterIsNotNull((Object)folderType, (String)"folderType");
        return folderType == ResourceFolderType.NAVIGATION;
    }

    public void visitDocument(@NotNull XmlContext context, @NotNull Document document) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        LintClient client = context.getClient();
        ResourceRepository resourceRepository = client.getResourceRepository(context.getMainProject(), true, false);
        if (resourceRepository == null) {
            return;
        }
        ResourceRepository resources = resourceRepository;
        ListMultimap layouts = resources.getResources(ResourceNamespace.TODO(), ResourceType.LAYOUT);
        if (layouts.size() == 0 || layouts.size() > 25) {
            return;
        }
        ListMultimap navGraphs = resources.getResources(ResourceNamespace.TODO(), ResourceType.NAVIGATION);
        Collection collection = layouts.values();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"layouts.values()");
        Collection collection2 = navGraphs.values();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection2, (String)"navGraphs.values()");
        List items = CollectionsKt.plus((Collection)collection, (Iterable)collection2);
        StringBuilder stringBuilder = new StringBuilder().append("@navigation/");
        String string = context.file.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"context.file.name");
        String target2 = stringBuilder.append(Lint.getBaseName((String)string)).toString();
        Iterator iterator = items.iterator();
        while (iterator.hasNext()) {
            ResourceItem item;
            ResourceItem resourceItem = item = (ResourceItem)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)resourceItem, (String)"item");
            if (resourceItem.getSource() == null) {
                continue;
            }
            try {
                PathString file;
                XmlPullParser parser = client.createXmlPullParser(file);
                if (parser == null || !this.referencesThis(parser, target2)) continue;
                return;
            }
            catch (XmlPullParserException xmlPullParserException) {
            }
            catch (IOException iOException) {
            }
        }
        Node node = document.getDocumentElement();
        Element element = document.getDocumentElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"document.documentElement");
        XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)node, (Location)context.getElementLocation(element), (String)("This navigation graph is not referenced from any layout files (expected to find it in at least one layout " + "file with a `NavHostFragment` with `app:navGraph=\"" + target2 + "\"` attribute)."), null, (int)16, null);
    }

    private final boolean referencesThis(XmlPullParser parser, String target2) {
        while (true) {
            int event;
            if ((event = parser.next()) == 2) {
                String include;
                String tag;
                if (parser.getName() == null) {
                    continue;
                }
                if (Intrinsics.areEqual((Object)tag, (Object)"fragment")) {
                    String navGraph;
                    String cls = parser.getAttributeValue("http://schemas.android.com/apk/res/android", "name");
                    if (!Intrinsics.areEqual((Object)cls, (Object)"androidx.navigation.fragment.NavHostFragment")) continue;
                    ResourceNamespace resourceNamespace = ResourceNamespace.TODO();
                    Intrinsics.checkExpressionValueIsNotNull((Object)resourceNamespace, (String)"ResourceNamespace.TODO()");
                    if (parser.getAttributeValue(resourceNamespace.getXmlNamespaceUri(), "navGraph") == null) {
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)navGraph, (Object)target2)) continue;
                    return true;
                }
                if (!Intrinsics.areEqual((Object)tag, (Object)"include") || !Intrinsics.areEqual((Object)(include = parser.getAttributeValue("http://schemas.android.com/apk/res-auto", "graph")), (Object)target2)) continue;
                return true;
            }
            if (event == 1) break;
        }
        return false;
    }

    static {
        Companion = new Companion(null);
        IMPLEMENTATION_XML = new Implementation(UnusedNavigationDetector.class, Scope.RESOURCE_FILE_SCOPE);
        ISSUE = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"UnusedNavigation", (String)"Unused Navigation", (String)"\n                Navigation resource files must be referenced from a `NavHostFragment` \\\n                in a layout in order to be relevant.\n                ", (Implementation)IMPLEMENTATION_XML, (String)"https://developer.android.com/topic/libraries/architecture/navigation/navigation-implementing#Modify-activity", (Category)Category.CORRECTNESS, (int)2, (Severity)Severity.ERROR, (boolean)false, null, null, null, (int)3840, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/lint/checks/UnusedNavigationDetector$Companion;", "", "()V", "IMPLEMENTATION_XML", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

